/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.task;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropSelectTraninglParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ICropEnrollService;
import cn.smarthse.radiationTraining.modules.training.task.CertService;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.io.Serializable;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EmergencyTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmergencyTask.class);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ITuCertificateService tuCertificateService;
    @Autowired
    private CertService certService;
    @Autowired
    private ICropEnrollService cropEnrollService;

    @XxlJob(value="EmergencyTask-cleanCert")
    public void cleanCert() {
        String certId = XxlJobHelper.getJobParam();
        this.logger.debug("\u6e05\u9664\u7279\u5b9a\u8bc1\u4e66\uff0cparam=[{}]", (Object)certId);
        if (StrUtil.isEmpty((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNumeric((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        this.tuCertificateService.cleanCert(Long.valueOf(certId));
    }

    @XxlJob(value="EmergencyTask-genCert")
    public void genCert() {
        String certId = XxlJobHelper.getJobParam();
        this.logger.debug("\u751f\u6210\u7279\u5b9a\u8bc1\u4e66\uff0cparam=[{}]", (Object)certId);
        if (StrUtil.isEmpty((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNumeric((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        this.certService.genCert(Long.valueOf(certId));
    }

    @XxlJob(value="EmergencyTask-reGenCertNO")
    public void reGenCertNO() {
        String certId = XxlJobHelper.getJobParam();
        this.logger.debug("\u91cd\u65b0\u751f\u6210\u8bc1\u4e66\u7f16\u7801\uff0cparam=[{}]", (Object)certId);
        if (StrUtil.isEmpty((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNumeric((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        this.tuCertificateService.reGenCertificateNo(Long.valueOf(certId));
    }

    @XxlJob(value="EmergencyTask-syncSingleInfo")
    public void syncSingleInfo() {
        String certId = XxlJobHelper.getJobParam();
        this.logger.debug("\u540c\u6b65\u67d0\u4e2a\u8bc1\u4e66\uff0cparam=[{}]", (Object)certId);
        if (StrUtil.isEmpty((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNumeric((CharSequence)certId)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        TuCertificate byId = (TuCertificate)this.tuCertificateService.getById((Serializable)((Object)certId));
        this.tuCertificateService.syncSingleInfo(byId);
    }

    @XxlJob(value="EmergencyTask-reSynceAllExceptionInfo")
    public void reSynceAllExceptionInfo() {
        this.logger.debug("\u540c\u6b65\u5f02\u5e38\u8bc1\u4e66");
        this.tuCertificateService.reSynceAllExceptionInfo();
    }

    @XxlJob(value="EmergencyTask-addTuCert")
    public void addTuCert() {
        String detailId = XxlJobHelper.getJobParam();
        this.logger.debug("\u8865\u5168\u8bc1\u4e66\u4e1a\u52a1\u6570\u636e\uff0cparam=[{}]", (Object)detailId);
        if (StrUtil.isEmpty((CharSequence)detailId)) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StrUtil.isNumeric((CharSequence)detailId)) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        this.tuCertificateService.addCertificate(Long.valueOf(detailId));
    }

    @XxlJob(value="EmergencyTask-batchGenCert")
    public void batchGenCert() {
        this.logger.debug("\u8bc1\u4e66\u6279\u91cf\u751f\u6210\uff0cparam=[{}]");
        this.certService.genCertFile();
    }

    @XxlJob(value="EmergencyTask-selectTraining")
    public void selectTraining() {
        String json = XxlJobHelper.getJobParam();
        this.logger.debug("\u5355\u4f4d\u62a5\u540d-\u7ed9\u81ea\u8eab\u62a5\u540d(\u65e0\u89c6\u65f6\u95f4)\uff0cparam=[{}]", (Object)json);
        if (StrUtil.isEmpty((CharSequence)json)) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CropSelectTraninglParam param = (CropSelectTraninglParam)JSONUtil.toBean((String)json, CropSelectTraninglParam.class);
        if (param.getCid() == null || param.getTid() == null || param.getLoginUserId() == null) {
            throw new ServiceException("\u4e0d\u5b8c\u6574");
        }
        if (param.getCompanyName() == null || !param.getCompanyName().equals("asedsfasdf")) {
            throw new ServiceException("\u4e0d\u5b8c\u6574");
        }
        param.setCompanyName(null);
        this.cropEnrollService.enrollBySelfEverytime(param);
    }

    @Generated
    public EmergencyTask() {
    }
}

