/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.task;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.extra.qrcode.QrCodeUtil;
import cn.hutool.extra.qrcode.QrConfig;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.utils.DateUtils;
import cn.smarthse.radiationTraining.core.framework.utils.FreemarkUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysFile;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.order.ISysOrderProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import cn.smarthse.radiationTraining.modules.training.enums.CertBgEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuSpecialCertificateNoService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingPersonCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.task.CertService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertSyncParam;
import cn.smarthse.rho.modules.sys.provider.sync.ITrainingSyncProvider;
import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.HtmlConverter;
import com.itextpdf.kernel.geom.PageSize;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CertRayService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertRayService.class);
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private SysProperties sysProperties;
    @Autowired
    private ITuCertificateService certificateService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuSpecialCertificateNoService tuSpecialCertificateNoService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITrainingPersonCertificateService trainingPersonCertificateService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @DubboReference
    private ITrainingSyncProvider rayTrainingSyncProvider;
    @DubboReference
    private ISysOrderProviderService orderService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    @Autowired
    RedisLockRegistry lockRegistry;
    public static final String certFont = "templates/ali/AlibabaPuHuiTi-3-55-Regular.ttf";

    public void genCertFile() {
        List<TuCertificate> dataList = this.certificateService.listNeedGenCertForRay();
        if (!CollectionUtils.isEmpty(dataList)) {
            log.info("\u5b9a\u65f6\u4efb\u52a1-\u751f\u6210\u8bc1\u4e66-\u5f00\u59cb- size\uff1a{}", (Object)dataList.size());
            for (int index = 0; index < dataList.size(); ++index) {
                TuCertificate record = dataList.get(index);
                if (!StringUtils.isEmpty((CharSequence)record.getPdfUrl())) continue;
                try {
                    this.genCert(record);
                }
                catch (Exception e) {
                    log.error("exception \uff1a{}", (Object)e.toString());
                }
                log.info("\u5b9a\u65f6\u4efb\u52a1-\u751f\u6210\u8bc1\u4e66- index\uff1a{} - certNo\uff1a{}", (Object)index++, (Object)record.getCertificateNo());
            }
        }
    }

    public TuCertVo genCert(Long id) {
        TuCertificate tuCert = (TuCertificate)this.certificateService.getById(id);
        if (tuCert == null) {
            return null;
        }
        log.info("\u8bc1\u4e66\u751f\u6210-\u5f00\u59cb\uff1aid\uff1a{}", (Object)id);
        tuCert = this.genCert(tuCert);
        if (tuCert == null) {
            return null;
        }
        TuCertVo tuCertVo = new TuCertVo();
        tuCertVo.setId(tuCert.getId());
        tuCertVo.setUnitName(tuCert.getUnitName());
        tuCertVo.setTrainType(tuCert.getTrainType());
        tuCertVo.setPdfUrl(this.ossClientBean.getUrl(tuCert.getPdfUrl()));
        tuCertVo.setIssueTime(tuCert.getIssueTime());
        tuCertVo.setUid(tuCert.getUid());
        log.info("\u8bc1\u4e66\u751f\u6210-\u7ed3\u675f\uff1aid\uff1a{}", (Object)id);
        return tuCertVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TuCertificate genCert(TuCertificate record) {
        block14: {
            boolean flag;
            Lock lock;
            String lock_key;
            TrainingDetailVo training;
            TuEnroll tuEnroll;
            TuEnrollDetail tuEnrollDetail;
            block13: {
                if (!StringUtils.isEmpty((CharSequence)record.getPdfUrl())) break block14;
                tuEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(record.getEnrollDetailId());
                if (tuEnrollDetail == null) {
                    log.error("\u4e2a\u4eba\u57f9\u8bad\u4fe1\u606f\u7f3a\u5931TuCertificate.id\uff1a{}", (Object)record.getId());
                    return null;
                }
                tuEnroll = (TuEnroll)this.tuEnrollService.getById(tuEnrollDetail.getEnrollId());
                if (tuEnroll == null) {
                    log.error("\u4e2a\u4eba\u57f9\u8bad\u4fe1\u606f\u7f3a\u5931tuEnroll is null. TuCertificate.id\uff1a{}", (Object)record.getId());
                    return null;
                }
                if (tuEnrollDetail.getTrainStatus() != 3) {
                    log.error("\u4e2a\u4eba\u57f9\u8bad\u672a\u901a\u8fc7TuCertificate.id\uff1a{}", (Object)record.getId());
                    return null;
                }
                training = this.trainingService.getTrainingInfo(tuEnrollDetail.getTid());
                if (training == null) {
                    log.error("\u4e2a\u4eba\u57f9\u8bad\u4fe1\u606f\u7f3a\u5931TuCertificate.id\uff1a{}", (Object)record.getId());
                    return null;
                }
                if (training.getIsCharge() == 1 && !this.orderService.checkPayedByBusinessId(tuEnrollDetail.getId())) {
                    log.error("\u65e0\u652f\u4ed8\u8ba2\u5355\u4fe1\u606fTuCertificate.id\uff1a{}", (Object)record.getId());
                    return null;
                }
                TrainingPersonCertificate personCertificate = this.trainingPersonCertificateService.getPersonCertificate(tuEnrollDetail.getTid(), record.getCertType());
                HseCompanyVo hseCompanyVo = this.hseCompanyProviderService.getInfoById(tuEnroll.getHseCid());
                Long superviseAreaId = this.hseCompanyProviderService.getRhoSuperviseAreaId(tuEnroll.getHseCid());
                hseCompanyVo.setSupervisionAreaId(superviseAreaId);
                if (superviseAreaId == null) {
                    log.error("\u76d1\u7ba1\u5355\u4f4d\u884c\u653f\u533a\u5212\u7f16\u7801\u7f3a\u5931TuCertificate.id\uff1a{} - cid\uff1a{}", (Object)record.getId(), (Object)tuEnroll.getHseCid());
                    return null;
                }
                if (superviseAreaId.toString().length() < 6) {
                    log.error("\u76d1\u7ba1\u5355\u4f4d\u884c\u653f\u533a\u5212\u7f16\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0cTuCertificate.id\uff1a{}\uff0csuperviseAreaId\uff1a{} - cid\uff1a{}", new Object[]{record.getId(), superviseAreaId, tuEnroll.getHseCid()});
                    return null;
                }
                if (training == null || personCertificate == null) {
                    log.error("\u4e2a\u4eba\u57f9\u8bad\u4fe1\u606f\u7f3a\u5931tuEnroll or training or personCertificate is null. TuCertificate.id\uff1a{}", (Object)record.getId());
                    return null;
                }
                UserVo userVo = this.userProviderService.getUserVo(record.getUid());
                PersonalUserVo personalUserInfo = this.userProviderService.getPersonalUserInfo(record.getUid());
                this.idCardProcessing(record, personalUserInfo);
                record.setUname(userVo.getName());
                lock_key = CertService.getKey(superviseAreaId, LocalDate.now().getYear(), record.getCertType());
                lock = this.lockRegistry.obtain((Object)lock_key);
                flag = false;
                try {
                    if (!lock.tryLock(10L, TimeUnit.MINUTES)) break block13;
                    log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u83b7\u53d6\u9501\uff1akey:\u201c{}\u201c-id:{}-uname\uff1a{}", new Object[]{lock_key, record.getId(), record.getUname()});
                    this.invokeGenFileTask(record, hseCompanyVo, (Training)training, personCertificate, tuEnroll);
                    flag = true;
                }
                catch (Exception e) {
                    try {
                        log.error("exception \uff1a{}", (Object)e.toString());
                    }
                    catch (Throwable throwable) {
                        log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname:{}", new Object[]{lock_key, record.getId(), record.getUname()});
                        lock.unlock();
                        throw throwable;
                    }
                    log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname:{}", new Object[]{lock_key, record.getId(), record.getUname()});
                    lock.unlock();
                }
            }
            log.debug("\u751f\u6210\u8bc1\u4e66\u7f16\u53f7-\u91ca\u653e\u9501\uff1akey:\u201c{}\u201c-id:{}-uname:{}", new Object[]{lock_key, record.getId(), record.getUname()});
            lock.unlock();
            if (flag && this.tuEnrollDetailService.ifCanSync(tuEnrollDetail)) {
                this.threadPoolTaskExecutor.execute(() -> this.syncCertInfo(record, tuEnrollDetail, tuEnroll, (Training)training));
            }
        }
        return record;
    }

    private void idCardProcessing(TuCertificate record, PersonalUserVo personalUserInfo) {
        String idcard = personalUserInfo.getIdcard();
        if (StrUtil.isNotBlank((CharSequence)idcard)) {
            int length;
            record.setIdCard(idcard);
            boolean validCard = IdcardUtil.isValidCard((String)idcard);
            Object desensitizationIdCard = null;
            desensitizationIdCard = validCard && StrUtil.length((CharSequence)idcard) == 18 ? DesensitizedUtil.idCardNum((String)idcard, (int)1, (int)2) : ((length = StrUtil.length((CharSequence)idcard)) >= 3 ? DesensitizedUtil.idCardNum((String)idcard, (int)1, (int)1) : StrUtil.subPre((CharSequence)idcard, (int)1) + "***");
            record.setDesensitizationIdCard((String)desensitizationIdCard);
        } else {
            record.setIdCard("         -        ");
            record.setDesensitizationIdCard("         -        ");
        }
    }

    private void invokeGenFileTask(TuCertificate record, HseCompanyVo hseCompanyVo, Training training, TrainingPersonCertificate personCertificate, TuEnroll tuEnroll) {
        if (StringUtils.isEmpty((CharSequence)record.getCertificateNo())) {
            TuCertificate certificateNo = this.certificateService.getCertificateNoV2ForRay(hseCompanyVo.getSupervisionAreaId(), LocalDate.now().getYear(), record.getCertType());
            record.setAreaId(certificateNo.getAreaId());
            record.setYear(certificateNo.getYear());
            record.setSerialNo(certificateNo.getSerialNo());
            record.setCertificateNo(certificateNo.getCertificateNo());
            this.updateCertificateNo(record);
        }
        record.setTrainingName(training.getTrainName());
        record.setTrainingUnitName(training.getIsCurrency() == 0 ? personCertificate.getAwardUnit() : tuEnroll.getIssueUnitName());
        record.setUnitName(hseCompanyVo.getName());
        record.setTrainType(training.getTrainType());
        record.setTrainStarDate(training.getTrainStarTime());
        record.setTrainEndDate(training.getTrainEndTime());
        record.setIssueTime(record.getIssueTime() == null ? new Date() : record.getIssueTime());
        if (personCertificate.getValidityDate() != null) {
            record.setInvalidDate(DateUtils.addYear((Date)record.getIssueTime(), (int)personCertificate.getValidityDate()));
        }
        if (personCertificate.getReviewDate() != null) {
            record.setReviewDate(DateUtils.addMonth((Date)record.getIssueTime(), (int)personCertificate.getReviewDate()));
        }
        record.setBackgroundId(personCertificate.getBackgroundId());
        record.setSealUrl(this.ossClientBean.getUrl(personCertificate.getElectronicSeal()));
        this.checkGenResult(record);
        this.genCertPdfFile(record, personCertificate);
    }

    private void genCertPdfFile(TuCertificate record, TrainingPersonCertificate personCertificate) {
        File file = this.genCertFile(record, personCertificate);
        SysFileModel pdfSysFile = this.uploadBackstage(file, file.getName());
        record.setPdfFileId(pdfSysFile.getId());
        record.setPdfUrl(pdfSysFile.getOssUrl());
        record.setUpdateTime(new Date());
        this.checkGenResult(record);
        this.certificateService.updateById(record);
    }

    private void checkGenResult(TuCertificate record) {
        List<TuCertificate> list = this.certificateService.getByCertificateNoForCheckResult(record.getCertificateNo());
        boolean isError = false;
        if (CollUtil.isNotEmpty(list)) {
            if (list.size() >= 2) {
                isError = true;
            }
            if (list.size() == 1) {
                TuCertificate tuCertificate = list.get(0);
                if (!record.getId().equals(tuCertificate.getId())) {
                    isError = true;
                }
            }
        }
        if (isError) {
            throw new ServiceException("\u6570\u636e\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u751f\u6210");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCertInfo(TuCertificate record, TuEnrollDetail tuEnrollDetail, TuEnroll tuEnroll, Training training) {
        if (!this.tuEnrollDetailService.ifCanSync(tuEnrollDetail)) {
            return;
        }
        UserVo userVo = this.userProviderService.getUserVo(tuEnrollDetail.getUid());
        String s = null;
        try {
            TrainingCertSyncParam syncParam = this.genSyncParam(record, tuEnrollDetail, tuEnroll, training, userVo);
            s = this.rayTrainingSyncProvider.syncTrainingCert(syncParam);
            this.updateSyncResult(record.getId(), s);
        }
        catch (Exception e) {
            try {
                log.error("Exception\uff1a", (Throwable)e);
                s = "\u8fdc\u7a0b\u63a5\u53e3\u8c03\u7528\u5f02\u5e38";
                this.updateSyncResult(record.getId(), s);
            }
            catch (Throwable throwable) {
                this.updateSyncResult(record.getId(), s);
                throw throwable;
            }
        }
    }

    private TrainingCertSyncParam genSyncParam(TuCertificate record, TuEnrollDetail tuEnrollDetail, TuEnroll tuEnroll, Training training, UserVo userVo) {
        TrainingPersonCertificate personCertificate = this.trainingPersonCertificateService.getPersonCertificate(tuEnrollDetail.getTid(), record.getCertType());
        record.setTrainingUnitName(training.getIsCurrency() == 0 ? personCertificate.getAwardUnit() : tuEnroll.getIssueUnitName());
        Double classHour = 0.0;
        if (training.getTrainMode() == 0) {
            classHour = personCertificate.getPersonalizedClassHour();
        }
        if (training.getTrainMode() == 1) {
            classHour = personCertificate.getTargetClassHour();
        }
        String trainingType = null;
        if ("\u521d\u6b21\u57f9\u8bad".equals(training.getTrainType())) {
            trainingType = "1";
        }
        if ("\u7ee7\u7eed\u6559\u80b2".equals(training.getTrainType())) {
            trainingType = "0";
        }
        if ("\u5c97\u524d\u57f9\u8bad".equals(training.getTrainType())) {
            trainingType = "1";
        }
        if ("\u5c97\u4e2d\u57f9\u8bad".equals(training.getTrainType())) {
            trainingType = "0";
        }
        SysFile file = this.sysFileProvideService.getRawFileData(record.getPdfFileId());
        TrainingCertSyncParam syncParam = new TrainingCertSyncParam();
        syncParam.setIdCard(userVo.getIdcard()).setName(userVo.getName()).setSourceTrainingId(training.getId()).setSourceEnrollId(tuEnrollDetail.getId()).setSourceCertId(record.getId()).setSourceStaffId(userVo.getId()).setCid(tuEnrollDetail.getHseCid()).setTechId(null).setTechName(record.getTrainingUnitName()).setCertType(TrainingPersonTypeEnum.getTcode((String)record.getCertType())).setCertNo(record.getCertificateNo()).setIssuanceDate(record.getIssueTime() == null ? null : LocalDate.from(DateUtil.toLocalDateTime((Date)record.getIssueTime()))).setCertValidDate(record.getInvalidDate() == null ? null : DateUtil.toLocalDateTime((Date)record.getInvalidDate())).setTrainingName(training.getTrainName()).setTrainingBeginDate(training.getTrainStarTime() == null ? null : LocalDate.from(DateUtil.toLocalDateTime((Date)training.getTrainStarTime()))).setTrainingEndDate(training.getTrainEndTime() == null ? null : LocalDate.from(DateUtil.toLocalDateTime((Date)training.getTrainEndTime()))).setTrainingType(trainingType).setResult(Integer.valueOf(1)).setTrainingContent(null).setTrainingHours(String.valueOf(classHour));
        syncParam.setTechName("\u6d59\u6c5f\u7701\u536b\u751f\u76d1\u7763\u534f\u4f1a");
        if (file != null) {
            syncParam.setOssUrl(file.getOssUrl()).setSourceFileId(file.getId()).setFileName(file.getFileName()).setFileSize(StrUtil.isNumeric((CharSequence)file.getFileSize()) ? Long.valueOf(file.getFileSize()) : null).setFileExt(file.getFileExt()).setFileHash(file.getFileHash()).setCreatorIp(file.getCreatorIp());
        }
        return syncParam;
    }

    private void updateSyncResult(Long tuCertificateId, String s) {
        TuCertificate tuCertificate = new TuCertificate();
        if (tuCertificateId == null) {
            throw new ServiceException("\u65e0\u6cd5\u8bc6\u522b\u8bc1\u4e66");
        }
        tuCertificate.setId(tuCertificateId);
        tuCertificate.setSyncDes(StringUtils.isEmpty((CharSequence)s) ? "\u540c\u6b65\u6210\u529f" : s);
        tuCertificate.setSyncState(Integer.valueOf(StringUtils.isEmpty((CharSequence)s) ? 1 : 2));
        this.certificateService.updateById(tuCertificate);
    }

    private File genCertFile(TuCertificate certificateData, TrainingPersonCertificate certSetting) {
        return this.genCertFile(certificateData, certSetting, null);
    }

    private File genCertFile(TuCertificate certificateData, TrainingPersonCertificate certSetting, String courseDesc) {
        boolean rotate = CertBgEnum.isRotate((Long)certificateData.getBackgroundId());
        String bgImg = CertBgEnum.getBgImg((Long)certificateData.getBackgroundId());
        String bgImgPreBase = "templates/images/" + bgImg;
        URL resource = ResourceUtil.getResource((String)bgImgPreBase);
        String certFileName = CertBgEnum.getCertFile((Long)certificateData.getBackgroundId());
        HashMap<String, Object> dataMap = new HashMap<String, Object>(5);
        dataMap.put("certificateData", certificateData);
        dataMap.put("score", "\u5408\u683c");
        dataMap.put("certTypeName", TrainingPersonTypeEnum.getNameByValue2((String)certificateData.getCertType()));
        dataMap.put("courseDesc", courseDesc);
        dataMap.put("bgImgUrl", resource.getPath());
        dataMap.put("color", CertBgEnum.getColorValue((Long)certificateData.getBackgroundId()));
        dataMap.put("certSetting", certSetting);
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.radiation_training.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.CERT.getPath() + UploadFileParameter.FILE_PATH_SEP + FileUploadSimple.getDataPath() + UploadFileParameter.FILE_PATH_SEP + IdUtil.getSnowflakeNextId();
        String realPath = this.ossClientBean.getLocal() + uploadDir;
        String filePath = realPath + UploadFileParameter.FILE_PATH_SEP + certificateData.getUname() + "-" + certificateData.getCertificateNo() + ".pdf";
        String qrUrl = this.sysProperties.getCertQrUrl() + certificateData.getId();
        dataMap.put("qrUrl", QrCodeUtil.generateAsBase64((String)qrUrl, (QrConfig)new QrConfig(150, 150), (String)"jpg"));
        dataMap.put("certFont", ResourceUtil.getResource((String)certFont).getPath());
        try {
            Files.createDirectories(Paths.get(realPath, new String[0]), new FileAttribute[0]);
            ConverterProperties properties = new ConverterProperties();
            File file = new File(filePath);
            FileOutputStream os = new FileOutputStream(file);
            PdfWriter pdfWriter = new PdfWriter((OutputStream)os);
            PdfDocument pdfDocument = new PdfDocument(pdfWriter);
            PageSize pageSize = PageSize.A4;
            if (rotate) {
                pageSize = pageSize.rotate();
            }
            pageSize.applyMargins(0.0f, 0.0f, 0.0f, 0.0f, true);
            pdfDocument.setDefaultPageSize(pageSize);
            pdfDocument.getDocumentInfo().setAuthor("\u667a\u6167\u804c\u5b89\u73af\u4fdd\u79d1\u6280").setCreator("\u6d59\u6c5f\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u7cfb\u7edf").setKeywords("\u804c\u4e1a\u5065\u5eb7\u5728\u7ebf\u57f9\u8bad\u8bc1\u4e66").setTitle(String.format("%s\u7684\u8bc1\u4e66", certificateData.getName())).setSubject(String.format("%s\u7684\u8bc1\u4e66", certificateData.getName()));
            HtmlConverter.convertToPdf((String)FreemarkUtil.loadFreemarkFile(dataMap, (String)certFileName), (PdfDocument)pdfDocument, (ConverterProperties)properties);
            return file;
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            return null;
        }
    }

    public SysFileModel uploadBackstage(File file, String ossFileName) {
        if (file == null) {
            throw new ServiceException("\u751f\u6210\u8bc1\u4e66\u5931\u8d25\uff0c\u60a8\u53ef\u5c1d\u8bd5\u7a0d\u540e\u518d\u6b21\u64cd\u4f5c\uff01");
        }
        String uploadDir = file.getParent().replace(this.ossClientBean.getLocal(), "").replace("\\", "/");
        int fileResource = FileResourceEnum.radiation_training.getValue();
        String originalFilename = file.getName();
        String fileExt = FilenameUtils.getExtension((String)file.getName());
        String ossUrl = null;
        if (this.ossClientBean.isAsynch()) {
            String fullname = StringUtils.isEmpty((CharSequence)FilenameUtils.getExtension((String)originalFilename)) ? originalFilename + "." + fileExt : originalFilename;
            ossUrl = this.ossClientBean.OSSPutObject(ossFileName, file, uploadDir, fullname);
            log.debug("\u4e0a\u4f20\u540e\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\uff1a{}", (Object)ossUrl);
        }
        SysFileModel sysFileModel = new SysFileModel();
        sysFileModel.setResource(Integer.valueOf(fileResource)).setFileName(originalFilename).setFileSize(String.valueOf(file.getFreeSpace())).setFileExt(fileExt).setFileHash(MD5.create().digestHex(file)).setOssUrl(ossUrl);
        file.delete();
        return this.sysFileProvideService.addSysFile(sysFileModel, null);
    }

    private void updateCertificateNo(TuCertificate record) {
        if (record.getId() == null || StrUtil.isBlank((CharSequence)record.getCertificateNo())) {
            throw new ServiceException("\u8bc1\u4e66\u7f16\u53f7\u6216\u8005\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        }
        TuCertificate tuCertificate = new TuCertificate();
        tuCertificate.setId(record.getId());
        tuCertificate.setAreaId(record.getAreaId());
        tuCertificate.setYear(record.getYear());
        tuCertificate.setSerialNo(record.getSerialNo());
        tuCertificate.setCertificateNo(record.getCertificateNo());
        this.certificateService.updateById(tuCertificate);
    }

    @Generated
    public CertRayService() {
    }
}

