/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.modules.health.supervise.entity.trainPlan.SyncTrainInfoModel;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISuperviseTrainPlanService;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.annotation.BeanPropertyName;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.training.converter.TrainingConverter;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingMapper;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingChangeRecord;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.training.AssoScoreListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RhoTrainHomeCropParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RhoTrainHomeUserParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TidParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeCetParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeCropParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeUserParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingAddParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingDelParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingEnrollDetailSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingStatusUpdateParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingUpdateParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ICertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingChangeRecordService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingIndustryService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingPersonCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingWorkTypeService;
import cn.smarthse.radiationTraining.modules.training.vo.training.AbutmentTrainChangeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.AbutmentTrainInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.AbutmentTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.ApiScoreSearchVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.AssoScoreListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.RhoTrainHomeCropVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.RhoTrainHomeUserVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainChangeRecordVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCetVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCropExportVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCropVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeUserExportVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeUserVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainTestMsgVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingHomeListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingHomeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingUnitEnrollCouldReturnVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingUnitEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrainingServiceImpl
extends ServiceImpl<TrainingMapper, Training>
implements ITrainingService {
    @Autowired(required=false)
    private TrainingConverter trainingConverter;
    @Autowired
    private ITrainingWorkTypeService trainingWorkTypeService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ICertificateService certificateService;
    @Autowired
    private ITrainingCourseService trainingCourseService;
    @Autowired
    private ITrainingPersonCertificateService personCertificateService;
    @Autowired
    private ITrainingIndustryService trainingIndustryService;
    @Autowired
    private ITrainingChangeRecordService changeRecordService;
    @DubboReference
    private ISuperviseTrainPlanService trainPlanService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;
    @Autowired
    private OssClientBean ossClientBean;

    @Override
    public LayuiGridData<TrainingListVo> getTrainingPageList(TrainingSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingListVo> trainingList = ((TrainingMapper)this.baseMapper).listTrainingPage(param);
        trainingList.stream().forEach(train -> {
            train.setPersonTypeNameList(this.personCertificateService.getPersonTypeName(train.getId()));
            train.setCourseNum(Integer.valueOf(this.trainingCourseService.getTrainingCourseTotalNum(train.getId())));
            if (param.getIsSpecifiedUser().booleanValue() || Objects.equals(train.getCouldModifyArea(), param.getAreaId())) {
                train.setIsModify(Integer.valueOf(1));
            }
            train.setCompanyCetNum(((TrainingMapper)this.baseMapper).countCompanyCetNumByTid(train.getId()));
        });
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    @Cacheable(cacheNames={"TRAINING:INFO"}, key="#tid")
    public TrainingDetailVo getTrainingInfo(Long tid) {
        Training training = this.getByIdNoLogic(tid);
        TrainingDetailVo rst = this.trainingConverter.trainingToDetailVo(training);
        rst.setTrainIndustryNameList(this.trainingIndustryService.getTrainIndustryName(tid));
        rst.setTrainIndustryVoList(this.trainingIndustryService.getTrainIndustryVoList(tid));
        rst.setPersonCertificateList(this.personCertificateService.getPersonCertificateListByTid(tid));
        rst.setPersonTypeNameList(this.personCertificateService.getPersonTypeName(tid));
        rst.setHasUnitEnroll(this.tuEnrollService.getHasUnitEnroll(tid));
        rst.setCourseNum(Integer.valueOf(this.trainingCourseService.getTrainingCourseTotalNum(tid)));
        rst.setClassHourNum(this.trainingCourseService.getTrainingCourseHourNum(tid));
        rst.setCoverUrl(this.ossClientBean.getUrl(rst.getCoverUrl()));
        return rst;
    }

    @Override
    public TrainingDetailVo getTrainingInfo(TrainingSearchParam param) {
        TrainingDetailVo info = this.getTrainingInfo(param.getTrainingId());
        int trainCreateAreaLevel = StringUtils.getAreaLevel((Long)info.getCouldModifyArea());
        int userAreaLevel = param.getLevel();
        if (userAreaLevel > trainCreateAreaLevel && !param.getIsSpecifiedUser().booleanValue()) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u672c\u7ea7\u533a\u57df\u4ee5\u4e0a\u7684\u57f9\u8bad\uff01");
        }
        if (param.getIsSpecifiedUser() != null && param.getAreaId() != null && info.getCouldModifyArea() != null && (param.getIsSpecifiedUser().booleanValue() || Objects.equals(info.getCouldModifyArea(), param.getAreaId()))) {
            info.setIsModify(Integer.valueOf(1));
        }
        return info;
    }

    @Override
    public LayuiGridData<TrainingUnitEnrollVo> getTrainingUnitEnrollList(TrainingEnrollSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingUnitEnrollVo> rst = ((TrainingMapper)this.baseMapper).listTrainingUnitEnroll(param);
        this.settleIsReturn(rst, param.getTrainingId());
        rst.stream().forEach(item -> item.setHasCertificateNum(Integer.valueOf(this.tuEnrollDetailService.getHasCertificateNum(item.getId()))));
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    private void settleIsReturn(List<TrainingUnitEnrollVo> list, Long tid) {
        list.stream().forEach(item -> {
            TrainingUnitEnrollCouldReturnVo studyInfo = ((TrainingMapper)this.baseMapper).getStudyInfoByBatchId(item.getId());
            Integer stuStatusNum = studyInfo.getStuStatusSum();
            if (stuStatusNum != null && stuStatusNum == 0) {
                item.setIsReturn(Integer.valueOf(1));
            } else {
                item.setIsReturn(Integer.valueOf(0));
            }
        });
    }

    @Override
    public List<TrainingWorkTypeVo> getTrainingWorkType() {
        return this.trainingWorkTypeService.getTrainingWorkType(null);
    }

    @Override
    public LayuiGridData<TrainingPersonEnrollVo> getTrainingPersonEnrollList(TrainingEnrollDetailSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingPersonEnrollVo> rst = ((TrainingMapper)this.baseMapper).listTrainingPersonEnroll(param);
        rst.stream().forEach(item -> {
            if (null != item.getPersonTypeCode()) {
                ArrayList personTypeNameList = new ArrayList();
                List<String> personTypeCodeList = Arrays.asList(item.getPersonTypeCode().split(","));
                personTypeCodeList.stream().forEach(code -> personTypeNameList.add(TrainingPersonTypeEnum.getNameByValue((String)code)));
                item.setPersonTypeCode(personTypeNameList.stream().collect(Collectors.joining("\uff0c")));
            }
        });
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"TRAINING:INFO"}, key="#param.trainingId")
    public Integer updateTrainingDetail(TrainingUpdateParam param) throws IllegalAccessException {
        boolean hasEnroll;
        TrainingDetailVo info = this.getTrainingInfo(param.getTrainingId());
        if (!param.getIsSpecifiedUser().booleanValue() && !Objects.equals(param.getUpdateBy(), info.getCreateBy())) {
            throw new ServiceException("\u65e0\u6cd5\u4fee\u6539\u5176\u4ed6\u8d26\u53f7\u521b\u5efa\u7684\u57f9\u8bad\uff01");
        }
        Training training = this.trainingConverter.updateParamToTraining(param);
        Byte status = info.getStatus();
        if (null != status && status.equals((byte)2)) {
            return -1;
        }
        Integer enrollNum = ((TrainingMapper)this.baseMapper).countEnrollNumByTrainId(param.getTrainingId());
        boolean bl = hasEnroll = enrollNum != null && enrollNum != 0;
        if (null != status && status.equals((byte)0) && hasEnroll) {
            this.addTrainChangeRecord(param);
            LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Training::getTrainName, (Object)param.getTrainName())).set(Training::getCoverUrl, (Object)param.getCoverUrl())).set(Training::getRetestSetting, (Object)param.getRetestSetting())).set(Training::getStatus, (Object)param.getStatus())).eq(Training::getId, (Object)param.getTrainingId());
            this.update((Wrapper)wrapper);
            if (training.getStatus() == 2 && Objects.equals(training.getTrainTarget(), TrainTargetEnum.UNIT.getValue())) {
                TrainingAddParam addParam = this.trainingConverter.updateParamToAddParam(param);
                this.addOrUpdateTrainToHSE(addParam, training, 2);
                this.pushMsgToHSE(new ArrayList<Long>(Collections.singletonList(training.getId())), param.getToken());
            }
            return 1;
        }
        if (status.equals((byte)0)) {
            this.addTrainChangeRecord(param);
        }
        this.updateById(training);
        this.personCertificateService.updatePersonCertificate(param.getTrainingId(), param.getPersonTypeCertificateList());
        if (Objects.equals(training.getTrainTarget(), TrainTargetEnum.UNIT.getValue()) || Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_MANGER.getValue()) || Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_WORK.getValue()) || Objects.equals(training.getTrainTarget(), TrainTargetEnum.RAY_WORK_NON_MEDICAL.getValue())) {
            this.trainingIndustryService.updateTrainIndustry(param.getTrainingId(), param.getTrainIndustryList());
        }
        if (training.getStatus() == 2 && Objects.equals(training.getTrainTarget(), TrainTargetEnum.UNIT.getValue())) {
            TrainingAddParam addParam = this.trainingConverter.updateParamToAddParam(param);
            this.addOrUpdateTrainToHSE(addParam, training, 2);
            this.pushMsgToHSE(new ArrayList<Long>(Collections.singletonList(training.getId())), param.getToken());
        }
        return 1;
    }

    @Override
    public LayuiGridData<TrainingChangeRecord> listTrainChangeRecord(TidParam param) {
        return this.changeRecordService.listTrainChangeRecord(param);
    }

    public void addTrainChangeRecord(TrainingUpdateParam param) throws IllegalAccessException {
        TrainingChangeRecord record = new TrainingChangeRecord(param.getTrainingId(), param.getModifyPerson(), new Date());
        TrainChangeRecordVo newTrain = this.addParamToChangeRecordVo(param);
        TrainChangeRecordVo oldTrain = this.trainToChangeRecordVo((Training)this.getTrainingInfo(param.getTrainingId()));
        StringBuilder changeInfo = new StringBuilder();
        for (Field field : newTrain.getClass().getDeclaredFields()) {
            String oldValue;
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
            }
            BeanPropertyName fieldName = field.getAnnotation(BeanPropertyName.class);
            String newValue = field.get(newTrain) == null ? "" : field.get(newTrain).toString();
            String string = oldValue = field.get(oldTrain) == null ? "" : field.get(oldTrain).toString();
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)oldValue)) continue;
            changeInfo.append(fieldName.name()).append("\u4ece\u3010").append(oldValue).append("\u3011\u53d8\u4e3a\u3010").append(newValue).append("\u3011\n");
        }
        if (param.getIsPersonTypeModify() != null && param.getIsPersonTypeModify() == 1) {
            changeInfo.append("\u4eba\u5458\u53ca\u8bc1\u4e66\u53d1\u751f\u4e86\u4fee\u6539\uff1b\n");
        }
        if (param.getIsIndustryModify() != null && param.getIsIndustryModify() == 1) {
            changeInfo.append("\u884c\u4e1a\u53d1\u751f\u4e86\u4fee\u6539\uff1b\n");
        }
        record.setChangeInfo(changeInfo.toString());
        this.changeRecordService.save(record);
    }

    @Override
    @Transactional
    @Caching(evict={@CacheEvict(value={"TRAINING:WORKTYPE:SEARCH"}, key="2")})
    public Integer changeTrainingStatus(TrainingStatusUpdateParam param) {
        List tidList = param.getTrainIdList();
        Integer rst = ((TrainingMapper)this.baseMapper).updateBatchTrainingStatus(param);
        TrainingAddParam addParam = new TrainingAddParam(param.getToken());
        addParam.setLoginName(param.getLoginName());
        addParam.setLoginUsername(param.getLoginUsername());
        tidList.stream().forEach(tid -> {
            Training train = (Training)this.getById((Serializable)tid);
            if (Objects.equals(train.getTrainTarget(), TrainTargetEnum.UNIT.getValue())) {
                this.addOrUpdateTrainToHSE(addParam, train, 2);
            }
            if (param.getStatus() == 2 && Objects.equals(train.getTrainTarget(), TrainTargetEnum.UNIT.getValue())) {
                this.pushMsgToHSE(new ArrayList<Long>(Collections.singletonList(train.getId())), param.getToken());
            }
        });
        if (rst > 0) {
            tidList.stream().forEach(tid -> {
                TrainingChangeRecord record = new TrainingChangeRecord(tid, param.getModifyPerson(), new Date());
                if (param.getStatus() == 2) {
                    record.setChangeInfo("\u72b6\u6001\u4ece\u3010\u5df2\u4e0b\u67b6\u3011\u53d8\u4e3a\u3010\u5df2\u4e0a\u67b6\u3011\u3002\n");
                } else if (param.getStatus() == 0) {
                    record.setChangeInfo("\u72b6\u6001\u4ece\u3010\u5df2\u4e0a\u67b6\u3011\u53d8\u4e3a\u3010\u5df2\u4e0b\u67b6\u3011\u3002\n");
                }
                this.changeRecordService.save(record);
                RedisUtils.deleteObject((String)RedisKey.getTrainInfoVo((Long)tid));
            });
        }
        return rst;
    }

    @Override
    public LayuiGridData<TrainingHomeVo> getTrainingHomeList(TrainHomeListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingHomeVo> rst = ((TrainingMapper)this.baseMapper).getTrainingHomeList(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<TrainingHomeListVo> getUntrainedList(TrainHomeListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingHomeListVo> rst = ((TrainingMapper)this.baseMapper).getUntrainedList(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<TrainHomeCropVo> getCropTrainList(TrainHomeCropParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainHomeCropVo> rst = ((TrainingMapper)this.baseMapper).getCropTrainList(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public List<TrainHomeCropExportVo> getCropTrainExportList(TrainHomeCropParam param) {
        return this.trainingConverter.homeCropVoToExportVo(this.getCropTrainList(param).getData());
    }

    @Override
    public LayuiGridData<RhoTrainHomeCropVo> getCropTrainListForRho(RhoTrainHomeCropParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RhoTrainHomeCropVo> rst = ((TrainingMapper)this.baseMapper).getCropTrainListForRho(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<TrainHomeUserVo> getUserTrainList(TrainHomeUserParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainHomeUserVo> rst = ((TrainingMapper)this.baseMapper).getUserTrainList(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public List<TrainHomeCetVo> getUserCetList(TrainHomeCetParam param) {
        List<TrainHomeCetVo> rst = ((TrainingMapper)this.baseMapper).getUserCetList(param);
        if (CollectionUtils.isNotEmpty(rst)) {
            for (TrainHomeCetVo cet : rst) {
                cet.setPdfUrl(this.ossClientBean.getUrl(cet.getPdfUrl()));
            }
        }
        return rst;
    }

    @Override
    public List<TrainHomeUserExportVo> getUserTrainCetExportList(TrainHomeUserParam param) {
        List<Object> rst = new ArrayList();
        if (param.getMajorCetBeginDate() != null) {
            List<TrainHomeUserExportVo> list = ((TrainingMapper)this.baseMapper).getUserTrainCetExportList(param);
            param.setUserIdList(list.stream().map(TrainHomeUserExportVo::getId).distinct().collect(Collectors.toList()));
            List<TrainHomeUserExportVo> remainingCetList = ((TrainingMapper)this.baseMapper).getUserCetByIdAndType(param);
            if (param.getManagerCetBeginDate() != null) {
                List<Object> fnl = new ArrayList();
                fnl = list.stream().filter(userCet -> remainingCetList.stream().anyMatch(remainingCet -> userCet.getId().equals(remainingCet.getId()))).collect(Collectors.toList());
                rst.addAll(fnl);
            }
            rst.addAll(remainingCetList);
        } else if (param.getMajorCetBeginDate() == null && param.getManagerCetBeginDate() != null) {
            rst = ((TrainingMapper)this.baseMapper).getUserTrainCetExportList(param);
            param.setUserIdList(rst.stream().map(TrainHomeUserExportVo::getId).distinct().collect(Collectors.toList()));
            List<TrainHomeUserExportVo> remainingCetList = ((TrainingMapper)this.baseMapper).getUserCetByIdAndType(param);
            rst.addAll(remainingCetList);
        } else if (param.getNonMedicalCetBeginDate() != null && param.getNonMedicalCetEndDate() != null) {
            rst = ((TrainingMapper)this.baseMapper).getUserTrainCetExportList(param);
            param.setUserIdList(rst.stream().map(TrainHomeUserExportVo::getId).distinct().collect(Collectors.toList()));
            List<TrainHomeUserExportVo> remainingCetList = ((TrainingMapper)this.baseMapper).getUserCetByIdAndType(param);
            rst.addAll(remainingCetList);
        } else {
            return ((TrainingMapper)this.baseMapper).getUserTrainCetExportList(param);
        }
        return rst;
    }

    @Override
    public LayuiGridData<RhoTrainHomeUserVo> getUserTrainListForRho(RhoTrainHomeUserParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RhoTrainHomeUserVo> rst = ((TrainingMapper)this.baseMapper).getUserTrainListForRho(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<AssoScoreListVo> listScoreForAssociation(AssoScoreListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<AssoScoreListVo> rst = ((TrainingMapper)this.baseMapper).listScoreForAssociation(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<ApiScoreSearchVo> searchScoreByUserForApi(PageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ApiScoreSearchVo> rst = ((TrainingMapper)this.baseMapper).searchScoreByUserForApi(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<ApiScoreSearchVo> searchScoreByCompanyForApi(PageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ApiScoreSearchVo> rst = ((TrainingMapper)this.baseMapper).searchScoreByCompanyForApi(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public Long addTrainingDetail(TrainingAddParam param) {
        Training train = this.trainingConverter.addParamToTraining(param);
        this.save(train);
        this.personCertificateService.addTrainPersonCertificate(train.getId(), param.getPersonTypeCertificateList());
        if (Objects.equals(train.getTrainTarget(), TrainTargetEnum.UNIT.getValue()) || Objects.equals(train.getTrainTarget(), TrainTargetEnum.RAY_MANGER.getValue()) || Objects.equals(train.getTrainTarget(), TrainTargetEnum.RAY_WORK.getValue()) || Objects.equals(train.getTrainTarget(), TrainTargetEnum.RAY_WORK_NON_MEDICAL.getValue())) {
            this.trainingIndustryService.addTrainIndustry(train.getId(), param.getTrainIndustryList());
        }
        if (param.getStatus() == 2 && Objects.equals(train.getTrainTarget(), TrainTargetEnum.UNIT.getValue())) {
            this.addOrUpdateTrainToHSE(param, train, 1);
            this.pushMsgToHSE(new ArrayList<Long>(Collections.singletonList(train.getId())), param.getToken());
        }
        return train.getId();
    }

    @Override
    @Transactional
    public Integer removeBatchTrainingInfo(TrainingDelParam param) {
        List trainIdList = param.getTrainIdList();
        trainIdList.stream().forEach(item -> {
            Integer countEnrollNum;
            Training train = (Training)((TrainingMapper)this.baseMapper).selectById((Serializable)item);
            if (!param.getIsSpecifiedUser().booleanValue() && !Objects.equals(param.getUid(), train.getCreateBy())) {
                throw new ServiceException("\u65e0\u6cd5\u5220\u9664\u5176\u4ed6\u8d26\u53f7\u521b\u5efa\u7684\u57f9\u8bad\uff01");
            }
            if (train.getStatus() != null && train.getStatus() != 2 && (countEnrollNum = ((TrainingMapper)this.baseMapper).countEnrollNumByTid((Long)item, param.getIsSpecifiedUser())) == 0) {
                if (Objects.equals(train.getTrainTarget(), TrainTargetEnum.UNIT.getValue())) {
                    this.addOrUpdateTrainToHSE(new TrainingAddParam(), new Training(item), 3);
                }
                ((TrainingMapper)this.baseMapper).deleteById((Serializable)item);
                this.trainingWorkTypeService.removeTrainWorkTypeByTid((Long)item);
                this.trainingIndustryService.delTrainIndustry((Long)item);
                this.personCertificateService.delPersonCertificate((Long)item);
            }
        });
        return 1;
    }

    @Override
    @Transactional
    public Long cloneTrainByTid(Long tid, Long userId, Boolean isSpecifiedUser, String version) {
        TrainingDetailVo info = this.getTrainingInfo(tid);
        if (!info.getCreateBy().equals(userId) && !isSpecifiedUser.booleanValue()) {
            throw new ServiceException("\u65e0\u6cd5\u514b\u9686\u5176\u4ed6\u7528\u6237\u7684\u57f9\u8bad\uff01");
        }
        Training train = this.trainingConverter.voToEntity(info);
        train.setId(null);
        train.setTrainName(null);
        train.setTrainEndTime(null);
        train.setSignStarTime(null);
        train.setSignEndTime(null);
        train.setStatus(Byte.valueOf((byte)1));
        train.setCreateTime(new Date());
        train.setVersion(version);
        this.save(train);
        this.trainingIndustryService.cloneTrainIndustry(tid, train.getId());
        this.personCertificateService.clonePersonCertificate(tid, train.getId());
        this.trainingCourseService.cloneTrainCourse(tid, train.getId());
        return train.getId();
    }

    @Override
    public List<Training> listWillOverTrain(Integer dayNum) {
        return ((TrainingMapper)this.baseMapper).batchWillOverTrain(dayNum);
    }

    @Override
    public List<TrainTestMsgVo> listWillOverTest(Integer dayNum) {
        return ((TrainingMapper)this.baseMapper).batchWillOverTest(dayNum);
    }

    @Override
    public LayuiGridData<TrainingListVo> getTrainingPageListForApi(TrainingSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingListVo> trainingList = ((TrainingMapper)this.baseMapper).listTrainingPageForApi(param);
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    public TrainingBaseInfoVo getTrainingBaseInfo(TrainingSearchParam param) {
        TrainingBaseInfoVo result = ((TrainingMapper)this.baseMapper).getTrainingBaseInfo(param);
        if (result != null) {
            result.setCoverUrl(this.ossClientBean.getUrl(result.getCoverUrl()));
        }
        return result;
    }

    @Override
    public Integer countEnrollNumByTrainId(Long tid) {
        return ((TrainingMapper)this.baseMapper).countEnrollNumByTrainId(tid);
    }

    @Override
    public Integer countEnrollNumByTrainIdForCourse(Long tid) {
        return ((TrainingMapper)this.baseMapper).countEnrollNumByTrainIdForCourse(tid);
    }

    @Override
    public List<AbutmentTrainListVo> getAbutmentTrainList() {
        return null;
    }

    @Override
    public AbutmentTrainInfoVo getAbutmentTrainInfo(Long tid) {
        return null;
    }

    @Override
    public AbutmentTrainChangeVo getAbutmentTrainChangeInfo(Long tid) {
        return null;
    }

    @Override
    public void pushMsgToHSE(List<Long> trainIdList, String token) {
        if (token != null) {
            trainIdList.stream().forEach(tid -> {
                TrainingDetailVo trainInfo = this.getTrainingInfo((Long)tid);
                this.trainPlanService.sendOnlineTrainAddMessage(Long.valueOf(Long.parseLong(token)), tid, trainInfo.getTrainArea(), Byte.valueOf((byte)StringUtils.getAreaLevel((Long)trainInfo.getTrainArea())), trainInfo.getTrainName(), "training/detail/" + tid, trainInfo.getSendBelong());
            });
        }
    }

    @Override
    public Integer updateHseTrainArea() {
        List onlineTrainIdList = this.syncTrainInfoService.getAllOnlineTrainId();
        if (onlineTrainIdList == null || onlineTrainIdList.isEmpty()) {
            throw new ServiceException("\u53ef\u540c\u6b65\u57f9\u8bad\u5217\u8868\u4e3a\u7a7a");
        }
        onlineTrainIdList.stream().forEach(tid -> {
            Training train = (Training)this.getById((Serializable)tid);
            SyncTrainInfoModel syncTrainInfoModel = new SyncTrainInfoModel();
            syncTrainInfoModel.setTrainId(tid);
            syncTrainInfoModel.setAreaId(train.getTrainArea());
            this.syncTrainInfoService.addOrUpdateTrainInfo(syncTrainInfoModel);
        });
        return null;
    }

    @Override
    public Training getByIdNoLogic(Long tid) {
        return ((TrainingMapper)this.baseMapper).getByIdNoLogic(tid);
    }

    @Override
    public void manuallySyncTrainInfo(Long tid) {
        Training train = (Training)this.getById(tid);
        SyncTrainInfoModel syncTrainInfoModel = new SyncTrainInfoModel();
        syncTrainInfoModel.setTrainId(train.getId());
        syncTrainInfoModel.setTrainName(train.getTrainName());
        syncTrainInfoModel.setTrainTimeBegin(train.getTrainStarTime());
        syncTrainInfoModel.setTrainTimeEnd(train.getTrainEndTime());
        syncTrainInfoModel.setTrainType(train.getTrainType());
        syncTrainInfoModel.setAreaId(train.getTrainArea());
        syncTrainInfoModel.setOperater(train.getCreateName());
        syncTrainInfoModel.setCompanyName(train.getCreateName());
        syncTrainInfoModel.setCreateBy(train.getCreateBy());
        syncTrainInfoModel.setChangeType(Byte.valueOf((byte)2));
        syncTrainInfoModel.setChangeReason("\u65b0\u589e\u57f9\u8bad");
        this.syncTrainInfoService.addOrUpdateTrainInfo(syncTrainInfoModel);
    }

    @Override
    public Training getByImportedId(String importedId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(Training::getImportedId, (Object)importedId);
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return null;
        }
        if (list.size() >= 2) {
            throw new ServiceException("\u5b58\u5728\u91cd\u590d\u57f9\u8bad\uff0c\u57f9\u8badid\u5982\u4e0b\uff1a" + importedId);
        }
        return (Training)list.get(0);
    }

    public void addOrUpdateTrainToHSE(TrainingAddParam param, Training train, int mode) {
        try {
            String s;
            SyncTrainInfoModel syncTrainInfoModel = new SyncTrainInfoModel();
            if (mode == 3) {
                syncTrainInfoModel.setTrainId(train.getId());
                syncTrainInfoModel.setTrainName(((Training)this.getById(train.getId())).getTrainName());
                syncTrainInfoModel.setIsValid(Boolean.valueOf(false));
                syncTrainInfoModel.setChangeReason("\u5220\u9664\u57f9\u8bad");
                syncTrainInfoModel.setOperater(param.getLoginUsername());
                syncTrainInfoModel.setCompanyName(param.getLoginName());
                syncTrainInfoModel.setCreateBy(train.getCreateBy());
                this.syncTrainInfoService.addOrUpdateTrainInfo(syncTrainInfoModel);
                return;
            }
            syncTrainInfoModel.setTrainId(train.getId());
            syncTrainInfoModel.setTrainName(train.getTrainName());
            syncTrainInfoModel.setTrainTimeBegin(train.getTrainStarTime());
            syncTrainInfoModel.setTrainTimeEnd(train.getTrainEndTime());
            syncTrainInfoModel.setTrainType(train.getTrainType());
            syncTrainInfoModel.setAreaId(train.getTrainArea());
            syncTrainInfoModel.setOperater(param.getLoginUsername());
            syncTrainInfoModel.setCompanyName(param.getLoginName());
            syncTrainInfoModel.setIsValid(Boolean.valueOf(true));
            if (mode == 1) {
                syncTrainInfoModel.setCreateBy(Long.valueOf(Long.parseLong(param.getToken())));
                syncTrainInfoModel.setChangeType(Byte.valueOf((byte)2));
                syncTrainInfoModel.setChangeReason("\u65b0\u589e\u57f9\u8bad");
            }
            if (mode == 2) {
                if (train.getStatus() == 2) {
                    syncTrainInfoModel.setChangeType(Byte.valueOf((byte)2));
                    syncTrainInfoModel.setChangeReason("\u4e0a\u67b6\u57f9\u8bad");
                } else if (train.getStatus() == 0) {
                    syncTrainInfoModel.setChangeType(Byte.valueOf((byte)3));
                    syncTrainInfoModel.setChangeReason("\u4e0b\u67b6\u57f9\u8bad");
                }
            }
            if ((s = this.syncTrainInfoService.addOrUpdateTrainInfo(syncTrainInfoModel)) == null || !s.contains("\u540c\u6b65\u6210\u529f")) {
                throw new ServiceException(s);
            }
        }
        catch (Exception e) {
            throw new ServiceException("RPC\u670d\u52a1\u9519\u8bef\uff01\u540c\u6b65\u57f9\u8bad\u4fe1\u606f\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
    }

    private TrainChangeRecordVo addParamToChangeRecordVo(TrainingUpdateParam param) {
        if (param == null) {
            return null;
        }
        TrainChangeRecordVo trainChangeRecordVo = new TrainChangeRecordVo();
        trainChangeRecordVo.setTrainName(param.getTrainName());
        trainChangeRecordVo.setSignEndTime(new SimpleDateFormat("yyyy-MM-dd").format(param.getSignEndTime()));
        trainChangeRecordVo.setTrainStarTime(new SimpleDateFormat("yyyy-MM-dd").format(param.getTrainStarTime()));
        trainChangeRecordVo.setTrainEndTime(new SimpleDateFormat("yyyy-MM-dd").format(param.getTrainEndTime()));
        trainChangeRecordVo.setTrainType(param.getTrainType());
        trainChangeRecordVo.setIsCharge(param.getIsCharge() == null ? "" : (param.getIsCharge() == 0 ? "\u4e0d\u6536\u8d39" : "\u6536\u8d39"));
        trainChangeRecordVo.setIsTestOnline(param.getIsTestOnline() == null ? "" : (param.getIsTestOnline() == 0 ? "\u5426" : "\u662f"));
        trainChangeRecordVo.setTrainArea(param.getTrainArea() == null ? "" : this.areaProviderService.getAreaNameById(param.getTrainArea()));
        trainChangeRecordVo.setRetestLimit((String)(param.getRetestLimit() == null ? "" : (param.getRetestLimit() == -10 ? "\u4e0d\u9650\u6b21\u6570" : param.getRetestLimit() + "\u6b21")));
        trainChangeRecordVo.setRetestSetting(param.getRetestSetting() == null ? "" : (param.getRetestSetting() == 0 ? "\u539f\u9898\u91cd\u8003" : (param.getRetestSetting() == 1 ? "\u539f\u9898\u6253\u4e71" : "\u91cd\u7ec4\u8bd5\u5377")));
        trainChangeRecordVo.setTestMode(param.getTestMode() == null ? "" : (param.getTestMode() == 0 ? "\u5206\u522b\u8003\u8bd5" : "\u7edf\u4e00\u8003\u8bd5"));
        trainChangeRecordVo.setTestPaperUsage(param.getTestPaperUsage() == null ? "" : (param.getTestPaperUsage() == 1 ? "\u5b66\u5458\u5171\u7528" : "\u968f\u673a\u5206\u914d"));
        trainChangeRecordVo.setStatus(param.getStatus() == null ? "" : (param.getStatus() == 0 ? "\u5df2\u4e0b\u67b6" : (param.getStatus() == 1 ? "\u8349\u7a3f" : "\u5df2\u4e0a\u67b6")));
        trainChangeRecordVo.setIsFaceRecognition(param.getIsFaceRecognition() == null ? "" : (param.getIsFaceRecognition() == 0 ? "\u4e0d\u9700\u8981" : "\u9700\u8981"));
        trainChangeRecordVo.setPaperStructureName(param.getPaperStructureName());
        trainChangeRecordVo.setTotalScore("" + param.getTotalScore());
        trainChangeRecordVo.setTestDuration("" + param.getTestDuration());
        trainChangeRecordVo.setPassingScore("" + param.getPassingScore());
        return trainChangeRecordVo;
    }

    private TrainChangeRecordVo trainToChangeRecordVo(Training param) {
        if (param == null) {
            return null;
        }
        TrainChangeRecordVo trainChangeRecordVo = new TrainChangeRecordVo();
        trainChangeRecordVo.setTrainName(param.getTrainName());
        trainChangeRecordVo.setSignEndTime(new SimpleDateFormat("yyyy-MM-dd").format(param.getSignEndTime()));
        trainChangeRecordVo.setTrainStarTime(new SimpleDateFormat("yyyy-MM-dd").format(param.getTrainStarTime()));
        trainChangeRecordVo.setTrainEndTime(new SimpleDateFormat("yyyy-MM-dd").format(param.getTrainEndTime()));
        trainChangeRecordVo.setTrainType(param.getTrainType());
        trainChangeRecordVo.setIsCharge(param.getIsCharge() == null ? "" : (param.getIsCharge() == 0 ? "\u4e0d\u6536\u8d39" : "\u6536\u8d39"));
        trainChangeRecordVo.setIsTestOnline(param.getIsTestOnline() == null ? "" : (param.getIsTestOnline() == 0 ? "\u5426" : "\u662f"));
        trainChangeRecordVo.setTrainArea(param.getTrainArea() == null ? "" : this.areaProviderService.getAreaNameById(param.getTrainArea()));
        trainChangeRecordVo.setRetestLimit((String)(param.getRetestLimit() == null ? "" : (param.getRetestLimit() == -10 ? "\u4e0d\u9650\u6b21\u6570" : param.getRetestLimit() + "\u6b21")));
        trainChangeRecordVo.setRetestSetting(param.getRetestSetting() == null ? "" : (param.getRetestSetting() == 0 ? "\u539f\u9898\u91cd\u8003" : (param.getRetestSetting() == 1 ? "\u539f\u9898\u6253\u4e71" : "\u91cd\u7ec4\u8bd5\u5377")));
        trainChangeRecordVo.setTestMode(param.getTestMode() == null ? "" : (param.getTestMode() == 0 ? "\u5206\u522b\u8003\u8bd5" : "\u7edf\u4e00\u8003\u8bd5"));
        trainChangeRecordVo.setTestPaperUsage(param.getTestPaperUsage() == null ? "" : (param.getTestPaperUsage() == 1 ? "\u5b66\u5458\u5171\u7528" : "\u968f\u673a\u5206\u914d"));
        trainChangeRecordVo.setStatus(param.getStatus() == null ? "" : (param.getStatus() == 0 ? "\u5df2\u4e0b\u67b6" : (param.getStatus() == 1 ? "\u8349\u7a3f" : "\u5df2\u4e0a\u67b6")));
        trainChangeRecordVo.setIsFaceRecognition(param.getIsFaceRecognition() == null ? "" : (param.getIsFaceRecognition() == 0 ? "\u4e0d\u9700\u8981" : "\u9700\u8981"));
        trainChangeRecordVo.setPaperStructureName(param.getPaperStructureName());
        trainChangeRecordVo.setTotalScore("" + param.getTotalScore());
        trainChangeRecordVo.setTestDuration("" + param.getTestDuration());
        trainChangeRecordVo.setPassingScore("" + param.getPassingScore());
        return trainChangeRecordVo;
    }
}

