/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.question.entity.PaperStructure;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperStructureProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysOccupationalHazardsProviderService;
import cn.smarthse.radiationTraining.modules.training.converter.TrainingCourseConverter;
import cn.smarthse.radiationTraining.modules.training.converter.TrainingCourseGroupConverter;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingCourseMapper;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourseGroup;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCoursePersonType;
import cn.smarthse.radiationTraining.modules.training.enums.CourseTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.training.AddNewTrainCourseGroupParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainNewCourseGroupParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemIndustryService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemPersonTypeService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemRaditaionService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCoursePersonTypeService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxTrainCourseGroupVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class TrainingCourseServiceImpl
extends ServiceImpl<TrainingCourseMapper, TrainingCourse>
implements ITrainingCourseService {
    @Autowired(required=false)
    private TrainingCourseConverter courseConverter;
    @Autowired(required=false)
    private TrainingCourseGroupConverter courseGroupConverter;
    @Autowired
    private ITrainingCourseGroupService trainingCourseGroupService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ICourseItemService courseItemService;
    @Autowired
    private ICourseGroupService courseGroupService;
    @Autowired
    private ICourseGroupItemService courseGroupItemService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITrainingRedisService trainingRedisService;
    @Autowired
    private ICourseRedisService courseRedisService;
    @Autowired
    private ICourseItemPersonTypeService courseItemPersonTypeService;
    @Autowired
    private ICourseItemRaditaionService courseItemRaditaionService;
    @Autowired
    private ICourseItemIndustryService courseItemIndustryService;
    @Autowired
    private ITrainingCoursePersonTypeService trainingCoursePersonTypeService;
    @DubboReference
    private IPaperStructureProviderService paperStructureProviderService;
    @DubboReference
    private ISysOccupationalHazardsProviderService sysOccupationalHazardsProviderService;

    @Override
    public LayuiGridData<TrainingNewCourseGroupVo> getNewTrainCourse(TrainingSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingNewCourseGroupVo> courseGroupList = this.trainingCourseGroupService.listNewTrainCourseGroup(param);
        courseGroupList.stream().forEach(item -> {
            item.setPersonType(this.trainingCourseGroupService.listPersonTypeByTAG(param.getTrainingId(), item.getCourseGroupId()));
            item.setIndustryList(this.trainingCourseGroupService.listIndustryByTAG(param.getTrainingId(), item.getCourseGroupId()));
            List<TrainingNewCourseVo> courseVoList = ((TrainingCourseMapper)this.baseMapper).listNewTrainCourse(param.getTrainingId(), item.getId());
            if (null != courseVoList && !courseVoList.isEmpty()) {
                courseVoList.stream().forEach(v -> {
                    v.setIndustryCodes(Arrays.asList(v.getIndustry()));
                    v.setPersonTypeCodes(Arrays.asList(v.getPersonTypeCode().split(",")));
                    v.setPersonTypeStudyList(this.trainingCoursePersonTypeService.getListByTrainCourseId(v.getId()));
                });
            }
            item.setCourseList(courseVoList);
        });
        return new LayuiGridData((Page)courseGroupList, (LayuiGridParam)param);
    }

    @Override
    public List<TrainingNewCourseGroupVo> getNewTrainCourseList(TrainingSearchParam param) {
        List<TrainingNewCourseGroupVo> courseGroupList = this.trainingCourseGroupService.listNewTrainCourseGroup(param);
        courseGroupList.stream().forEach(item -> {
            List<TrainingNewCourseVo> courseVoList = ((TrainingCourseMapper)this.baseMapper).listNewTrainCourseForUser(param.getTrainingId(), param.getUid(), item.getId());
            item.setCourseList(courseVoList);
        });
        return courseGroupList;
    }

    @Override
    @Transactional
    public void cloneTrainCourse(Long oldTid, Long newTid) {
        QueryWrapper groupWrapper = new QueryWrapper();
        ((QueryWrapper)groupWrapper.eq((Object)"tid", (Object)oldTid)).eq((Object)"is_valid", (Object)Constant.YES);
        List groupList = this.trainingCourseGroupService.list((Wrapper)groupWrapper);
        groupList.stream().forEach(group -> {
            group.setId(null);
            group.setTid(newTid);
            group.setCreateTime(new Date());
            group.setUpdateTime(null);
        });
        this.trainingCourseGroupService.saveBatch(groupList);
        List<TrainingCourse> courseList = this.getTrainingCourseListByTid(oldTid);
        for (TrainingCourse course : courseList) {
            List<TrainingCoursePersonType> personTypeList = this.trainingCoursePersonTypeService.getListByTrainCourseId(course.getId());
            course.setId(null);
            course.setTid(newTid);
            course.setCreateTime(new Date());
            course.setUpdateTime(null);
            for (TrainingCourseGroup group2 : groupList) {
                if (!Objects.equals(group2.getCourseGroupId(), course.getCourseGroupId())) continue;
                course.setTrainCourseGroupId(group2.getId());
            }
            this.save(course);
            for (TrainingCoursePersonType personType : personTypeList) {
                personType.setId(null);
                personType.setTrainingCourseId(course.getId());
                personType.setTid(newTid);
            }
            this.trainingCoursePersonTypeService.saveBatch(personTypeList);
        }
    }

    @Override
    @Transactional
    @CacheEvict(cacheNames={"TRAINING:COURSE:NUM", "TRAINING:INFO", "TRAINING:COURSE_HOUR:NUM"}, key="#param.tid")
    public void saveOrUpdateNewTrainCourse(AddNewTrainCourseGroupParam param) {
        Integer enrollNum = this.trainingService.countEnrollNumByTrainIdForCourse(param.getTid());
        if (enrollNum == null || enrollNum == 0) {
            this.saveOrUpdateCourseForNoEnroll(param);
        } else {
            this.updateCourseForHasEnroll(param);
        }
    }

    private void saveOrUpdateCourseForNoEnroll(AddNewTrainCourseGroupParam param) {
        Long tid = param.getTid();
        TrainingDetailVo trainInfo = this.trainingService.getTrainingInfo(tid);
        List<TrainingCourseGroup> inGroupList = this.courseGroupConverter.newAddParamToEntity(param.getCourseGroupParamList());
        int cnt = 1;
        for (TrainingCourseGroup group : inGroupList) {
            group.setId(null);
            group.setGroupIndex(Integer.valueOf(cnt++));
            group.setTid(tid);
            group.setCreateBy(param.getLoginUserId());
        }
        ArrayList<TrainingCoursePersonType> studyStatusList = new ArrayList<TrainingCoursePersonType>();
        Set<TrainingCourse> inCourseList = this.removeRepeatCourse(param.getCourseGroupParamList(), tid, studyStatusList);
        this.trainingCourseGroupService.delTrainCourseGroupByTid(tid);
        ((TrainingCourseMapper)this.baseMapper).delTrainCourseByTid(tid);
        this.trainingCoursePersonTypeService.delListByTid(tid);
        this.trainingCourseGroupService.saveBatch(inGroupList);
        Map<Long, PaperStructure> structureMap = this.courseItemService.getCoursePaperStructs(inCourseList);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tid", (Object)tid);
        List newCourseGroupList = this.trainingCourseGroupService.list((Wrapper)queryWrapper);
        inCourseList.forEach(item -> {
            this.checkTrainCourseField((TrainingCourse)item);
            this.trainingRedisService.delTrainCourseHashCache(item.getId());
            item.setId(null);
            List tmp = newCourseGroupList.stream().filter(v -> Objects.equals(v.getCourseGroupId(), item.getCourseGroupId())).collect(Collectors.toList());
            item.setTrainCourseGroupId(((TrainingCourseGroup)tmp.get(0)).getId());
            if (trainInfo.getIsTestOnline() == 0 || trainInfo.getTestMode() != null && trainInfo.getTestMode() == 0) {
                this.setPaperStructure((TrainingCourse)item, structureMap);
            } else {
                this.setPaperStructureCentralized((TrainingCourse)item, trainInfo.getPaperStructureId());
            }
            item.setCreateBy(param.getLoginUserId());
        });
        this.saveBatch(inCourseList);
        studyStatusList.forEach(item -> {
            for (TrainingCourse trainingCourse : inCourseList) {
                if (!trainingCourse.getCourseId().equals(item.getCourseId())) continue;
                item.setId(null);
                item.setTid(tid);
                item.setTrainingCourseId(trainingCourse.getId());
                break;
            }
        });
        this.trainingCoursePersonTypeService.saveBatch(studyStatusList);
        this.trainingRedisService.rmBaseCourseCataLogue(param.getTid());
    }

    private void updateCourseForHasEnroll(AddNewTrainCourseGroupParam param) {
        List<TrainingCourseGroup> groupList = this.courseGroupConverter.newAddParamToEntity(param.getCourseGroupParamList());
        List<TrainingNewCourseVo> inCourseList = param.getCourseGroupParamList().stream().flatMap(courseGroup -> courseGroup.getCourseList().stream()).collect(Collectors.toList());
        List<TrainingCourse> courseList = this.courseConverter.newCourseVoListToEntityList(inCourseList);
        List<TrainingCoursePersonType> coursePersonTypeList = inCourseList.stream().flatMap(course -> course.getPersonTypeStudyList().stream()).collect(Collectors.toList());
        courseList.stream().forEach(course -> this.checkTrainCourseField((TrainingCourse)course));
        courseList.forEach(course -> course.setUpdateBy(param.getLoginUserId()));
        groupList.forEach(group -> group.setUpdateBy(param.getLoginUserId()));
        coursePersonTypeList.forEach(item -> item.setUpdateBy(param.getLoginUserId()));
        this.trainingCourseGroupService.updateBatchById(groupList);
        this.updateBatchById(courseList);
        this.trainingCoursePersonTypeService.updateBatchById(coursePersonTypeList);
        this.trainingRedisService.rmBaseCourseCataLogue(param.getTid());
        this.trainingRedisService.rmBaseCourseCataLogue(param.getTid());
        courseList.stream().forEach(course -> {
            this.trainingRedisService.delTrainCourseHashCache(course.getId());
            this.tuCourseService.updateRedundency(param.getTid(), course.getCourseId());
        });
    }

    private void checkTrainCourseField(TrainingCourse course) {
        if (StrUtil.isEmpty((CharSequence)course.getVideoUrl()) || course.getVideoDurationSec() == null || course.getClassHour() == null || course.getPaperStructureId() == null) {
            throw new ServiceException("\u8bfe\u7a0b\u3010" + course.getCourseName() + "\u3011\u4e2d'\u89c6\u9891\u94fe\u63a5\u3001\u8bfe\u65f6\u3001\u65f6\u957f\u3001\u8bd5\u5377\u7ed3\u6784'\u5b57\u6bb5\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    @Cacheable(cacheNames={"TRAINING:COURSE:NUM"}, key="#tid")
    public int getTrainingCourseTotalNum(Long tid) {
        List<TrainingCourse> trainingCourseList = this.getTrainingCourseListByTid(tid);
        if (CollectionUtils.isEmpty(trainingCourseList)) {
            return 0;
        }
        return trainingCourseList.stream().map(TrainingCourse::getCourseId).collect(Collectors.toSet()).size();
    }

    @Override
    @Cacheable(cacheNames={"TRAINING:COURSE_HOUR:NUM"}, key="#tid")
    public Double getTrainingCourseHourNum(Long tid) {
        List<TrainingCourse> trainingCourseList = this.getTrainingCourseListByTid(tid);
        if (CollectionUtils.isEmpty(trainingCourseList)) {
            return 0.0;
        }
        double rst = 0.0;
        for (TrainingCourse course : trainingCourseList) {
            rst += course.getClassHour().doubleValue();
        }
        return rst;
    }

    @Override
    public TrainingCourse getPaperInfoByTid(Long tid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"tid", (Object)tid)).last("limit 1");
        return (TrainingCourse)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public CourseItemVo getNewCourseInfo(Long courseId) {
        if (courseId == null) {
            throw new RuntimeException("\u8bfe\u7a0bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CourseItemVo courseItemVo = this.courseItemService.getCourseItemById(courseId);
        if (courseItemVo == null) {
            throw new RuntimeException("\u539f\u8bfe\u7a0b\u5df2\u88ab\u5220\u9664\uff01");
        }
        return courseItemVo;
    }

    @Override
    public String delTrainCourseRedis() {
        this.trainingRedisService.delTrainCourseAndCatalogue();
        return null;
    }

    public void setPaperStructure(TrainingCourse trainingCourse, Map<Long, PaperStructure> structureMap) {
        PaperStructure paperStructure = structureMap.get(trainingCourse.getCourseId());
        if (paperStructure == null) {
            throw new RuntimeException("\u8bd5\u5377\u7ed3\u6784\u4e0d\u5b58\u5728\uff01");
        }
        trainingCourse.setPaperStructureId(paperStructure.getId());
        trainingCourse.setWay(paperStructure.getWay());
        trainingCourse.setSingleNum(paperStructure.getSingleNum());
        trainingCourse.setMultipleNum(paperStructure.getMultipleNum());
        trainingCourse.setJudgeNum(paperStructure.getJudgeNum());
        trainingCourse.setCompletionNum(paperStructure.getCompletionNum());
        trainingCourse.setSingleScore(paperStructure.getSingleScore());
        trainingCourse.setMultipleScore(paperStructure.getMultipleScore());
        trainingCourse.setCompletionScore(paperStructure.getCompletionScore());
        trainingCourse.setJudgeScore(paperStructure.getJudgeScore());
        trainingCourse.setTotalScore(paperStructure.getTotalScore());
    }

    public void setPaperStructureCentralized(TrainingCourse trainingCourse, Long structureId) {
        if (structureId == null) {
            throw new RuntimeException("\u8bd5\u5377\u7ed3\u6784id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PaperStructure paperStructure = this.paperStructureProviderService.getPaperStructureDetailById(structureId);
        if (paperStructure != null) {
            trainingCourse.setPaperStructureId(paperStructure.getId());
            trainingCourse.setWay(paperStructure.getWay());
            trainingCourse.setSingleNum(paperStructure.getSingleNum());
            trainingCourse.setMultipleNum(paperStructure.getMultipleNum());
            trainingCourse.setCompletionNum(paperStructure.getCompletionNum());
            trainingCourse.setJudgeNum(paperStructure.getJudgeNum());
            trainingCourse.setSingleScore(paperStructure.getSingleScore());
            trainingCourse.setMultipleScore(paperStructure.getMultipleScore());
            trainingCourse.setCompletionScore(paperStructure.getCompletionScore());
            trainingCourse.setJudgeScore(paperStructure.getJudgeScore());
            trainingCourse.setTotalScore(paperStructure.getTotalScore());
        }
    }

    private Set<TrainingCourse> removeRepeatCourse(List<TrainNewCourseGroupParam> inGroupList, Long tid, List<TrainingCoursePersonType> studyStatusList) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        List personCertificateList = trainingInfo.getPersonCertificateList();
        List personTypeList = personCertificateList.stream().map(v -> "" + v.getPersonType()).collect(Collectors.toList());
        List listList = inGroupList.stream().map(TrainNewCourseGroupParam::getCourseList).collect(Collectors.toList());
        HashSet<TrainingNewCourseVo> courseVoList = new HashSet<TrainingNewCourseVo>();
        for (List tmp : listList) {
            int cnt = 1;
            for (TrainingNewCourseVo item : tmp) {
                Set courseIdList;
                boolean isMatch = false;
                if (item.getCourseType() != null && item.getCourseType() == CourseTypeEnum.SPECIAL.getValue()) {
                    if (null == item.getPersonTypeCodes() || item.getPersonTypeCodes().isEmpty()) continue;
                    for (String personType : item.getPersonTypeCodes()) {
                        if (!personType.equals("0") && !personTypeList.contains(personType)) continue;
                        isMatch = true;
                        break;
                    }
                } else if (item.getCourseType() == CourseTypeEnum.GENERAL.getValue()) {
                    isMatch = true;
                }
                if (!isMatch || (courseIdList = courseVoList.stream().map(TrainingNewCourseVo::getCourseId).collect(Collectors.toSet())).contains(item.getCourseId())) continue;
                item.setCourseIndex(Integer.valueOf(cnt++));
                item.setTid(tid);
                if (trainingInfo.getIsTestOnline() == 0) {
                    item.setIsTest(Byte.valueOf((byte)0));
                    item.setIsPass(Byte.valueOf((byte)0));
                }
                if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 1) {
                    item.setIsTest(Byte.valueOf((byte)1));
                    item.setIsPass(Byte.valueOf((byte)1));
                }
                courseVoList.add(item);
                studyStatusList.addAll(item.getPersonTypeStudyList());
            }
        }
        return this.courseConverter.addNewParamToEntity(courseVoList);
    }

    @Override
    public List<TrainingCourse> getTrainingCourseListByTid(Long tid) {
        QueryWrapper trainingCourseQueryWrapper = new QueryWrapper();
        ((QueryWrapper)trainingCourseQueryWrapper.eq((Object)"tid", (Object)tid)).eq((Object)"is_valid", (Object)Constant.YES);
        return ((TrainingCourseMapper)this.baseMapper).selectList((Wrapper)trainingCourseQueryWrapper);
    }

    @Override
    public Boolean isSelectedInTrain(Long courseId) {
        return false;
    }

    @Override
    public List<TrainingCourseVo> getTrainingCourseForApi(Long tid, Long courseGroupId) {
        return ((TrainingCourseMapper)this.baseMapper).getTrainingCourseForApi(tid, courseGroupId);
    }

    @Override
    public List<UserMyTrainCourseVo> getTrainingCourse(Long tid, Long uid, Long courseGroupId) {
        return ((TrainingCourseMapper)this.baseMapper).listTrainingCourseForUser(tid, uid, courseGroupId);
    }

    @Override
    public List<UserMyTrainCourseVo> getMyTrainingCourse(Long tid, Long uid, Long courseGroupId) {
        List<UserMyTrainCourseVo> vos = ((TrainingCourseMapper)this.baseMapper).listMyTrainingCourseForUser(tid, uid, courseGroupId);
        vos.stream().forEach(item -> {
            List<CourseWorkTypeVo> workTypeList = this.courseGroupItemService.getWorkTypeByCourseItemId(item.getCourseId().toString());
            item.setWorkTypeList(workTypeList);
        });
        return vos;
    }

    @Override
    public List<WxTrainCourseGroupVo> getTrainCourseListForWx(Long tid) {
        List<WxTrainCourseGroupVo> rst = this.trainingCourseGroupService.listCourseGroupForWx(tid);
        rst.stream().forEach(group -> {
            List<TrainingCourseVo> courseList = ((TrainingCourseMapper)this.baseMapper).listTrainingCourseForWx(tid, group.getId());
            group.setCourseList(courseList);
        });
        return rst;
    }

    @Override
    public List<TrainingCourseVo> getTrainingCourseForCorp(Long tid, Long trainCourseGroupId) {
        List<TrainingCourseVo> rst = ((TrainingCourseMapper)this.baseMapper).listTrainingCourseForCorp(tid, trainCourseGroupId);
        if (rst != null && !rst.isEmpty()) {
            rst.stream().forEach(course -> {
                String nameStr = this.sysOccupationalHazardsProviderService.getNameStrByCodeStr(course.getRiskFactor());
                course.setRiskFactorNameList(nameStr);
            });
        }
        return rst;
    }

    @Override
    public List<CourseItemCatalogueVo> getCourseCataSubLogue(Long GroupId, Long loginUserId) {
        return ((TrainingCourseMapper)this.baseMapper).getCourseItemCatalogue(GroupId, loginUserId);
    }

    @Override
    public TrainingCourse getDetailById(Long traningCourseId) {
        return this.trainingRedisService.getTrainingCourse(traningCourseId);
    }

    @Override
    public List<String> getCourseIdListByTid(Long tid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tid", (Object)tid);
        List courseList = this.list((Wrapper)queryWrapper);
        return courseList.stream().map(x -> x.getCourseId().toString()).collect(Collectors.toList());
    }

    @Override
    public List<String> getRiskFactorListByTid(Long tid) {
        HashSet riskFactorSet = new HashSet();
        List<TrainingCourse> courseList = this.getTrainingCourseListByTid(tid);
        courseList.stream().forEach(course -> {
            if (course.getCourseType() == CourseTypeEnum.GENERAL.getValue()) {
                riskFactorSet.add("0");
            } else {
                List<String> riskCodeList = Arrays.asList(course.getRiskFactor().split(","));
                riskCodeList.stream().forEach(riskCode -> riskFactorSet.add(riskCode));
            }
        });
        return new ArrayList<String>(riskFactorSet);
    }

    @Override
    public List<CourseGroupCatalogueVo> getBaseCourseCataLogueFromDB(Long tid) {
        List<CourseGroupCatalogueVo> courseCatalogueVoList = ((TrainingCourseMapper)this.baseMapper).getCourseGroupCataLogue(tid);
        for (CourseGroupCatalogueVo group : courseCatalogueVoList) {
            List<CourseItemCatalogueVo> item = ((TrainingCourseMapper)this.baseMapper).getBaseCourseItemCatalogue(group.getTrainingGroupId());
            group.setItemList(item);
        }
        return courseCatalogueVoList;
    }

    @Override
    public List<TrainingCourse> getByTid(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(TrainingCourse::getTid, (Object)tid);
        return ((TrainingCourseMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<TrainingCourse> matchCourseByPersonTypeCodeV3_2_2_1(Long tid, String[] personTypeCodes) {
        return ((TrainingCourseMapper)this.baseMapper).matchCourseByPersonTypeCodeV3_2_2_1(tid, personTypeCodes);
    }
}

