/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseIndustry;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseIndustryProviderService;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingCourseGroupMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourseGroup;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingAddCourseGroupParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseGroupManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseGroupService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxTrainCourseGroupVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class TrainingCourseGroupServiceImpl
extends ServiceImpl<TrainingCourseGroupMapper, TrainingCourseGroup>
implements ITrainingCourseGroupService {
    @DubboReference
    private IHseIndustryProviderService industryProviderService;
    private final ICourseGroupManagerProviderService courseGroupProviderService;

    @Override
    public List<TrainingNewCourseGroupVo> listNewTrainCourseGroup(TrainingSearchParam param) {
        return ((TrainingCourseGroupMapper)this.baseMapper).listNewTrainCourseGroup(param);
    }

    @Override
    public List<Long> listTrainCourseGroupId(Long tid) {
        return ((TrainingCourseGroupMapper)this.baseMapper).listTrainCourseGroupId(tid);
    }

    @Override
    public void delTrainCourseGroupByTid(Long tid) {
        ((TrainingCourseGroupMapper)this.baseMapper).delTrainCourseGroupByTid(tid);
    }

    @Override
    public List<TrainingCourseGroupVo> listTrainingCourseGroup(TrainingSearchParam param) {
        return ((TrainingCourseGroupMapper)this.baseMapper).listTrainingCourseGroup(param);
    }

    @Override
    public Integer updateCourseGroupIndex(Long id, Integer index) {
        return ((TrainingCourseGroupMapper)this.baseMapper).updateCourseGroupIndex(id, index);
    }

    @Override
    public Integer getCourseGroupMaxIndex(TrainingAddCourseGroupParam param) {
        return ((TrainingCourseGroupMapper)this.baseMapper).getCourseGroupMaxIndex(param);
    }

    @Override
    public Long insertCourseGroup(TrainingCourseGroup param) {
        return ((TrainingCourseGroupMapper)this.baseMapper).insertCourseGroup(param);
    }

    @Override
    public Integer delTrainCourseGroup(Long tid, List<Long> courseGroupIdList) {
        return ((TrainingCourseGroupMapper)this.baseMapper).delTrainCourseGroup(tid, courseGroupIdList);
    }

    @Override
    public Boolean isSelectedInTrain(Long courseGroupId) {
        return false;
    }

    @Override
    @Transactional
    public String modifyOldTrainCourseGroup() {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"is_valid", (Object)true)).groupBy((Object)"course_group_id");
        List courseGroupList = this.list((Wrapper)wrapper);
        courseGroupList.stream().forEach(trainCourseGroup -> {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            String personTypeCode = "";
            String riskFactor = "";
            String industry = "";
            CourseGroupVo groupDetail = this.courseGroupProviderService.getGroupDetailById(trainCourseGroup.getCourseGroupId());
            if (null != groupDetail) {
                if (null != groupDetail.getPersonTypeList()) {
                    personTypeCode = groupDetail.getPersonTypeList().stream().map(CourseItemPersonType::getCode).collect(Collectors.joining(","));
                }
                ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.set((Object)"course_group_name", (Object)groupDetail.getName())).set((Object)"person_type_code", (Object)personTypeCode)).eq((Object)"course_group_id", (Object)trainCourseGroup.getCourseGroupId())).eq((Object)"is_valid", (Object)true);
                this.update((Wrapper)updateWrapper);
            }
        });
        return null;
    }

    @Override
    public List<TrainingCourseGroupVo> getTrainingCourseGroupForApi(Long tid) {
        return ((TrainingCourseGroupMapper)this.baseMapper).getTrainingCourseGroupForApi(tid);
    }

    @Override
    public List<TrainingCourseGroupVo> getTrainingCourseGroupForUser(Long tid, Long uid) {
        return ((TrainingCourseGroupMapper)this.baseMapper).getTrainingCourseGroupForUser(tid, uid);
    }

    @Override
    public List<TrainingCourseGroupVo> getMyTrainingCourseGroupForUser(Long tid, Long uid) {
        return ((TrainingCourseGroupMapper)this.baseMapper).getMyTrainingCourseGroupForUser(tid, uid);
    }

    @Override
    public List<WxTrainCourseGroupVo> listCourseGroupForWx(Long tid) {
        return ((TrainingCourseGroupMapper)this.baseMapper).listCourseGroupForWx(tid);
    }

    @Override
    public List<TrainingCourseGroupVo> getTrainingCourseGroupForCorp(Long tid, Long cid) {
        return ((TrainingCourseGroupMapper)this.baseMapper).getTrainingCourseGroupForCorp(tid, cid);
    }

    public TrainingCourseGroup getGroupByTidGId(Long tid, Long groupId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"tid", (Object)tid)).eq((Object)"course_group_id", (Object)groupId);
        return (TrainingCourseGroup)this.getOne((Wrapper)wrapper);
    }

    @Override
    public List<CourseItemPersonType> listPersonTypeByTAG(Long tid, Long groupId) {
        TrainingCourseGroup group = this.getGroupByTidGId(tid, groupId);
        if (group.getPersonTypeCode() == null) {
            return null;
        }
        ArrayList<CourseItemPersonType> rst = new ArrayList<CourseItemPersonType>();
        List<String> codeList = Arrays.asList(group.getPersonTypeCode().split(","));
        codeList.stream().forEach(code -> rst.add(new CourseItemPersonType(code, TrainingPersonTypeEnum.getNameByValue((String)code))));
        return rst;
    }

    @Override
    public List<CourseItemIndustry> listIndustryByTAG(Long tid, Long groupId) {
        TrainingCourseGroup group = this.getGroupByTidGId(tid, groupId);
        if (group.getIndustry() == null) {
            return null;
        }
        ArrayList<CourseItemIndustry> rst = new ArrayList<CourseItemIndustry>();
        List<String> codeList = Arrays.asList(group.getIndustry().split(","));
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        codeList.stream().forEach(code -> {
            HseIndustry industry = this.industryProviderService.getIndustryByCode(code);
            if (industry != null) {
                rst.add(new CourseItemIndustry(code, industry.getName()));
            }
        });
        return rst;
    }

    @Generated
    public TrainingCourseGroupServiceImpl(ICourseGroupManagerProviderService courseGroupProviderService) {
        this.courseGroupProviderService = courseGroupProviderService;
    }
}

