/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.training.dao.training.RaTrainingMapper;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.training.RaTraining;
import cn.smarthse.radiationTraining.modules.training.enums.RaCertStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.IRaTuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.IRaTrainingService;
import cn.smarthse.radiationTraining.modules.training.task.cert.offline.CertOfflineService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RaTrainingServiceImpl
extends ServiceImpl<RaTrainingMapper, RaTraining>
implements IRaTrainingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RaTrainingServiceImpl.class);
    @Autowired
    private IRaTuCertificateService raTuCertificateService;
    @Autowired
    private CertOfflineService certOfflineService;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    @Override
    public LayuiGridData<RaTraining> getList(RaTuCertificateParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RaTraining> voList = ((RaTrainingMapper)this.baseMapper).getList(param);
        return new LayuiGridData((Page)voList, (LayuiGridParam)param);
    }

    @Override
    @Transactional(readOnly=false)
    public RaTraining addRaTraining(RaTraining training) {
        training.setStatus(RaCertStatusEnum.DRAFT.getValue());
        this.saveOrUpdate(training);
        return training;
    }

    @Override
    @Transactional(readOnly=false)
    public void submit(RaTuCertificateParam param) {
        List<RaTuCertificate> certList = this.raTuCertificateService.getListByTid(param.getTrainingId());
        if (CollectionUtils.isEmpty(certList)) {
            throw new RuntimeException("\u8bf7\u6dfb\u52a0\u57f9\u8bad\u4eba\u5458\u4fe1\u606f\uff01");
        }
        RaTraining training = (RaTraining)this.getById(param.getTrainingId());
        training.setStatus(RaCertStatusEnum.SUBMITTED.getValue());
        this.updateById(training);
        certList.forEach(item -> item.setStatus(RaCertStatusEnum.SUBMITTED.getValue()));
        this.raTuCertificateService.updateBatchById(certList);
        log.info("\u66f4\u65b0\u8bc1\u4e66\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4\uff0c\u57f9\u8badID: {}\uff0c\u8bc1\u4e66\u6570\u91cf: {}", (Object)param.getTrainingId(), (Object)certList.size());
        this.sqlSessionTemplate.flushStatements();
        certList.forEach(item -> {
            try {
                this.genCertFile(item.getId());
                log.debug("\u8bc1\u4e66\u6587\u4ef6\u751f\u6210\u6210\u529f\uff0c\u8bc1\u4e66ID: {}", (Object)item.getId());
            }
            catch (Exception e) {
                throw new ServiceException(String.format("\u8bc1\u4e66\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bc1\u4e66ID: %s\uff0c%s", item.getId(), e.getMessage()));
            }
        });
        log.info("\u8bc1\u4e66\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff0c\u57f9\u8badID: {}", (Object)param.getTrainingId());
    }

    private void genCertFile(Long certId) {
        this.certOfflineService.genCertFile(certId);
    }

    @Override
    @Transactional(readOnly=false)
    public void delTraining(Long id) {
        this.raTuCertificateService.delByTid(id);
        RaTraining training = (RaTraining)this.getById(id);
        if (training == null) {
            return;
        }
        if (Objects.equals(training.getStatus(), RaCertStatusEnum.SUBMITTED.getValue())) {
            throw new ServiceException("\u5df2\u63d0\u4ea4\u4e0d\u53ef\u5220\u9664\uff01");
        }
        ((RaTrainingMapper)this.baseMapper).deleteById(id);
        log.info("\u57f9\u8bad\u5220\u9664\u6210\u529f\uff0c\u57f9\u8badID: {}", (Object)id);
    }
}

