/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.redis.impl;

import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import com.alibaba.fastjson2.JSON;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrainingRedisServiceImpl
implements ITrainingRedisService {
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private ITrainingCourseService trainingCourseService;

    @Override
    public List<CourseGroupCatalogueVo> getBaseCourseCataLogue(Long tid) {
        String hashCache = (String)RedisUtils.getCacheMapValue((String)RedisKey.getCatalogue(null), (String)RedisKey.getCatalogue((Long)tid));
        List courseGroupCatalogueVos = hashCache == null ? this.addOrUpBaseCataLogueHashCache(tid) : JSON.parseArray((String)hashCache, CourseGroupCatalogueVo.class);
        return courseGroupCatalogueVos;
    }

    @Override
    public void rmBaseCourseCataLogue(Long tid) {
        RedisUtils.delCacheMapValue((String)RedisKey.getCatalogue(null), (String)RedisKey.getCatalogue((Long)tid));
    }

    @Override
    public List<CourseGroupCatalogueVo> addOrUpBaseCataLogueHashCache(Long tid) {
        List<CourseGroupCatalogueVo> baseInfoList = this.trainingCourseService.getBaseCourseCataLogueFromDB(tid);
        this.addOrUpBaseCataLogueHashCache(baseInfoList, tid);
        return baseInfoList;
    }

    @Override
    public void addOrUpBaseCataLogueHashCache(List<CourseGroupCatalogueVo> list, Long tid) {
        RedisUtils.setCacheMapValue((String)RedisKey.getCatalogue(null), (String)RedisKey.getCatalogue((Long)tid), (Object)JSON.toJSONString(list));
    }

    @Override
    public TrainingCourse getTrainingCourse(Long traningCourseId) {
        String hashCache = (String)RedisUtils.getCacheMapValue((String)RedisKey.getTrainCourse(null), (String)RedisKey.getTrainCourse((Long)traningCourseId));
        if (hashCache == null) {
            TrainingCourse trainingCourse = (TrainingCourse)this.trainingCourseService.getById(traningCourseId);
            this.addOrUpTrainCourseHashCache(trainingCourse);
            return trainingCourse;
        }
        return (TrainingCourse)JSON.parseObject((String)hashCache, TrainingCourse.class);
    }

    @Override
    public void addOrUpTrainCourseHashCache(TrainingCourse trainingCourse) {
        RedisUtils.setCacheMapValue((String)RedisKey.getTrainCourse(null), (String)RedisKey.getTrainCourse((Long)trainingCourse.getId()), (Object)JSON.toJSONString((Object)trainingCourse));
    }

    @Override
    public void delTrainCourseHashCache(Long trainCourseId) {
        RedisUtils.delCacheMapValue((String)RedisKey.getTrainCourse(null), (String)RedisKey.getTrainCourse((Long)trainCourseId));
    }

    @Override
    public void delTrainingById(Long tid) {
        RedisUtils.deleteObject((String)("TRAINING:INFO::" + tid));
    }

    @Override
    public void delTrainCourseAndCatalogue() {
        RedisUtils.deleteObject((String)RedisKey.getCatalogue(null));
        RedisUtils.deleteObject((String)RedisKey.getTrainCourse(null));
    }
}

