/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.redis.impl;

import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import com.alibaba.fastjson2.JSON;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CourseRedisServiceImpl
implements ICourseRedisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CourseRedisServiceImpl.class);
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ICourseItemService courseItemService;

    @Override
    public Long getTuCourseId(Long detailId, Long courseItemId) {
        String hashCache = (String)RedisUtils.getCacheMapValue((String)RedisKey.getTuCourseId(null, null), (String)RedisKey.getTuCourseId((Long)detailId, (Long)courseItemId));
        if (hashCache == null) {
            TuCourse tuCourse = this.tuCourseService.getByDetailIdAndCourseItemId(detailId, courseItemId);
            if (tuCourse == null) {
                return null;
            }
            this.addOrUpTuCourse(tuCourse);
            this.addOrUpTuCourseId(tuCourse);
            return tuCourse.getId();
        }
        return Long.parseLong(hashCache);
    }

    @Override
    public void addOrUpTuCourseId(TuCourse tuCourse) {
        RedisUtils.setCacheMapValue((String)RedisKey.getTuCourseId(null, null), (String)RedisKey.getTuCourseId((Long)tuCourse.getEnrollDetailId(), (Long)tuCourse.getCourseItemId()), (Object)String.valueOf(tuCourse.getId()));
    }

    @Override
    public void rmTuCourseId(Long detailId, Long courseItemId) {
        RedisUtils.delCacheMapValue((String)RedisKey.getTuCourseId(null, null), (String)RedisKey.getTuCourseId((Long)detailId, (Long)courseItemId));
    }

    @Override
    public TuCourse getTuCourse(Long tuCoruseId) {
        String hashCache = (String)RedisUtils.getCacheMapValue((String)RedisKey.getTuCourse(null), (String)RedisKey.getTuCourse((Long)tuCoruseId));
        if (hashCache == null) {
            TuCourse tuCourseDB = (TuCourse)this.tuCourseService.getById(tuCoruseId);
            this.addOrUpTuCourse(tuCourseDB);
            return tuCourseDB;
        }
        return (TuCourse)JSON.parseObject((String)hashCache, TuCourse.class);
    }

    @Override
    public void rmTuCourse(Long tuCoruseId) {
        RedisUtils.delCacheMapValue((String)RedisKey.getTuCourse(null), (String)RedisKey.getTuCourse((Long)tuCoruseId));
    }

    @Override
    public void addOrUpTuCourse(TuCourse tuCourse) {
        RedisUtils.setCacheMapValue((String)RedisKey.getTuCourse(null), (String)RedisKey.getTuCourse((Long)tuCourse.getId()), (Object)JSON.toJSONString((Object)tuCourse));
        RedisUtils.setCacheMapValue((String)RedisKey.getTuCourseId(null, null), (String)RedisKey.getTuCourseId((Long)tuCourse.getEnrollDetailId(), (Long)tuCourse.getCourseItemId()), (Object)String.valueOf(tuCourse.getId()));
    }

    @Override
    public void rmTuCourse(TuCourse tuCourse) {
        RedisUtils.delCacheMapValue((String)RedisKey.getTuCourse(null), (String)RedisKey.getTuCourse((Long)tuCourse.getId()));
        RedisUtils.delCacheMapValue((String)RedisKey.getTuCourseId(null, null), (String)RedisKey.getTuCourseId((Long)tuCourse.getEnrollDetailId(), (Long)tuCourse.getCourseItemId()));
    }

    @Override
    public void cleanStuiedRecord() {
        RedisUtils.deleteObject((String)RedisKey.getTuCourse(null));
    }

    @Override
    public CourseItemVo getCourseItemVo(Long courseItemId) {
        String itemCache = (String)RedisUtils.getCacheMapValue((String)RedisKey.getCourseItemVo(null), (String)RedisKey.getCourseItemVo((Long)courseItemId));
        if (itemCache == null) {
            CourseItemVo courseItemVo = this.courseItemService.getCourseItemByIdFromDB(courseItemId);
            if (courseItemVo == null) {
                return null;
            }
            this.addOrUpCourseItemVo(courseItemVo);
            return courseItemVo;
        }
        return (CourseItemVo)JSON.parseObject((String)itemCache, CourseItemVo.class);
    }

    @Override
    public void addOrUpCourseItemVo(CourseItemVo courseItemVo) {
        RedisUtils.setCacheMapValue((String)RedisKey.getCourseItemVo(null), (String)RedisKey.getCourseItemVo((Long)courseItemVo.getId()), (Object)JSON.toJSONString((Object)courseItemVo));
    }

    @Override
    public void rmCourseItemVo(CourseItemVo courseItemVo) {
        RedisUtils.delCacheMapValue((String)RedisKey.getCourseItemVo(null), (String)RedisKey.getCourseItemVo((Long)courseItemVo.getId()));
    }

    @Override
    public void rmCourseItemVo(Long courseItemId) {
        RedisUtils.delCacheMapValue((String)RedisKey.getCourseItemVo(null), (String)RedisKey.getCourseItemVo((Long)courseItemId));
    }
}

