/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.enroll.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaper;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperProviderService;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperQuestProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.training.dto.TrainingContext;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.enums.CropEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.PersnoalEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropSelectTraninglParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonalEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RemoveEnrollInfoParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.ResurgenceEnrollDataParam;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingSynService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ICropEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.CountObtainedCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UserEnrollServiceImpl
implements IUserEnrollService {
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ICropEnrollService cropEnrollService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ICourseItemService courseItemService;
    @Autowired
    private ITrainingRedisService trainingRedisService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuCertificateService tuCertificateService;
    @Autowired
    private TrainingSynService trainingSynService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ITrainingCourseService trainingCourseService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ITuPaperProviderService tuPaperProviderService;
    @DubboReference
    private ITuPaperQuestProviderService tuPaperQuestProviderService;
    @DubboReference
    private ISysCompanyStaffProviderService sysCompanyStaffProviderService;

    @Override
    @Transactional
    public void personalSignUpForMajorByIndividual(PersonalEnrollParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"name", "areaId", "companyName", "cid", "personTypeCode", "trainMode", "trainingId", "userId", "name"});
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTrainingId());
        PersonalUserVo personalUserInfo = this.userProviderService.getPersonalUserInfo(param.getLoginUserId());
        TuEnroll tuEnroll = this.tuEnrollService.getByHseCidAndTid(param.getCid(), param.getTrainingId());
        if (tuEnroll == null || tuEnroll.getTrainStatus().equals(TrainingStatusEnum.RETURNED.getValue())) {
            CropSelectTraninglParam cropEnrollParam = new CropSelectTraninglParam();
            cropEnrollParam.setTid(param.getTrainingId());
            cropEnrollParam.setCid(param.getCid());
            cropEnrollParam.setSource(CropEnrollSourceEnum.PERSONAL.getValue());
            tuEnroll = this.cropEnrollService.enroll(cropEnrollParam);
        }
        TuEnrollDetail originTuEnrollDetail = this.tuEnrollDetailService.getByUidAndEnrollId(param.getLoginUserId(), tuEnroll.getId());
        this.ifCanEnrollForMajorByIndividual(trainingInfo, personalUserInfo, tuEnroll, originTuEnrollDetail, param);
        TuEnrollDetail enrollDetail = new TuEnrollDetail().setUid(param.getLoginUserId()).setIdCard(param.getIdcard()).setTid(param.getTrainingId()).setHseCid(param.getCid()).setUname(param.getName()).setEnrollTime(new Date()).setEnrollSource(PersnoalEnrollSourceEnum.PERSONAL.getValue()).setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo)).setEmail(param.getEmail()).setIdCard(param.getIdcard()).setPhone(param.getPhone()).setTrainMode(TrainingModeEnum.MARJOR.getValue()).setEnrollId(tuEnroll.getId()).setCname(param.getCompanyName()).setPersonTypeCode(param.getPersonTypeCode()).setCreditCode(param.getCreditCode());
        if (originTuEnrollDetail != null) {
            enrollDetail.setId(originTuEnrollDetail.getId());
        }
        this.tuEnrollDetailService.saveOrUpdate(enrollDetail);
        this.tuCourseService.initInfoForMajor(enrollDetail, (Training)trainingInfo, param.getLoginUserId());
        this.sysCompanyStaffProviderService.save(enrollDetail.getHseCid(), enrollDetail.getUid(), param.getLoginUserId());
        if (this.tuEnrollDetailService.ifCanSync(enrollDetail)) {
            this.threadPoolTaskExecutor.execute(() -> {
                ArrayList<Long> tids = new ArrayList<Long>();
                tids.add(enrollDetail.getTid());
                List<CountObtainedCertificateVo> numVos = this.tuEnrollDetailService.countObtainedCertificateNum(tids);
                this.trainingSynService.syncObtainedCertificateNum(numVos.get(0).getTid(), numVos.get(0).getNum());
            });
        }
    }

    @Override
    @Transactional
    public void personalSignUpForPreciseByIndividual(PersonalEnrollParam param) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTrainingId());
        PersonalUserVo personalUserInfo = this.userProviderService.getPersonalUserInfo(param.getLoginUserId());
        TuEnroll tuEnroll = this.tuEnrollService.getByHseCidAndTid(param.getCid(), param.getTrainingId());
        if (tuEnroll == null || tuEnroll.getTrainStatus().equals(TrainingStatusEnum.RETURNED.getValue())) {
            CropSelectTraninglParam cropEnrollParam = new CropSelectTraninglParam();
            cropEnrollParam.setTid(param.getTrainingId());
            cropEnrollParam.setCid(param.getCid());
            cropEnrollParam.setSource(CropEnrollSourceEnum.PERSONAL.getValue());
            tuEnroll = this.cropEnrollService.enroll(cropEnrollParam);
        }
        TuEnrollDetail originTuEnrollDetail = this.tuEnrollDetailService.getByUidAndEnrollId(param.getLoginUserId(), tuEnroll.getId());
        this.ifCanEnrollForPreciseByIndividual(trainingInfo, personalUserInfo, tuEnroll, originTuEnrollDetail, param);
        TuEnrollDetail enrollDetail = new TuEnrollDetail().setUid(param.getLoginUserId()).setIdCard(param.getIdcard()).setTid(param.getTrainingId()).setHseCid(param.getCid()).setUname(param.getName()).setEnrollTime(new Date()).setEnrollSource(PersnoalEnrollSourceEnum.PERSONAL.getValue()).setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo)).setEmail(param.getEmail()).setPhone(param.getPhone()).setTrainMode(TrainingModeEnum.PRECISE.getValue()).setEnrollId(tuEnroll.getId()).setCname(param.getCompanyName()).setPersonTypeCode(param.getPersonTypeCode()).setCreditCode(param.getCreditCode()).setRetestLimit(trainingInfo.getRetestLimit());
        if (originTuEnrollDetail != null) {
            enrollDetail.setId(originTuEnrollDetail.getId());
        }
        this.tuEnrollDetailService.saveOrUpdate(enrollDetail);
        param.getMatchCourseParam().setRiskCodeList(this.hseCompanyProviderService.getRiskFactorByCid(param.getCid()));
        param.getMatchCourseParam().setIndustryCodeList(this.hseCompanyProviderService.getIndustryCodesByCid(param.getCid()));
        HseCompanyVo hseCompanyVo = this.hseCompanyProviderService.getInfoById(param.getCid());
        if (hseCompanyVo == null) {
            throw new ServiceException("\u65e0\u516c\u53f8\u4fe1\u606f");
        }
        param.getMatchCourseParam().setAreaId(hseCompanyVo.getAreaId());
        List<CourseItemVo> itemVoList = this.courseItemService.matchCourseItem(param.getMatchCourseParam());
        this.tuCourseService.initInfoForPrecise(enrollDetail, (Training)trainingInfo, itemVoList, param.getLoginUserId());
        this.sysCompanyStaffProviderService.save(enrollDetail.getHseCid(), enrollDetail.getUid(), param.getLoginUserId());
        if (this.tuEnrollDetailService.ifCanSync(enrollDetail)) {
            this.threadPoolTaskExecutor.execute(() -> {
                ArrayList<Long> tids = new ArrayList<Long>();
                tids.add(enrollDetail.getTid());
                List<CountObtainedCertificateVo> numVos = this.tuEnrollDetailService.countObtainedCertificateNum(tids);
                this.trainingSynService.syncObtainedCertificateNum(numVos.get(0).getTid(), numVos.get(0).getNum());
            });
        }
    }

    private void ifCanEnrollForMajorByIndividual(TrainingDetailVo training, PersonalUserVo personalUserInfo, TuEnroll tuEnroll, TuEnrollDetail tuEnrollDetail, PersonalEnrollParam param) {
        if (training == null || personalUserInfo == null) {
            throw new ServiceException("\u6570\u636e\u7f3a\u5931");
        }
        if (training.getStatus() != 2) {
            throw new ServiceException("\u57f9\u8bad\u672a\u4e0a\u67b6\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
        }
        if (tuEnrollDetail != null && TrainingStatusEnum.getEnrolledStatus().contains(tuEnrollDetail.getTrainStatus())) {
            throw new ServiceException("\u60a8\u4e0d\u80fd\u91cd\u590d\u62a5\u540d\uff0c\u5982\u7b2c\u4e00\u6b21\u62a5\u540d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5220\u9664\u540e\u518d\u91cd\u65b0\u62a5\u540d\uff01");
        }
        if (training.getTrainEndTime().getTime() < new Date().getTime()) {
            throw new ServiceException("\u57f9\u8bad\u65f6\u95f4\u5df2\u8fc7\uff0c\u65e0\u6cd5\u53c2\u52a0\u57f9\u8bad\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getIdcard())) {
            if (StringUtils.isEmpty((CharSequence)personalUserInfo.getIdcard())) {
                throw new ServiceException("\u62b1\u6b49\uff0c\u60a8\u6240\u63d0\u4f9b\u7684\u8eab\u4efd\u8bc1\u4e0e\u60a8\u7684\u8d26\u53f7\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
            }
            if (!param.getIdcard().equals(personalUserInfo.getIdcard())) {
                throw new ServiceException("\u62b1\u6b49\uff0c\u60a8\u6240\u63d0\u4f9b\u7684\u8eab\u4efd\u8bc1\u4e0e\u60a8\u7684\u8d26\u53f7\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
            }
        }
    }

    private void ifCanEnrollForPreciseByIndividual(TrainingDetailVo training, PersonalUserVo personalUserInfo, TuEnroll tuEnroll, TuEnrollDetail tuEnrollDetail, PersonalEnrollParam param) {
        if (training == null) {
            throw new ServiceException("\u57f9\u8bad\u4e0d\u5b58\u5728\uff01");
        }
        if (training == null || personalUserInfo == null) {
            throw new ServiceException("\u6570\u636e\u7f3a\u5931");
        }
        if (training.getStatus() != 2) {
            throw new ServiceException("\u57f9\u8bad\u672a\u4e0a\u67b6\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
        }
        if (tuEnrollDetail != null && TrainingStatusEnum.getEnrolledStatus().contains(tuEnrollDetail.getTrainStatus())) {
            throw new ServiceException("\u60a8\u4e0d\u80fd\u91cd\u590d\u62a5\u540d\uff0c\u5982\u7b2c\u4e00\u6b21\u62a5\u540d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5220\u9664\u540e\u518d\u91cd\u65b0\u62a5\u540d\uff01");
        }
        if (training.getTrainEndTime().getTime() < new Date().getTime()) {
            throw new ServiceException("\u57f9\u8bad\u65f6\u95f4\u5df2\u8fc7\uff0c\u65e0\u6cd5\u53c2\u52a0\u57f9\u8bad\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getIdcard())) {
            if (personalUserInfo.getIdcard() == null) {
                throw new ServiceException("\u62b1\u6b49\uff0c\u60a8\u6240\u63d0\u4f9b\u7684\u8eab\u4efd\u8bc1\u4e0e\u60a8\u7684\u8d26\u53f7\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
            }
            if (!param.getIdcard().equals(personalUserInfo.getIdcard())) {
                throw new ServiceException("\u62b1\u6b49\uff0c\u60a8\u6240\u63d0\u4f9b\u7684\u8eab\u4efd\u8bc1\u4e0e\u60a8\u7684\u8d26\u53f7\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
            }
        }
    }

    @Override
    @Transactional
    public void rmByEnrollId(Long enrollId, Long opt, String optName) {
        List<TuEnrollDetail> detailList = this.tuEnrollDetailService.getByEnrollId(enrollId);
        TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(enrollId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnroll.getTid());
        if (CollectionUtil.isEmpty(detailList)) {
            return;
        }
        List<Long> detailIdList = detailList.stream().map(TuEnrollDetail::getId).collect(Collectors.toList());
        UpdateWrapper upWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)upWrapper.lambda().in(TuEnrollDetail::getId, detailIdList)).set(TuEnrollDetail::getCreateBy, (Object)opt)).set(TuEnrollDetail::getUpdateName, (Object)optName);
        this.tuEnrollDetailService.update((Wrapper)upWrapper);
        this.tuCourseService.deleteByEnrollDetailIds(detailIdList);
        this.tuCertificateService.rmByEnrollDetailIds(detailIdList);
        this.tuEnrollDetailService.removeByIds(detailIdList);
        this.tuPaperProviderService.delTuPaperAndQuestionBatch(detailIdList);
        this.trainingRedisService.delTrainingById(detailList.get(0).getTid());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TuEnrollDetail::getEnrollId, (Object)enrollId);
        this.tuEnrollDetailService.remove((Wrapper)wrapper);
        for (TuEnrollDetail detail : detailList) {
            this.tuEnrollDetailService.perTrainingInfoDeleteAndRecovery(detail, trainingInfo, opt);
        }
    }

    @Override
    @Transactional
    public void rmEnrollInfo(RemoveEnrollInfoParam param) {
        Long enrollDetailId = param.getEnrollDetailId();
        TuEnrollDetail tuEnrollDetailDB = (TuEnrollDetail)this.tuEnrollDetailService.getById(enrollDetailId);
        if (tuEnrollDetailDB == null) {
            return;
        }
        if (!tuEnrollDetailDB.getUid().equals(param.getLoginUserId())) {
            throw new ServiceException("\u65e0\u6cd5\u5220\u9664\u4ed6\u4eba\u62a5\u540d\u4fe1\u606f");
        }
        this.tuCourseService.deleteByEnrollDetailId(enrollDetailId);
        this.tuCertificateService.rmByEnrollDetailId(enrollDetailId);
        tuEnrollDetailDB.setUpdateBy(param.getLoginUserId());
        tuEnrollDetailDB.setUpdateName(param.getLoginUsername());
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        this.tuEnrollDetailService.removeById(enrollDetailId);
        this.tuPaperProviderService.delTuPaperAndQuestion(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnrollDetailDB.getTid());
        if (!TrainingModeEnum.ORG.getValue().equals(trainingInfo.getTrainMode())) {
            this.tuEnrollDetailService.perTrainingInfoDeleteAndRecovery(tuEnrollDetailDB, trainingInfo, param.getLoginUserId());
        }
        this.trainingRedisService.delTrainingById(tuEnrollDetailDB.getTid());
    }

    @Override
    @Transactional
    public void resurgenceData(ResurgenceEnrollDataParam param) {
        TuEnrollDetail tuEnrollDetail = this.tuEnrollDetailService.getDeletedDataById(param.getEnrollDetailId());
        if (tuEnrollDetail == null || tuEnrollDetail.getIsValid().booleanValue()) {
            throw new ServiceException("\u6570\u636e\u672a\u88ab\u5220\u9664\u6216\u8005\u6570\u636e\u4e0d\u5b58\u5728");
        }
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnrollDetail.getTid());
        if (trainingInfo == null) {
            throw new ServiceException("\u57f9\u8bad\u4e0d\u5b58\u5728");
        }
        TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(tuEnrollDetail.getEnrollId());
        if (tuEnroll == null) {
            throw new ServiceException("\u65e0\u8d35\u5355\u4f4d\u62a5\u540d\u6570\u636e\uff0c\u6062\u590d\u5931\u8d25");
        }
        TuEnrollDetail currEnrollDetail = this.tuEnrollDetailService.getByUidAndEnrollId(tuEnrollDetail.getUid(), tuEnroll.getId());
        if (currEnrollDetail != null) {
            throw new ServiceException("\u60a8\u5728\u8be5\u5355\u4f4d\u5b58\u5728\u62a5\u540d\u6570\u636e\uff0c\u65e0\u6cd5\u6062\u590d\u8001\u62a5\u540d\u6570\u636e");
        }
        List<TuCourse> tuCourseList = this.tuCourseService.getDeletedDataByDetailId(param.getEnrollDetailId());
        List<TuCertificate> tuCertificateList = this.tuCertificateService.getDeletedDataByDetailId(param.getEnrollDetailId());
        List tuPaperList = this.tuPaperProviderService.getDeletedDataByDetailId(param.getEnrollDetailId());
        if (CollectionUtil.isEmpty(tuCourseList)) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.dealStuRecord(tuEnrollDetail, tuCourseList, trainingInfo);
        this.dealCertificateData(tuEnrollDetail, tuCertificateList, trainingInfo);
        UserVo userVo = this.userProviderService.getUserVo(tuEnrollDetail.getUid());
        this.tuEnrollDetailService.setIsValidById(true, Collections.singletonList(tuEnrollDetail.getId()));
        this.tuCourseService.setIsValidById(true, tuCourseList.stream().map(TuCourse::getId).collect(Collectors.toList()));
        this.tuCertificateService.setIsValidById(true, tuCertificateList.stream().map(TuCertificate::getId).collect(Collectors.toList()));
        this.tuPaperProviderService.setIsValidById(Boolean.valueOf(true), tuPaperList.stream().map(TuPaper::getId).collect(Collectors.toList()));
        this.tuPaperQuestProviderService.setIsValidByTuPaperId(Boolean.valueOf(true), tuPaperList.stream().map(TuPaper::getId).collect(Collectors.toList()));
        this.tuEnrollDetailService.updateById(tuEnrollDetail);
        this.tuCourseService.updateBatchById(tuCourseList);
        this.tuCertificateService.updateBatchById(tuCertificateList);
        if (this.tuEnrollDetailService.ifCanSync(tuEnrollDetail) && !CollectionUtil.isEmpty(tuCertificateList)) {
            for (TuCertificate tuCertificate : tuCertificateList) {
                String result = this.trainingSynService.syncTrainAttendAndCertInfo(new TrainingContext().setTraining((Training)trainingInfo).setTuEnroll(tuEnroll).setTuEnrollDetail(tuEnrollDetail).setTuCertificate(tuCertificate).setToken(String.valueOf(tuEnroll.getHseCid())).setUserPhone(userVo.getUsername()), (byte)1);
                if (!StringUtils.isEmpty((CharSequence)result)) {
                    throw new ServiceException(result);
                }
                tuCertificate.setSyncDes("\u6570\u636e\u6062\u590d\u540e\u540c\u6b65\u6210\u529f");
                tuCertificate.setSyncState(Integer.valueOf(1));
            }
            this.tuCertificateService.updateBatchById(tuCertificateList);
            ArrayList<Long> tids = new ArrayList<Long>();
            tids.add(tuEnrollDetail.getTid());
            List<CountObtainedCertificateVo> numVos = this.tuEnrollDetailService.countObtainedCertificateNum(tids);
            this.trainingSynService.syncObtainedCertificateNum(numVos.get(0).getTid(), numVos.get(0).getNum());
        }
    }

    public Integer analyseTrainStateAfterEnroll(TrainingDetailVo training) {
        long trainStartTime;
        long currTime = new Date().getTime();
        if (currTime < (trainStartTime = training.getTrainStarTime().getTime())) {
            return TrainingStatusEnum.TO_BE_TRAINED.getValue();
        }
        return TrainingStatusEnum.IN_TRAINING.getValue();
    }

    private void dealStuRecord(TuEnrollDetail detail, List<TuCourse> tuCourseList, TrainingDetailVo trainingDetailVo) {
        if (trainingDetailVo.getTrainMode().intValue() == TrainingModeEnum.MARJOR.getValue().intValue()) {
            this.dealMajorStuRecord(detail, tuCourseList, trainingDetailVo);
        } else if (trainingDetailVo.getTrainMode().intValue() == TrainingModeEnum.PRECISE.getValue().intValue()) {
            this.dealPreciseStuRecord(detail, tuCourseList, trainingDetailVo);
        } else {
            if (trainingDetailVo.getTrainMode().intValue() == TrainingModeEnum.ORG.getValue().intValue()) {
                throw new ServiceException("\u6682\u65f6\u4e0d\u652f\u6301\u673a\u6784\u7aef\u6570\u636e\u6062\u590d\u3002");
            }
            throw new ServiceException("\u57f9\u8bad\u6570\u636e\u5f02\u5e38\u8fd8\u539f\u5931\u8d25\u3002");
        }
    }

    private void dealMajorStuRecord(TuEnrollDetail detail, List<TuCourse> tuCourseList, TrainingDetailVo trainingDetailVo) {
        List<TrainingCourse> tcList = this.trainingCourseService.getByTid(trainingDetailVo.getId());
        if (CollectionUtil.isEmpty(tcList) || tuCourseList.size() != tcList.size()) {
            throw new ServiceException("\u57f9\u8bad\u4fe1\u606f\u4e0e\u5b66\u4e60\u8bb0\u5f55\u65e0\u6cd5\u5339\u914d\uff0c\u6062\u590d\u5931\u8d25");
        }
        Map<Long, TrainingCourse> tcMap = tcList.stream().collect(Collectors.toMap(v -> v.getCourseId(), v -> v));
        for (TuCourse tuCourse : tuCourseList) {
            TrainingCourse tc = tcMap.get(tuCourse.getCourseItemId());
            tuCourse.setUserId(detail.getUid()).setVideoDurationSec(tc.getVideoDurationSec()).setTrainMode(TrainingModeEnum.MARJOR.getValue()).setCourseName(tc.getCourseName()).setLecturer(tc.getLecturer()).setDescription(tc.getDescription()).setClassHour(tc.getClassHour()).setVideoUrl(tc.getVideoUrl()).setVideoId(tc.getVideoId()).setCoverUrl(tc.getCoverUrl()).setCoverId(tc.getCoverId()).setTrainingCourseId(tc.getId()).setPaperStructureId(tc.getPaperStructureId()).setWay(Integer.valueOf(Math.toIntExact(tc.getWay()))).setSingleNum(tc.getSingleNum()).setMultipleNum(tc.getMultipleNum()).setCompletionNum(tc.getCompletionNum()).setJudgeNum(tc.getJudgeNum()).setSingleScore(tc.getSingleScore()).setMultipleScore(tc.getMultipleScore()).setCompletionScore(tc.getCompletionScore()).setJudgeScore(tc.getJudgeScore()).setTotalScore(tc.getTotalScore()).setIndustry(tc.getIndustry()).setPersonType(tc.getPersonTypeCode()).setRiskFactor(tc.getRiskFactor()).setIsValid(Boolean.valueOf(true));
        }
    }

    private void dealPreciseStuRecord(TuEnrollDetail detail, List<TuCourse> tuCourseList, TrainingDetailVo trainingDetailVo) {
        for (TuCourse tuCourse : tuCourseList) {
            tuCourse.setIsValid(Boolean.valueOf(true));
        }
    }

    private void dealCertificateData(TuEnrollDetail detail, List<TuCertificate> tuCertificateList, TrainingDetailVo trainingDetailVo) {
        int length = detail.getPersonTypeCode().split(",").length;
        if (!CollectionUtil.isEmpty(tuCertificateList) && tuCertificateList.size() != length) {
            throw new ServiceException("\u8bc1\u4e66\u6570\u91cf\u5f02\u5e38\uff0c\u6062\u590d\u6570\u636e\u5931\u8d25");
        }
        if (tuCertificateList.size() == 2 && tuCertificateList.get(0).getCertType().equals(tuCertificateList.get(1).getCertType())) {
            throw new ServiceException("\u8bc1\u4e66\u6570\u636e\u91cd\u590d\uff0c\u6062\u590d\u6570\u636e\u5931\u8d25");
        }
        for (TuCertificate tuCertificate : tuCertificateList) {
            tuCertificate.setIsValid(Boolean.valueOf(true));
            tuCertificate.setSyncState(Integer.valueOf(3));
            tuCertificate.setSyncDes("\u6570\u636e\u8fd8\u539f\u540e\u672a\u540c\u6b65");
        }
    }
}

