/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.enroll.impl;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.radiationTraining.core.framework.annotation.AtomEnrollLimit;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysOccupationalHazardsProviderService;
import cn.smarthse.radiationTraining.modules.training.dao.enroll.TuEnrollMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingVersionEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonalEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.ResurgenceEnrollDataParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SearchRegListParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SearchStaffTrainingDetailParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpRedundancyInfoParam;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingSynService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserEnrollServiceV3_2_2_1;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserOrgEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserOrgEnrollServiceV3_2_2_1;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.course.EnrollInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollNumberVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollResultVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.HSECompanyTrainStatusVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.StaffTrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TuEnrollServiceImpl
extends ServiceImpl<TuEnrollMapper, TuEnroll>
implements ITuEnrollService {
    @Autowired
    private ITuEnrollService self;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private IUserEnrollService userEnrollService;
    @Autowired
    private IUserEnrollServiceV3_2_2_1 userEnrollServiceV3_2_2_1;
    @Autowired
    private IUserOrgEnrollService userOrgEnrollService;
    @Autowired
    private IUserOrgEnrollServiceV3_2_2_1 userOrgEnrollServiceV3_2_2_1;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private ITuCertificateService tuCertificateService;
    @Autowired
    private TrainingSynService trainingSynService;
    @Autowired
    private ITrainingService trainingService;
    @DubboReference
    private ISysCompanyStaffProviderService sysCompanyStaffProviderService;
    @DubboReference
    private ISysOccupationalHazardsProviderService riskFactorsService;

    @Override
    @Transactional
    @AtomEnrollLimit(enrollSource=1, optType=1, tid="#param.trainingId", targetId="#param.userId")
    @CacheEvict(value={"TRAINING:INFO"}, key="#param.trainingId")
    public EnrollResultVo personalSignUpByIndividual(PersonalEnrollParam param) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTrainingId());
        Integer mode = trainingInfo.getTrainMode();
        EnrollResultVo resultVo = null;
        if (!mode.equals(TrainingModeEnum.MARJOR.getValue())) {
            if (mode.equals(TrainingModeEnum.PRECISE.getValue())) {
                throw new ServiceException("\u529f\u80fd\u505c\u7528");
            }
            if (mode.equals(TrainingModeEnum.ORG.getValue())) {
                throw new ServiceException("\u529f\u80fd\u505c\u7528");
            }
            throw new ServiceException("\u57f9\u8bad\u6a21\u5f0f\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
        }
        resultVo = this.self.personalSignUpForMajorByIndividual(param);
        return resultVo;
    }

    @Override
    @Transactional
    public EnrollResultVo personalSignUpForMajorByIndividual(PersonalEnrollParam param) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTrainingId());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        EnrollResultVo resultVo = null;
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            this.userEnrollService.personalSignUpForMajorByIndividual(param);
        } else if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            resultVo = this.userEnrollServiceV3_2_2_1.personalSignUpForMajorByIndividual(param);
        } else {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
        }
        return resultVo;
    }

    @Override
    @Transactional
    public void personalSignUpForPreciseByIndividual(PersonalEnrollParam param) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTrainingId());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            this.userEnrollService.personalSignUpForPreciseByIndividual(param);
        } else if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            this.userEnrollServiceV3_2_2_1.personalSignUpForPreciseByIndividual(param);
        } else {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
        }
    }

    @Override
    @Transactional
    public void personalSignUpForOrgByIndividual(PersonalEnrollParam param) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTrainingId());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            this.userOrgEnrollService.personalSignUpForOrgByIndividual(param);
        } else if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            this.userOrgEnrollServiceV3_2_2_1.personalSignUpForOrgByIndividual(param);
        } else {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
        }
    }

    @Override
    public Byte getHasUnitEnroll(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"tid", (Object)tid)).ne((Object)"train_status", (Object)0);
        List list = this.list((Wrapper)wrapper);
        if (list == null || list.size() == 0) {
            return (byte)0;
        }
        return (byte)1;
    }

    @Override
    public List<EnrollNumberVo> getEnrollCount(List<Long> cidList) {
        return ((TuEnrollMapper)this.baseMapper).getEnrollCount(cidList);
    }

    @Override
    public LayuiGridData<EnrollInfoVo> searchEnrollRegList(SearchRegListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EnrollInfoVo> enrollInfoVoList = ((TuEnrollMapper)this.baseMapper).searchEnrollRegList(param);
        for (EnrollInfoVo vo : enrollInfoVoList) {
            vo.setPhone(StringUtils.desensitizationUsernameNumber((String)vo.getPhone()));
            vo.setUname(DesensitizationUtils.desensitized((CharSequence)vo.getUname(), (DesensitizationType)DesensitizationType.NAME));
            if (StringUtils.isEmpty((CharSequence)vo.getPdfUrl())) continue;
            ArrayList newUrlList = new ArrayList();
            List<String> pdfUrlList = Arrays.asList(vo.getPdfUrl().split(","));
            pdfUrlList.stream().forEach(url -> newUrlList.add(this.ossClientBean.getUrl(url)));
            vo.setPdfUrl(newUrlList.stream().collect(Collectors.joining(",")));
        }
        return new LayuiGridData((Page)enrollInfoVoList, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<StaffTrainingDetailVo> getStaffTrainingDetail(SearchStaffTrainingDetailParam param) {
        TuEnrollDetail detailDB = (TuEnrollDetail)this.tuEnrollDetailService.getById((Serializable)((Object)param.getEnrollDetailId()));
        if (!param.getCid().equals(detailDB.getHseCid())) {
            return new LayuiGridData();
        }
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(detailDB.getTid());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffTrainingDetailVo> voList = null;
        Integer trainMode = trainingInfo.getTrainMode();
        if (TrainingModeEnum.MARJOR.getValue().equals(trainMode)) {
            voList = ((TuEnrollMapper)this.baseMapper).getStaffTrainingDetailForMajor(param);
        } else if (TrainingModeEnum.PRECISE.getValue().equals(trainMode)) {
            voList = ((TuEnrollMapper)this.baseMapper).getStaffTrainingDetailForPrecise(param);
        } else if (TrainingModeEnum.ORG.getValue().equals(trainMode)) {
            voList = ((TuEnrollMapper)this.baseMapper).getStaffTrainingDetailForOrg(param);
        } else {
            throw new ServiceException("\u57f9\u8bad\u7c7b\u578b\u9519\u8bef");
        }
        for (StaffTrainingDetailVo vo : voList) {
            String riskFactors = vo.getRiskFactors();
            if (StringUtils.isEmpty((CharSequence)riskFactors)) continue;
            List riskFactorList = this.riskFactorsService.getByCodes(Arrays.stream(riskFactors.split(",")).collect(Collectors.toList()));
            List courseItemRadiationList = riskFactorList.stream().map(v -> new CourseItemRadiation().setName(v.getName()).setCode(v.getCode())).collect(Collectors.toList());
            vo.setCourseItemRadiationList(courseItemRadiationList);
        }
        return new LayuiGridData((Page)voList, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void updateAllStatus() {
        ((TuEnrollMapper)this.baseMapper).updateAllStatus();
    }

    @Override
    @Transactional
    public void updateRedundancyExcludeUintInfo(UpRedundancyInfoParam param) {
        this.tuEnrollDetailService.updateRedundancyExcludeUintInfo(param);
        this.tuCertificateService.updateRedundancyExcludeUintInfo(param);
    }

    @Override
    @Transactional
    public void updateUnitRedundancyInfo(UpRedundancyInfoParam param) {
        this.tuEnrollDetailService.updateUnitRedundancyInfo(param);
        this.tuCertificateService.updateUnitRedundancyInfo(param);
    }

    @Override
    public List<HSECompanyTrainStatusVo> analyseHSEComapnyTrain() {
        return ((TuEnrollMapper)this.baseMapper).analyseHSEComapnyTrain();
    }

    @Override
    public String syncHSECompanyTrainStatus() {
        List<HSECompanyTrainStatusVo> hseCompanyTrainStatusVos = this.analyseHSEComapnyTrain();
        return this.trainingSynService.syncComapnyTrainStatus(hseCompanyTrainStatusVos);
    }

    @Override
    public void reBuildAllRelationship(String pwd) {
        if (!pwd.equals("zhzhhbkjyxgs15589")) {
            throw new ServiceException("\u64cd\u4f5c\u9519\u8bef");
        }
        List<TuEnrollDetail> list = this.tuEnrollDetailService.getEnrolledList();
        this.sysCompanyStaffProviderService.removeAll(pwd);
        for (TuEnrollDetail enrollDetail : list) {
            this.sysCompanyStaffProviderService.save(enrollDetail.getHseCid(), enrollDetail.getUid(), Long.valueOf(11L));
        }
    }

    @Override
    public void resurgenceData(ResurgenceEnrollDataParam param) {
        this.userEnrollService.resurgenceData(param);
    }

    @Override
    public TuEnroll getByHseCidAndTid(Long companyId, Long trainingId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"tid", (Object)trainingId)).eq((Object)"hse_cid", (Object)companyId);
        return (TuEnroll)((TuEnrollMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Generated
    public TuEnrollServiceImpl() {
    }
}

