/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.enroll.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.modules.health.supervise.entity.trainPlan.PerTrainingInfoModel;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.provider.order.ISysOrderProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysOccupationalHazardsProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.training.dao.enroll.TuEnrollDetailMapper;
import cn.smarthse.radiationTraining.modules.training.dto.TrainingContext;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.enums.PersnoalEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingVersionEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropStaffEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.MaintainBeforeExamParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpRedundancyInfoParam;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingSynService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.CountObtainedCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollResultVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainEnrollCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertSyncParam;
import cn.smarthse.rho.modules.sys.provider.sync.ITrainingSyncProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TuEnrollDetailServiceImpl
extends ServiceImpl<TuEnrollDetailMapper, TuEnrollDetail>
implements ITuEnrollDetailService {
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ISysOrderProviderService sysOrderService;
    @Autowired
    private TrainingSynService trainingSynService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuCertificateService tuCertificateService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @DubboReference
    private ISysOccupationalHazardsProviderService hazardsProviderService;
    @DubboReference
    private ITrainingSyncProvider trainingSyncProvider;
    @Autowired
    private OssClientBean ossClientBean;

    @Override
    public TuEnrollDetail getByUidAndCidAndTid(Long uid, Long cid, Long tid) {
        QueryWrapper tuEnrollDetailQueryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)tuEnrollDetailQueryWrapper.eq((Object)"tid", (Object)tid)).eq((Object)"uid", (Object)uid)).eq((Object)"hse_cid", (Object)cid);
        return (TuEnrollDetail)((TuEnrollDetailMapper)this.baseMapper).selectOne((Wrapper)tuEnrollDetailQueryWrapper);
    }

    @Override
    public TuEnrollDetail getByUidAndEnrollId(Long uid, Long enrollId) {
        QueryWrapper tuEnrollDetailQueryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)tuEnrollDetailQueryWrapper.lambda().eq(TuEnrollDetail::getUid, (Object)uid)).eq(TuEnrollDetail::getEnrollId, (Object)enrollId);
        return (TuEnrollDetail)((TuEnrollDetailMapper)this.baseMapper).selectOne((Wrapper)tuEnrollDetailQueryWrapper);
    }

    @Override
    @Transactional
    public void updateStudiedProgress(Long enrollDetailId) {
        Integer num = ((TuEnrollDetailMapper)this.baseMapper).getStudiedNum(enrollDetailId);
        num = num == null ? 0 : num;
        ((TuEnrollDetailMapper)this.baseMapper).updateStudiedProgress2(enrollDetailId, num);
    }

    @Override
    @Transactional
    public void updateTestedProgress(Long enrollDetailId) {
        ((TuEnrollDetailMapper)this.baseMapper).updateTestedProgress(enrollDetailId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateClassHourProgress(Long enrollDetailId) {
        TuEnrollDetail detail = (TuEnrollDetail)this.getById(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(detail.getTid());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgress(enrollDetailId);
            return;
        } else {
            if (!trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
            if (trainingInfo.getTrainMode().equals(TrainingModeEnum.MARJOR.getValue())) {
                double hour = ((TuEnrollDetailMapper)this.baseMapper).getClassHourProgressForMajorV3_2_2_1(enrollDetailId);
                ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgressForMajorV3_2_2_1_2(enrollDetailId, hour);
                return;
            } else if (trainingInfo.getTrainMode().equals(TrainingModeEnum.ORG.getValue())) {
                ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgressForOrgV3_2_2_1(enrollDetailId);
                return;
            } else {
                if (!trainingInfo.getTrainMode().equals(TrainingModeEnum.PRECISE.getValue())) throw new ServiceException("\u57f9\u8bad\u6a21\u5f0f\u672a\u77e5\uff0c\u5b66\u65f6\u66f4\u65b0\u5931\u8d25");
                ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgressForPreciseV3_2_2_1(enrollDetailId);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void updateClassHourProgress(Long enrollDetailId, Long tid) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgress(enrollDetailId);
            return;
        } else {
            if (!trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
            if (trainingInfo.getTrainMode().equals(TrainingModeEnum.MARJOR.getValue())) {
                ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgressForMajorV3_2_2_1(enrollDetailId);
                return;
            } else if (trainingInfo.getTrainMode().equals(TrainingModeEnum.ORG.getValue())) {
                ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgressForOrgV3_2_2_1(enrollDetailId);
                return;
            } else {
                if (!trainingInfo.getTrainMode().equals(TrainingModeEnum.PRECISE.getValue())) throw new ServiceException("\u57f9\u8bad\u6a21\u5f0f\u672a\u77e5\uff0c\u5b66\u65f6\u66f4\u65b0\u5931\u8d25");
                ((TuEnrollDetailMapper)this.baseMapper).updateClassHourProgressForPreciseV3_2_2_1(enrollDetailId);
            }
        }
    }

    @Override
    public Double getStudiedClassHour(Long enrollDetailId) {
        TuEnrollDetail detail = (TuEnrollDetail)this.getById(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(detail.getTid());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            return ((TuEnrollDetailMapper)this.baseMapper).getStudiedClassHour(enrollDetailId);
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            if (trainingInfo.getTrainMode().equals(TrainingModeEnum.MARJOR.getValue())) {
                return ((TuEnrollDetailMapper)this.baseMapper).getStudiedClassHourForMajorV3_2_2_1(enrollDetailId);
            }
            if (trainingInfo.getTrainMode().equals(TrainingModeEnum.ORG.getValue())) {
                return ((TuEnrollDetailMapper)this.baseMapper).getStudiedClassHourForOrgV3_2_2_1(enrollDetailId);
            }
            if (trainingInfo.getTrainMode().equals(TrainingModeEnum.PRECISE.getValue())) {
                return ((TuEnrollDetailMapper)this.baseMapper).getStudiedClassHourForPreciseV3_2_2_1(enrollDetailId);
            }
            throw new ServiceException("\u57f9\u8bad\u6a21\u5f0f\u672a\u77e5\uff0c\u5b66\u65f6\u66f4\u65b0\u5931\u8d25");
        }
        throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
    }

    @Override
    @Transactional
    public void updateCentralizedExamResult(Long tuEnrollDetailId, Integer resultValue) {
        TuEnrollDetail tuEnrollDetail = (TuEnrollDetail)((TuEnrollDetailMapper)this.baseMapper).selectById(tuEnrollDetailId);
        if (resultValue == 2) {
            tuEnrollDetail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
            tuEnrollDetail.setTestedProgress(Integer.valueOf(1));
            tuEnrollDetail.setTestStatus(Integer.valueOf(2));
            tuEnrollDetail.setRetestLimit(Integer.valueOf(tuEnrollDetail.getRetestLimit() - 1));
            this.tuCourseService.updateTestStateByEnrollDetailId(tuEnrollDetailId, 2);
            this.updateById(tuEnrollDetail);
            this.updateClassHourProgress(tuEnrollDetailId);
            this.threadPoolTaskExecutor.execute(() -> {
                if (!this.tuCertificateService.hasBaseCertificate(tuEnrollDetail.getId()).booleanValue()) {
                    this.tuCertificateService.addCertificate(tuEnrollDetail.getId());
                }
            });
            return;
        }
        if (tuEnrollDetail.getRetestLimit() != null && tuEnrollDetail.getRetestLimit() > 0) {
            tuEnrollDetail.setRetestLimit(Integer.valueOf(tuEnrollDetail.getRetestLimit() - 1));
            tuEnrollDetail.setTestStatus(Integer.valueOf(1));
            this.tuCourseService.updateTestStateByEnrollDetailId(tuEnrollDetailId, 1);
        } else if (tuEnrollDetail.getRetestLimit() == null || tuEnrollDetail.getRetestLimit() <= -10) {
            tuEnrollDetail.setTestStatus(Integer.valueOf(1));
            this.tuCourseService.updateTestStateByEnrollDetailId(tuEnrollDetailId, 1);
        }
        this.updateById(tuEnrollDetail);
    }

    @Override
    public UserMyTrainListVo getTrainingBaseInfo(Long id) {
        if (id == null) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UserMyTrainListVo rst = ((TuEnrollDetailMapper)this.baseMapper).getTrainingBaseInfo(id);
        ArrayList personTypeNameList = new ArrayList();
        List<String> personTypeCodeList = Arrays.asList(rst.getPersonTypeCode().split(","));
        personTypeCodeList.stream().forEach(code -> personTypeNameList.add(TrainingPersonTypeEnum.getNameByValue((String)code)));
        TrainingDetailVo trainInfo = this.trainingService.getTrainingInfo(rst.getTid());
        rst.setTrainIndustryNameList(trainInfo.getTrainIndustryNameList());
        rst.setIsFaceRecognition(trainInfo.getIsFaceRecognition());
        rst.setCoverUrl(this.ossClientBean.getUrl(rst.getCoverUrl()));
        rst.setPersonTypeNameList(personTypeNameList.stream().collect(Collectors.joining("\uff0c")));
        if (rst.getTestMode() == 0) {
            rst.setIsIncludeFlunked(this.tuCourseService.ifIncludeFlunked(rst.getEnrollDetailId(), rst.getTid()));
        }
        if (rst.getTestStatus() != null && rst.getTestStatus() != 2 && rst.getRetestLimit() != null && rst.getRetestLimit() == 0) {
            rst.setIsIncludeFlunked(Boolean.valueOf(true));
        }
        return rst;
    }

    @Override
    public LayuiGridData<TrainingPersonEnrollVo> listUnitPersonEnroll(CropStaffEnrollSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingPersonEnrollVo> list = ((TuEnrollDetailMapper)this.baseMapper).listUnitPersonEnroll(param);
        list.stream().forEach(item -> {
            if (null != item.getPdfUrl()) {
                ArrayList newUrlList = new ArrayList();
                List<String> pdfUrlList = Arrays.asList(item.getPdfUrl().split(","));
                pdfUrlList.stream().forEach(url -> newUrlList.add(this.ossClientBean.getUrl(url)));
                item.setPdfUrl(newUrlList.stream().collect(Collectors.joining(",")));
            }
            if (null != item.getPersonTypeCode()) {
                ArrayList personTypeNameList = new ArrayList();
                List<String> personTypeCodeList = Arrays.asList(item.getPersonTypeCode().split(","));
                personTypeCodeList.stream().forEach(code -> personTypeNameList.add(TrainingPersonTypeEnum.getNameByValue((String)code)));
                item.setPersonTypeCode(personTypeNameList.stream().collect(Collectors.joining("\uff0c")));
            }
            item.setUsername(StringUtils.desensitizationUsernameNumber((String)item.getUsername()));
        });
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<TrainingPersonEnrollVo> listDelEnroll(CropStaffEnrollSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingPersonEnrollVo> list = ((TuEnrollDetailMapper)this.baseMapper).listDelEnroll(param);
        list.stream().forEach(item -> item.setUsername(StringUtils.desensitizationUsernameNumber((String)item.getUsername())));
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<TrainingPersonEnrollVo> listPersnoEnroll(PersonEnrollSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingPersonEnrollVo> list = ((TuEnrollDetailMapper)this.baseMapper).listPersnoEnroll(param);
        list.stream().forEach(item -> {
            if (null != item.getPdfUrl()) {
                ArrayList newUrlList = new ArrayList();
                List<String> pdfUrlList = Arrays.asList(item.getPdfUrl().split(","));
                pdfUrlList.stream().forEach(url -> newUrlList.add(this.ossClientBean.getUrl(url)));
                item.setPdfUrl(newUrlList.stream().collect(Collectors.joining(",")));
            }
            if (null != item.getPersonTypeCode()) {
                ArrayList personTypeNameList = new ArrayList();
                List<String> personTypeCodeList = Arrays.asList(item.getPersonTypeCode().split(","));
                personTypeCodeList.stream().forEach(code -> personTypeNameList.add(TrainingPersonTypeEnum.getNameByValue((String)code)));
                item.setPersonTypeCode(personTypeNameList.stream().collect(Collectors.joining("\uff0c")));
            }
        });
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<TrainEnrollCourseVo> listPersnoEnrollCourse(PersonEnrollCourseParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<Object> list = new ArrayList();
        Integer trainMode = this.trainingService.getTrainingInfo(param.getTid()).getTrainMode();
        if (trainMode != null && trainMode.equals(TrainingModeEnum.PRECISE.getValue())) {
            list = ((TuEnrollDetailMapper)this.baseMapper).listPreciseEnrollCourse(param);
            list.stream().forEach(course -> {
                if (course.getRiskFactor().equals("0")) {
                    course.setRiskFactorNameList("\u5168\u90e8");
                } else if (course.getRiskFactor().equals("")) {
                    course.setRiskFactorNameList("");
                } else {
                    course.setRiskFactorNameList(this.hazardsProviderService.getNameStrByCodeStr(course.getRiskFactor()));
                }
            });
        } else {
            list = ((TuEnrollDetailMapper)this.baseMapper).listPersnoEnrollCourse(param);
            list.stream().forEach(course -> {
                if (course.getRiskFactor().equals("0")) {
                    course.setRiskFactorNameList("\u5168\u90e8");
                } else if (course.getRiskFactor().equals("")) {
                    course.setRiskFactorNameList("");
                } else {
                    course.setRiskFactorNameList(this.hazardsProviderService.getNameStrByCodeStr(course.getRiskFactor()));
                }
            });
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public List<TuEnrollDetail> getCropPersonSourceCidAndTid(Long cid, Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"hse_cid", (Object)cid)).eq((Object)"tid", (Object)tid)).eq((Object)"enroll_source", (Object)PersnoalEnrollSourceEnum.QRCODE.getValue());
        return ((TuEnrollDetailMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<TuEnrollDetail> getByEnrollId(Long enrollId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"enroll_id", (Object)enrollId);
        return ((TuEnrollDetailMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void updateAllState() {
        ((TuEnrollDetailMapper)this.baseMapper).updateAllMajorState();
        ((TuEnrollDetailMapper)this.baseMapper).updateAllPreciseState();
    }

    @Override
    public Integer getEnrollNumber(Long enrollId) {
        return ((TuEnrollDetailMapper)this.baseMapper).getEnrollNumber(enrollId);
    }

    @Override
    public void rmCropSourceByEnrollId(Long enrollId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(TuEnrollDetail::getEnrollId, (Object)enrollId)).eq(TuEnrollDetail::getEnrollSource, (Object)PersnoalEnrollSourceEnum.COMPANY.getValue());
        ((TuEnrollDetailMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public int getHasCertificateNum(Long enrollBatchId) {
        return ((TuEnrollDetailMapper)this.baseMapper).getHasCertificateNum(enrollBatchId);
    }

    @Override
    @Transactional
    public void perTrainingInfoDeleteAndRecovery(TuEnrollDetail detail, TrainingDetailVo training, Long opter) {
        if (TrainTargetEnum.isHseTraining((Integer)training.getTrainTarget()).booleanValue()) {
            this.deleteHseTrainingSync(detail, training, opter);
        } else if (TrainTargetEnum.isRhoTraining((Integer)training.getTrainTarget()).booleanValue()) {
            this.deleteRayTrainingSync(detail);
        }
    }

    @Transactional
    public void deleteHseTrainingSync(TuEnrollDetail detail, TrainingDetailVo training, Long opter) {
        ArrayList<Long> tids = new ArrayList<Long>();
        tids.add(detail.getTid());
        List<CountObtainedCertificateVo> numVos = this.countObtainedCertificateNum(tids);
        this.trainingSynService.syncObtainedCertificateNum(numVos.get(0).getTid(), numVos.get(0).getNum());
        if (!this.tuCertificateService.hasBaseCertificateIgnoreIsValid(detail.getId())) {
            return;
        }
        if (!this.ifCanSync(detail)) {
            return;
        }
        PerTrainingInfoModel model = new PerTrainingInfoModel();
        model.setOnlineTrainId(training.getId());
        model.setCid(detail.getHseCid());
        model.setOperationType(Byte.valueOf((byte)1));
        model.setTrainUserId(detail.getUid());
        model.setOnlineTrainId(training.getId());
        model.setUpdateBy(opter);
        String s = this.trainingSynService.perTrainingInfoDeleteAndRecovery(model);
        if (!(StringUtils.isEmpty((CharSequence)s) || s.equals("\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u4fe1\u606f") || s.equals("\u672a\u67e5\u8be2\u5230\u4f01\u4e1a\u62a5\u540d\u8bb0\u5f55"))) {
            throw new ServiceException(s);
        }
    }

    @Transactional
    public void deleteRayTrainingSync(TuEnrollDetail detail) {
        TrainingCertSyncParam syncParam = new TrainingCertSyncParam();
        syncParam.setSourceEnrollId(detail.getId());
        String s = this.trainingSyncProvider.rmTrainingCert(syncParam);
        if (!StringUtils.isEmpty((CharSequence)s)) {
            throw new ServiceException(s);
        }
    }

    @Override
    @Transactional
    public void updateRedundancyExcludeUintInfo(UpRedundancyInfoParam param) {
        if (param.getCid() != null || !StringUtils.isEmpty((CharSequence)param.getUnitName()) || !StringUtils.isEmpty((CharSequence)param.getCreditCode())) {
            throw new ServiceException("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5355\u4f4d\u53d8\u66f4");
        }
        if (param.getUid() == null) {
            throw new ServiceException("uid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Boolean upFlag = false;
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.lambda().eq(TuEnrollDetail::getUid, (Object)param.getUid());
        if (param.getEnrollDetailId() != null) {
            wrapper.lambda().eq(TuEnrollDetail::getId, (Object)param.getEnrollDetailId());
        }
        TuEnrollDetail tuEnrollDetail = new TuEnrollDetail();
        if (!StringUtils.isEmpty((CharSequence)param.getIdCard())) {
            tuEnrollDetail.setIdCard(param.getIdCard());
            upFlag = true;
        }
        if (!StringUtils.isEmpty((CharSequence)param.getName())) {
            tuEnrollDetail.setUname(param.getName());
            upFlag = true;
        }
        if (!StringUtils.isEmpty((CharSequence)param.getEmail())) {
            tuEnrollDetail.setEmail(param.getEmail());
            upFlag = true;
        }
        if (upFlag.booleanValue()) {
            this.update(tuEnrollDetail, (Wrapper)wrapper);
        }
    }

    @Override
    @Transactional
    public void updateUnitRedundancyInfo(UpRedundancyInfoParam param) {
        Boolean syncCompanyFlag = false;
        if (param.getEnrollDetailId() == null) {
            throw new ServiceException("\u62a5\u540d\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TuEnrollDetail oldDetail = (TuEnrollDetail)this.getById(param.getEnrollDetailId());
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.lambda().eq(TuEnrollDetail::getId, (Object)param.getEnrollDetailId());
        TuEnrollDetail tuEnrollDetail = new TuEnrollDetail();
        TuEnroll newTuEnroll = this.tuEnrollService.getByHseCidAndTid(param.getCid(), oldDetail.getTid());
        if (newTuEnroll == null) {
            throw new ServiceException("\u65e0\u5355\u4f4d\u62a5\u540d\u6570\u636e");
        }
        syncCompanyFlag = true;
        tuEnrollDetail.setEnrollId(newTuEnroll.getId());
        if (param.getCid() != null) {
            syncCompanyFlag = true;
            tuEnrollDetail.setHseCid(param.getCid());
        }
        if (StringUtils.isEmpty((CharSequence)param.getCreditCode())) {
            syncCompanyFlag = true;
            tuEnrollDetail.setCreditCode(param.getCreditCode());
        }
        if (StringUtils.isEmpty((CharSequence)param.getUnitName())) {
            syncCompanyFlag = true;
            tuEnrollDetail.setCname(param.getUnitName());
        }
        if (syncCompanyFlag.booleanValue()) {
            this.update(tuEnrollDetail, (Wrapper)wrapper);
            TuEnrollDetail detail = (TuEnrollDetail)this.getById(param.getEnrollDetailId());
            UserVo userVo = this.userProviderService.getUserVo(detail.getUid());
            if (!this.ifCanSync(detail)) {
                return;
            }
            TrainingContext trainingContext = new TrainingContext();
            trainingContext.setTraining((Training)this.trainingService.getById(detail.getTid()));
            trainingContext.setTuEnrollDetail(detail);
            trainingContext.setToken(String.valueOf(param.getCid()));
            trainingContext.setOldToken(String.valueOf(oldDetail.getHseCid()));
            trainingContext.setUserPhone(userVo.getUsername());
            List<TuCertificate> tuCertificateList = this.tuCertificateService.getDeletedDataByDetailId(param.getEnrollDetailId());
            for (TuCertificate tuCertificate : tuCertificateList) {
                trainingContext.setTuCertificate(tuCertificate);
                String s = this.trainingSynService.syncTrainAttendAndCertInfo(trainingContext, (byte)2);
                if (StringUtils.isEmpty((CharSequence)s)) continue;
                if (s.equals("\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u4fe1\u606f")) {
                    return;
                }
                throw new ServiceException("\u540c\u6b65\u4fe1\u606f\u5931\u8d25\uff1a" + s);
            }
            ArrayList<Long> tids = new ArrayList<Long>();
            tids.add(detail.getTid());
            List<CountObtainedCertificateVo> numVos = ((TuEnrollDetailMapper)this.baseMapper).countObtainedCertificateNum(tids);
            if (!CollectionUtil.isEmpty(numVos)) {
                this.trainingSynService.syncObtainedCertificateNum(numVos.get(0).getTid(), numVos.get(0).getNum());
            }
        }
    }

    @Override
    public List<TuEnrollDetail> getEnrolledList() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(TuEnrollDetail::getIsValid, (Object)1);
        return ((TuEnrollDetailMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public TuEnrollDetail getDeletedDataById(Long id) {
        return ((TuEnrollDetailMapper)this.baseMapper).getDeletedDataById(id);
    }

    @Override
    public void setIsValidById(Boolean isValid, List<Long> ids) {
        ((TuEnrollDetailMapper)this.baseMapper).setIsValidById(isValid, ids);
    }

    @Override
    public boolean ifCanSync(TuEnrollDetail detail) {
        PersonalUserVo personalUserInfo = this.userProviderService.getPersonalUserInfo(detail.getUid());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(detail.getTid());
        return !TrainingModeEnum.ORG.getValue().equals(trainingInfo.getTrainMode()) && (personalUserInfo.getIsTest() == null || personalUserInfo.getIsTest() != 1);
    }

    @Override
    public List<CountObtainedCertificateVo> countObtainedCertificateNum(List<Long> tids) {
        return ((TuEnrollDetailMapper)this.baseMapper).countObtainedCertificateNum(tids);
    }

    @Override
    public Long getTidByDetailId(Long enrollDetailId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select((Object[])new String[]{"tid"});
        wrapper.eq((Object)"id", (Object)enrollDetailId);
        TuEnrollDetail tuEnrollDetail = (TuEnrollDetail)((TuEnrollDetailMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        return tuEnrollDetail == null ? null : tuEnrollDetail.getTid();
    }

    @Override
    @Transactional
    public void maintainBeforeExam(MaintainBeforeExamParam param) {
        if (param.getTuEnrollDetailId() == null || param.getExamEarliestTime() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        TuEnrollDetail db = (TuEnrollDetail)this.getById(param.getTuEnrollDetailId());
        if (db == null) {
            throw new ServiceException("\u7f3a\u5c11\u6570\u636e");
        }
        if (db.getHasBegunTest() == 1) {
            return;
        }
        TuEnrollDetail upEntity = new TuEnrollDetail();
        upEntity.setId(param.getTuEnrollDetailId());
        upEntity.setHasBegunTest(Integer.valueOf(1));
        upEntity.setExamEarliestTime(param.getExamEarliestTime());
        this.updateById(upEntity);
    }

    @Override
    public EnrollResultVo getSignUpOrderDetails(Long id) {
        SysOrder sysOrder = this.sysOrderService.getById(id);
        if (sysOrder == null || sysOrder.getGoodsId() == null) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        Training training = (Training)this.trainingService.getById(sysOrder.getGoodsId());
        return new EnrollResultVo().setOrderId(sysOrder.getId()).setTrainName(training.getTrainName()).setTrainPrice(training.getPrice()).setTrainStarTime(training.getTrainStarTime()).setTrainEndTime(training.getTrainEndTime());
    }

    @Override
    public void maintainEnrollPayState() {
        ((TuEnrollDetailMapper)this.baseMapper).maintainEnrollPayState();
    }

    @Generated
    public TuEnrollDetailServiceImpl() {
    }
}

