/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.enroll.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.utils.AesUtil;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperProviderService;
import cn.smarthse.radiationTraining.modules.sys.dto.sys.SysAreaDto;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.enums.CropEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropDeleteOneEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropSelectTraninglParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.GenerateEnrollQRCodeParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RemoveStaffParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SendBackParam;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingCallService;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingSynService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ICropEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.CountObtainedCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollOptVo;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollQRCodeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CropEnrollServiceImpl
implements ICropEnrollService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CropEnrollServiceImpl.class);
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITuCertificateService tuCertificateService;
    @Autowired
    private ITrainingRedisService trainingRedisService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private TrainingSynService trainingSynService;
    @Autowired
    private ICropEnrollService self;
    @Autowired
    private IUserEnrollService userEnrollService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    TrainingCallService trainingCallService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private ITuPaperProviderService tuPaperProviderService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    @Autowired
    private SysProperties sysProperties;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    @Transactional(readOnly=false)
    public TuEnroll enroll(CropSelectTraninglParam param) {
        if (param.getSource() == null) {
            throw new ServiceException("\u62a5\u540d\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getSource().equals(CropEnrollSourceEnum.PERSONAL.getValue())) {
            return this.self.enrollByStaff(param);
        }
        if (param.getSource().equals(CropEnrollSourceEnum.CROP.getValue())) {
            return this.self.enrollBySelf(param);
        }
        throw new ServiceException("\u62a5\u540d\u6765\u6e90\u9519\u8bef");
    }

    @Override
    @Transactional(readOnly=false)
    @CacheEvict(value={"TRAINING:INFO"}, key="#param.tid")
    public TuEnroll enrollBySelf(CropSelectTraninglParam param) {
        Long companyId = param.getCid();
        Long trainingId = param.getTid();
        Long uid = param.getLoginUserId();
        Integer source = CropEnrollSourceEnum.CROP.getValue();
        HseCompanyVo hseCompany = this.hseCompanyProviderService.getInfoById(param.getCid());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(trainingId);
        this.checkCropEnrollPermission(hseCompany, trainingInfo, param);
        TuEnroll tuEnrollDB = this.tuEnrollService.getByHseCidAndTid(companyId, trainingId);
        if (tuEnrollDB != null) {
            if (tuEnrollDB.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue()) {
                tuEnrollDB.setUid(uid);
                tuEnrollDB.setSource(source);
                tuEnrollDB.setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo));
                tuEnrollDB.setTrainMode(trainingInfo.getTrainMode());
                this.tuEnrollService.updateById(tuEnrollDB);
                this.threadPoolTaskExecutor.execute(() -> {
                    try {
                        this.syncCropEnrollInfo(tuEnrollDB);
                    }
                    catch (Exception e) {
                        log.error("Exception\uff1a", (Throwable)e);
                    }
                });
            } else if (tuEnrollDB.getSource().equals(CropEnrollSourceEnum.PERSONAL.getValue())) {
                tuEnrollDB.setSource(source);
                this.tuEnrollService.updateById(tuEnrollDB);
            }
            return tuEnrollDB;
        }
        Map<String, Object> issueMap = this.getSuperviseUnit(param.getCid(), trainingInfo.getId());
        TuEnroll tuEnroll = new TuEnroll().setUid(uid).setTid(trainingId).setHseCid(companyId).setCompanyName(hseCompany.getName()).setCreditCode(hseCompany.getUnifiedSocialCc()).setEnrollTime(new Date()).setEnrollNum(Integer.valueOf(0)).setHasCertificateNum(Integer.valueOf(0)).setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo)).setEnrollTime(new Date()).setSource(source).setTrainMode(trainingInfo.getTrainMode()).setIssueUnitName(String.valueOf(issueMap.get("name"))).setIssueUnitId((Long)issueMap.get("id")).setCreateBy(param.getLoginUserId()).setUpdateBy(param.getLoginUserId());
        this.tuEnrollService.save(tuEnroll);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.syncCropEnrollInfo(tuEnroll);
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        });
        return tuEnroll;
    }

    @Override
    @Transactional(readOnly=false)
    @CacheEvict(value={"TRAINING:INFO"}, key="#param.tid")
    public TuEnroll enrollBySelfEverytime(CropSelectTraninglParam param) {
        Long companyId = param.getCid();
        Long trainingId = param.getTid();
        Long uid = param.getLoginUserId();
        Integer source = CropEnrollSourceEnum.CROP.getValue();
        HseCompanyVo hseCompany = this.hseCompanyProviderService.getInfoById(param.getCid());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(trainingId);
        TuEnroll tuEnrollDB = this.tuEnrollService.getByHseCidAndTid(companyId, trainingId);
        if (tuEnrollDB != null) {
            if (tuEnrollDB.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue()) {
                tuEnrollDB.setUid(uid);
                tuEnrollDB.setSource(source);
                tuEnrollDB.setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo));
                tuEnrollDB.setTrainMode(trainingInfo.getTrainMode());
                this.tuEnrollService.updateById(tuEnrollDB);
                this.threadPoolTaskExecutor.execute(() -> {
                    try {
                        this.syncCropEnrollInfo(tuEnrollDB);
                    }
                    catch (Exception e) {
                        log.error("Exception\uff1a", (Throwable)e);
                    }
                });
            } else if (tuEnrollDB.getSource().equals(CropEnrollSourceEnum.PERSONAL.getValue())) {
                tuEnrollDB.setSource(source);
                this.tuEnrollService.updateById(tuEnrollDB);
            }
            return tuEnrollDB;
        }
        Map<String, Object> issueMap = this.getSuperviseUnit(param.getCid(), trainingInfo.getId());
        TuEnroll tuEnroll = new TuEnroll().setUid(uid).setTid(trainingId).setHseCid(companyId).setCompanyName(hseCompany.getName()).setCreditCode(hseCompany.getUnifiedSocialCc()).setEnrollTime(new Date()).setEnrollNum(Integer.valueOf(0)).setHasCertificateNum(Integer.valueOf(0)).setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo)).setEnrollTime(new Date()).setSource(source).setTrainMode(trainingInfo.getTrainMode()).setIssueUnitName(String.valueOf(issueMap.get("name"))).setIssueUnitId((Long)issueMap.get("id")).setCreateBy(param.getLoginUserId()).setUpdateBy(param.getLoginUserId());
        this.tuEnrollService.save(tuEnroll);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.syncCropEnrollInfo(tuEnroll);
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        });
        return tuEnroll;
    }

    @Override
    @Transactional(readOnly=false)
    @CacheEvict(value={"TRAINING:INFO"}, key="#param.tid")
    public TuEnroll enrollByStaff(CropSelectTraninglParam param) {
        Long companyId = param.getCid();
        Long trainingId = param.getTid();
        Long uid = param.getLoginUserId();
        Integer source = CropEnrollSourceEnum.PERSONAL.getValue();
        HseCompanyVo hseCompany = this.hseCompanyProviderService.getInfoById(param.getCid());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(trainingId);
        this.checkCropEnrollPermission(hseCompany, trainingInfo, param);
        TuEnroll tuEnrollDB = this.tuEnrollService.getByHseCidAndTid(companyId, trainingId);
        if (tuEnrollDB != null) {
            if (tuEnrollDB.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue()) {
                tuEnrollDB.setUid(uid).setSource(source).setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo)).setTrainMode(trainingInfo.getTrainMode());
                this.tuEnrollService.updateById(tuEnrollDB);
                this.threadPoolTaskExecutor.execute(() -> {
                    try {
                        this.syncCropEnrollInfo(tuEnrollDB);
                    }
                    catch (Exception e) {
                        log.error("Exception\uff1a", (Throwable)e);
                    }
                });
            }
            return tuEnrollDB;
        }
        Map<String, Object> issueMap = this.getSuperviseUnit(param.getCid(), trainingInfo.getId());
        TuEnroll tuEnroll = new TuEnroll().setUid(uid).setTid(trainingId).setHseCid(companyId).setCompanyName(hseCompany.getName()).setCreditCode(hseCompany.getUnifiedSocialCc()).setEnrollTime(new Date()).setEnrollNum(Integer.valueOf(0)).setHasCertificateNum(Integer.valueOf(0)).setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo)).setEnrollTime(new Date()).setSource(source).setTrainMode(trainingInfo.getTrainMode()).setIssueUnitName(String.valueOf(issueMap.get("name"))).setIssueUnitId((Long)issueMap.get("id")).setCreateBy(param.getLoginUserId()).setUpdateBy(param.getLoginUserId());
        this.tuEnrollService.save(tuEnroll);
        this.threadPoolTaskExecutor.execute(() -> {
            try {
                this.syncCropEnrollInfo(tuEnroll);
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        });
        return tuEnroll;
    }

    @Override
    @Transactional
    public EnrollQRCodeVo generateQRCodeContent(GenerateEnrollQRCodeParam param) {
        String content = AesUtil.encrypt((String)new StringBuffer(String.valueOf(param.getTid())).append(",").append(param.getCid()).append(",").append(param.getExpiration()).toString(), (String)this.sysProperties.getEnrollQrcodeAesKey());
        EnrollQRCodeVo enrollQRCodeVo = new EnrollQRCodeVo().setContent(content).setTime(param.getExpiration());
        RedisUtils.setCacheObject((String)RedisKey.getEnrollQRCode((Long)param.getTid(), (Long)param.getCid()), (Object)enrollQRCodeVo, (Duration)Duration.ofDays(7L));
        return enrollQRCodeVo;
    }

    @Override
    public String parsingQRCode(String qrcode) {
        return AesUtil.decrypt((String)qrcode, (String)this.sysProperties.getEnrollQrcodeAesKey());
    }

    @Override
    @Transactional
    public EnrollQRCodeVo getQRCodeContent(GenerateEnrollQRCodeParam param) {
        String oldContent = (String)RedisUtils.getCacheObject((String)RedisKey.getEnrollQRCode((Long)param.getTid(), (Long)param.getCid()));
        if (oldContent == null) {
            return this.generateQRCodeContent(param.setExpiration(Long.valueOf(System.currentTimeMillis())));
        }
        EnrollQRCodeVo enrollQRCodeVo = (EnrollQRCodeVo)JSON.parseObject((String)oldContent, EnrollQRCodeVo.class);
        if (System.currentTimeMillis() - enrollQRCodeVo.getTime() >= 604799000L) {
            return this.generateQRCodeContent(param.setExpiration(Long.valueOf(System.currentTimeMillis())));
        }
        return (EnrollQRCodeVo)JSON.parseObject((String)oldContent, EnrollQRCodeVo.class);
    }

    @Override
    @Transactional
    public void syncAllCropEnrollInfo() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().ne(TuEnroll::getSyncState, (Object)"1");
        List tuEnrollList = this.tuEnrollService.list((Wrapper)wrapper);
        for (TuEnroll tuEnroll : tuEnrollList) {
            try {
                this.self.syncCropEnrollInfo(tuEnroll);
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        }
    }

    @Override
    public void syncAllObtainedCertificateNum() {
        List<CountObtainedCertificateVo> vos = this.tuEnrollDetailService.countObtainedCertificateNum(null);
        for (CountObtainedCertificateVo vo : vos) {
            try {
                this.trainingSynService.syncObtainedCertificateNum(vo.getTid(), vo.getNum());
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void syncCropEnrollInfo(TuEnroll source) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(source.getTid());
        if (trainingInfo.getTrainMode() == TrainingModeEnum.ORG.getValue()) {
            return;
        }
        TuEnrollDetail tuEnroll = new TuEnrollDetail();
        BeanUtils.copyProperties((Object)source, (Object)tuEnroll);
        TuEnroll upEntity = new TuEnroll();
        String res = null;
        try {
            res = this.trainingSynService.addTrainInfoByCid((long)tuEnroll.getHseCid(), tuEnroll.getTid(), source.getTrainStatus() == 0 ? (byte)2 : 1, tuEnroll.getEnrollSource());
        }
        catch (NumberFormatException e) {
            upEntity.setId(tuEnroll.getId());
            upEntity.setSyncState(Integer.valueOf(2));
            upEntity.setSynDes("\u8fdc\u7a0b\u63a5\u53e3\u540c\u6b65\u5f02\u5e38");
            this.tuEnrollService.updateById(upEntity);
            return;
        }
        if (res != null) {
            upEntity.setId(tuEnroll.getId()).setSyncState(Integer.valueOf(2)).setSynDes(res);
        } else {
            upEntity.setId(tuEnroll.getId()).setSyncState(Integer.valueOf(1)).setSynDes(source.getTrainStatus() == 0 ? "\u9000\u56de\u540c\u6b65\u6210\u529f" : "\u62a5\u540d\u540c\u6b65\u6210\u529f");
        }
        this.tuEnrollService.updateById(upEntity);
    }

    private void checkCropEnrollPermission(HseCompanyVo company, TrainingDetailVo trainingInfo, CropSelectTraninglParam param) {
        if (trainingInfo.getTrainMode() == null) {
            throw new ServiceException("\u57f9\u8bad\u6a21\u5f0f\u5f02\u5e38");
        }
        if (trainingInfo.getTrainArea() != null && trainingInfo.getIsCurrency() == 0) {
            if (trainingInfo.getTrainArea() == null || company.getAreaId() == null) {
                throw new ServiceException("\u57f9\u8bad\u6216\u8005\u516c\u53f8\u7f3a\u5c11\u533a\u57dfid");
            }
            SysAreaDto trainArea = this.areaProviderService.getAreaById(trainingInfo.getTrainArea());
            SysAreaDto companyArea = this.areaProviderService.getAreaById(company.getAreaId());
            if (trainArea.getLevel() > companyArea.getLevel()) {
                throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
            }
            if (trainArea.getLevel() == 1) {
                return;
            }
            if (trainArea.getLevel() == 2) {
                if (!trainArea.getCityId().equals(companyArea.getCityId())) {
                    throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
                }
            } else if (trainArea.getLevel() == 3) {
                if (!trainArea.getAreaId().equals(companyArea.getAreaId())) {
                    throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
                }
            } else if (trainArea.getLevel() == 4) {
                if (!trainArea.getStreetId().equals(companyArea.getStreetId())) {
                    throw new ServiceException("\u516c\u53f8\u533a\u57df\u4e0e\u57f9\u8bad\u533a\u57df\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d");
                }
            } else {
                throw new ServiceException("\u533a\u57df\u6821\u9a8c\u5931\u8d25");
            }
        }
    }

    @Override
    @Transactional
    public void cropToSendBack(SendBackParam param) {
        TuEnrollDetail tuEnrollDetailDB = (TuEnrollDetail)this.tuEnrollDetailService.getById(param.getEnrollDetailId());
        EnrollOptVo enrollOptVo = this.ifCanSendBack(tuEnrollDetailDB, param.getLoginUserId());
        if (enrollOptVo != null && enrollOptVo.getCode() == 0) {
            throw new ServiceException(enrollOptVo.getMsg());
        }
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnrollDetailDB.getTid());
        this.cropToSendBack(tuEnrollDetailDB, trainingInfo, param.getLoginUserId());
    }

    @Transactional
    @CacheEvict(cacheNames={"TRAINING:INFO"}, key="#trainingInfo.id")
    public void cropToSendBack(TuEnrollDetail tuEnrollDetail, TrainingDetailVo trainingInfo, Long loginUserId) {
        if (tuEnrollDetail == null) {
            return;
        }
        if (tuEnrollDetail.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue()) {
            return;
        }
        tuEnrollDetail.setTrainStatus(TrainingStatusEnum.RETURNED.getValue());
        tuEnrollDetail.setUpdateTime(new Date());
        tuEnrollDetail.setUpdateBy(loginUserId);
        this.tuEnrollDetailService.updateById(tuEnrollDetail);
    }

    @Override
    @Transactional
    public void cropToDeleteStaff(RemoveStaffParam param) {
        Long enrollDetailId = param.getEnrollDetailId();
        Long cid = param.getCid();
        TuEnrollDetail tuEnrollDetailDB = (TuEnrollDetail)this.tuEnrollDetailService.getById(enrollDetailId);
        if (tuEnrollDetailDB == null) {
            return;
        }
        if (!tuEnrollDetailDB.getHseCid().equals(cid)) {
            throw new ServiceException(tuEnrollDetailDB.getEmail() + "\u8be5\u7528\u6237\u4e0d\u662f\u8be5\u516c\u53f8\u5458\u5de5");
        }
        this.tuCourseService.deleteByEnrollDetailId(enrollDetailId);
        this.tuCertificateService.rmByEnrollDetailId(enrollDetailId);
        tuEnrollDetailDB.setUpdateBy(param.getLoginUserId());
        tuEnrollDetailDB.setUpdateName(param.getLoginUsername());
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        this.tuEnrollDetailService.removeById(enrollDetailId);
        this.tuPaperProviderService.delTuPaperAndQuestion(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnrollDetailDB.getTid());
        if (!TrainingModeEnum.ORG.getValue().equals(trainingInfo.getTrainMode())) {
            this.tuEnrollDetailService.perTrainingInfoDeleteAndRecovery(tuEnrollDetailDB, trainingInfo, tuEnrollDetailDB.getHseCid());
        }
        this.trainingRedisService.delTrainingById(tuEnrollDetailDB.getTid());
    }

    @Override
    @Transactional
    public void cropTodeleteStaffBatch(List<RemoveStaffParam> paramList) {
        if (CollectionUtil.isEmpty(paramList)) {
            return;
        }
        ArrayList<CallSite> msgList = new ArrayList<CallSite>();
        Long cid = paramList.get(0).getCid();
        List<Long> enrollDetailIdList = paramList.stream().map(RemoveStaffParam::getEnrollDetailId).collect(Collectors.toList());
        List tuEnrollDetailList = this.tuEnrollDetailService.listByIds(enrollDetailIdList);
        for (TuEnrollDetail detail : tuEnrollDetailList) {
            if (detail.getTrainStatus() != 0) {
                msgList.add((CallSite)((Object)(detail.getEmail() + "\u7528\u6237\u4e0d\u5728\u5ba1\u6838\u672a\u901a\u8fc7\u540d\u5355\u4e2d")));
                continue;
            }
            if (detail.getHseCid().equals(cid)) continue;
            msgList.add((CallSite)((Object)(detail.getEmail() + "\u8be5\u7528\u6237\u4e0d\u662f\u8be5\u516c\u53f8\u5458\u5de5")));
        }
        if (msgList.size() > 0) {
            throw new ServiceException(Integer.valueOf(1), "\u5220\u9664\u5931\u8d25,\u8bf7\u5237\u65b0\u9875\u9762", msgList);
        }
        this.tuCourseService.deleteByEnrollDetailIds(enrollDetailIdList);
        this.tuCertificateService.rmByEnrollDetailIds(enrollDetailIdList);
        for (TuEnrollDetail tuEnrollDetailDB : tuEnrollDetailList) {
            tuEnrollDetailDB.setUpdateBy(paramList.get(0).getLoginUserId());
            tuEnrollDetailDB.setUpdateName(paramList.get(0).getLoginUsername());
            this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        }
        this.tuEnrollDetailService.removeByIds(enrollDetailIdList);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(((TuEnrollDetail)tuEnrollDetailList.get(0)).getTid());
        for (TuEnrollDetail detail : tuEnrollDetailList) {
            this.tuEnrollDetailService.perTrainingInfoDeleteAndRecovery(detail, trainingInfo, detail.getHseCid());
        }
    }

    @Override
    @Transactional
    public void cropToDeleteOneEnroll(CropDeleteOneEnrollParam param) {
        TuEnroll tuEnrollDB = (TuEnroll)this.tuEnrollService.getById(param.getEnrollId());
        if (tuEnrollDB == null) {
            return;
        }
        if (!tuEnrollDB.getHseCid().equals(param.getCid())) {
            throw new ServiceException("\u65e0\u6cd5\u5220\u9664\u975e\u672c\u516c\u53f8\u62a5\u540d\u4fe1\u606f");
        }
        Integer number = this.tuEnrollDetailService.getEnrollNumber(param.getEnrollId());
        if (number > 0) {
            throw new ServiceException("\u62a5\u540d\u4eba\u5458\u672a\u5168\u90e8\u9000\u56de\uff0c\u65e0\u6cd5\u5220\u9664\u8be5\u62a5\u540d");
        }
        this.userEnrollService.rmByEnrollId(param.getEnrollId(), param.getLoginUserId(), param.getLoginUsername());
        this.tuEnrollService.removeById(param.getEnrollId());
    }

    public Integer analyseTrainStateAfterEnroll(TrainingDetailVo training) {
        long trainStartTime;
        long currTime = new Date().getTime();
        if (currTime < (trainStartTime = training.getTrainStarTime().getTime())) {
            return TrainingStatusEnum.TO_BE_TRAINED.getValue();
        }
        return TrainingStatusEnum.IN_TRAINING.getValue();
    }

    private EnrollOptVo ifCanSendBack(TuEnrollDetail tuEnrollDetail, Long loginUsesrId) {
        double studyProgressTotal;
        double studiedProgress = tuEnrollDetail.getStudiedProgress().intValue();
        if (studiedProgress / (studyProgressTotal = (double)tuEnrollDetail.getStudyProgressTotal().intValue()) >= 0.5) {
            return new EnrollOptVo(Integer.valueOf(0), tuEnrollDetail.getEmail(), tuEnrollDetail.getUname(), tuEnrollDetail.getIdCard(), "\u5b66\u4e60\u8fdb\u5ea6\u5df2\u7ecf\u8fbe\u523050%,\u65e0\u6cd5\u9000\u56de", null);
        }
        return null;
    }

    private EnrollOptVo ifCanRmForUser(TuEnrollDetail tuEnrollDetail) {
        double studyProgressTotal;
        double studiedProgress = tuEnrollDetail.getStudiedProgress().intValue();
        if (studiedProgress / (studyProgressTotal = (double)tuEnrollDetail.getStudyProgressTotal().intValue()) >= 0.5) {
            return new EnrollOptVo(Integer.valueOf(0), tuEnrollDetail.getEmail(), tuEnrollDetail.getUname(), tuEnrollDetail.getIdCard(), "\u5b66\u4e60\u8fdb\u5ea6\u5df2\u7ecf\u8fbe\u523050%,\u65e0\u6cd5\u5220\u9664", null);
        }
        return null;
    }

    private Map<String, Object> getSuperviseUnit(Long cid, Long tid) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        Map<String, Object> result = new HashMap<String, Object>();
        if (trainingInfo.getIsCurrency() == 1) {
            result = this.trainingCallService.getSuperviseUnit(cid, trainingInfo.getTrainTarget());
        }
        return result;
    }
}

