/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperProviderService;
import cn.smarthse.radiationTraining.modules.training.dao.course.TuCourseMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.enums.CourseTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.ExamResultEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingVersionEnum;
import cn.smarthse.radiationTraining.modules.training.param.course.TuCoursePageParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonalEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RestoreStuRecordParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningOrgService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningOrgServiceV3_2_2_1;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningServiceV3_2_2_1;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseExamCountVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class TuCourseServiceImpl
extends ServiceImpl<TuCourseMapper, TuCourse>
implements ITuCourseService {
    @Autowired
    private ITuCourseService self;
    @Autowired
    private ILearningService learningService;
    @Autowired
    private ILearningServiceV3_2_2_1 learningServiceV3_2_2_1;
    @Autowired
    private ILearningOrgService learningOrgService;
    @Autowired
    private ILearningOrgServiceV3_2_2_1 learningOrgServiceV3_2_2_1;
    @Autowired
    private ITrainingCourseService trainingCourseService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuCertificateService certificateService;
    @Autowired
    private ICourseRedisService courseRedisService;
    @Autowired
    private OssClientBean ossClientBean;
    @DubboReference
    private ITuPaperProviderService tuPaperProviderService;

    @Override
    @Transactional(readOnly=false)
    public void initInfoForMajor(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, Long loginUserId) {
        if (trainingDB.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingDB.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            this.learningService.initInfoForMajor(tuEnrollDetailDB, trainingDB, loginUserId);
        } else if (trainingDB.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            this.learningServiceV3_2_2_1.initInfoForMajor(tuEnrollDetailDB, trainingDB, loginUserId);
        } else {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void initInfoForPrecise(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, List<CourseItemVo> courseItemVoList, Long loginUserId) {
        if (trainingDB.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingDB.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            this.learningService.initInfoForPrecise(tuEnrollDetailDB, trainingDB, courseItemVoList, loginUserId);
        } else if (trainingDB.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            this.learningServiceV3_2_2_1.initInfoForPrecise(tuEnrollDetailDB, trainingDB, courseItemVoList, loginUserId);
        } else {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void initInfoForOrg(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, PersonalEnrollParam param) {
        if (trainingDB.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingDB.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            this.learningOrgService.initInfoForOrg(tuEnrollDetailDB, trainingDB, param);
        } else if (trainingDB.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            this.learningOrgServiceV3_2_2_1.initInfoForOrg(tuEnrollDetailDB, trainingDB, param);
        } else {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
        }
    }

    @Override
    @Transactional
    public TuCourse updateStuDuration(UpdateDurationParam param) {
        TuCourse dto = this.getRecordById(param.getTuCourseId());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(dto.getTid());
        if (trainingInfo.getTrainMode().equals(TrainingModeEnum.MARJOR.getValue())) {
            return this.self.updateStuDurationForMajor(param);
        }
        if (trainingInfo.getTrainMode().equals(TrainingModeEnum.PRECISE.getValue())) {
            return this.self.updateStuDurationForPrecise(param);
        }
        if (trainingInfo.getTrainMode().equals(TrainingModeEnum.ORG.getValue())) {
            return this.self.updateStuDurationForOrg(param);
        }
        throw new ServiceException("\u672a\u77e5\u57f9\u8bad\u7c7b\u578b");
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForMajor(UpdateDurationParam param) {
        TuCourse dto = this.getRecordById(param.getTuCourseId());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(dto.getTid());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            return this.learningService.updateStuDurationForMajor(param);
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            return this.learningServiceV3_2_2_1.updateStuDurationForMajor(param);
        }
        throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForPrecise(UpdateDurationParam param) {
        TuCourse dto = this.getRecordById(param.getTuCourseId());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(dto.getTid());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            return this.learningService.updateStuDurationForPrecise(param);
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            return this.learningServiceV3_2_2_1.updateStuDurationForPrecise(param);
        }
        throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForOrg(UpdateDurationParam param) {
        TuCourse dto = this.getRecordById(param.getTuCourseId());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(dto.getTid());
        if (trainingInfo.getVersion() == null) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            return this.learningOrgService.updateStuDurationForOrg(param);
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            return this.learningOrgServiceV3_2_2_1.updateStuDurationForOrg(param);
        }
        throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u62a5\u540d\u5931\u8d25");
    }

    @Override
    @Transactional
    public void deleteByEnrollDetailId(Long enrollDetailId) {
        List<TuCourse> tuCourseList = this.getByEnrollDetailId(enrollDetailId);
        UpdateWrapper tuCourseUpdateWrapper = new UpdateWrapper();
        tuCourseUpdateWrapper.eq((Object)"enroll_detail_id", (Object)enrollDetailId);
        ((TuCourseMapper)this.baseMapper).delete((Wrapper)tuCourseUpdateWrapper);
        for (TuCourse tuCourse : tuCourseList) {
            this.courseRedisService.rmTuCourse(tuCourse);
        }
    }

    @Override
    @Transactional
    public void deleteByEnrollDetailIds(List<Long> enrollDetailIdList) {
        for (Long detailId : enrollDetailIdList) {
            this.deleteByEnrollDetailId(detailId);
        }
    }

    @Override
    @Transactional
    public TuCourse updateExamResult(Long tuCourseId, Integer resultValue, int passTimes, int score, Integer trainMode) {
        TuCourse tuCourse = (TuCourse)this.getById(tuCourseId);
        if (tuCourse == null) {
            throw new ServiceException("\u8003\u8bd5\u7ed3\u679c\u66f4\u65b0\u5f02\u5e38\uff1a\u672a\u627e\u5230\u5f53\u524d\u5b66\u4e60\u8bfe\u7a0b\uff01");
        }
        TrainingCourse trainingCourse = (TrainingCourse)this.trainingCourseService.getById(tuCourse.getTrainingCourseId());
        tuCourse.setIsPassed(resultValue);
        tuCourse.setScore(Integer.valueOf(score));
        if (tuCourse.getRetestLimit() != null && tuCourse.getRetestLimit() > 0) {
            tuCourse.setRetestLimit(Integer.valueOf(tuCourse.getRetestLimit() - 1));
        }
        this.updateById(tuCourse);
        this.tuEnrollDetailService.updateClassHourProgress(tuCourse.getEnrollDetailId());
        TuEnrollDetail tuEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCourse.getEnrollDetailId());
        if (Objects.equals(trainMode, TrainingModeEnum.MARJOR.getValue())) {
            if (trainingCourse != null && trainingCourse.getIsPass() == 1 && trainingCourse.getIsTest() == 1 && resultValue.equals(ExamResultEnum.PASSED.getValue())) {
                tuEnrollDetail.setTestedProgress(((TuCourseMapper)this.baseMapper).getExamPassNumByDetailId(tuEnrollDetail.getId(), trainMode));
            }
        } else if (Objects.equals(trainMode, TrainingModeEnum.PRECISE.getValue())) {
            if (resultValue.equals(ExamResultEnum.PASSED.getValue())) {
                tuEnrollDetail.setTestedProgress(((TuCourseMapper)this.baseMapper).getExamPassNumByDetailId(tuEnrollDetail.getId(), trainMode));
            }
        } else if (Objects.equals(trainMode, TrainingModeEnum.ORG.getValue()) && trainingCourse != null && trainingCourse.getIsPass() == 1 && trainingCourse.getIsTest() == 1 && resultValue.equals(ExamResultEnum.PASSED.getValue())) {
            tuEnrollDetail.setTestedProgress(((TuCourseMapper)this.baseMapper).getExamPassNumByDetailId(tuEnrollDetail.getId(), trainMode));
        }
        if (tuEnrollDetail.getStudiedProgress() >= tuEnrollDetail.getStudyProgressTotal() && (Objects.equals(tuEnrollDetail.getTrainMode(), TrainingModeEnum.MARJOR.getValue()) && tuEnrollDetail.getTestedProgress() >= tuEnrollDetail.getTestProgressTotal() || Objects.equals(tuEnrollDetail.getTrainMode(), TrainingModeEnum.PRECISE.getValue()) && tuEnrollDetail.getStudiedClassHour() >= tuEnrollDetail.getPassClassHour() || Objects.equals(tuEnrollDetail.getTrainMode(), TrainingModeEnum.ORG.getValue()) && tuEnrollDetail.getTestedProgress() >= tuEnrollDetail.getTestProgressTotal())) {
            tuEnrollDetail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
            if (!this.certificateService.hasBaseCertificate(tuEnrollDetail.getId()).booleanValue()) {
                this.certificateService.addCertificate(tuEnrollDetail.getId());
            }
        }
        this.tuEnrollDetailService.updateById(tuEnrollDetail);
        this.courseRedisService.rmTuCourse(tuCourse);
        return tuCourse;
    }

    @Override
    @Transactional
    public void updateStatus(Long tuCoruseId, Integer status) {
        TuCourse tuCourse = new TuCourse();
        tuCourse.setId(tuCoruseId).setStatus(status);
        this.updateById(tuCourse);
    }

    public List<TuCourse> getByTid(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(TuCourse::getTid, (Object)tid);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<TuCourse> getByEnrollDetailId(Long enrollDetailId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"enroll_detail_id", (Object)enrollDetailId);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public LayuiGridData<TuCourseVo> getTuCourseExamPageList(TuCoursePageParam pageParam) {
        if (Objects.equals(pageParam.getTrainMode(), TrainingModeEnum.MARJOR.getValue())) {
            if (pageParam.getTestMode() == 0) {
                PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getLimit());
                PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getLimit());
                List<TuCourseVo> list = ((TuCourseMapper)this.baseMapper).getTuCourseExamPageList(pageParam);
                return new LayuiGridData((Page)list, (LayuiGridParam)pageParam);
            }
            TuCourseVo tuCourseVo = this.getTuTrainingExam(pageParam.getTuEnrollDetailId(), pageParam.getTid(), pageParam.getKeyword());
            TrainingDetailVo info = this.trainingService.getTrainingInfo(pageParam.getTid());
            tuCourseVo.setTotalScore(info.getTotalScore());
            tuCourseVo.setQuestionNum(Integer.valueOf(info.getSingleNum() + info.getMultipleNum() + info.getCompletionNum() + info.getJudgeNum()));
            if (tuCourseVo == null) {
                return new LayuiGridData();
            }
            ArrayList<TuCourseVo> list = new ArrayList<TuCourseVo>();
            list.add(tuCourseVo);
            return new LayuiGridData(list);
        }
        if (pageParam.getTestMode() == 0) {
            PageHelper.startPage((int)pageParam.getPage(), (int)pageParam.getLimit());
            List<TuCourseVo> list = ((TuCourseMapper)this.baseMapper).listTuCourseExam(pageParam);
            return new LayuiGridData((Page)list, (LayuiGridParam)pageParam);
        }
        TuCourseVo tuCourseVo = ((TuCourseMapper)this.baseMapper).getCentExamPreciseTrain(pageParam.getTuEnrollDetailId(), pageParam.getTid(), pageParam.getKeyword());
        TrainingDetailVo info = this.trainingService.getTrainingInfo(pageParam.getTid());
        tuCourseVo.setTotalScore(info.getTotalScore());
        tuCourseVo.setQuestionNum(Integer.valueOf(info.getSingleNum() + info.getMultipleNum() + info.getCompletionNum() + info.getJudgeNum()));
        ArrayList<TuCourseVo> list = new ArrayList<TuCourseVo>();
        list.add(tuCourseVo);
        return new LayuiGridData(list);
    }

    @Override
    public TuCourseVo getTuTrainingExam(Long enrollDetailId, Long tid, String keyword) {
        return ((TuCourseMapper)this.baseMapper).getTuTrainingExam(enrollDetailId, tid, keyword);
    }

    @Override
    public TuCourseExamCountVo getTuCourseExamCount(Long loginUserId, Long tid) {
        TuCoursePageParam param = new TuCoursePageParam();
        param.setTid(tid);
        param.setUid(loginUserId);
        param.setLimit(Integer.MAX_VALUE);
        List<TuCourseVo> trainingList = ((TuCourseMapper)this.baseMapper).getTuCourseExamPageList(param);
        TuCourseExamCountVo tuCourseExamCountVo = new TuCourseExamCountVo();
        if (!CollectionUtils.isEmpty(trainingList)) {
            Integer totalNum = trainingList.size();
            Integer pendingExamNum = (int)trainingList.stream().filter(t -> t.getIsPassed().equals(ExamResultEnum.PENDING_EXAM.getValue())).count();
            Integer passedNum = (int)trainingList.stream().filter(t -> t.getIsPassed().equals(ExamResultEnum.PASSED.getValue())).count();
            tuCourseExamCountVo.setTotalNum(totalNum).setPendingExamNum(pendingExamNum).setPassedNum(passedNum);
        }
        return tuCourseExamCountVo;
    }

    @Override
    public List<Long> listUnstudiedUserByTid(Long tid) {
        return ((TuCourseMapper)this.baseMapper).batchUnstudiedUserByTid(tid);
    }

    @Override
    public TuCourse getRecordById(Long tuCoruseId) {
        TuCourse tuCourse = this.courseRedisService.getTuCourse(tuCoruseId);
        tuCourse.setVideoUrl(this.ossClientBean.getUrl(tuCourse.getVideoUrl()));
        tuCourse.setCoverUrl(this.ossClientBean.getUrl(tuCourse.getCoverUrl()));
        return tuCourse;
    }

    @Override
    public TuCourse getByDetailIdAndCourseItemId(Long detailId, Long courseItemId) {
        List<TuCourse> tuCourseList = ((TuCourseMapper)this.baseMapper).getByDetailIdAndCourseItemId(detailId, courseItemId);
        if (tuCourseList.size() > 1) {
            throw new ServiceException("\u62a5\u540d\u8bb0\u5f55\u5b58\u5728\u91cd\u590d\u6570\u636e");
        }
        if (tuCourseList.size() == 0) {
            throw new ServiceException("\u57f9\u8bad\u65e0\u8bfe\u7a0b");
        }
        return tuCourseList.get(0);
    }

    @Override
    @Transactional
    public void restoreSingleness(RestoreStuRecordParam param) {
        TuCourse tuCourseDB = (TuCourse)this.getById(param.getTuCourseId());
        if (!tuCourseDB.getUserId().equals(param.getLoginUserId())) {
            throw new ServiceException("\u65e0\u6cd5\u6062\u590d\u4ed6\u4eba\u5b66\u4e60\u8bb0\u5f55");
        }
        this.courseRedisService.rmTuCourse(tuCourseDB);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuCourseDB.getTid());
        if (trainingInfo.getIsTestOnline() == 1 && (trainingInfo.getTestMode() == null || trainingInfo.getTestMode() == 1)) {
            throw new ServiceException("\u975e\u5206\u522b\u8003\u8bd5\u8003\u8bd5\u65e0\u6cd5\u6062\u590d\u5355\u4e2a\u8bfe\u7a0b\u6570\u636e");
        }
        this.restore(tuCourseDB, trainingInfo, param.getLoginUserId());
        this.updateById(tuCourseDB);
        this.tuEnrollDetailService.updateClassHourProgress(tuCourseDB.getEnrollDetailId());
        this.tuEnrollDetailService.updateStudiedProgress(tuCourseDB.getEnrollDetailId());
        this.courseRedisService.rmTuCourse(tuCourseDB);
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(param.getTuCourseId());
        this.tuPaperProviderService.setResetByTuCourseId(longs);
        this.courseRedisService.rmTuCourse(tuCourseDB);
    }

    private void restore(TuCourse tuCourse, TrainingDetailVo trainingInfo, Long optor) {
        tuCourse.setStuDurationSec(Long.valueOf(0L)).setScore(Integer.valueOf(0)).setRetestLimit(trainingInfo.getRetestLimit()).setStatus(Integer.valueOf(0)).setIsPassed(Integer.valueOf(0)).setUpdateBy(optor).setUpdateTime(new Date());
    }

    @Override
    @Transactional
    public void restoreAll(RestoreStuRecordParam param) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTid());
        List<Object> tuCourseList = this.getByEnrollDetailId(param.getEnrollDetailId());
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0) {
            if (StringUtils.isEmpty((CharSequence)trainingInfo.getVersion())) {
                throw new ServiceException("\u7248\u672c\u7f3a\u5931");
            }
            if (TrainingVersionEnum.VERSION_BEFORE.getValue().equals(trainingInfo.getVersion())) {
                tuCourseList = tuCourseList.stream().filter(v -> v.getIsPassed() != 2 && v.getRetestLimit() == 0).collect(Collectors.toList());
            } else if (TrainingVersionEnum.VERSION_V_3_2_1_1.getValue().equals(trainingInfo.getVersion())) {
                if (TrainingModeEnum.PRECISE.getValue().equals(trainingInfo.getTrainMode())) {
                    tuCourseList = tuCourseList.stream().filter(v -> v.getIsPassed() != 2 && v.getRetestLimit() == 0).collect(Collectors.toList());
                } else if (TrainingModeEnum.MARJOR.getValue().equals(trainingInfo.getTrainMode()) || TrainingModeEnum.ORG.getValue().equals(trainingInfo.getTrainMode())) {
                    tuCourseList = tuCourseList.stream().filter(v -> {
                        TrainingCourse tc = (TrainingCourse)this.trainingCourseService.getById(v.getTrainingCourseId());
                        return tc != null && tc.getIsTest() == 1 && v.getIsPassed() != 2 && v.getRetestLimit() == 0;
                    }).collect(Collectors.toList());
                }
            } else {
                throw new ServiceException("\u672a\u77e5\u7248\u672c");
            }
        }
        if (CollectionUtils.isEmpty(tuCourseList)) {
            return;
        }
        if (!tuCourseList.get(0).getUserId().equals(param.getLoginUserId())) {
            throw new ServiceException("\u65e0\u6cd5\u6062\u590d\u4ed6\u4eba\u5b66\u4e60\u8bb0\u5f55");
        }
        for (TuCourse tuCourse : tuCourseList) {
            this.restore(tuCourse, trainingInfo, param.getLoginUserId());
        }
        this.updateBatchById(tuCourseList);
        this.tuEnrollDetailService.updateClassHourProgress(param.getEnrollDetailId());
        this.tuEnrollDetailService.updateStudiedProgress(param.getEnrollDetailId());
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0) {
            this.tuEnrollDetailService.updateTestedProgress(param.getEnrollDetailId());
        } else if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 1) {
            TuEnrollDetail upEntity = new TuEnrollDetail();
            upEntity.setId(param.getEnrollDetailId());
            upEntity.setTestedProgress(Integer.valueOf(0));
            upEntity.setTestStatus(Integer.valueOf(0));
            upEntity.setRetestLimit(trainingInfo.getRetestLimit());
            this.tuEnrollDetailService.updateById(upEntity);
        }
        this.tuPaperProviderService.setResetByTuCourseId(tuCourseList.stream().map(TuCourse::getId).collect(Collectors.toList()));
        for (TuCourse tuCourse : tuCourseList) {
            this.courseRedisService.rmTuCourse(tuCourse);
        }
    }

    @Override
    public void updateTestStateByEnrollDetailId(Long tuEnrollDetailId, Integer resultValue) {
        ((TuCourseMapper)this.baseMapper).updateTestStateByEnrollDetailId(tuEnrollDetailId, resultValue);
    }

    @Override
    public Boolean ifIncludeFlunked(Long enrollDetailId, Long tid) {
        if (enrollDetailId == null || tid == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<TuCourse> tuCourseList = this.getByEnrollDetailId(enrollDetailId);
        for (TuCourse tuCourse : tuCourseList) {
            if (tuCourse.getIsPassed() == 2 || tuCourse.getRetestLimit() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CourseItemCatalogueVo> getFlunkedCourse(Long tid, Long detailId) {
        return this.learningService.getFlunkedCourse(tid, detailId);
    }

    @Override
    public List<CourseGroupCatalogueVo> getCourseCataLogueMajor(Long tid, Long enrollDetailId, Integer stuStatus) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        if (StringUtils.isEmpty((CharSequence)trainingInfo.getVersion())) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u83b7\u53d6\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            return this.learningService.getCourseCataLogueMajor(tid, enrollDetailId, stuStatus);
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            return this.learningServiceV3_2_2_1.getCourseCataLogueMajor(tid, enrollDetailId, stuStatus);
        }
        throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u83b7\u53d6\u5931\u8d25");
    }

    @Override
    public List<CourseItemCatalogueVo> getCourseCataLogueForPrecise(Long enrollDetailId, Integer stuStatus) {
        Long tid = this.tuEnrollDetailService.getTidByDetailId(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        if (StringUtils.isEmpty((CharSequence)trainingInfo.getVersion())) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u83b7\u53d6\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            return this.learningService.getCourseCataLogueForPrecise(enrollDetailId, stuStatus);
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            return this.learningServiceV3_2_2_1.getCourseCataLogueForPrecise(enrollDetailId, stuStatus);
        }
        throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u83b7\u53d6\u5931\u8d25");
    }

    @Override
    public List<CourseItemCatalogueVo> getCourseCataLogueForOrg(Long tid, Long enrollDetailId, Integer stuStatus) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        if (StringUtils.isEmpty((CharSequence)trainingInfo.getVersion())) {
            throw new ServiceException("\u57f9\u8bad\u7248\u672c\u7f3a\u5931\uff0c\u83b7\u53d6\u5931\u8d25");
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_BEFORE.getValue())) {
            return this.learningOrgService.getCourseCataLogueOrg(tid, enrollDetailId, stuStatus);
        }
        if (trainingInfo.getVersion().equals(TrainingVersionEnum.VERSION_V_3_2_1_1.getValue())) {
            return this.learningOrgServiceV3_2_2_1.getCourseCataLogueOrg(tid, enrollDetailId, stuStatus);
        }
        throw new ServiceException("\u57f9\u8bad\u7248\u672c\u672a\u77e5\uff0c\u83b7\u53d6\u5931\u8d25");
    }

    @Override
    public List<TuCourse> getTuCourseList(Long tid, Long uid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tid", (Object)tid);
        queryWrapper.eq((Object)"user_id", (Object)uid);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<String> getCourseIdListByTAU(Long tid, Long uid) {
        List<TuCourse> courseList = this.getTuCourseList(tid, uid);
        return courseList.stream().map(x -> x.getCourseItemId().toString()).collect(Collectors.toList());
    }

    @Override
    public List<String> getRiskFactorListByTAU(Long tid, Long uid) {
        HashSet riskFactorSet = new HashSet();
        List<TuCourse> courseList = this.getTuCourseList(tid, uid);
        courseList.stream().forEach(course -> {
            if (course.getCourseType() == CourseTypeEnum.GENERAL.getValue()) {
                riskFactorSet.add("0");
            } else {
                List<String> riskCodeList = Arrays.asList(course.getRiskFactor().split(","));
                riskCodeList.stream().forEach(riskCode -> riskFactorSet.add(riskCode));
            }
        });
        return new ArrayList<String>(riskFactorSet);
    }

    @Override
    @Transactional
    public void updateRedundency(Long tid, Long courseItemId) {
        if (tid == null || courseItemId == null) {
            throw new ServiceException("tid\u6216courseItemId\u4e3a\u7a7a");
        }
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        if (trainingInfo == null) {
            throw new ServiceException("\u65e0\u57f9\u8bad\u6570\u636e");
        }
        if (trainingInfo.getTrainMode().intValue() == TrainingModeEnum.MARJOR.getValue().intValue()) {
            ((TuCourseMapper)this.baseMapper).updateRedundencyForMajor(tid, courseItemId);
        }
        if (trainingInfo.getTrainMode().intValue() == TrainingModeEnum.PRECISE.getValue().intValue()) {
            ((TuCourseMapper)this.baseMapper).updateRedundencyForPrecise(tid, courseItemId);
        }
        if (trainingInfo.getTrainMode().intValue() == TrainingModeEnum.ORG.getValue().intValue()) {
            ((TuCourseMapper)this.baseMapper).updateRedundencyForMajor(tid, courseItemId);
        }
        List<TuCourse> tuCourseList = this.getByTidAndCourseItemId(tid, courseItemId);
        for (TuCourse tuCourse : tuCourseList) {
            this.courseRedisService.rmTuCourse(tuCourse);
        }
    }

    @Override
    public List<TuCourse> getByTidAndCourseItemId(Long tid, Long courseItemId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(TuCourse::getTid, (Object)tid)).eq(TuCourse::getCourseItemId, (Object)courseItemId);
        return ((TuCourseMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    public List<TuCourse> getDeletedDataByDetailId(Long detailId) {
        return ((TuCourseMapper)this.baseMapper).getDeletedDataByDetailId(detailId);
    }

    @Override
    public void setIsValidById(Boolean isValid, List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        ((TuCourseMapper)this.baseMapper).setIsValidById(isValid, ids);
    }

    @Override
    public Integer getTrainModeByTuCourseId(Long tuCourseId) {
        return ((TuCourseMapper)this.baseMapper).getTrainModeByTuCourseId(tuCourseId);
    }

    @Override
    public List<CourseItemCatalogueVo> getCatalogueVoByEnrollDetailId(Long detailId) {
        return ((TuCourseMapper)this.baseMapper).getCatalogueVoByEnrollDetailId(detailId);
    }

    @Generated
    public TuCourseServiceImpl() {
    }
}

