/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperStructureProviderService;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.PaperStructureVo;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import cn.smarthse.radiationTraining.modules.training.enums.CourseTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.InudstryAllCodeTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RestoreStuRecordParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningOrgService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningServiceV3_2_2_1;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class LearningServiceImplV3_2_2_1
implements ILearningServiceV3_2_2_1 {
    @Autowired
    private ITrainingCourseService trainingCourseService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ILearningOrgService tuCourseOrgService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITrainingRedisService trainingRedisService;
    @Autowired
    private ITuCertificateService certificateService;
    @Autowired
    private ICourseRedisService courseRedisService;
    @DubboReference
    private ITuPaperProviderService tuPaperProviderService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private IPaperStructureProviderService paperStructureProviderService;

    @Override
    @Transactional(readOnly=false)
    public void initInfoForMajor(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, Long loginUserId) {
        List<TrainingCourse> trainingCourseListDB = this.matchCourse(tuEnrollDetailDB);
        this.checkBaseDateForMajor(trainingCourseListDB);
        int courseTotalNum = trainingCourseListDB.stream().map(TrainingCourse::getCourseId).collect(Collectors.toSet()).size();
        int isPassNum = trainingCourseListDB.stream().filter(v -> v.getIsPass() != null && v.getIsPass() == 1 && v.getIsTest() == 1).map(TrainingCourse::getCourseId).collect(Collectors.toSet()).size();
        Double classHourTotal = trainingCourseListDB.stream().mapToDouble(TrainingCourse::getClassHour).sum();
        tuEnrollDetailDB.setStudyProgressTotal(Integer.valueOf(courseTotalNum));
        tuEnrollDetailDB.setStudiedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setTestProgressTotal(Integer.valueOf(trainingDB.getIsTestOnline() == 0 ? 0 : (trainingDB.getTestMode() == 1 ? 1 : isPassNum)));
        tuEnrollDetailDB.setRetestLimit(trainingDB.getRetestLimit());
        tuEnrollDetailDB.setTestedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setPassClassHour(classHourTotal);
        tuEnrollDetailDB.setClassHourTotal(classHourTotal);
        tuEnrollDetailDB.setStudiedClassHour(Double.valueOf(0.0));
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        this.tuCourseService.deleteByEnrollDetailId(tuEnrollDetailDB.getId());
        for (TrainingCourse tc : trainingCourseListDB) {
            TuCourse temp = this.buildTuCourseForMajor(tuEnrollDetailDB, trainingDB, loginUserId, tc);
            this.tuCourseService.save(temp);
        }
    }

    public List<TrainingCourse> matchCourse(TuEnrollDetail tuEnrollDetail) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnrollDetail.getTid());
        List riskList = this.hseCompanyProviderService.getRiskFactorByCid(tuEnrollDetail.getHseCid());
        List industryList = this.hseCompanyProviderService.getIndustryCodesByCid(tuEnrollDetail.getHseCid());
        String personTypeCode = tuEnrollDetail.getPersonTypeCode();
        String[] personArr = personTypeCode.split(",");
        if (StringUtils.isEmpty((CharSequence)personTypeCode)) {
            throw new ServiceException("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<TrainingCourse> trainingCourses = this.trainingCourseService.matchCourseByPersonTypeCodeV3_2_2_1(tuEnrollDetail.getTid(), personArr);
        Map<Integer, List<TrainingCourse>> trainingCourseMap = trainingCourses.stream().collect(Collectors.groupingBy(v -> v.getCourseType()));
        List<TrainingCourse> generalCourse = trainingCourseMap.get(CourseTypeEnum.GENERAL.getValue());
        List<TrainingCourse> specialCourse = trainingCourseMap.get(CourseTypeEnum.SPECIAL.getValue());
        if (CollectionUtil.isEmpty(specialCourse)) {
            specialCourse = new ArrayList<TrainingCourse>();
        } else if (CollectionUtil.isEmpty(specialCourse = this.dealSpecialCourseForMajor(specialCourse, trainingInfo, tuEnrollDetail, industryList, riskList))) {
            specialCourse = new ArrayList<TrainingCourse>();
        }
        if (CollectionUtil.isNotEmpty(generalCourse)) {
            specialCourse.addAll(generalCourse);
        }
        return specialCourse;
    }

    private List<TrainingCourse> dealSpecialCourseForMajor(List<TrainingCourse> trainingCourses, TrainingDetailVo trainingInfo, TuEnrollDetail tuEnrollDetail, List<String> industryList, List<String> riskList) {
        trainingCourses.forEach(v -> this.analysisMatchRate((TrainingCourse)v, industryList, riskList));
        trainingCourses = trainingCourses.stream().sorted(Comparator.comparing(TrainingCourse::getMatchingRate).reversed()).collect(Collectors.toList());
        List personCertificateList = trainingInfo.getPersonCertificateList();
        String personTypeCode = tuEnrollDetail.getPersonTypeCode();
        String[] personArr = personTypeCode.split(",");
        if (StringUtils.isEmpty((CharSequence)personTypeCode)) {
            throw new ServiceException("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, TrainingPersonCertificate> personCertificateTypeMap = personCertificateList.stream().collect(Collectors.toMap(v -> String.valueOf(v.getPersonType()), v -> v));
        HashMap resultMap = new HashMap();
        for (String userPersonType : personArr) {
            if (!personCertificateTypeMap.containsKey(userPersonType)) {
                throw new ServiceException("\u62a5\u540d\u6240\u9009\u4eba\u5458\u7c7b\u578b\u4e0e\u57f9\u8bad\u4eba\u5458\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            ArrayList<TrainingCourse> subResult = new ArrayList<TrainingCourse>();
            TrainingPersonCertificate trainingPersonCertificate = personCertificateTypeMap.get(userPersonType);
            Double targetHour = trainingPersonCertificate.getPersonalizedClassHour() == null ? 0.0 : trainingPersonCertificate.getPersonalizedClassHour();
            if (targetHour <= 0.0) continue;
            Double matchHour = 0.0;
            for (TrainingCourse trainingCourse : trainingCourses) {
                if (!StrUtil.contains((CharSequence)trainingCourse.getPersonTypes(), (CharSequence)userPersonType)) continue;
                subResult.add(trainingCourse);
                if (!((matchHour = Double.valueOf(matchHour + trainingCourse.getClassHour())) >= targetHour)) continue;
                break;
            }
            if (matchHour < targetHour) {
                throw new ServiceException(TrainingPersonTypeEnum.getNameByValue2((String)userPersonType) + "\u76ee\u6807\u5b66\u65f6\u4e0d\u8db3\uff0c\u5339\u914d\u5931\u8d25");
            }
            if (resultMap.containsKey(userPersonType)) {
                throw new ServiceException("\u5b58\u5728\u91cd\u590d\u4eba\u5458\u7c7b\u578b\uff0c\u5339\u914d\u5931\u8d25");
            }
            resultMap.put(userPersonType, subResult);
        }
        Collection result = new ArrayList();
        for (List subList : resultMap.values()) {
            result = CollectionUtil.unionDistinct(result, (Collection)subList, (Collection[])new Collection[0]);
        }
        return ListUtil.toList(result);
    }

    private void analysisMatchRate(TrainingCourse trainingCourse, List<String> unitIndustryList, List<String> unitRiskList) {
        this.dealTrainingCourseTag(trainingCourse);
        this.analysisMatchLevel(trainingCourse, unitIndustryList, unitRiskList);
        Integer industryMatchingLevel = trainingCourse.getIndustryMatchingLevel();
        Integer riskMatchingLevel = trainingCourse.getRiskMatchingLevel();
        BigDecimal pow1 = NumberUtil.pow((Number)industryMatchingLevel, (int)industryMatchingLevel);
        BigDecimal pow2 = NumberUtil.pow((Number)riskMatchingLevel, (int)riskMatchingLevel);
        BigDecimal add = NumberUtil.add((Number)pow1, (Number)pow2);
        BigDecimal matchingRate = NumberUtil.div((Number)2, (Number)add);
        trainingCourse.setMatchingRate(matchingRate);
    }

    private void dealTrainingCourseTag(TrainingCourse trainingCourse) {
        String industry = trainingCourse.getIndustry();
        String riskFactor = trainingCourse.getRiskFactor();
        if (StrUtil.isNotEmpty((CharSequence)industry)) {
            trainingCourse.setIndustryList(StrUtil.split((CharSequence)industry, (CharSequence)","));
        }
        if (StrUtil.isNotEmpty((CharSequence)riskFactor)) {
            trainingCourse.setRiskFactorList(StrUtil.split((CharSequence)riskFactor, (CharSequence)","));
        }
    }

    private void analysisMatchLevel(TrainingCourse trainingCourse, List<String> unitIndustryList, List<String> unitRiskList) {
        boolean flag;
        this.dealTrainingCourseTag(trainingCourse);
        Integer industryMatchLevel = null;
        Integer riskMatchLevel = null;
        List courseIndustrySet = trainingCourse.getIndustryList();
        List courseRiskFactorSet = trainingCourse.getRiskFactorList();
        boolean courseIndustrySetContainAllType = CollUtil.containsAny((Collection)courseIndustrySet, Arrays.asList(InudstryAllCodeTypeEnum.ALL.getValue(), InudstryAllCodeTypeEnum.ALL_NON_MEDICAL.getValue(), InudstryAllCodeTypeEnum.ALL_MEDICAL.getValue()));
        if (CollectionUtil.isEmpty((Collection)courseIndustrySet) || courseIndustrySetContainAllType || CollectionUtil.isEmpty(unitIndustryList)) {
            industryMatchLevel = 2;
        } else {
            flag = false;
            block0: for (String courseIndustry : courseIndustrySet) {
                for (String unitIndustry : unitIndustryList) {
                    if (StrUtil.contains((CharSequence)unitIndustry, (CharSequence)courseIndustry)) {
                        flag = true;
                        continue block0;
                    }
                    if (!flag) continue;
                    continue block0;
                }
            }
            industryMatchLevel = flag ? 1 : 3;
        }
        if (CollectionUtil.isEmpty((Collection)courseRiskFactorSet) || courseRiskFactorSet.contains("0") || CollectionUtil.isEmpty(unitRiskList)) {
            riskMatchLevel = 2;
        } else {
            flag = false;
            block2: for (String courseRisk : courseRiskFactorSet) {
                for (String unitRisk : unitRiskList) {
                    if (StrUtil.contains((CharSequence)unitRisk, (CharSequence)courseRisk)) {
                        flag = true;
                        continue block2;
                    }
                    if (!flag) continue;
                    continue block2;
                }
            }
            riskMatchLevel = flag ? 1 : 3;
        }
        trainingCourse.setIndustryMatchingLevel(industryMatchLevel);
        trainingCourse.setRiskMatchingLevel(riskMatchLevel);
    }

    private TuCourse buildTuCourseForMajor(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, Long loginUserId, TrainingCourse tc) {
        Long tcId = tc.getId();
        Byte isTest = null;
        isTest = trainingDB.getIsTestOnline() == 1 ? Byte.valueOf(trainingDB.getTestMode() == 1 ? (byte)1 : tc.getIsTest()) : Byte.valueOf((byte)0);
        TuCourse temp = new TuCourse().setUserId(tuEnrollDetailDB.getUid()).setTid(tuEnrollDetailDB.getTid()).setEnrollId(tuEnrollDetailDB.getEnrollId()).setEnrollDetailId(tuEnrollDetailDB.getId()).setVideoDurationSec(tc.getVideoDurationSec()).setTrainMode(TrainingModeEnum.MARJOR.getValue()).setStatus(Integer.valueOf(0)).setIsPassed(isTest == 1 ? Integer.valueOf(0) : null).setIsTest(Integer.valueOf(isTest.byteValue())).setRetestLimit(trainingDB.getRetestLimit()).setCourseItemId(tc.getCourseId()).setCourseName(tc.getCourseName()).setLecturer(tc.getLecturer()).setCourseType(tc.getCourseType()).setDescription(tc.getDescription()).setClassHour(tc.getClassHour()).setVideoUrl(tc.getVideoUrl()).setVideoId(tc.getVideoId()).setCoverUrl(tc.getCoverUrl()).setCoverId(tc.getCoverId()).setTrainingCourseId(tcId).setPaperStructureId(tc.getPaperStructureId()).setWay(Integer.valueOf(Math.toIntExact(tc.getWay()))).setSingleNum(tc.getSingleNum()).setMultipleNum(tc.getMultipleNum()).setCompletionNum(tc.getCompletionNum()).setJudgeNum(tc.getJudgeNum()).setSingleScore(tc.getSingleScore()).setMultipleScore(tc.getMultipleScore()).setCompletionScore(tc.getCompletionScore()).setJudgeScore(tc.getJudgeScore()).setTotalScore(tc.getTotalScore()).setRiskFactor(tc.getRiskFactor()).setIndustry(tc.getIndustry()).setPersonType(tc.getPersonTypeCode()).setCreateBy(loginUserId).setUpdateBy(loginUserId);
        return temp;
    }

    @Override
    @Transactional(readOnly=false)
    public void initInfoForPrecise(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, List<CourseItemVo> courseItemVoList, Long loginUserId) {
        double courseTotalNum = courseItemVoList.stream().mapToDouble(CourseItemVo::getClassHour).sum();
        tuEnrollDetailDB.setStudiedClassHour(Double.valueOf(0.0));
        tuEnrollDetailDB.setPassClassHour(Double.valueOf(courseTotalNum));
        tuEnrollDetailDB.setClassHourTotal(Double.valueOf(courseTotalNum));
        tuEnrollDetailDB.setStudiedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setStudyProgressTotal(Integer.valueOf(courseItemVoList.size()));
        tuEnrollDetailDB.setTestedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setTestProgressTotal(Integer.valueOf(trainingDB.getIsTestOnline() == 0 ? 0 : (trainingDB.getTestMode() == 1 ? 1 : courseItemVoList.size())));
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        this.checkBaseDateForPrecise(courseItemVoList);
        this.tuCourseService.deleteByEnrollDetailId(tuEnrollDetailDB.getId());
        for (CourseItemVo vo : courseItemVoList) {
            TuCourse temp = this.buildTuCourseForPrecise(tuEnrollDetailDB, trainingDB, loginUserId, vo);
            this.tuCourseService.save(temp);
        }
    }

    private TuCourse buildTuCourseForPrecise(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, Long loginUserId, CourseItemVo vo) {
        String indstryCodes = vo.getCourseItemIndustryList() == null ? null : vo.getCourseItemIndustryList().stream().map(CourseItemIndustry::getCode).collect(Collectors.joining(","));
        String riskFactorCodes = vo.getCourseItemRadiationList() == null ? null : vo.getCourseItemRadiationList().stream().map(CourseItemRadiation::getCode).collect(Collectors.joining(","));
        String personTypeCodes = vo.getCourseItemPersonTypeList() == null ? null : vo.getCourseItemPersonTypeList().stream().map(CourseItemPersonType::getCode).collect(Collectors.joining(","));
        PaperStructureVo paperStructureVo = this.paperStructureProviderService.getVoById(vo.getPaperStructureId());
        if (paperStructureVo == null) {
            throw new ServiceException("\u8bfe\u7a0b\u201c" + vo.getName() + "\u201d\u7684\u8bd5\u5377\u7ed3\u6784\u5df2\u7ecf\u4e0d\u5b58\u5728,\u65e0\u6cd5\u62a5\u540d");
        }
        TuCourse temp = new TuCourse().setUserId(tuEnrollDetailDB.getUid()).setTid(tuEnrollDetailDB.getTid()).setEnrollId(tuEnrollDetailDB.getEnrollId()).setEnrollDetailId(tuEnrollDetailDB.getId()).setVideoDurationSec(vo.getVideoDurationSec()).setTrainMode(TrainingModeEnum.PRECISE.getValue()).setStatus(Integer.valueOf(0)).setIsTest(Integer.valueOf(1)).setIsPassed(Integer.valueOf(0)).setRetestLimit(trainingDB.getRetestLimit()).setCourseItemId(vo.getId()).setCourseName(vo.getName()).setLecturer(vo.getLecturer()).setDescription(vo.getDescription()).setClassHour(vo.getClassHour()).setVideoUrl(vo.getVideoUrl()).setVideoId(vo.getVideoId()).setCoverUrl(vo.getCoverUrl()).setCoverId(vo.getCoverId()).setCourseType(vo.getCourseType()).setPaperStructureId(vo.getPaperStructureId()).setWay(Integer.valueOf(paperStructureVo.getWayCode())).setSingleNum(paperStructureVo.getSingleNum()).setMultipleNum(paperStructureVo.getMultipleNum()).setCompletionNum(paperStructureVo.getCompletionNum()).setJudgeNum(paperStructureVo.getJudgeNum()).setSingleScore(paperStructureVo.getSingleScore()).setMultipleScore(paperStructureVo.getMultipleScore()).setCompletionScore(paperStructureVo.getCompletionScore()).setJudgeScore(paperStructureVo.getJudgeScore()).setTotalScore(paperStructureVo.getTotalScore()).setIndustry(indstryCodes).setPersonType(personTypeCodes).setRiskFactor(riskFactorCodes).setCreateBy(loginUserId).setUpdateBy(loginUserId);
        return temp;
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForMajor(UpdateDurationParam param) {
        Long tuCoruseId = param.getTuCourseId();
        Long stuDurationSec = param.getDuration();
        Long loginUserId = param.getLoginUserId();
        TuCourse dto = this.tuCourseService.getRecordById(tuCoruseId);
        if (!dto.getUserId().equals(loginUserId)) {
            throw new ServiceException("\u65e0\u6cd5\u66f4\u65b0\u4ed6\u4eba\u65f6\u957f");
        }
        if (dto.getStatus() == 2) {
            this.tuEnrollDetailService.updateStudiedProgress(dto.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(dto.getEnrollDetailId());
            List<TuCourse> byEnrollDetailId = this.tuCourseService.getByEnrollDetailId(dto.getEnrollDetailId());
            for (TuCourse tuCourse : byEnrollDetailId) {
                TuCourse temp = this.courseRedisService.getTuCourse(tuCourse.getId());
                if (temp.getStatus() != 2) continue;
                this.courseRedisService.rmTuCourse(tuCourse);
            }
            return dto;
        }
        if (dto.getStatus() == 0) {
            this.tuCourseService.updateStatus(tuCoruseId, 1);
        }
        Long stuDurationDBSec = dto.getStuDurationSec();
        Long videoDurationDBSec = dto.getVideoDurationSec() - 30L;
        if (stuDurationDBSec >= stuDurationSec && stuDurationSec < videoDurationDBSec) {
            return dto;
        }
        int status = stuDurationSec >= videoDurationDBSec ? 2 : 1;
        dto.setStatus(Integer.valueOf(status));
        dto.setStuDurationSec(stuDurationSec);
        if (status == 2) {
            TuCourse tuCourse = (TuCourse)this.tuCourseService.getById(tuCoruseId);
            tuCourse.setStatus(Integer.valueOf(status));
            tuCourse.setStuDurationSec(stuDurationSec);
            this.tuCourseService.updateById(tuCourse);
            this.tuEnrollDetailService.updateStudiedProgress(tuCourse.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(tuCourse.getEnrollDetailId());
            TuEnrollDetail newEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCourse.getEnrollDetailId());
            this.addCertificateForMajor(newEnrollDetail);
            dto = tuCourse;
            this.courseRedisService.rmTuCourse(dto);
            return new TuCourse().setStatus(Integer.valueOf(status));
        }
        this.courseRedisService.addOrUpTuCourse(dto);
        return dto;
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForPrecise(UpdateDurationParam param) {
        Long tuCoruseId = param.getTuCourseId();
        Long stuDurationSec = param.getDuration();
        Long loginUserId = param.getLoginUserId();
        TuCourse dto = this.tuCourseService.getRecordById(tuCoruseId);
        if (!dto.getUserId().equals(loginUserId)) {
            throw new ServiceException("\u65e0\u6cd5\u66f4\u65b0\u4ed6\u4eba\u65f6\u957f");
        }
        if (dto.getStatus() == 2) {
            this.tuEnrollDetailService.updateStudiedProgress(dto.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(dto.getEnrollDetailId());
            List<TuCourse> byEnrollDetailId = this.tuCourseService.getByEnrollDetailId(dto.getEnrollDetailId());
            for (TuCourse tuCourse : byEnrollDetailId) {
                TuCourse temp = this.courseRedisService.getTuCourse(tuCourse.getId());
                if (temp.getStatus() != 2) continue;
                this.courseRedisService.rmTuCourse(tuCourse);
            }
            return dto;
        }
        if (dto.getStatus() == 0) {
            this.tuCourseService.updateStatus(tuCoruseId, 1);
        }
        Long stuDurationDBSec = dto.getStuDurationSec();
        Long videoDurationDBSec = dto.getVideoDurationSec() - 10L;
        if (stuDurationDBSec >= stuDurationSec && stuDurationSec < videoDurationDBSec) {
            return dto;
        }
        int status = stuDurationSec >= videoDurationDBSec ? 2 : 1;
        dto.setStatus(Integer.valueOf(status));
        dto.setStuDurationSec(stuDurationSec);
        if (status == 2) {
            TuCourse tuCourse = (TuCourse)this.tuCourseService.getById(tuCoruseId);
            tuCourse.setStatus(Integer.valueOf(status));
            tuCourse.setStuDurationSec(stuDurationSec);
            this.tuCourseService.updateById(tuCourse);
            this.tuEnrollDetailService.updateStudiedProgress(tuCourse.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(tuCourse.getEnrollDetailId());
            TuEnrollDetail newEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCourse.getEnrollDetailId());
            this.addCertificateForPrecise(newEnrollDetail);
            dto = tuCourse;
            this.courseRedisService.rmTuCourse(dto);
            return new TuCourse().setStatus(Integer.valueOf(status));
        }
        this.courseRedisService.addOrUpTuCourse(dto);
        return dto;
    }

    @Transactional
    public void addCertificateForPrecise(TuEnrollDetail newEnrollDetail) {
        if (newEnrollDetail.getStudiedClassHour() >= newEnrollDetail.getPassClassHour()) {
            newEnrollDetail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
            if (!this.certificateService.hasBaseCertificate(newEnrollDetail.getId()).booleanValue()) {
                this.certificateService.addCertificate(newEnrollDetail.getId());
            }
            this.tuEnrollDetailService.updateById(newEnrollDetail);
        }
    }

    @Transactional
    public void addCertificateForMajor(TuEnrollDetail newEnrollDetail) {
        if (newEnrollDetail.getStudiedClassHour() >= newEnrollDetail.getPassClassHour()) {
            TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(newEnrollDetail.getTid());
            if (trainingInfo.getIsTestOnline() == 0 || trainingInfo.getIsTestOnline() == 1 && newEnrollDetail.getTestedProgress() >= newEnrollDetail.getTestProgressTotal()) {
                newEnrollDetail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
            }
            if (!this.certificateService.hasBaseCertificate(newEnrollDetail.getId()).booleanValue()) {
                this.certificateService.addCertificate(newEnrollDetail.getId());
            }
            this.tuEnrollDetailService.updateById(newEnrollDetail);
        }
    }

    @Override
    @Transactional
    public void restoreSingleness(RestoreStuRecordParam param) {
        TuCourse tuCourseDB = (TuCourse)this.tuCourseService.getById(param.getTuCourseId());
        if (!tuCourseDB.getUserId().equals(param.getLoginUserId())) {
            throw new ServiceException("\u65e0\u6cd5\u6062\u590d\u4ed6\u4eba\u5b66\u4e60\u8bb0\u5f55");
        }
        this.courseRedisService.rmTuCourse(tuCourseDB);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuCourseDB.getTid());
        if (trainingInfo.getIsTestOnline() == 1 && (trainingInfo.getTestMode() == null || trainingInfo.getTestMode() == 1)) {
            throw new ServiceException("\u975e\u5206\u522b\u8003\u8bd5\u8003\u8bd5\u65e0\u6cd5\u6062\u590d\u5355\u4e2a\u8bfe\u7a0b\u6570\u636e");
        }
        if (tuCourseDB.getIsPassed() == 2 || tuCourseDB.getRetestLimit() != 0) {
            this.courseRedisService.rmTuCourse(tuCourseDB);
            throw new ServiceException("\u5269\u4f59\u8003\u8bd5\u6b21\u6570\u4e0d\u4e3a\u96f6\uff0c\u65e0\u6cd5\u91cd\u7f6e");
        }
        this.restore(tuCourseDB, trainingInfo, param.getLoginUserId());
        this.tuCourseService.updateById(tuCourseDB);
        this.tuEnrollDetailService.updateClassHourProgress(tuCourseDB.getEnrollDetailId());
        this.tuEnrollDetailService.updateStudiedProgress(tuCourseDB.getEnrollDetailId());
        this.courseRedisService.rmTuCourse(tuCourseDB);
        ArrayList<Long> longs = new ArrayList<Long>();
        longs.add(param.getTuCourseId());
        this.tuPaperProviderService.setResetByTuCourseId(longs);
        this.courseRedisService.rmTuCourse(tuCourseDB);
    }

    private void restore(TuCourse tuCourse, TrainingDetailVo trainingInfo, Long optor) {
        tuCourse.setStuDurationSec(Long.valueOf(0L)).setScore(Integer.valueOf(0)).setRetestLimit(trainingInfo.getRetestLimit()).setStatus(Integer.valueOf(0)).setIsPassed(Integer.valueOf(0)).setUpdateBy(optor).setUpdateTime(new Date());
    }

    @Override
    @Transactional
    public void restoreAll(RestoreStuRecordParam param) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTid());
        List<Object> tuCourseList = this.tuCourseService.getByEnrollDetailId(param.getEnrollDetailId());
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0) {
            tuCourseList = tuCourseList.stream().filter(v -> v.getIsPassed() != 2 && v.getRetestLimit() == 0).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(tuCourseList)) {
            return;
        }
        if (!tuCourseList.get(0).getUserId().equals(param.getLoginUserId())) {
            throw new ServiceException("\u65e0\u6cd5\u6062\u590d\u4ed6\u4eba\u5b66\u4e60\u8bb0\u5f55");
        }
        for (TuCourse tuCourse : tuCourseList) {
            this.restore(tuCourse, trainingInfo, param.getLoginUserId());
        }
        this.tuCourseService.updateBatchById(tuCourseList);
        this.tuEnrollDetailService.updateClassHourProgress(param.getEnrollDetailId());
        this.tuEnrollDetailService.updateStudiedProgress(param.getEnrollDetailId());
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0) {
            this.tuEnrollDetailService.updateTestedProgress(param.getEnrollDetailId());
        } else if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 1) {
            TuEnrollDetail upEntity = new TuEnrollDetail();
            upEntity.setId(param.getEnrollDetailId());
            upEntity.setTestedProgress(Integer.valueOf(0));
            upEntity.setTestStatus(Integer.valueOf(0));
            upEntity.setRetestLimit(trainingInfo.getRetestLimit());
            this.tuEnrollDetailService.updateById(upEntity);
        }
        this.tuPaperProviderService.setResetByTuCourseId(tuCourseList.stream().map(TuCourse::getId).collect(Collectors.toList()));
        for (TuCourse tuCourse : tuCourseList) {
            this.courseRedisService.rmTuCourse(tuCourse);
        }
    }

    @Override
    public List<CourseItemCatalogueVo> getFlunkedCourseForMajor(Long tid, Long detailId) {
        if (tid == null || detailId == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        if (trainingInfo.getTrainMode().intValue() != TrainingModeEnum.MARJOR.getValue().intValue()) {
            throw new ServiceException("\u65b9\u6cd5\u8c03\u7528\u9519\u8bef\uff0c\u8be5\u65b9\u6cd5\u4e3a\u4e13\u4e1a\u57f9\u8bad\u65b9\u6cd5");
        }
        ArrayList<CourseItemCatalogueVo> voList = new ArrayList<CourseItemCatalogueVo>();
        List<CourseGroupCatalogueVo> courseCataLogue = this.getCourseCataLogueMajor(tid, detailId, null);
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0) {
            for (CourseGroupCatalogueVo vo : courseCataLogue) {
                for (CourseItemCatalogueVo subVo : vo.getItemList()) {
                    if (!subVo.getIfCanRefresh().booleanValue()) continue;
                    voList.add(subVo);
                }
            }
        } else {
            for (CourseGroupCatalogueVo vo : courseCataLogue) {
                for (CourseItemCatalogueVo subVo : vo.getItemList()) {
                    voList.add(subVo);
                }
            }
        }
        return voList;
    }

    @Override
    public List<CourseItemCatalogueVo> getFlunkedCourseForPrecise(Long tid, Long enrollDetailId) {
        if (tid == null || enrollDetailId == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        if (trainingInfo.getTrainMode().intValue() != TrainingModeEnum.PRECISE.getValue().intValue()) {
            throw new ServiceException("\u65b9\u6cd5\u8c03\u7528\u9519\u8bef\uff0c\u8be5\u65b9\u6cd5\u4e3a\u7cbe\u51c6\u57f9\u8bad\u65b9\u6cd5");
        }
        List<CourseItemCatalogueVo> catalogueVoList = this.getCourseCataLogueForPrecise(enrollDetailId, null);
        ArrayList<CourseItemCatalogueVo> voList = new ArrayList<CourseItemCatalogueVo>();
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0) {
            for (CourseItemCatalogueVo subVo : catalogueVoList) {
                if (!subVo.getIfCanRefresh().booleanValue()) continue;
                voList.add(subVo);
            }
            return voList;
        }
        return catalogueVoList;
    }

    @Override
    public List<CourseGroupCatalogueVo> getCourseCataLogueMajor(Long tid, Long enrollDetailId, Integer stuStatus) {
        List<CourseGroupCatalogueVo> courseGroupCatalogueVoList = this.trainingRedisService.getBaseCourseCataLogue(tid);
        List<TuCourse> tuCourseList = this.tuCourseService.getByEnrollDetailId(enrollDetailId);
        Map<Long, TuCourse> tuCourseMap = tuCourseList.stream().collect(Collectors.toMap(v -> v.getCourseItemId(), v -> v));
        Iterator<CourseGroupCatalogueVo> iterator = courseGroupCatalogueVoList.iterator();
        while (iterator.hasNext()) {
            CourseGroupCatalogueVo next = iterator.next();
            Iterator subIterator = next.getItemList().iterator();
            while (subIterator.hasNext()) {
                CourseItemCatalogueVo subVo = (CourseItemCatalogueVo)subIterator.next();
                if (tuCourseMap.containsKey(subVo.getCourseItemId())) {
                    TuCourse dto = this.tuCourseService.getRecordById(tuCourseMap.get(subVo.getCourseItemId()).getId());
                    if (stuStatus == null || stuStatus == -1 || dto.getStatus() == stuStatus || stuStatus == 0 && (dto.getStatus() == 0 || dto.getStatus() == 1)) {
                        subVo.setIsPassed(dto.getIsPassed()).setStuStatus(dto.getStatus()).setStuDurationSec(dto.getStuDurationSec()).setVideoDurationSec(dto.getVideoDurationSec()).setTuCourseId(dto.getId()).setRetestLimitNum(dto.getRetestLimit()).setScore(dto.getScore());
                        subVo.setVideoUrl(dto.getVideoUrl()).setName(dto.getCourseName()).setCoverUrl(dto.getCoverUrl()).setClassHour(dto.getClassHour());
                        continue;
                    }
                    subIterator.remove();
                    continue;
                }
                subIterator.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)next.getItemList())) continue;
            iterator.remove();
        }
        return courseGroupCatalogueVoList;
    }

    @Override
    public List<CourseItemCatalogueVo> getCourseCataLogueForPrecise(Long enrollDetailId, Integer stuStatus) {
        List<TuCourse> tuCourseList = this.tuCourseService.getByEnrollDetailId(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuCourseList.get(0).getTid());
        ArrayList<CourseItemCatalogueVo> catalogueVoList = new ArrayList<CourseItemCatalogueVo>();
        for (TuCourse tuCourse : tuCourseList) {
            if (stuStatus != null && stuStatus != -1 && tuCourse.getStatus() != stuStatus && (stuStatus != 0 || tuCourse.getStatus() != 0 && tuCourse.getStatus() != 1)) continue;
            CourseItemCatalogueVo catalogueVo = new CourseItemCatalogueVo();
            TuCourse cache = this.tuCourseService.getRecordById(tuCourse.getId());
            catalogueVo.setName(cache.getCourseName());
            catalogueVo.setCoverUrl(cache.getCoverUrl());
            catalogueVo.setVideoUrl(cache.getVideoUrl());
            catalogueVo.setTuCourseId(cache.getId());
            catalogueVo.setDescription(cache.getDescription());
            catalogueVo.setIsTest(String.valueOf(trainingInfo.getIsTestOnline()));
            catalogueVo.setIsPassed(cache.getIsPassed());
            catalogueVo.setStuDurationSec(cache.getStuDurationSec());
            catalogueVo.setVideoDurationSec(cache.getVideoDurationSec());
            catalogueVo.setStuStatus(cache.getStatus());
            catalogueVo.setScore(cache.getScore());
            catalogueVo.setClassHour(cache.getClassHour());
            catalogueVo.setRetestLimitNum(cache.getRetestLimit());
            catalogueVoList.add(catalogueVo);
        }
        return catalogueVoList;
    }

    @Override
    @Transactional
    public void updateRedundency(Long tid, Long courseItemId) {
    }

    private void checkBaseDateForMajor(List<TrainingCourse> trainingCourseList) {
        if (trainingCourseList == null || trainingCourseList.size() == 0) {
            throw new ServiceException("\u7528\u6237\u57f9\u8bad\uff1a\u8bfe\u7a0b\u6570\u91cf\u4e0d\u6ee1\u8db3\u57f9\u8bad\u8981\u6c42\uff0c\u62a5\u540d\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25");
        }
        for (TrainingCourse e : trainingCourseList) {
            if (!StringUtils.isEmpty((CharSequence)e.getVideoUrl()) && e.getClassHour() != null && e.getPaperStructureId() != null && e.getVideoDurationSec() != null) continue;
            throw new ServiceException("\u89c6\u9891\uff08" + e.getId() + "\uff09\u6570\u636e\u7f3a\u5931\uff0c\u65e0\u6cd5\u62a5\u540d");
        }
        trainingCourseList.stream().collect(Collectors.groupingBy(v -> v.getCourseId())).forEach((k, v) -> {
            if (v.size() > 1) {
                throw new ServiceException("\u5b58\u5728\u91cd\u590d\u8bfe\u7a0b\uff0c\u62a5\u540d\u5931\u8d25");
            }
        });
    }

    private void checkBaseDateForPrecise(List<CourseItemVo> CourseItemVoList) {
        if (CourseItemVoList.size() == 0) {
            throw new ServiceException("\u65e0\u8bfe\u7a0b\u6570\u636e");
        }
        for (CourseItemVo vo : CourseItemVoList) {
            if (!StringUtils.isEmpty((CharSequence)vo.getVideoUrl()) && vo.getClassHour() != null && vo.getPaperStructureId() != null && vo.getVideoDurationSec() != null) continue;
            throw new ServiceException("\u89c6\u9891\uff08" + vo.getId() + "\uff09\u6570\u636e\u7f3a\u5931\uff0c\u65e0\u6cd5\u62a5\u540d");
        }
        CourseItemVoList.stream().collect(Collectors.groupingBy(v -> v.getId())).forEach((k, v) -> {
            if (v.size() > 1) {
                throw new ServiceException("\u5b58\u5728\u91cd\u590d\u8bfe\u7a0b\uff0c\u62a5\u540d\u5931\u8d25");
            }
        });
    }

    @Generated
    public LearningServiceImplV3_2_2_1() {
    }
}

