/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperStructureProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.PaperStructureVo;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class LearningServiceImpl
implements ILearningService {
    @Autowired
    private ITrainingCourseService trainingCourseService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITrainingRedisService trainingRedisService;
    @Autowired
    private ITuCertificateService certificateService;
    @Autowired
    private ICourseRedisService courseRedisService;
    @DubboReference
    private IPaperStructureProviderService paperStructureProviderService;

    @Override
    @Transactional(readOnly=false)
    public void initInfoForMajor(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, Long loginUserId) {
        List<TrainingCourse> trainingCourseListDB = this.trainingCourseService.getTrainingCourseListByTid(tuEnrollDetailDB.getTid());
        if (trainingCourseListDB == null || trainingCourseListDB.size() == 0) {
            throw new ServiceException("\u7528\u6237\u57f9\u8bad\uff1a\u57f9\u8bad\u65e0\u8bfe\u7a0b\uff0c\u62a5\u540d\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25");
        }
        int courseTotalNum = trainingCourseListDB.stream().map(TrainingCourse::getCourseId).collect(Collectors.toSet()).size();
        int isPassNum = trainingCourseListDB.stream().filter(v -> v.getIsPass() != null && v.getIsPass() == 1 && v.getIsTest() == 1).map(TrainingCourse::getCourseId).collect(Collectors.toSet()).size();
        Double classHourTotal = trainingCourseListDB.stream().mapToDouble(TrainingCourse::getClassHour).sum();
        tuEnrollDetailDB.setStudyProgressTotal(Integer.valueOf(courseTotalNum));
        tuEnrollDetailDB.setStudiedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setTestProgressTotal(Integer.valueOf(trainingDB.getIsTestOnline() == 0 ? 0 : (trainingDB.getTestMode() == 1 ? 1 : isPassNum)));
        tuEnrollDetailDB.setRetestLimit(trainingDB.getRetestLimit());
        tuEnrollDetailDB.setTestedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setPassClassHour(classHourTotal);
        tuEnrollDetailDB.setClassHourTotal(classHourTotal);
        tuEnrollDetailDB.setStudiedClassHour(Double.valueOf(0.0));
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        for (TrainingCourse trainingCourse : trainingCourseListDB) {
            this.checkEnrollBaseDataForMajor(trainingCourse);
        }
        this.tuCourseService.deleteByEnrollDetailId(tuEnrollDetailDB.getId());
        for (TrainingCourse tc : trainingCourseListDB) {
            TuCourse temp = this.buildTuCourseForMajor(tuEnrollDetailDB, trainingDB, loginUserId, tc);
            this.tuCourseService.save(temp);
        }
    }

    private TuCourse buildTuCourseForMajor(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, Long loginUserId, TrainingCourse tc) {
        Long tcId = tc.getId();
        Byte isTest = null;
        isTest = trainingDB.getIsTestOnline() == 1 ? Byte.valueOf(trainingDB.getTestMode() == 1 ? (byte)1 : tc.getIsTest()) : Byte.valueOf((byte)0);
        TuCourse temp = new TuCourse().setUserId(tuEnrollDetailDB.getUid()).setTid(tuEnrollDetailDB.getTid()).setEnrollId(tuEnrollDetailDB.getEnrollId()).setEnrollDetailId(tuEnrollDetailDB.getId()).setVideoDurationSec(tc.getVideoDurationSec()).setTrainMode(TrainingModeEnum.MARJOR.getValue()).setStatus(Integer.valueOf(0)).setIsPassed(isTest == 1 ? Integer.valueOf(0) : null).setIsTest(Integer.valueOf(isTest.byteValue())).setRetestLimit(trainingDB.getRetestLimit()).setCourseItemId(tc.getCourseId()).setCourseName(tc.getCourseName()).setLecturer(tc.getLecturer()).setCourseType(tc.getCourseType()).setDescription(tc.getDescription()).setClassHour(tc.getClassHour()).setVideoUrl(tc.getVideoUrl()).setVideoId(tc.getVideoId()).setCoverUrl(tc.getCoverUrl()).setCoverId(tc.getCoverId()).setTrainingCourseId(tcId).setPaperStructureId(tc.getPaperStructureId()).setWay(Integer.valueOf(Math.toIntExact(tc.getWay()))).setSingleNum(tc.getSingleNum()).setMultipleNum(tc.getMultipleNum()).setCompletionNum(tc.getCompletionNum()).setJudgeNum(tc.getJudgeNum()).setSingleScore(tc.getSingleScore()).setMultipleScore(tc.getMultipleScore()).setCompletionScore(tc.getCompletionScore()).setJudgeScore(tc.getJudgeScore()).setTotalScore(tc.getTotalScore()).setRiskFactor(tc.getRiskFactor()).setIndustry(tc.getIndustry()).setPersonType(tc.getPersonTypeCode()).setCreateBy(loginUserId).setUpdateBy(loginUserId);
        return temp;
    }

    @Override
    @Transactional(readOnly=false)
    public void initInfoForPrecise(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, List<CourseItemVo> courseItemVoList, Long loginUserId) {
        double courseTotalNum = courseItemVoList.stream().mapToDouble(CourseItemVo::getClassHour).sum();
        tuEnrollDetailDB.setStudiedClassHour(Double.valueOf(0.0));
        tuEnrollDetailDB.setPassClassHour(trainingDB.getTargetClassHour());
        tuEnrollDetailDB.setClassHourTotal(Double.valueOf(courseTotalNum));
        tuEnrollDetailDB.setStudiedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setStudyProgressTotal(Integer.valueOf(courseItemVoList.size()));
        tuEnrollDetailDB.setTestedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setTestProgressTotal(Integer.valueOf(trainingDB.getIsTestOnline() == 0 ? 0 : (trainingDB.getTestMode() == 1 ? 1 : courseItemVoList.size())));
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        for (CourseItemVo vo : courseItemVoList) {
            this.checkEnrollBaseDataForPrecise(vo);
        }
        this.tuCourseService.deleteByEnrollDetailId(tuEnrollDetailDB.getId());
        for (CourseItemVo vo : courseItemVoList) {
            TuCourse temp = this.buildTuCourseForPrecise(tuEnrollDetailDB, trainingDB, loginUserId, vo);
            this.tuCourseService.save(temp);
        }
    }

    private TuCourse buildTuCourseForPrecise(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, Long loginUserId, CourseItemVo vo) {
        String indstryCodes = vo.getCourseItemIndustryList() == null ? null : vo.getCourseItemIndustryList().stream().map(CourseItemIndustry::getCode).collect(Collectors.joining(","));
        String riskFactorCodes = vo.getCourseItemRadiationList() == null ? null : vo.getCourseItemRadiationList().stream().map(CourseItemRadiation::getCode).collect(Collectors.joining(","));
        String personTypeCodes = vo.getCourseItemPersonTypeList() == null ? null : vo.getCourseItemPersonTypeList().stream().map(CourseItemPersonType::getCode).collect(Collectors.joining(","));
        PaperStructureVo paperStructureVo = this.paperStructureProviderService.getVoById(vo.getPaperStructureId());
        if (paperStructureVo == null) {
            throw new ServiceException("\u8bfe\u7a0b\u201c" + vo.getName() + "\u201d\u7684\u8bd5\u5377\u7ed3\u6784\u5df2\u7ecf\u4e0d\u5b58\u5728,\u65e0\u6cd5\u62a5\u540d");
        }
        TuCourse temp = new TuCourse().setUserId(tuEnrollDetailDB.getUid()).setTid(tuEnrollDetailDB.getTid()).setEnrollId(tuEnrollDetailDB.getEnrollId()).setEnrollDetailId(tuEnrollDetailDB.getId()).setVideoDurationSec(vo.getVideoDurationSec()).setTrainMode(TrainingModeEnum.PRECISE.getValue()).setStatus(Integer.valueOf(0)).setIsPassed(Integer.valueOf(0)).setRetestLimit(trainingDB.getRetestLimit()).setCourseItemId(vo.getId()).setCourseName(vo.getName()).setLecturer(vo.getLecturer()).setDescription(vo.getDescription()).setClassHour(vo.getClassHour()).setVideoUrl(vo.getVideoUrl()).setVideoId(vo.getVideoId()).setCoverUrl(vo.getCoverUrl()).setCoverId(vo.getCoverId()).setCourseType(vo.getCourseType()).setPaperStructureId(vo.getPaperStructureId()).setWay(Integer.valueOf(paperStructureVo.getWayCode())).setSingleNum(paperStructureVo.getSingleNum()).setMultipleNum(paperStructureVo.getMultipleNum()).setCompletionNum(paperStructureVo.getCompletionNum()).setJudgeNum(paperStructureVo.getJudgeNum()).setSingleScore(paperStructureVo.getSingleScore()).setMultipleScore(paperStructureVo.getMultipleScore()).setCompletionScore(paperStructureVo.getCompletionScore()).setJudgeScore(paperStructureVo.getJudgeScore()).setTotalScore(paperStructureVo.getTotalScore()).setIndustry(indstryCodes).setPersonType(personTypeCodes).setRiskFactor(riskFactorCodes).setCreateBy(loginUserId).setUpdateBy(loginUserId);
        return temp;
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForMajor(UpdateDurationParam param) {
        Long tuCoruseId = param.getTuCourseId();
        Long stuDurationSec = param.getDuration();
        Long loginUserId = param.getLoginUserId();
        TuCourse dto = this.tuCourseService.getRecordById(tuCoruseId);
        if (!dto.getUserId().equals(loginUserId)) {
            throw new ServiceException("\u65e0\u6cd5\u66f4\u65b0\u4ed6\u4eba\u65f6\u957f");
        }
        if (dto.getStatus() == 2) {
            this.tuEnrollDetailService.updateStudiedProgress(dto.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(dto.getEnrollDetailId());
            List<TuCourse> byEnrollDetailId = this.tuCourseService.getByEnrollDetailId(dto.getEnrollDetailId());
            for (TuCourse tuCourse : byEnrollDetailId) {
                TuCourse temp = this.courseRedisService.getTuCourse(tuCourse.getId());
                if (temp.getStatus() != 2) continue;
                this.courseRedisService.rmTuCourse(tuCourse);
            }
            return dto;
        }
        if (dto.getStatus() == 0) {
            this.tuCourseService.updateStatus(tuCoruseId, 1);
        }
        Long stuDurationDBSec = dto.getStuDurationSec();
        Long videoDurationDBSec = dto.getVideoDurationSec() - 10L;
        if (stuDurationDBSec >= stuDurationSec && stuDurationSec < videoDurationDBSec) {
            return dto;
        }
        int status = stuDurationSec >= videoDurationDBSec ? 2 : 1;
        dto.setStatus(Integer.valueOf(status));
        dto.setStuDurationSec(stuDurationSec);
        if (status == 2) {
            TuCourse tuCourse = (TuCourse)this.tuCourseService.getById(tuCoruseId);
            tuCourse.setStatus(Integer.valueOf(status));
            tuCourse.setStuDurationSec(stuDurationSec);
            this.tuCourseService.updateById(tuCourse);
            this.tuEnrollDetailService.updateStudiedProgress(tuCourse.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(tuCourse.getEnrollDetailId());
            TuEnrollDetail newEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCourse.getEnrollDetailId());
            this.addCertificateForMajor(newEnrollDetail);
            dto = tuCourse;
            this.courseRedisService.rmTuCourse(dto);
            return new TuCourse().setStatus(Integer.valueOf(status));
        }
        this.courseRedisService.addOrUpTuCourse(dto);
        return dto;
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForPrecise(UpdateDurationParam param) {
        Long tuCoruseId = param.getTuCourseId();
        Long stuDurationSec = param.getDuration();
        Long loginUserId = param.getLoginUserId();
        TuCourse dto = this.tuCourseService.getRecordById(tuCoruseId);
        if (!dto.getUserId().equals(loginUserId)) {
            throw new ServiceException("\u65e0\u6cd5\u66f4\u65b0\u4ed6\u4eba\u65f6\u957f");
        }
        if (dto.getStatus() == 2) {
            this.tuEnrollDetailService.updateStudiedProgress(dto.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(dto.getEnrollDetailId());
            List<TuCourse> byEnrollDetailId = this.tuCourseService.getByEnrollDetailId(dto.getEnrollDetailId());
            for (TuCourse tuCourse : byEnrollDetailId) {
                TuCourse temp = this.courseRedisService.getTuCourse(tuCourse.getId());
                if (temp.getStatus() != 2) continue;
                this.courseRedisService.rmTuCourse(tuCourse);
            }
            return dto;
        }
        if (dto.getStatus() == 0) {
            this.tuCourseService.updateStatus(tuCoruseId, 1);
        }
        Long stuDurationDBSec = dto.getStuDurationSec();
        Long videoDurationDBSec = dto.getVideoDurationSec() - 10L;
        if (stuDurationDBSec >= stuDurationSec && stuDurationSec < videoDurationDBSec) {
            return dto;
        }
        int status = stuDurationSec >= videoDurationDBSec ? 2 : 1;
        dto.setStatus(Integer.valueOf(status));
        dto.setStuDurationSec(stuDurationSec);
        if (status == 2) {
            TuCourse tuCourse = (TuCourse)this.tuCourseService.getById(tuCoruseId);
            tuCourse.setStatus(Integer.valueOf(status));
            tuCourse.setStuDurationSec(stuDurationSec);
            this.tuCourseService.updateById(tuCourse);
            this.tuEnrollDetailService.updateStudiedProgress(tuCourse.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(tuCourse.getEnrollDetailId());
            TuEnrollDetail newEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCourse.getEnrollDetailId());
            this.addCertificateForPrecise(newEnrollDetail);
            dto = tuCourse;
            this.courseRedisService.rmTuCourse(dto);
            return new TuCourse().setStatus(Integer.valueOf(status));
        }
        this.courseRedisService.addOrUpTuCourse(dto);
        return dto;
    }

    @Transactional
    public void addCertificateForPrecise(TuEnrollDetail newEnrollDetail) {
        if (newEnrollDetail.getStudiedClassHour() >= newEnrollDetail.getPassClassHour()) {
            newEnrollDetail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
            if (!this.certificateService.hasBaseCertificate(newEnrollDetail.getId()).booleanValue()) {
                this.certificateService.addCertificate(newEnrollDetail.getId());
            }
            this.tuEnrollDetailService.updateById(newEnrollDetail);
        }
    }

    @Transactional
    public void addCertificateForMajor(TuEnrollDetail newEnrollDetail) {
        if (newEnrollDetail.getStudiedProgress() >= newEnrollDetail.getStudyProgressTotal() && newEnrollDetail.getTestedProgress() >= newEnrollDetail.getTestProgressTotal()) {
            newEnrollDetail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
            if (!this.certificateService.hasBaseCertificate(newEnrollDetail.getId()).booleanValue()) {
                this.certificateService.addCertificate(newEnrollDetail.getId());
            }
            this.tuEnrollDetailService.updateById(newEnrollDetail);
        }
    }

    @Override
    public List<CourseGroupCatalogueVo> getCourseCataLogueMajor(Long tid, Long enrollDetailId, Integer stuStatus) {
        List<CourseGroupCatalogueVo> courseGroupCatalogueVoList = this.trainingRedisService.getBaseCourseCataLogue(tid);
        Iterator<CourseGroupCatalogueVo> iterator = courseGroupCatalogueVoList.iterator();
        while (iterator.hasNext()) {
            CourseGroupCatalogueVo next = iterator.next();
            Iterator subIterator = next.getItemList().iterator();
            while (subIterator.hasNext()) {
                CourseItemCatalogueVo subVo = (CourseItemCatalogueVo)subIterator.next();
                Long tuCourseId = this.courseRedisService.getTuCourseId(enrollDetailId, subVo.getCourseItemId());
                TuCourse dto = this.tuCourseService.getRecordById(tuCourseId);
                if (stuStatus == null || stuStatus == -1 || dto.getStatus() == stuStatus || stuStatus == 0 && (dto.getStatus() == 0 || dto.getStatus() == 1)) {
                    subVo.setIsPassed(dto.getIsPassed()).setStuStatus(dto.getStatus()).setStuDurationSec(dto.getStuDurationSec()).setVideoDurationSec(dto.getVideoDurationSec()).setTuCourseId(tuCourseId).setRetestLimitNum(dto.getRetestLimit()).setScore(dto.getScore());
                    subVo.setVideoUrl(dto.getVideoUrl()).setName(dto.getCourseName()).setCoverUrl(dto.getCoverUrl()).setClassHour(dto.getClassHour());
                    continue;
                }
                subIterator.remove();
            }
            if (!CollectionUtils.isEmpty((Collection)next.getItemList())) continue;
            iterator.remove();
        }
        return courseGroupCatalogueVoList;
    }

    @Override
    public List<CourseItemCatalogueVo> getCourseCataLogueForPrecise(Long enrollDetailId, Integer stuStatus) {
        List<TuCourse> tuCourseList = this.tuCourseService.getByEnrollDetailId(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuCourseList.get(0).getTid());
        ArrayList<CourseItemCatalogueVo> catalogueVoList = new ArrayList<CourseItemCatalogueVo>();
        for (TuCourse tuCourse : tuCourseList) {
            if (stuStatus != null && stuStatus != -1 && tuCourse.getStatus() != stuStatus && (stuStatus != 0 || tuCourse.getStatus() != 0 && tuCourse.getStatus() != 1)) continue;
            CourseItemCatalogueVo catalogueVo = new CourseItemCatalogueVo();
            TuCourse cache = this.tuCourseService.getRecordById(tuCourse.getId());
            catalogueVo.setName(cache.getCourseName());
            catalogueVo.setCoverUrl(cache.getCoverUrl());
            catalogueVo.setVideoUrl(cache.getVideoUrl());
            catalogueVo.setTuCourseId(cache.getId());
            catalogueVo.setDescription(cache.getDescription());
            catalogueVo.setIsTest(String.valueOf(trainingInfo.getIsTestOnline()));
            catalogueVo.setIsPassed(cache.getIsPassed());
            catalogueVo.setStuDurationSec(cache.getStuDurationSec());
            catalogueVo.setVideoDurationSec(cache.getVideoDurationSec());
            catalogueVo.setClassHour(cache.getClassHour());
            catalogueVo.setStuStatus(cache.getStatus());
            catalogueVo.setScore(cache.getScore());
            catalogueVo.setRetestLimitNum(cache.getRetestLimit());
            catalogueVoList.add(catalogueVo);
        }
        return catalogueVoList;
    }

    @Override
    @Transactional
    public void updateRedundency(Long tid, Long courseItemId) {
    }

    @Override
    public List<CourseItemCatalogueVo> getFlunkedCourse(Long tid, Long detailId) {
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        List<CourseItemCatalogueVo> voList = this.tuCourseService.getCatalogueVoByEnrollDetailId(detailId);
        ArrayList<CourseItemCatalogueVo> result = new ArrayList<CourseItemCatalogueVo>();
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0) {
            for (CourseItemCatalogueVo vo : voList) {
                if (!vo.getIfCanRefresh().booleanValue()) continue;
                result.add(vo);
            }
            return result;
        }
        if (trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 1) {
            return voList;
        }
        if (trainingInfo.getIsTestOnline() == 0) {
            return new ArrayList<CourseItemCatalogueVo>();
        }
        throw new ServiceException("\u57f9\u8bad\u8003\u8bd5\u7c7b\u578b\u9519\u8bef\uff0c\u83b7\u53d6\u672a\u901a\u8fc7\u8bfe\u7a0b\u5217\u8868\u5931\u8d25");
    }

    private void checkEnrollBaseDataForMajor(TrainingCourse vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getVideoUrl()) || vo.getClassHour() == null || vo.getPaperStructureId() == null || vo.getVideoDurationSec() == null) {
            throw new ServiceException("\u89c6\u9891\uff08" + vo.getId() + "\uff09\u6570\u636e\u7f3a\u5931\uff0c\u65e0\u6cd5\u62a5\u540d");
        }
    }

    private void checkEnrollBaseDataForPrecise(CourseItemVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getVideoUrl()) || vo.getClassHour() == null || vo.getPaperStructureId() == null || vo.getVideoDurationSec() == null) {
            throw new ServiceException("\u89c6\u9891\uff08" + vo.getId() + "\uff09\u6570\u636e\u7f3a\u5931\uff0c\u65e0\u6cd5\u62a5\u540d");
        }
    }

    @Generated
    public LearningServiceImpl() {
    }
}

