/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonalEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningOrgService;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningOrgServiceV3_2_2_1;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCoursePersonTypeService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LearningOrgServiceImplV3_2_2_1
implements ILearningOrgServiceV3_2_2_1 {
    @Autowired
    private ITrainingCourseService trainingCourseService;
    @Autowired
    private ITrainingCoursePersonTypeService trainingCoursePersonTypeService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ICourseItemService courseItemService;
    @Autowired
    private ILearningOrgService self;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITrainingRedisService trainingRedisService;
    @Autowired
    private ITuCertificateService certificateService;
    @Autowired
    private ICourseRedisService courseRedisService;

    @Override
    @Transactional(readOnly=false)
    public void initInfoForOrg(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, PersonalEnrollParam param) {
        List<TrainingCourse> trainingCourseList = this.matchCourse(param);
        this.checkEnrollBaseDataForORG(trainingCourseList);
        int courseTotalNum = trainingCourseList.stream().map(TrainingCourse::getCourseId).collect(Collectors.toSet()).size();
        int isPassNum = trainingCourseList.stream().filter(v -> v.getIsPass() != null && v.getIsPass() == 1 && v.getIsTest() == 1).map(TrainingCourse::getCourseId).collect(Collectors.toSet()).size();
        Double classHourTotal = trainingCourseList.stream().mapToDouble(TrainingCourse::getClassHour).sum();
        tuEnrollDetailDB.setStudyProgressTotal(Integer.valueOf(courseTotalNum));
        tuEnrollDetailDB.setStudiedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setTestProgressTotal(Integer.valueOf(trainingDB.getIsTestOnline() == 0 ? 0 : (trainingDB.getTestMode() == 1 ? 1 : isPassNum)));
        tuEnrollDetailDB.setRetestLimit(trainingDB.getRetestLimit());
        tuEnrollDetailDB.setTestedProgress(Integer.valueOf(0));
        tuEnrollDetailDB.setPassClassHour(classHourTotal);
        tuEnrollDetailDB.setClassHourTotal(classHourTotal);
        tuEnrollDetailDB.setStudiedClassHour(Double.valueOf(0.0));
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        this.tuCourseService.deleteByEnrollDetailId(tuEnrollDetailDB.getId());
        for (TrainingCourse tc : trainingCourseList) {
            TuCourse temp = this.buildTuCourse(tuEnrollDetailDB, trainingDB, param, tc);
            this.tuCourseService.save(temp);
        }
    }

    private TuCourse buildTuCourse(TuEnrollDetail tuEnrollDetailDB, Training trainingDB, PersonalEnrollParam param, TrainingCourse tc) {
        Long tcId = tc.getId();
        Byte isTest = tc.getIsTest();
        TuCourse temp = new TuCourse().setUserId(tuEnrollDetailDB.getUid()).setTid(tuEnrollDetailDB.getTid()).setEnrollId(tuEnrollDetailDB.getEnrollId()).setEnrollDetailId(tuEnrollDetailDB.getId()).setVideoDurationSec(tc.getVideoDurationSec()).setTrainMode(TrainingModeEnum.MARJOR.getValue()).setStatus(Integer.valueOf(0)).setIsPassed(isTest == 1 ? Integer.valueOf(0) : null).setRetestLimit(trainingDB.getRetestLimit()).setCourseItemId(tc.getCourseId()).setCourseName(tc.getCourseName()).setLecturer(tc.getLecturer()).setCourseType(tc.getCourseType()).setDescription(tc.getDescription()).setClassHour(tc.getClassHour()).setVideoUrl(tc.getVideoUrl()).setVideoId(tc.getVideoId()).setCoverUrl(tc.getCoverUrl()).setCoverId(tc.getCoverId()).setTrainingCourseId(tcId).setPaperStructureId(tc.getPaperStructureId()).setWay(Integer.valueOf(Math.toIntExact(tc.getWay()))).setSingleNum(tc.getSingleNum()).setMultipleNum(tc.getMultipleNum()).setCompletionNum(tc.getCompletionNum()).setSingleScore(tc.getSingleScore()).setMultipleScore(tc.getMultipleScore()).setCompletionScore(tc.getCompletionScore()).setTotalScore(tc.getTotalScore()).setRiskFactor(tc.getRiskFactor()).setIndustry(tc.getIndustry()).setPersonType(tc.getPersonTypeCode()).setCreateBy(param.getLoginUserId()).setUpdateBy(param.getLoginUserId());
        return temp;
    }

    @Override
    @Transactional
    public TuCourse updateStuDurationForOrg(UpdateDurationParam param) {
        Long tuCoruseId = param.getTuCourseId();
        Long stuDurationSec = param.getDuration();
        Long loginUserId = param.getLoginUserId();
        TuCourse dto = this.tuCourseService.getRecordById(tuCoruseId);
        if (!dto.getUserId().equals(loginUserId)) {
            throw new ServiceException("\u65e0\u6cd5\u66f4\u65b0\u4ed6\u4eba\u65f6\u957f");
        }
        if (dto.getStatus() == 2) {
            this.tuEnrollDetailService.updateStudiedProgress(dto.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(dto.getEnrollDetailId());
            List<TuCourse> byEnrollDetailId = this.tuCourseService.getByEnrollDetailId(dto.getEnrollDetailId());
            for (TuCourse tuCourse : byEnrollDetailId) {
                TuCourse temp = this.courseRedisService.getTuCourse(tuCourse.getId());
                if (temp.getStatus() != 2) continue;
                this.courseRedisService.rmTuCourse(tuCourse);
            }
            return dto;
        }
        if (dto.getStatus() == 0) {
            this.tuCourseService.updateStatus(tuCoruseId, 1);
        }
        Long stuDurationDBSec = dto.getStuDurationSec();
        Long videoDurationDBSec = dto.getVideoDurationSec() - 10L;
        if (stuDurationDBSec >= stuDurationSec && stuDurationSec < videoDurationDBSec) {
            return dto;
        }
        int status = stuDurationSec >= videoDurationDBSec ? 2 : 1;
        dto.setStatus(Integer.valueOf(status));
        dto.setStuDurationSec(stuDurationSec);
        if (status == 2) {
            TuCourse tuCourse = (TuCourse)this.tuCourseService.getById(tuCoruseId);
            tuCourse.setStatus(Integer.valueOf(status));
            tuCourse.setStuDurationSec(stuDurationSec);
            this.tuCourseService.updateById(tuCourse);
            this.tuEnrollDetailService.updateStudiedProgress(tuCourse.getEnrollDetailId());
            this.tuEnrollDetailService.updateClassHourProgress(tuCourse.getEnrollDetailId());
            TuEnrollDetail newEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCourse.getEnrollDetailId());
            this.addCertificateForOrg(newEnrollDetail);
            dto = tuCourse;
            this.courseRedisService.rmTuCourse(dto);
            return new TuCourse().setStatus(Integer.valueOf(status));
        }
        this.courseRedisService.addOrUpTuCourse(dto);
        return dto;
    }

    @Transactional
    public void addCertificateForOrg(TuEnrollDetail newEnrollDetail) {
        if (newEnrollDetail.getStudiedProgress() >= newEnrollDetail.getStudyProgressTotal() && newEnrollDetail.getTestedProgress() >= newEnrollDetail.getTestProgressTotal()) {
            newEnrollDetail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
            if (!this.certificateService.hasBaseCertificate(newEnrollDetail.getId()).booleanValue()) {
                this.certificateService.addCertificate(newEnrollDetail.getId());
            }
            this.tuEnrollDetailService.updateById(newEnrollDetail);
        }
    }

    @Override
    public List<CourseItemCatalogueVo> getCourseCataLogueOrg(Long tid, Long enrollDetailId, Integer stuStatus) {
        ArrayList<CourseItemCatalogueVo> result = new ArrayList<CourseItemCatalogueVo>();
        List<CourseGroupCatalogueVo> courseGroupCatalogueVoList = this.trainingRedisService.getBaseCourseCataLogue(tid);
        List<TuCourse> tuCourseList = this.tuCourseService.getByEnrollDetailId(enrollDetailId);
        courseGroupCatalogueVoList.stream().map(CourseGroupCatalogueVo::getItemList).collect(Collectors.toList()).stream().forEach(v -> result.addAll((Collection<CourseItemCatalogueVo>)v));
        Iterator iterator = result.iterator();
        Map<Long, TuCourse> tuCourseMap = tuCourseList.stream().collect(Collectors.toMap(TuCourse::getCourseItemId, v -> v));
        while (iterator.hasNext()) {
            CourseItemCatalogueVo vo = (CourseItemCatalogueVo)iterator.next();
            if (tuCourseMap.containsKey(vo.getCourseItemId())) {
                TuCourse tuCourse = tuCourseMap.get(vo.getCourseItemId());
                if (stuStatus == null || stuStatus == -1 || tuCourse.getStatus() == stuStatus || stuStatus == 0 && (tuCourse.getStatus() == 0 || tuCourse.getStatus() == 1)) {
                    vo.setIsPassed(tuCourse.getIsPassed()).setStuStatus(tuCourse.getStatus()).setStuDurationSec(tuCourse.getStuDurationSec()).setVideoDurationSec(tuCourse.getVideoDurationSec()).setTuCourseId(tuCourse.getId()).setRetestLimitNum(tuCourse.getRetestLimit()).setScore(tuCourse.getScore());
                    vo.setVideoUrl(tuCourse.getVideoUrl()).setName(tuCourse.getCourseName()).setCoverUrl(tuCourse.getCoverUrl()).setClassHour(tuCourse.getClassHour());
                    continue;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return result;
    }

    private void checkEnrollBaseDataForORG(List<TrainingCourse> trainingCourseList) {
        if (trainingCourseList == null || trainingCourseList.size() == 0) {
            throw new ServiceException("\u7528\u6237\u57f9\u8bad\uff1a\u57f9\u8bad\u65e0\u8bfe\u7a0b\uff0c\u62a5\u540d\u4fe1\u606f\u521d\u59cb\u5316\u5931\u8d25");
        }
        for (TrainingCourse tc : trainingCourseList) {
            if (!StringUtils.isEmpty((CharSequence)tc.getVideoUrl()) && tc.getClassHour() != null && tc.getPaperStructureId() != null && tc.getVideoDurationSec() != null) continue;
            throw new ServiceException("\u89c6\u9891\uff08" + tc.getId() + "\uff09\u6570\u636e\u7f3a\u5931\uff0c\u65e0\u6cd5\u62a5\u540d");
        }
        trainingCourseList.stream().collect(Collectors.groupingBy(v -> v.getCourseId())).forEach((k, v) -> {
            if (v.size() > 1) {
                throw new ServiceException("\u5b58\u5728\u91cd\u590d\u8bfe\u7a0b\uff0c\u62a5\u540d\u5931\u8d25");
            }
        });
    }

    public List<TrainingCourse> matchCourse(PersonalEnrollParam param) {
        String personTypeCode = param.getPersonTypeCode();
        String[] personArr = personTypeCode.split(",");
        if (StringUtils.isEmpty((CharSequence)personTypeCode)) {
            throw new ServiceException("\u4eba\u5458\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.trainingCourseService.matchCourseByPersonTypeCodeV3_2_2_1(param.getTrainingId(), personArr);
    }

    @Generated
    public LearningOrgServiceImplV3_2_2_1() {
    }
}

