/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.question.entity.PaperStructure;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperStructureProviderService;
import cn.smarthse.radiationTraining.modules.question.vo.PaperStructureVo;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseIndustryProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysOccupationalHazardsProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileVo;
import cn.smarthse.radiationTraining.modules.training.converter.CourseItemConverter;
import cn.smarthse.radiationTraining.modules.training.dao.course.CourseItemMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseGroup;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseGroupItem;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItem;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import cn.smarthse.radiationTraining.modules.training.enums.CourseTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.InudstryAllCodeTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.course.CheckEditPermissionParam;
import cn.smarthse.radiationTraining.modules.training.param.course.ClassHourStatisticsParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemAddIndustryParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemAddPensonParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemAddRiskParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemEditFullInfoParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseItemSingleOptParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CoursePageParam;
import cn.smarthse.radiationTraining.modules.training.param.course.KeyCourseAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.KeyCourseFileParam;
import cn.smarthse.radiationTraining.modules.training.param.course.MatchCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.course.RearrangementParam;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemIndustryService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemPersonTypeService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemRaditaionService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingPersonCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.utils.IndustryTypeUtils;
import cn.smarthse.radiationTraining.modules.training.utils.PersonTypeUtils;
import cn.smarthse.radiationTraining.modules.training.vo.course.ClassHourstatisticsVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemBatchOptVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseQuestionFileVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.MatchResult;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class CourseItemServiceImpl
extends ServiceImpl<CourseItemMapper, CourseItem>
implements ICourseItemService {
    @Resource
    private CourseItemMapper courseItemMapper;
    @DubboReference
    private IPaperStructureProviderService paperStructureProviderService;
    @DubboReference
    private ISysOccupationalHazardsProviderService riskFactorProvider;
    @DubboReference
    private IHseIndustryProviderService hseIndustryProviderService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ICourseItemPersonTypeService courseItemPersonTypeService;
    @Autowired
    private ICourseItemIndustryService courseItemIndustryService;
    @Autowired
    private ICourseItemRaditaionService courseItemRaditaionService;
    @Autowired
    private ICourseGroupService courseGroupService;
    @Autowired
    private ITrainingCourseService trainingCourseService;
    @Autowired
    private ITrainingPersonCertificateService trainingPersonCertificateService;
    @Autowired
    private ICourseGroupItemService courseGroupItemService;
    @Autowired
    private ICourseRedisService courseRedisService;
    @Autowired(required=false)
    private CourseItemConverter courseItemConverter;
    @Autowired
    private OssClientBean ossClientBean;
    public static final int HOUR_MULTIPLE = 100;

    @Override
    public LayuiGridData<CourseItemVo> getPreciseCourseByTid(CoursePageParam param) {
        if (param.getTid() == null) {
            throw new ServiceException("\u57f9\u8badid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<CourseItemVo> courseItemVoList = ((CourseItemMapper)this.baseMapper).getPreciseCourseByTid(param);
        return new LayuiGridData(courseItemVoList);
    }

    @Override
    public List<CourseItem> getCourseItemByGroupId(Long id) {
        List<CourseItem> items = this.courseItemMapper.getCourseItemByGroupId(id);
        return items;
    }

    @Override
    public List<CourseItem> getCourseItemByGroupIdsExNul(List<Long> groupIds) {
        return this.courseItemMapper.getCourseItemByGroupIdsExNul(groupIds);
    }

    @Override
    public void updateStatusByCourseItemId(Long courseItemId, Integer status) {
        this.courseItemMapper.updateStatusByCourseItemId(courseItemId, status);
    }

    @Override
    public List<CourseItemVo> getCourseItemVoByGroupId(Long groupId) {
        return this.courseItemMapper.getCourseItemVoByGroupId(groupId);
    }

    @Override
    public CourseItemVo getVoById(Long courseItemId) {
        return this.courseItemMapper.getVoById(courseItemId);
    }

    @Override
    public List<CourseItemVo> getCourseItemVoByGroupId(Long groupId, Integer state) {
        return this.courseItemMapper.getCourseItemVo(groupId, state);
    }

    @Override
    public List<Long> getCourseItemIdVoByGroupId(Long groupId, Integer state) {
        return this.courseItemMapper.getCourseItemIdVoByGroupId(groupId, state);
    }

    @Override
    public Map<Long, PaperStructure> getCoursePaperStructs(Set<TrainingCourse> inCourseList) {
        if (CollectionUtils.isEmpty(inCourseList)) {
            return null;
        }
        List courseIds = inCourseList.stream().map(TrainingCourse::getCourseId).collect(Collectors.toList());
        List courseItems = ((CourseItemMapper)this.baseMapper).selectByIds(courseIds);
        if (CollectionUtils.isEmpty((Collection)courseItems)) {
            return null;
        }
        List paperStructureIds = courseItems.stream().map(CourseItem::getPaperStructureId).collect(Collectors.toList());
        List structures = this.paperStructureProviderService.selectBatchIds(paperStructureIds);
        Map<Long, PaperStructure> maps = structures.stream().collect(Collectors.toMap(PaperStructure::getId, record -> record));
        HashMap<Long, PaperStructure> resultMap = new HashMap<Long, PaperStructure>();
        courseItems.forEach(item -> resultMap.put(item.getId(), (PaperStructure)maps.get(item.getPaperStructureId())));
        return resultMap;
    }

    @Override
    public CourseItemVo getCourseItemById(Long courseItemId) {
        CourseItemVo courseItemVo = this.courseRedisService.getCourseItemVo(courseItemId);
        if (courseItemVo == null) {
            return null;
        }
        courseItemVo.setVideoUrl(this.sysFileProvideService.getFileUrl(courseItemVo.getVideoId()));
        courseItemVo.setCoverUrl(this.ossClientBean.getUrl(courseItemVo.getCoverUrl()));
        return courseItemVo;
    }

    @Override
    public CourseItemVo getCourseItemByIdFromDB(Long courseItemId) {
        CourseItemVo courseItemVo = this.getVoById(courseItemId);
        if (courseItemVo == null) {
            throw new ServiceException("\u65e0\u8bfe\u7a0b\u4fe1\u606f\uff0c\u8bfe\u7a0bid\uff1a" + courseItemId);
        }
        List<CourseGroupVo> courseGroupVoList = this.courseGroupService.getByItemId(courseItemId);
        courseItemVo.setCourseGroupVoList(courseGroupVoList);
        courseItemVo.setCourseItemRadiationList(this.courseItemRaditaionService.getByCourseItemIdList(Collections.singletonList(courseItemVo.getId())));
        courseItemVo.setCourseItemPersonTypeList(this.courseItemPersonTypeService.getByCourseItemIdList(Collections.singletonList(courseItemVo.getId())));
        courseItemVo.setCourseItemIndustryList(this.courseItemIndustryService.getByCourseItemId(courseItemId));
        return courseItemVo;
    }

    private List<CourseQuestionFileVo> toQuestionFileVo(List<SysFileVo> questionFileList) {
        List<CourseQuestionFileVo> resultList = questionFileList.stream().map(v -> {
            CourseQuestionFileVo qv = new CourseQuestionFileVo();
            qv.setId(v.getId());
            qv.setFileName(v.getFileName());
            qv.setFileExt(v.getFileExt());
            qv.setFileSize(v.getFileSize());
            qv.setFullOssUrl(v.getFullOssUrl());
            return qv;
        }).collect(Collectors.toList());
        return resultList;
    }

    @Transactional
    public void addIndustry(List<CourseItemAddIndustryParam> industryList, Long courseItemId, Long optor) {
        ArrayList<CourseItemIndustry> list = new ArrayList<CourseItemIndustry>();
        for (CourseItemAddIndustryParam param : industryList) {
            if (this.courseItemIndustryService.exist(param.getCode(), courseItemId)) continue;
            list.add(new CourseItemIndustry().setCourseItemId(courseItemId).setCode(param.getCode()).setName(param.getName()).setCreateBy(optor).setIsLeaf(param.getIsLeaf()).setLevel(param.getLeve()).setProgenyNum(this.hseIndustryProviderService.getProgenyNum(param.getCode(), param.getLeve())));
        }
        if (list.size() > 0) {
            this.courseItemIndustryService.saveBatch(list);
        }
        this.courseRedisService.rmCourseItemVo(courseItemId);
    }

    @Override
    @Transactional
    public void addGroup(List<Long> gourpIds, Long courseItemId, Long optor) {
        ArrayList<CourseGroupItem> courseGroupItemList = new ArrayList<CourseGroupItem>();
        for (Long gourpId : gourpIds) {
            if (this.courseGroupItemService.exist(gourpId, courseItemId)) continue;
            CourseGroupItem last = this.courseGroupItemService.getLast((long)gourpId);
            Long sequence = last == null ? 0L : last.getSequence() + 100L;
            courseGroupItemList.add(new CourseGroupItem().setCourseItemId(courseItemId).setCourseGroupId(Long.valueOf(gourpId)).setSequence(sequence).setCreateDate(new Date()).setUpdateDate(new Date()).setCreateBy(optor).setUpdateBy(optor));
        }
        this.courseGroupItemService.saveBatch(courseGroupItemList);
        for (Long gourpId : gourpIds) {
            this.courseGroupService.updateVideoNumberByCourseGroupId((long)gourpId);
        }
        this.courseRedisService.rmCourseItemVo(courseItemId);
    }

    @Override
    @Transactional
    public void addPersonType(List<CourseItemAddPensonParam> personTypeList, Long courseItemId, Long optor) {
        ArrayList<CourseItemPersonType> courseItemPersonTypeList = new ArrayList<CourseItemPersonType>();
        for (CourseItemAddPensonParam param : personTypeList) {
            if (StringUtils.isEmpty((CharSequence)param.getCode()) || this.courseItemPersonTypeService.exist(param.getCode(), courseItemId)) continue;
            courseItemPersonTypeList.add(new CourseItemPersonType().setCode(param.getCode()).setName(TrainingPersonTypeEnum.getNameByValue2((String)param.getCode())).setCourseItemId(courseItemId).setInitialEducationType(param.getInitialEducationType()).setContinuingEducationType(param.getContinuingEducationType()));
        }
        if (courseItemPersonTypeList.size() > 0) {
            this.courseItemPersonTypeService.saveBatch(courseItemPersonTypeList);
        }
        this.courseRedisService.rmCourseItemVo(courseItemId);
    }

    @Override
    @Transactional
    public void addRadiation(List<CourseItemAddRiskParam> radiationFactorList, Long courseItemId, Long optor) {
        ArrayList<CourseItemRadiation> courseItemRadiationList = new ArrayList<CourseItemRadiation>();
        for (CourseItemAddRiskParam param : radiationFactorList) {
            if (this.courseItemRaditaionService.exist(param.getCode(), courseItemId)) continue;
            courseItemRadiationList.add(new CourseItemRadiation().setCourseItemId(courseItemId).setCode(param.getCode()).setName(param.getName()).setLevel(param.getLeve()).setType(param.getType()).setCreateBy(optor).setProgenyNum(Long.valueOf(param.getLeve() != 1 ? 0L : this.riskFactorProvider.getProgenyNum(param.getCode(), param.getLeve()))));
        }
        if (courseItemRadiationList.size() > 0) {
            this.courseItemRaditaionService.saveBatch(courseItemRadiationList);
        }
        this.courseRedisService.rmCourseItemVo(courseItemId);
    }

    @Override
    @Transactional
    public void addCourseItem(CourseItemAddParam param) {
        CourseItemBatchOptVo optVo;
        CourseItem newest;
        if (param.getStatus() == 0L) {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"name"});
        } else {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"name", "description", "videoId", "videoUrl", "paperStructureId", "status"});
        }
        this.checkClassHour(param.getClassHour());
        CourseItem courseItem = this.courseItemConverter.param2CourseItem(param);
        courseItem.setAreaId(param.getAreaId());
        courseItem.setOwner(param.getLoginUserId());
        this.save(courseItem);
        param.setId(courseItem.getId());
        if (param.getPersonTypeList() != null) {
            this.addPersonType(param.getPersonTypeList(), courseItem.getId(), param.getLoginUserId());
        }
        if (param.getRadiationFactorList() != null) {
            this.addRadiation(param.getRadiationFactorList(), courseItem.getId(), param.getLoginUserId());
        }
        if (param.getGroups() != null && param.getGroups().length() > 0) {
            List<Long> gourpIds = Arrays.stream(param.getGroups().split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toList());
            this.addGroup(gourpIds, courseItem.getId(), param.getLoginUserId());
        }
        if (param.getIndustryList() != null) {
            this.addIndustry(param.getIndustryList(), courseItem.getId(), param.getLoginUserId());
        }
        if ((newest = (CourseItem)this.getById(courseItem.getId())).getStatus() == 1L && (optVo = this.ifCanStart(newest.getId())) != null) {
            throw new ServiceException(optVo.getMsg());
        }
    }

    @Override
    @Transactional
    public void addKeyCourse(KeyCourseAddParam param) {
        KeyCourseFileParam videoFileParam = param.getVideoFileParams();
        SysFileModel videoFileModel = this.toSysFileModel(videoFileParam);
        videoFileModel = this.sysFileProvideService.addOnlySysFile(videoFileModel, param.getOptId());
        CourseItemAddParam addParam = new CourseItemAddParam();
        addParam.setName(param.getName());
        addParam.setLecturer(param.getLecturer());
        addParam.setDescription(param.getDescription());
        addParam.setName(param.getName());
        addParam.setCourseType(CourseTypeEnum.GENERAL.getValue());
        addParam.setVideoId(videoFileModel.getId());
        addParam.setVideoUrl(videoFileModel.getOssUrl());
        addParam.setVideoDurationSec(param.getVideoDurationSec());
        addParam.setIsKeyCourse(Integer.valueOf(1));
        addParam.setStatus(Long.valueOf(0L));
        addParam.setPersonTypeList(param.getPersonTypeList());
        this.addKeyCourse(addParam);
    }

    @Transactional
    public void addKeyCourse(CourseItemAddParam param) {
        if (param.getStatus() == 0L) {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"name"});
        }
        CourseItem courseItem = this.courseItemConverter.param2CourseItem(param);
        this.save(courseItem);
        param.setId(courseItem.getId());
        if (param.getPersonTypeList() != null) {
            this.addPersonType(param.getPersonTypeList(), courseItem.getId(), null);
        }
        if (param.getRadiationFactorList() != null) {
            this.addRadiation(param.getRadiationFactorList(), courseItem.getId(), null);
        }
    }

    private List<Long> addFiles(List<SysFileModel> fileList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (SysFileModel sysFileModel : fileList) {
            SysFileModel db = this.sysFileProvideService.addOnlySysFile(sysFileModel, sysFileModel.getOptId());
            idList.add(db.getId());
        }
        return idList;
    }

    private List<SysFileModel> toSysFileModelList(List<KeyCourseFileParam> list) {
        ArrayList<SysFileModel> sysFileModelList = new ArrayList<SysFileModel>();
        for (KeyCourseFileParam fileParam : list) {
            SysFileModel sysFileModel = this.toSysFileModel(fileParam);
            sysFileModelList.add(sysFileModel);
        }
        return sysFileModelList;
    }

    private SysFileModel toSysFileModel(KeyCourseFileParam fileParam) {
        if (StrUtil.isBlank((CharSequence)fileParam.getFileHash())) {
            throw new ServiceException("\u7f3a\u5c11\u6587\u4ef6hash");
        }
        if (StrUtil.isBlank((CharSequence)fileParam.getOssUrl())) {
            throw new ServiceException("\u7f3a\u5c11\u6587\u4ef6url");
        }
        SysFileModel sysFileModel = new SysFileModel();
        sysFileModel.setSourceId(fileParam.getSourceId());
        sysFileModel.setResource(Integer.valueOf(FileResourceEnum.supervise_05.getValue()));
        sysFileModel.setFileName(fileParam.getFileName());
        sysFileModel.setFileSize(fileParam.getFileSize());
        sysFileModel.setFileExt(fileParam.getFileExt());
        sysFileModel.setFileHash(fileParam.getFileHash());
        sysFileModel.setCreatorIp(fileParam.getCreatorIp());
        sysFileModel.setFullOssUrl(fileParam.getFullOssUrl());
        sysFileModel.setOssUrl(fileParam.getOssUrl());
        return sysFileModel;
    }

    @Override
    @Transactional
    public void editFullCourseItemInfo(CourseItemEditFullInfoParam param) {
        CourseItemBatchOptVo optVo;
        CourseItem courseItem;
        if (param.getStatus() != 0L) {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"id", "name", "description", "videoId", "videoUrl", "paperStructureId", "status"});
        } else {
            FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"id", "name"});
        }
        if (this.trainingCourseService.isSelectedInTrain(param.getId()).booleanValue()) {
            throw new ServiceException("\u8bfe\u7a0b\u5df2\u88ab\u57f9\u8bad\u9009\u62e9\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
        }
        CourseItem oldCourseItem = (CourseItem)this.getById(param.getId());
        Long oldPsId = oldCourseItem.getPaperStructureId();
        Long psId = param.getPaperStructureId();
        if (psId != null && !psId.equals(oldPsId)) {
            PaperStructureVo paperStructureVo = this.paperStructureProviderService.getVoById(psId);
            if (paperStructureVo == null || paperStructureVo.getIsSpecial() == null) {
                throw new ServiceException("\u8bd5\u5377\u7ed3\u6784\u6570\u636e\u9519\u8bef\uff0c\u65e0\u6cd5\u7f16\u8f91\u8bfe\u7a0b");
            }
            if (paperStructureVo.getIsSpecial() != 1) {
                throw new ServiceException("\u6240\u9009\u8bd5\u5377\u7ed3\u6784\u65e0\u6cd5\u88ab\u4f7f\u7528\uff0c\u8bf7\u66f4\u6362\u8bd5\u5377\u7ed3\u6784");
            }
        }
        if (oldCourseItem.getStatus() != null && oldCourseItem.getStatus() == 1L && param.getStatus() != null && param.getStatus() != 1L) {
            ArrayList<Long> beforeItemIdList = new ArrayList<Long>();
            beforeItemIdList.add(param.getId());
            this.ifCanDisable(beforeItemIdList, 2);
        }
        if (StrUtil.isNotBlank((CharSequence)(courseItem = this.courseItemConverter.editFullInfoParam2CourseItem(param)).getLecturer()) && StrUtil.contains((CharSequence)courseItem.getLecturer(), (CharSequence)"*")) {
            courseItem.setLecturer(null);
        }
        this.updateById(courseItem);
        if (!StringUtils.isEmpty((CharSequence)param.getGroups())) {
            List<Long> groupIdList = Arrays.stream(param.getGroups().split(",")).map(Long::parseLong).collect(Collectors.toList());
            this.editGroup(groupIdList, courseItem.getId(), param.getLoginUserId());
        } else {
            this.editGroup(new ArrayList<Long>(), courseItem.getId(), param.getLoginUserId());
        }
        this.editPerson(param.getPersonTypeList(), param.getId(), param.getLoginUserId());
        this.editRadiationFactor(param.getRadiationFactorList(), param.getId(), param.getLoginUserId());
        this.editIndustry(param.getIndustryList(), param.getId(), param.getLoginUserId());
        CourseItem newest = (CourseItem)this.getById(courseItem.getId());
        if (newest.getStatus() == 1L && (optVo = this.ifCanStart(newest.getId())) != null) {
            throw new ServiceException(optVo.getMsg());
        }
        this.courseRedisService.rmCourseItemVo(param.getId());
    }

    @Transactional
    public void editRadiationFactor(List<CourseItemAddRiskParam> radiationFactorList, Long courseItemId, Long optor) {
        this.courseItemRaditaionService.deleteByCourseItemId(courseItemId);
        if (CollectionUtils.isEmpty(radiationFactorList)) {
            return;
        }
        this.addRadiation(radiationFactorList, courseItemId, optor);
    }

    @Transactional
    public void editPerson(List<CourseItemAddPensonParam> personTypeList, Long courseItemId, Long optor) {
        this.courseItemPersonTypeService.deleteByCourseItemId(courseItemId);
        if (CollectionUtils.isEmpty(personTypeList)) {
            return;
        }
        this.addPersonType(personTypeList, courseItemId, optor);
    }

    @Transactional
    public void editGroup(List<Long> groupIdList, Long courseItemId, Long optor) {
        this.courseGroupItemService.deleteByCourseItemId(courseItemId);
        if (CollectionUtils.isEmpty(groupIdList)) {
            for (Long gourpId : groupIdList) {
                this.courseGroupService.updateVideoNumberByCourseGroupId((long)gourpId);
            }
            return;
        }
        this.addGroup(groupIdList, courseItemId, optor);
    }

    @Transactional
    public void editIndustry(List<CourseItemAddIndustryParam> paramList, Long courseItemId, Long optor) {
        this.courseItemIndustryService.removeByCourseItemId(courseItemId);
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        this.addIndustry(paramList, courseItemId, optor);
    }

    @Override
    @Transactional
    public void delete(Long courseItemId) {
        if (courseItemId == null) {
            return;
        }
        if (this.trainingCourseService.isSelectedInTrain(courseItemId).booleanValue()) {
            throw new ServiceException("\u8bfe\u7a0b\u5df2\u88ab\u57f9\u8bad\u9009\u62e9\uff0c\u4e0d\u53ef\u4fee\u6539\uff01");
        }
        CourseItem oldCourseItem = (CourseItem)this.getById(courseItemId);
        if (oldCourseItem.getStatus() != null && oldCourseItem.getStatus() == 1L) {
            ArrayList<Long> beforeItemIdList = new ArrayList<Long>();
            beforeItemIdList.add(courseItemId);
            this.ifCanDisable(beforeItemIdList, 2);
        }
        this.courseGroupItemService.deleteByCourseItemId(courseItemId);
        this.courseItemPersonTypeService.deleteByCourseItemId(courseItemId);
        this.courseItemRaditaionService.deleteByCourseItemId(courseItemId);
        this.courseItemIndustryService.removeByCourseItemId(courseItemId);
        this.removeById(courseItemId);
        this.courseGroupService.updateVideoNumberByCourseItemId(courseItemId);
        this.courseRedisService.rmCourseItemVo(courseItemId);
    }

    @Override
    @Transactional
    public void rearrangement(List<RearrangementParam> paramList) {
        Long courseGroupId;
        Long courseItemId;
        List newInfo = paramList.stream().filter(v -> v.isIfNew()).collect(Collectors.toList());
        for (RearrangementParam param : newInfo) {
            courseItemId = param.getCourseItemId();
            courseGroupId = param.getCourseGroupId();
            this.addGroup(Collections.singletonList(courseGroupId), courseItemId, param.getLoginUserId());
            this.courseRedisService.rmCourseItemVo(courseItemId);
        }
        for (int i = 0; i < paramList.size(); ++i) {
            RearrangementParam param;
            param = paramList.get(i);
            courseItemId = param.getCourseItemId();
            courseGroupId = param.getCourseGroupId();
            this.courseGroupItemService.updateSequence(courseGroupId, courseItemId, (long)i * 100L);
        }
        if (paramList.size() > 0) {
            Long courseGroupId2 = paramList.get(0).getCourseGroupId();
            this.courseGroupService.updateVideoNumberByCourseGroupId(courseGroupId2);
        }
    }

    @Override
    @Transactional
    public List<CourseItemBatchOptVo> batchOpt(List<CourseItemSingleOptParam> paramList) {
        ArrayList<CourseItemBatchOptVo> errVoList = new ArrayList<CourseItemBatchOptVo>();
        List optList = paramList.stream().filter(v -> this.trainingCourseService.isSelectedInTrain(v.getCourseItemId()) == false && (v.getStatus() != 0 || v.getType() == 3)).collect(Collectors.toList());
        List cantOptList02 = paramList.stream().filter(v -> v.getStatus() == 0 && v.getType() != 3).collect(Collectors.toList());
        Map<Integer, List<CourseItemSingleOptParam>> optTypeMap = optList.stream().collect(Collectors.groupingBy(v -> v.getType()));
        optTypeMap.forEach((k, list) -> {
            block5: {
                block6: {
                    block4: {
                        if (k != 1) break block4;
                        for (CourseItemSingleOptParam v2 : list) {
                            CourseItemBatchOptVo vo = this.ifCanStart(v2.getCourseItemId());
                            if (vo != null) {
                                errVoList.add(vo);
                                continue;
                            }
                            this.updateStatusByCourseItemId(v2.getCourseItemId(), 1);
                            this.courseGroupService.updateVideoNumberByCourseItemId(v2.getCourseItemId());
                            this.courseRedisService.rmCourseItemVo(v2.getCourseItemId());
                        }
                        break block5;
                    }
                    if (k != 2) break block6;
                    List<Long> courseList = list.stream().map(v -> v.getCourseItemId()).collect(Collectors.toList());
                    this.ifCanDisable(courseList, 2);
                    for (CourseItemSingleOptParam v3 : list) {
                        this.updateStatusByCourseItemId(v3.getCourseItemId(), 2);
                        this.courseGroupService.updateVideoNumberByCourseItemId(v3.getCourseItemId());
                        this.courseRedisService.rmCourseItemVo(v3.getCourseItemId());
                    }
                    break block5;
                }
                if (k != 3) break block5;
                List<Long> courseList = list.stream().map(v -> v.getCourseItemId()).collect(Collectors.toList());
                this.ifCanDisable(courseList, 2);
                for (CourseItemSingleOptParam v4 : list) {
                    this.delete(v4.getCourseItemId());
                    this.courseGroupService.updateVideoNumberByCourseItemId(v4.getCourseItemId());
                    this.courseRedisService.rmCourseItemVo(v4.getCourseItemId());
                }
            }
        });
        for (CourseItemSingleOptParam param : cantOptList02) {
            CourseItem courseItem = (CourseItem)this.getById(param.getCourseItemId());
            CourseItemBatchOptVo optVo = new CourseItemBatchOptVo();
            optVo.setCourseId(param.getCourseItemId());
            optVo.setCourseName(courseItem.getName());
            optVo.setMsg("\u4e3a\u8349\u7a3f\u65e0\u6cd5\u542f\u7528\u7981\u7528");
            errVoList.add(optVo);
        }
        return errVoList;
    }

    private CourseItemBatchOptVo ifCanStart(Long courseItemId) {
        boolean checkResult;
        StringBuilder sb = new StringBuilder();
        CourseItem courseItem = (CourseItem)this.getById(courseItemId);
        List<Long> groupIdList = this.getActivatedGroupIds(courseItemId);
        List<String> ptList = this.getPersonType(courseItemId);
        List<String> industryList = this.getIndustry(courseItemId);
        if (CourseTypeEnum.SPECIAL.getValue().equals(courseItem.getCourseType()) && !(checkResult = PersonTypeUtils.checkPtAndIndustry(ptList, industryList))) {
            sb.append("\u4eba\u5458\u7c7b\u578b\u4e0e\u884c\u4e1a\u4e0d\u5339\u914d\u3002");
        }
        for (Long groupId : groupIdList) {
            CourseGroup group = (CourseGroup)this.courseGroupService.getById(groupId);
            if (group.getStatus() != 1) continue;
            List<String> coursePT = this.getPersonType(courseItemId);
            boolean b = PersonTypeUtils.checkTTTypeAndPT((String)group.getTrainingTargetType(), coursePT);
            if (b) continue;
            sb.append("\u4e0e\u8bfe\u7a0b\u7ec4\uff08").append(group.getName()).append("\uff09\u4e0d\u5339\u914d");
        }
        if (StringUtils.isEmpty((CharSequence)courseItem.getVideoUrl()) || courseItem.getVideoDurationSec() == null) {
            sb.append("\u7f3a\u5c11\u89c6\u9891\u6570\u636e\uff0c\u65e0\u6cd5\u542f\u7528\u3002");
        }
        if (sb.length() > 0) {
            CourseItemBatchOptVo optVo = new CourseItemBatchOptVo();
            optVo.setCourseId(courseItem.getId());
            optVo.setCourseName(courseItem.getName());
            optVo.setMsg(sb.toString());
            return optVo;
        }
        return null;
    }

    @Override
    public LayuiGridData<CourseItemVo> searchByKeyword(CoursePageParam param) {
        List industryCodeList = param.getIndustryCodeList();
        boolean containMedicalIndustry = IndustryTypeUtils.containMedicalIndustry((List)industryCodeList);
        boolean containNonMedicalIndustry = IndustryTypeUtils.containNonMedicalIndustry((List)industryCodeList);
        boolean containAllMedicalIndustry = CollUtil.contains((Collection)industryCodeList, (Object)InudstryAllCodeTypeEnum.ALL_MEDICAL.getValue());
        boolean containAllNonMedicalIndustry = CollUtil.contains((Collection)industryCodeList, (Object)InudstryAllCodeTypeEnum.ALL_NON_MEDICAL.getValue());
        param.setContainMedicalIndustry(Boolean.valueOf(containMedicalIndustry));
        param.setContainNonMedicalIndustry(Boolean.valueOf(containNonMedicalIndustry));
        param.setContainAllMedicalIndustry(Boolean.valueOf(containAllMedicalIndustry));
        param.setContainAllNonMedicalIndustry(Boolean.valueOf(containAllNonMedicalIndustry));
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CourseItemVo> courseItemVoList = ((CourseItemMapper)this.baseMapper).searchByKeyword(param);
        ArrayList<CourseItemVo> courseItemVoListRes = new ArrayList<CourseItemVo>();
        for (CourseItemVo temp : courseItemVoList) {
            courseItemVoListRes.add(this.getCourseItemById(temp.getId()));
        }
        courseItemVoList.clear();
        courseItemVoList.addAll(courseItemVoListRes);
        return new LayuiGridData((Page)courseItemVoList, (LayuiGridParam)param);
    }

    @Override
    public List<CourseItemVo> matchCourseItem(MatchCourseParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"preciseClassHour", "generalClassHour"});
        double lackClassHour = param.getPreciseClassHour();
        ArrayList<MatchResult> matchResultTotal = new ArrayList<MatchResult>();
        ArrayList<MatchResult> threeDimensionMatchResultList = new ArrayList();
        ArrayList<MatchResult> doubleDimensionMatchResultList = new ArrayList();
        ArrayList<MatchResult> randomMajorCourseList = new ArrayList();
        param.setSize(Integer.valueOf((int)Math.ceil(lackClassHour) * 100));
        threeDimensionMatchResultList = ((CourseItemMapper)this.baseMapper).matchThreeDimension(param);
        this.dealMatchRes(threeDimensionMatchResultList, lackClassHour);
        double threeDimensionClassHourTotal = threeDimensionMatchResultList.stream().mapToDouble(MatchResult::getClassHour).sum();
        if (threeDimensionClassHourTotal >= lackClassHour) {
            lackClassHour = 0.0;
        } else {
            param.setSize(Integer.valueOf((int)Math.ceil(lackClassHour -= threeDimensionClassHourTotal) * 100));
            List excludeCourseItemIdList = threeDimensionMatchResultList.stream().map(MatchResult::getCourseItemId).collect(Collectors.toList());
            param.setExcludeCourseItemIdList(excludeCourseItemIdList);
            doubleDimensionMatchResultList = ((CourseItemMapper)this.baseMapper).matchDoubleDimension(param);
            this.dealMatchRes(doubleDimensionMatchResultList, lackClassHour);
            double doubleDimensionClassHourTotal = doubleDimensionMatchResultList.stream().mapToDouble(MatchResult::getClassHour).sum();
            lackClassHour = doubleDimensionClassHourTotal >= lackClassHour ? 0.0 : (lackClassHour -= doubleDimensionClassHourTotal);
        }
        randomMajorCourseList = ((CourseItemMapper)this.baseMapper).randomAccessGeneralCourse((int)Math.ceil(lackClassHour += param.getGeneralClassHour().doubleValue()) * 100);
        this.dealMatchRes(randomMajorCourseList, lackClassHour);
        double randomClassHour = randomMajorCourseList.stream().mapToDouble(MatchResult::getClassHour).sum();
        if (randomClassHour < lackClassHour) {
            throw new ServiceException("\u62b1\u6b49\uff0c\u6240\u5339\u914d\u7684\u8bfe\u7a0b\u603b\u5b66\u65f6\u65e0\u6cd5\u6ee1\u8db3\u57f9\u8bad\u8981\u6c42\uff0c\u62a5\u540d\u5931\u8d25");
        }
        ArrayList<CourseItemVo> voList = new ArrayList<CourseItemVo>();
        matchResultTotal.addAll(threeDimensionMatchResultList);
        matchResultTotal.addAll(doubleDimensionMatchResultList);
        matchResultTotal.addAll(randomMajorCourseList);
        for (MatchResult matchResult : matchResultTotal) {
            voList.add(this.getCourseItemById(matchResult.getCourseItemId()));
        }
        return voList;
    }

    @Override
    public List<CourseItemVo> matchCourseItemV3_2_2_1(MatchCourseParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"personCodeList"});
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTid());
        List personCertificateList = trainingInfo.getPersonCertificateList();
        List personCodeList = param.getPersonCodeList();
        ArrayList<TrainingPersonCertificate> matchPersonList = new ArrayList<TrainingPersonCertificate>();
        for (TrainingPersonCertificate tpc : personCertificateList) {
            if (!personCodeList.contains(String.valueOf(tpc.getPersonType()))) continue;
            matchPersonList.add(tpc);
        }
        if (CollectionUtils.isEmpty(matchPersonList)) {
            throw new ServiceException("\u65e0\u4eba\u5458\u7c7b\u578b\uff0c\u62a5\u540d\u5931\u8d25");
        }
        ArrayList<CourseItemVo> result = new ArrayList<CourseItemVo>();
        for (TrainingPersonCertificate tpc : matchPersonList) {
            MatchCourseParam temp = new MatchCourseParam();
            Double generalClassHour = tpc.getGeneralClassHour();
            Double targetClassHour = tpc.getTargetClassHour();
            temp.setGeneralClassHour(generalClassHour);
            temp.setPreciseClassHour(Double.valueOf(targetClassHour - generalClassHour));
            temp.setTrainType(TrainingTypeEnum.getValueByValue2((String)trainingInfo.getTrainType()));
            temp.setPersonType(String.valueOf(tpc.getPersonType()));
            temp.setIndustryCodeList(param.getIndustryCodeList());
            temp.setAreaId(param.getAreaId());
            temp.setRiskCodeList(param.getRiskCodeList());
            List<CourseItemVo> itemVos = this.matchCourseItemByOnePersonTypeV3_2_2_1(temp);
            result.addAll(itemVos);
        }
        return this.dealMatchResult(result);
    }

    public List<CourseItemVo> matchCourseItemByOnePersonTypeV3_2_2_1(MatchCourseParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"preciseClassHour", "generalClassHour", "trainType", "personType"});
        if (param.getTrainType() != 0 && param.getTrainType() != 1) {
            throw new ServiceException("\u57f9\u8bad\u7c7b\u578b\u9519\u8bef");
        }
        Double personalizedHour = param.getPreciseClassHour();
        Double commonHour = param.getGeneralClassHour();
        Double lackHour = 0.0;
        ArrayList<MatchResult> resultTotal = new ArrayList<MatchResult>();
        ArrayList<MatchResult> personalizedResult = new ArrayList();
        ArrayList<MatchResult> commonResult = new ArrayList();
        param.setSize(Integer.valueOf((int)Math.ceil(personalizedHour) * 100));
        personalizedResult = ((CourseItemMapper)this.baseMapper).matchPersonalizedCourseItem(param);
        this.dealMatchRes(personalizedResult, personalizedHour);
        Double personalizedResultTotalHour = personalizedResult.stream().mapToDouble(MatchResult::getClassHour).sum();
        if (personalizedResultTotalHour < personalizedHour) {
            lackHour = personalizedHour - personalizedResultTotalHour;
        }
        param.setSize(Integer.valueOf((int)Math.ceil(commonHour + lackHour) * 100));
        commonResult = ((CourseItemMapper)this.baseMapper).matchCommonCoursesItem(param);
        this.dealMatchRes(commonResult, commonHour + lackHour);
        Double commonResultTotalHour = commonResult.stream().mapToDouble(MatchResult::getClassHour).sum();
        if (commonResultTotalHour < commonHour + lackHour) {
            throw new ServiceException("\u6240\u5339\u914d\u5230\u7684\u8bfe\u7a0b\u603b\u8bfe\u65f6\u603b\u6570\u4e0d\u8db3\uff0c\u62a5\u540d\u5931\u8d25");
        }
        resultTotal.addAll(personalizedResult);
        resultTotal.addAll(commonResult);
        ArrayList<CourseItemVo> voList = new ArrayList<CourseItemVo>();
        for (MatchResult matchResult : resultTotal) {
            voList.add(this.getCourseItemById(matchResult.getCourseItemId()));
        }
        return voList;
    }

    public List<CourseItemVo> dealMatchResult(List<CourseItemVo> courseItemVoList) {
        return courseItemVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CourseItemVo>(Comparator.comparing(CourseItemVo::getId))), ArrayList::new));
    }

    void dealMatchRes(List<MatchResult> result, double lackClassHour) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        double temp = 0.0;
        ArrayList<MatchResult> resultTemp = new ArrayList<MatchResult>();
        for (MatchResult matchResult : result) {
            temp += matchResult.getClassHour().doubleValue();
            resultTemp.add(matchResult);
            if (!(temp >= lackClassHour)) continue;
            break;
        }
        result.clear();
        result.addAll(resultTemp);
    }

    @Override
    public ClassHourstatisticsVo countClassHoursV1(ClassHourStatisticsParam param) {
        return ((CourseItemMapper)this.baseMapper).countClassHours(param);
    }

    @Override
    public ClassHourstatisticsVo countOnePersonPreciseClassHoursV3_2_2_1(ClassHourStatisticsParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"personType"});
        return ((CourseItemMapper)this.baseMapper).countClassHoursV3_2_2_1(param);
    }

    @Override
    public List<ClassHourstatisticsVo> countClassPreciseHoursV3_2_2_1(ClassHourStatisticsParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"personTypeList"});
        ArrayList<ClassHourstatisticsVo> result = new ArrayList<ClassHourstatisticsVo>();
        for (String personType : param.getPersonTypeList()) {
            param.setPersonType(personType);
            ClassHourstatisticsVo classHourstatisticsVo = this.countOnePersonPreciseClassHoursV3_2_2_1(param);
            if (classHourstatisticsVo == null) {
                classHourstatisticsVo = new ClassHourstatisticsVo();
                classHourstatisticsVo.setPersonType(personType).setFirstcommonClassHour1(Double.valueOf(0.0)).setFirstTotalClassHour1(Double.valueOf(0.0)).setSecondTotalClassHour2(Double.valueOf(0.0)).setSecondCommonClassHour2(Double.valueOf(0.0));
            }
            classHourstatisticsVo.setPersonType(personType);
            result.add(classHourstatisticsVo);
        }
        return result;
    }

    @Override
    public boolean isSelectedInCourseItem(Long paperStructureId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(CourseItem::getPaperStructureId, (Object)paperStructureId);
        List courseItemList = ((CourseItemMapper)this.baseMapper).selectList((Wrapper)wrapper);
        return !CollectionUtils.isEmpty((Collection)courseItemList);
    }

    @Override
    public void checkOneEditPermission(CheckEditPermissionParam param) {
        Long uid = param.getUid();
        String uname = param.getUname();
        Integer userFrom = param.getUserFrom();
        Integer userOptRole = param.getUserOptRole();
        Long itemId = param.getItemId();
        Long areaId = param.getAreaId();
        CourseItem item = (CourseItem)this.getById(itemId);
        if (!(item.getPermissionType() == null || item.getPermissionType() != 1 || item.getAreaId() != null && item.getAreaId().equals(areaId))) {
            throw new ServiceException("\u65e0\u6743\u7f16\u8f91\u5176\u4ed6\u533a\u57df\u4e13\u7528\u8bfe\u7a0b\u300a" + item.getName() + "\u300b");
        }
        if (AccountUtil.isSpecifiedUserName((String)uname)) {
            return;
        }
        if (this.ifCanEditPermission(uid, item)) {
            return;
        }
        throw new ServiceException("\u65e0\u6743\u7f16\u8f91\u300a" + item.getName() + "\u300b");
    }

    @Override
    public void checkBatchEditPermission(CheckEditPermissionParam param) {
        Long uid = param.getUid();
        String uname = param.getUname();
        Integer userFrom = param.getUserFrom();
        Integer userOptRole = param.getUserOptRole();
        List itemIdList = param.getItemIdList();
        Long areaId = param.getAreaId();
        List courseItemList = this.listByIds(itemIdList);
        if (CollectionUtil.isEmpty((Collection)itemIdList)) {
            return;
        }
        ArrayList<CourseItemBatchOptVo> resultVo = new ArrayList<CourseItemBatchOptVo>();
        List privateCourseList = courseItemList.stream().filter(v -> v.getPermissionType() != null && v.getPermissionType() == 1 && (v.getAreaId() == null || !v.getAreaId().equals(areaId))).collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(privateCourseList)) {
            for (CourseItem item2 : privateCourseList) {
                CourseItemBatchOptVo optVo = new CourseItemBatchOptVo();
                optVo.setCourseId(item2.getId());
                optVo.setCourseName(item2.getName());
                optVo.setMsg("\u4e3a\u5176\u4ed6\u533a\u57df\u4e13\u7528\u8bfe\u7a0b\uff0c\u65e0\u6743\u7f16\u8f91");
                resultVo.add(optVo);
            }
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u6743\u9650\u4e0d\u8db3", resultVo);
        }
        if (AccountUtil.isSpecifiedUserName((String)uname)) {
            return;
        }
        courseItemList.forEach(item -> {
            if (!this.ifCanEditPermission(uid, (CourseItem)item)) {
                CourseItemBatchOptVo optVo = new CourseItemBatchOptVo();
                optVo.setCourseId(item.getId());
                optVo.setCourseName(item.getName());
                optVo.setMsg("\u65e0\u6743\u7f16\u8f91\u8be5\u8bfe\u7a0b");
                resultVo.add(optVo);
            }
        });
        if (!CollectionUtils.isEmpty(resultVo)) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u6743\u9650\u4e0d\u8db3", resultVo);
        }
    }

    public void ifCanDisable(List<Long> courseIdList, Integer status) {
        if (status == null || status == 1) {
            return;
        }
        List list = this.listByIds(courseIdList);
        if (CollectionUtil.isEmpty(list = list.stream().filter(v -> v.getStatus() == 1L).collect(Collectors.toList()))) {
            return;
        }
        List<Long> beforeList = list.stream().map(v -> v.getId()).collect(Collectors.toList());
        this.ifCanDisablePreciseV1(beforeList, null);
        this.ifCanDisablePreciseV3_2_2_1(beforeList, null);
    }

    @Override
    public void ifCanDisablePreciseV1(List<Long> beforeCourseIdList, List<Long> afterCourseIdList) {
        if (CollectionUtil.isEmpty(beforeCourseIdList) && CollectionUtil.isEmpty(afterCourseIdList)) {
            return;
        }
        if (CollectionUtil.isEmpty(beforeCourseIdList)) {
            return;
        }
        if (CollectionUtil.isEmpty(afterCourseIdList)) {
            afterCourseIdList = new ArrayList<Long>();
            afterCourseIdList.add(123321887994L);
        }
        ClassHourstatisticsVo beforeItemHour = this.countClassHoursV1(new ClassHourStatisticsParam().setCourseItemIdList(beforeCourseIdList));
        ClassHourstatisticsVo afterItemHour = this.countClassHoursV1(new ClassHourStatisticsParam().setCourseItemIdList(afterCourseIdList));
        ClassHourstatisticsVo totalItemHour = this.countClassHoursV1(new ClassHourStatisticsParam());
        ClassHourstatisticsVo trainHour = this.trainingPersonCertificateService.getMaxClassHourVoV1();
        double diffGeneral = beforeItemHour.getGeneral() - afterItemHour.getGeneral();
        double diffTotal = beforeItemHour.getTotal() - afterItemHour.getTotal();
        if (trainHour.getGeneral() > totalItemHour.getGeneral() - diffGeneral && diffGeneral > 0.0) {
            throw new ServiceException("\u82e5\u7981\u7528\u8bfe\u7a0b\uff0c\u5171\u6027\u8bfe\u7a0b\u8bfe\u65f6\u5c06\u4e0d\u8db3");
        }
        if (trainHour.getTotal() > totalItemHour.getTotal() - diffTotal && diffTotal > 0.0) {
            throw new ServiceException("\u82e5\u7981\u7528\u8bfe\u7a0b\uff0c\u8bfe\u7a0b\u8bfe\u65f6\u5c06\u4e0d\u8db3");
        }
    }

    @Override
    public void ifCanDisablePreciseV3_2_2_1(List<Long> beforeCourseIdList, List<Long> afterCourseIdList) {
        if (CollectionUtil.isEmpty(beforeCourseIdList) && CollectionUtil.isEmpty(afterCourseIdList)) {
            return;
        }
        if (CollectionUtil.isEmpty(beforeCourseIdList)) {
            return;
        }
        if (CollectionUtil.isEmpty(afterCourseIdList)) {
            afterCourseIdList = new ArrayList<Long>();
            afterCourseIdList.add(123321887994L);
        }
        ArrayList<String> personList = new ArrayList<String>();
        personList.add(TrainingPersonTypeEnum.MAIN_IN_CHARGE.getValue());
        personList.add(TrainingPersonTypeEnum.HEALTH_ADMIN.getValue());
        ClassHourStatisticsParam param = new ClassHourStatisticsParam().setPersonTypeList(personList);
        List<ClassHourstatisticsVo> totalHours = this.countClassPreciseHoursV3_2_2_1(param.setCourseItemIdList(null));
        List<ClassHourstatisticsVo> beforeItemHours = this.countClassPreciseHoursV3_2_2_1(param.setCourseItemIdList(beforeCourseIdList));
        List<ClassHourstatisticsVo> afterItemHours = this.countClassPreciseHoursV3_2_2_1(param.setCourseItemIdList(afterCourseIdList));
        List<ClassHourstatisticsVo> trainHours = this.trainingPersonCertificateService.getMaxClassPreciseHourVoV3_2_2_1();
        Map<String, ClassHourstatisticsVo> totalHoursMap = totalHours.stream().collect(Collectors.toMap(v -> v.getPersonType(), v -> v));
        Map<String, ClassHourstatisticsVo> beforeItemHoursMap = beforeItemHours.stream().collect(Collectors.toMap(v -> v.getPersonType(), v -> v));
        Map<String, ClassHourstatisticsVo> afterItemHoursMap = afterItemHours.stream().collect(Collectors.toMap(v -> v.getPersonType(), v -> v));
        for (ClassHourstatisticsVo trainHour : trainHours) {
            boolean secondTotalClassHourLTE0;
            ClassHourstatisticsVo totalHour = totalHoursMap.get(trainHour.getPersonType());
            ClassHourstatisticsVo beforeItemHourVo = beforeItemHoursMap.get(trainHour.getPersonType());
            ClassHourstatisticsVo afterItemHourVo = afterItemHoursMap.get(trainHour.getPersonType());
            double diffFirstCommonClassHour = totalHour.getFirstcommonClassHour1() - (beforeItemHourVo.getFirstcommonClassHour1() - afterItemHourVo.getFirstcommonClassHour1());
            double diffSecondCommonClassHour = totalHour.getSecondCommonClassHour2() - (beforeItemHourVo.getSecondCommonClassHour2() - afterItemHourVo.getSecondCommonClassHour2());
            double diffFirstTotalClassHour = totalHour.getFirstTotalClassHour1() - (beforeItemHourVo.getFirstTotalClassHour1() - afterItemHourVo.getFirstTotalClassHour1());
            double diffSecondTotalClassHour = totalHour.getSecondTotalClassHour2() - (beforeItemHourVo.getSecondTotalClassHour2() - afterItemHourVo.getSecondTotalClassHour2());
            boolean firstCommonClassHourLTE0 = beforeItemHourVo.getFirstcommonClassHour1() - afterItemHourVo.getFirstcommonClassHour1() <= 0.0;
            boolean secondCommonClassHourLTE0 = beforeItemHourVo.getSecondCommonClassHour2() - afterItemHourVo.getSecondCommonClassHour2() <= 0.0;
            boolean firstTotalClassHourLTE0 = beforeItemHourVo.getFirstTotalClassHour1() - afterItemHourVo.getFirstTotalClassHour1() <= 0.0;
            boolean bl = secondTotalClassHourLTE0 = beforeItemHourVo.getSecondTotalClassHour2() - afterItemHourVo.getSecondTotalClassHour2() <= 0.0;
            if (trainHour.getFirstcommonClassHour1() > diffFirstCommonClassHour && !firstCommonClassHourLTE0) {
                throw new ServiceException("\u82e5\u7981\u7528\u8bfe\u7a0b\uff0c\u521d\u6b21\u6559\u80b2\u5171\u6027\u8bfe\u7a0b\u8bfe\u65f6\u5c06\u4e0d\u8db3");
            }
            if (trainHour.getFirstTotalClassHour1() > diffFirstTotalClassHour && !secondCommonClassHourLTE0) {
                throw new ServiceException("\u82e5\u7981\u7528\u8bfe\u7a0b\uff0c\u521d\u6b21\u6559\u80b2\u8bfe\u7a0b\u8bfe\u65f6\u5c06\u4e0d\u8db3");
            }
            if (trainHour.getSecondCommonClassHour2() > diffSecondCommonClassHour && !firstTotalClassHourLTE0) {
                throw new ServiceException("\u82e5\u7981\u7528\u8bfe\u7a0b\uff0c\u7ee7\u7eed\u6559\u80b2\u5171\u6027\u8bfe\u7a0b\u8bfe\u65f6\u5c06\u4e0d\u8db3");
            }
            if (!(trainHour.getSecondTotalClassHour2() > diffSecondTotalClassHour) || secondTotalClassHourLTE0) continue;
            throw new ServiceException("\u82e5\u7981\u7528\u8bfe\u7a0b\uff0c\u7ee7\u7eed\u6559\u80b2\u8bfe\u7a0b\u8bfe\u65f6\u5c06\u4e0d\u8db3");
        }
    }

    @Override
    public List<Long> getActivatedGroupIds(Long courseItemId) {
        return ((CourseItemMapper)this.baseMapper).getActivatedGroupIds(courseItemId);
    }

    @Override
    public List<String> getPersonType(Long courseItemId) {
        return ((CourseItemMapper)this.baseMapper).getPersonType(courseItemId);
    }

    @Override
    public List<String> getIndustry(Long courseItemId) {
        return ((CourseItemMapper)this.baseMapper).getIndustry(courseItemId);
    }

    public boolean ifCanEditPermission(Long uid, CourseItem item) {
        return uid.equals(item.getCreateBy());
    }

    private void checkClassHour(Double classHour) {
        if (classHour == null) {
            return;
        }
        if (classHour - Math.ceil(classHour) > 0.0) {
            throw new ServiceException("\u8bfe\u65f6\u6570\u9700\u4e3a\u6574\u6570");
        }
    }
}

