/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.training.dao.course.CourseGroupMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseGroup;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseGroupItem;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItem;
import cn.smarthse.radiationTraining.modules.training.enums.GroupTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.CheckEditPermissionParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupEditParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupSingleOptParam;
import cn.smarthse.radiationTraining.modules.training.param.course.DefaultCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupAddItemsParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupPageParam;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingPersonCertificateService;
import cn.smarthse.radiationTraining.modules.training.utils.PersonTypeUtils;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupBatchOptVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.GroupWarningVo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CourseGroupServiceImpl
extends ServiceImpl<CourseGroupMapper, CourseGroup>
implements ICourseGroupService {
    @Resource
    private CourseGroupMapper courseGroupMapper;
    @Autowired
    private ICourseGroupItemService courseGroupItemService;
    @Autowired
    private ITrainingCourseGroupService trainingCourseGroupService;
    @Autowired
    private ICourseItemService courseItemService;
    @Autowired
    private ITrainingPersonCertificateService trainingPersonCertificateService;
    @Autowired
    private ICourseRedisService courseRedisService;

    @Override
    @Transactional
    public void updateVideoNumberByCourseGroupId(Long courseGroupId) {
        this.courseGroupMapper.updateVideoNumber(courseGroupId);
    }

    @Override
    @Transactional
    public void updateVideoNumberByCourseGroupIdList(List<Long> courseGroupIdList) {
        if (courseGroupIdList == null || courseGroupIdList.size() == 0) {
            return;
        }
        courseGroupIdList.forEach(v -> this.updateVideoNumberByCourseGroupId((Long)v));
    }

    @Override
    @Transactional
    public void updateVideoNumberByCourseItemId(Long courseItemId) {
        List<Long> courseGroupIds = this.courseGroupItemService.getCourseGroupIdsByCourseItemId(courseItemId);
        for (Long courseGroupId : courseGroupIds) {
            this.updateVideoNumberByCourseGroupId(courseGroupId);
        }
    }

    @Override
    @Transactional
    public void updateVideoNumberByCourseItemIds(List<Long> ids) {
        for (Long id : ids) {
            this.updateVideoNumberByCourseItemId(id);
        }
    }

    @Override
    public List<CourseGroupVo> searchByKeyword(GroupPageParam param) {
        return this.courseGroupMapper.searchByKeyword(param);
    }

    @Override
    @Transactional
    public void changeStatusById(Long id, Long status) {
        this.courseGroupMapper.changeStatusById(id, status);
    }

    @Override
    public List<CourseWorkTypeVo> getWorkTypeByCourseGroupId(Long id) {
        return this.courseGroupMapper.getWorkTypeByCourseGroupId(id);
    }

    @Override
    @Transactional
    public void updateVideoNumberByCourseGroupIds(List<Long> ids) {
        for (Long id : ids) {
            this.updateVideoNumberByCourseGroupId(id);
        }
    }

    @Override
    public List<CourseGroupVo> getByItemId(Long courseItemId) {
        return ((CourseGroupMapper)this.baseMapper).getByItemId(courseItemId);
    }

    @Override
    public List<CourseGroupVo> getGroupByItemId(Long courseItemId) {
        return ((CourseGroupMapper)this.baseMapper).getGroupByItemId(courseItemId);
    }

    @Override
    public List<CourseGroupVo> getIdsAndNamesByKeyword(String keyword) {
        return ((CourseGroupMapper)this.baseMapper).getIdsAndNamesByKeyword(keyword);
    }

    @Override
    public List<GroupWarningVo> ifCanStartGroupDetail(Long groupId) {
        ArrayList<GroupWarningVo> resultList = new ArrayList<GroupWarningVo>();
        CourseGroup group = (CourseGroup)this.getById(groupId);
        if (CollUtil.isNotEmpty(resultList)) {
            return resultList;
        }
        List<Long> courseIdList = this.getActivatedCourseIdList(group.getId());
        for (Long courseId : courseIdList) {
            CourseItem course = (CourseItem)this.courseItemService.getById(courseId);
            List<String> personType = this.courseItemService.getPersonType(course.getId());
            boolean b = PersonTypeUtils.checkTTTypeAndPT((String)group.getTrainingTargetType(), personType);
            if (b) continue;
            GroupWarningVo warningVo = new GroupWarningVo();
            warningVo.setGroupId(group.getId());
            warningVo.setGroupName(group.getName());
            warningVo.setCourseId(course.getId());
            warningVo.setCourseName(course.getName());
            warningVo.setMsg("\u8bfe\u7a0b\u7ec4\u9002\u7528\u4eba\u5458\u7c7b\u578b\u4e0e\u8bfe\u7a0b\u4eba\u5458\u7c7b\u578b\u4e0d\u5339\u914d\u3002");
            resultList.add(warningVo);
        }
        return resultList;
    }

    public void ifCanDisabledGroup(List<Long> groupIds, Integer state) {
        if (state == null || state == 1) {
            return;
        }
        List groupList = this.listByIds(groupIds);
        List<CourseGroup> oldSimpleGroup = groupList.stream().filter(v -> GroupTypeEnum.SIMPLE_OLD.getValue().equals(v.getType()) && v.getStatus() == 1).collect(Collectors.toList());
        List<CourseGroup> newSimpleGroup = groupList.stream().filter(v -> GroupTypeEnum.SIMPLE_NEW.getValue().equals(v.getType()) && v.getStatus() == 1).collect(Collectors.toList());
        this.ifCanDisabledGroupV1(oldSimpleGroup);
        this.ifCanDisabledGroupV3_2_2_1(newSimpleGroup);
    }

    public void ifCanDisabledGroupV1(List<CourseGroup> groupList) {
        if (CollectionUtil.isEmpty(groupList)) {
            return;
        }
        groupList.forEach(v -> {
            if (!v.getType().equals(GroupTypeEnum.SIMPLE_OLD.getValue())) {
                throw new ServiceException("\u65b9\u6cd5\u8c03\u7528\u9519\u8bef");
            }
        });
        List<Long> groupIdList = groupList.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<Object> courseItemList = this.courseItemService.getCourseItemByGroupIdsExNul(groupIdList);
        courseItemList = courseItemList.stream().filter(v -> v.getStatus() == 1L).collect(Collectors.toList());
        List<Long> beforeItemIdList = courseItemList.stream().map(v -> v.getId()).collect(Collectors.toList());
        this.courseItemService.ifCanDisablePreciseV1(beforeItemIdList, null);
    }

    public void ifCanDisabledGroupV3_2_2_1(List<CourseGroup> groupList) {
        if (CollectionUtil.isEmpty(groupList)) {
            return;
        }
        groupList.forEach(v -> {
            if (!v.getType().equals(GroupTypeEnum.SIMPLE_NEW.getValue())) {
                throw new ServiceException("\u65b9\u6cd5\u8c03\u7528\u9519\u8bef");
            }
        });
        if (CollectionUtil.isEmpty(groupList)) {
            return;
        }
        List<Long> groupIdList = groupList.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<Object> courseItemList = this.courseItemService.getCourseItemByGroupIdsExNul(groupIdList);
        courseItemList = courseItemList.stream().filter(v -> v.getStatus() == 1L).collect(Collectors.toList());
        List<Long> beforeItemIdList = courseItemList.stream().map(v -> v.getId()).collect(Collectors.toList());
        this.courseItemService.ifCanDisablePreciseV3_2_2_1(beforeItemIdList, null);
    }

    @Override
    public void checkEditPermission(CheckEditPermissionParam param) {
        if (AccountUtil.isSpecifiedUserName((String)param.getUname())) {
            return;
        }
        if (param.getGroupType() != null && !param.getGroupType().equals(GroupTypeEnum.UNIVERSAL.getValue())) {
            throw new ServiceException("\u65e0\u6743\u7f16\u8f91\u8bfe\u7a0b\u7ec4\u7c7b\u522b");
        }
        CourseGroup courseGroup = (CourseGroup)this.getById(param.getGroupId());
        if (this.ifCanEditPermission(param.getUid(), courseGroup)) {
            return;
        }
        throw new ServiceException("\u65e0\u6743\u7f16\u8f91\u300a" + courseGroup.getName() + "\u300b");
    }

    @Override
    public void checkEditPermission(Long uid, String uname, Integer userFrom, Integer userOptRole, List<Long> groupIdList) {
        if (AccountUtil.isSpecifiedUserName((String)uname)) {
            return;
        }
        List courseGroupList = this.listByIds(groupIdList);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < courseGroupList.size(); ++i) {
            CourseGroup group = (CourseGroup)courseGroupList.get(i);
            if (this.ifCanEditPermission(uid, group)) continue;
            if (sb.length() == 0) {
                sb.append("\u60a8\u65e0\u6743\u7f16\u8f91\u8fd9\u4e9b\u8bfe\u7a0b\u7ec4\uff1a");
            }
            sb.append(" \u300a").append(group.getName()).append("\u300b ");
        }
        if (sb.length() > 0) {
            throw new ServiceException(sb.toString());
        }
    }

    @Override
    public List<CourseGroupVo> getDefaultCourse(DefaultCourseParam param) {
        return ((CourseGroupMapper)this.baseMapper).getDefaultCourse(param);
    }

    @Override
    @Transactional
    public void editGroup(CourseGroupEditParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"id"});
        this.ifCanDisabledGroup(Arrays.asList(param.getId()), param.getStatus());
        CourseGroup dbCourseGroup = new CourseGroup();
        dbCourseGroup.setId(param.getId()).setName(param.getName()).setStatus(param.getStatus()).setType(param.getType()).setType2(param.getType2()).setEditor(param.getLoginUserId()).setUpdateBy(param.getLoginUserId());
        this.updateById(dbCourseGroup);
        CourseGroup newest = (CourseGroup)this.getById(dbCourseGroup.getId());
        if (newest.getStatus() == 1) {
            List<GroupWarningVo> groupWarningVos = this.ifCanStartGroupDetail(newest.getId());
            if (CollectionUtil.isNotEmpty(groupWarningVos)) {
                throw new ServiceException(groupWarningVos.get(0).getMsg());
            }
            if (StrUtil.isBlank((CharSequence)newest.getTrainingTargetType())) {
                throw new ServiceException("\u57f9\u8bad\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
            }
        }
        this.updateVideoNumberByCourseGroupId(dbCourseGroup.getId());
    }

    @Override
    @Transactional
    public void addCourseItem(GroupAddItemsParam param) {
        List<GroupWarningVo> groupWarningVoList;
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"groupId", "idList"});
        CourseGroup group = (CourseGroup)this.getById(param.getGroupId());
        if (group == null) {
            throw new ServiceException("\u8bfe\u7a0b\u7ec4\u4e0d\u5b58\u5728");
        }
        if (StrUtil.isBlank((CharSequence)param.getTrainingTargetType()) && StrUtil.isBlank((CharSequence)group.getTrainingTargetType())) {
            throw new ServiceException("\u57f9\u8bad\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List<Long> oldItemIdList = this.courseItemService.getCourseItemIdVoByGroupId(group.getId(), null);
        if (param.getType() != null || param.getType2() != null || StrUtil.isNotBlank((CharSequence)param.getTrainingTargetType())) {
            group.setType(param.getType());
            group.setType2(param.getType2());
            group.setTrainingTargetType(param.getTrainingTargetType());
            this.updateById(group);
        }
        this.courseGroupItemService.deleteByCourseGroupId(param.getGroupId());
        ArrayList<CourseGroupItem> courseGroupItemList = new ArrayList<CourseGroupItem>();
        Long sequence = 0L;
        for (Long itemId : param.getIdList()) {
            sequence = sequence + 100L;
            courseGroupItemList.add(new CourseGroupItem().setCourseGroupId(param.getGroupId()).setCourseItemId(itemId).setSequence(sequence).setCreateBy(param.getLoginUserId()).setUpdateBy(param.getLoginUserId()).setCreateDate(new Date()).setUpdateDate(new Date()));
        }
        this.courseGroupItemService.saveBatch(courseGroupItemList);
        if (group.getStatus() != null && group.getStatus() == 1 && CollUtil.isNotEmpty(groupWarningVoList = this.ifCanStartGroupDetail(group.getId()))) {
            throw new ServiceException(Integer.valueOf(-1), "\u8bfe\u7a0b\u7ec4\u7f16\u8f91\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5931\u8d25\u63d0\u793a\u8fdb\u884c\u4fee\u6539", groupWarningVoList);
        }
        this.updateVideoNumberByCourseGroupId(param.getGroupId());
        for (Long itemId : oldItemIdList) {
            this.courseRedisService.rmCourseItemVo(itemId);
        }
        for (Long itemId : param.getIdList()) {
            this.courseRedisService.rmCourseItemVo(itemId);
        }
    }

    @Override
    @Transactional
    public List<CourseGroupBatchOptVo> batchOpt(List<CourseGroupSingleOptParam> paramList) {
        List<CourseGroupSingleOptParam> optList = paramList;
        ArrayList<CourseGroupBatchOptVo> cantOptList = new ArrayList<CourseGroupBatchOptVo>();
        Map<Integer, List<CourseGroupSingleOptParam>> optTypeMap = optList.stream().collect(Collectors.groupingBy(v -> v.getType()));
        optTypeMap.forEach((k, list) -> {
            block6: {
                block5: {
                    if (k != 1) break block5;
                    for (CourseGroupSingleOptParam param : list) {
                        CourseGroup courseGroup = (CourseGroup)this.getById(param.getCourseGroupId());
                        if (StrUtil.isBlank((CharSequence)courseGroup.getTrainingTargetType())) {
                            CourseGroupBatchOptVo optVo = new CourseGroupBatchOptVo();
                            optVo.setGroupId(courseGroup.getId());
                            optVo.setGroupName(courseGroup.getName());
                            optVo.setMsg("\u57f9\u8bad\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
                            cantOptList.add(optVo);
                            continue;
                        }
                        List<GroupWarningVo> groupWarningVos = this.ifCanStartGroupDetail(courseGroup.getId());
                        if (CollUtil.isNotEmpty(groupWarningVos)) {
                            CourseGroupBatchOptVo optVo = new CourseGroupBatchOptVo();
                            optVo.setGroupId(courseGroup.getId());
                            optVo.setGroupName(courseGroup.getName());
                            optVo.setMsg(groupWarningVos.get(0).getMsg());
                            cantOptList.add(optVo);
                            continue;
                        }
                        courseGroup.setStatus(Integer.valueOf(1));
                        this.updateById(courseGroup);
                    }
                    break block6;
                }
                if (k != 2) break block6;
                this.ifCanDisabledGroup(list.stream().map(v -> v.getCourseGroupId()).collect(Collectors.toList()), 2);
                for (CourseGroupSingleOptParam courseGroupSingleOptParam : list) {
                    CourseGroup courseGroup = (CourseGroup)this.getById(courseGroupSingleOptParam.getCourseGroupId());
                    if (courseGroup != null) {
                        courseGroup.setStatus(Integer.valueOf(2));
                        this.updateById(courseGroup);
                    }
                    this.updateVideoNumberByCourseGroupId(courseGroupSingleOptParam.getCourseGroupId());
                }
            }
        });
        return cantOptList;
    }

    @Override
    public List<Long> getCourseIdsById(Long id) {
        return ((CourseGroupMapper)this.baseMapper).getCourseIdsById(id);
    }

    @Override
    @Transactional
    public boolean deleteOne(Long id) {
        if (id == null) {
            return false;
        }
        List<CourseGroupItem> cgcList = this.courseGroupItemService.getByGroupId(id);
        for (CourseGroupItem v : cgcList) {
            this.courseRedisService.rmCourseItemVo(v.getCourseItemId());
        }
        this.ifCanDisabledGroup(Arrays.asList(id), 2);
        this.courseGroupItemService.deleteByCourseGroupId(id);
        this.removeById(id);
        return true;
    }

    @Override
    public List<String> getActivatedPersonTypeListById(Long groupId) {
        return ((CourseGroupMapper)this.baseMapper).getActivatedPersonTypeListById(groupId);
    }

    @Override
    public List<Long> getActivatedCourseIdList(Long id) {
        return ((CourseGroupMapper)this.baseMapper).getActivatedCourseIdList(id);
    }

    public boolean ifCanEditPermission(Long uid, CourseGroup group) {
        return uid.equals(group.getCreateBy());
    }
}

