/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.certificate.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserInfoProviderService;
import cn.smarthse.radiationTraining.modules.sys.shiro.UserInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.training.dao.certificate.TuCertificateMapper;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.Certificate;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.TuCertificatePageParam;
import cn.smarthse.radiationTraining.modules.training.param.UpdateCertificateParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpRedundancyInfoParam;
import cn.smarthse.radiationTraining.modules.training.param.training.MyCertificateParam;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingCallService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ICertificateService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.task.CertService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.CertTrainVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.MyCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertListVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TuCertificateServiceImpl
extends ServiceImpl<TuCertificateMapper, TuCertificate>
implements ITuCertificateService {
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private TrainingCallService trainingCallService;
    @Autowired
    private ICertificateService certificateService;
    @Autowired
    private CertService certService;
    @Autowired
    private OssClientBean ossClientBean;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private IUserInfoProviderService userInfoProviderService;

    @Override
    public void reGenCertificateNo(Long tuCertificateId) {
        throw new ServiceException("\u529f\u80fd\u505c\u7528");
    }

    @Override
    public LayuiGridData<MyCertificateVo> getMyCertificateList(MyCertificateParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<MyCertificateVo> list = ((TuCertificateMapper)this.baseMapper).getMyCertificateList(param);
        if (!CollectionUtils.isEmpty(list)) {
            for (MyCertificateVo vo : list) {
                vo.setPdfUrl(this.ossClientBean.getUrl(vo.getPdfUrl()));
            }
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public CertTrainVo getMyCertificateListCount(MyCertificateParam param) {
        return ((TuCertificateMapper)this.baseMapper).getMyCertificateListCount(param);
    }

    @Override
    public LayuiGridData<CertTrainVo> getHasCetTrainList(MyCertificateParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CertTrainVo> list = ((TuCertificateMapper)this.baseMapper).getHasCetTrainList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public List<MyCertificateVo> getTrainCetList(MyCertificateParam param) {
        List<MyCertificateVo> list = ((TuCertificateMapper)this.baseMapper).getTrainCetList(param);
        if (!CollectionUtils.isEmpty(list)) {
            for (MyCertificateVo vo : list) {
                vo.setPdfUrl(this.ossClientBean.getUrl(vo.getPdfUrl()));
            }
        }
        return list;
    }

    @Override
    public List<MyCertificateVo> getMyCertificateList(Long enrollDetailId) {
        return ((TuCertificateMapper)this.baseMapper).getCertListByEnrollDetailId(enrollDetailId);
    }

    @Override
    @Transactional
    public void addCertificate(Long tuEnrollDetailId) {
        String[] personTypeArr;
        if (this.hasBaseCertificate(tuEnrollDetailId).booleanValue()) {
            return;
        }
        TuEnrollDetail detail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuEnrollDetailId);
        TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(detail.getEnrollId());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(detail.getTid());
        HseCompanyVo companyVo = this.hseCompanyProviderService.getInfoById(tuEnroll.getHseCid());
        if (detail == null || detail.getTid() == null) {
            throw new ServiceException("\u62a5\u540d\u8be6\u60c5\u6570\u636e\u5f02\u5e38\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)detail.getPersonTypeCode())) {
            throw new ServiceException("\u7f3a\u5c11\u4eba\u5458\u7c7b\u578b\u6570\u636e\uff01");
        }
        boolean ifCanSync = this.tuEnrollDetailService.ifCanSync(detail);
        Map<String, String> awardUnitMap = null;
        if (trainingInfo.getIsCurrency() == 0) {
            awardUnitMap = trainingInfo.getPersonCertificateList().stream().collect(Collectors.toMap(v -> String.valueOf(v.getPersonType()), v -> v.getAwardUnit()));
        }
        for (String personType : personTypeArr = detail.getPersonTypeCode().split(",")) {
            TuCertificate tuCertificate = new TuCertificate();
            tuCertificate.setUid(detail.getUid());
            tuCertificate.setCertType(personType);
            tuCertificate.setEnrollDetailId(tuEnrollDetailId);
            tuCertificate.setName(trainingInfo.getTrainName());
            tuCertificate.setTrainingName(trainingInfo.getTrainName());
            tuCertificate.setTrainType(trainingInfo.getTrainType());
            tuCertificate.setUname(detail.getUname());
            tuCertificate.setUnitName(companyVo.getName());
            tuCertificate.setIssueTime(new Date());
            tuCertificate.setTrainingUnitName(trainingInfo.getIsCurrency() == 0 ? awardUnitMap.get(personType) : tuEnroll.getIssueUnitName());
            UserInfo userInfo = this.userInfoProviderService.getUserInfo(detail.getUid());
            if (userInfo != null) {
                tuCertificate.setSex(userInfo.getSex());
                tuCertificate.setIdCard(userInfo.getIdcard());
            }
            tuCertificate.setCreateTime(new Date());
            tuCertificate.setSyncState(Integer.valueOf(ifCanSync ? 0 : -1));
            tuCertificate.setSyncDes(ifCanSync ? "\u672a\u540c\u6b65" : "\u65e0\u9700\u540c\u6b65");
            this.save(tuCertificate);
        }
    }

    @Override
    public Boolean hasBaseCertificate(Long tuEnrollDetailId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"enroll_detail_id", (Object)tuEnrollDetailId);
        List list = this.list((Wrapper)wrapper);
        return list != null && list.size() != 0;
    }

    @Override
    public boolean hasBaseCertificateIgnoreIsValid(Long tuEnrollDetailId) {
        List<TuCertificate> list = ((TuCertificateMapper)this.baseMapper).getBaseCertificateIgnoreIsValid(tuEnrollDetailId);
        return list != null && list.size() != 0;
    }

    @Override
    public TuCertificate getCertificateNoV2(Long areaId, Integer year, String certType) {
        TuCertificate result = new TuCertificate();
        if (areaId == null) {
            result.setAreaId("000000");
        } else {
            result.setAreaId((areaId + "000000").substring(0, 6));
        }
        if (year == null) {
            year = LocalDate.now().getYear();
        }
        String certType6 = certType;
        certType = StringUtils.isEmpty((CharSequence)certType) || ((String)certType).length() < 2 ? "00" : ((String)certType).substring(((String)certType).length() - 2);
        if (StrUtil.equals((CharSequence)certType6, (CharSequence)TrainingPersonTypeEnum.RAY_WORK_NON_MEDICAL.getValue())) {
            certType = "R" + (String)certType;
        }
        int maxSerialNo = ((TuCertificateMapper)this.baseMapper).getMaxSerialNo(result.getAreaId().substring(0, 6), year, certType6);
        result.setYear(year);
        result.setCertType((String)certType);
        result.setSerialNo(Integer.valueOf(++maxSerialNo));
        result.setCertificateNo(result.getAreaId().substring(0, 6) + (String)certType + year.toString().substring(year.toString().length() - 2) + String.format("%06d", maxSerialNo));
        return result;
    }

    @Override
    public TuCertificate getCertificateNoV2ForRay(Long areaId, Integer year, String certType) {
        TuCertificate result = new TuCertificate();
        if (areaId == null) {
            result.setAreaId("000000");
        } else {
            result.setAreaId((areaId + "000000").substring(0, 6));
        }
        if (year == null) {
            year = LocalDate.now().getYear();
        }
        String certType6 = certType;
        certType = StringUtils.isEmpty((CharSequence)certType) || certType.length() < 2 ? "00" : certType.substring(certType.length() - 2);
        int maxSerialNo = ((TuCertificateMapper)this.baseMapper).getMaxSerialNo(result.getAreaId().substring(0, 6), year, certType6);
        result.setYear(year);
        result.setCertType(certType);
        result.setSerialNo(Integer.valueOf(++maxSerialNo));
        result.setCertificateNo(result.getAreaId().substring(0, 6) + "R" + certType + year.toString().substring(year.toString().length() - 2) + String.format("%06d", maxSerialNo));
        return result;
    }

    @Override
    @Transactional
    public void saveCertificateFile(Long enrollDetailId, String pdfUrl, String imgUrl) {
        TuCertificate tuCertificate = ((TuCertificateMapper)this.baseMapper).getByEnrollDetailId(enrollDetailId);
        tuCertificate.setPdfUrl(pdfUrl);
        tuCertificate.setImgUrl(imgUrl);
        this.updateById(tuCertificate);
    }

    @Override
    @Transactional
    public TuCertificate upDateCertificateFile(UpdateCertificateParam updateCertificateVo) {
        TuCertificate tuCertificate = ((TuCertificateMapper)this.baseMapper).getByEnrollDetailId(updateCertificateVo.getEnrollDetailId());
        Long tid = ((TuEnrollDetail)this.tuEnrollDetailService.getById(tuCertificate.getEnrollDetailId())).getTid();
        Long targetCertificateId = ((Training)this.trainingService.getById(tid)).getTargetCertificate();
        Certificate targetCertificate = (Certificate)this.certificateService.getById(targetCertificateId);
        tuCertificate.setIssueTime(updateCertificateVo.getIssueTime());
        tuCertificate.setPdfUrl(updateCertificateVo.getPdfUrl());
        tuCertificate.setImgUrl(updateCertificateVo.getImgUrl());
        tuCertificate.setTrainingName(updateCertificateVo.getTrainName());
        tuCertificate.setTrainingUnitName(updateCertificateVo.getTrainUnitName());
        tuCertificate.setIdCard(updateCertificateVo.getIdCard());
        tuCertificate.setCertificateNo(updateCertificateVo.getCertificateNo());
        tuCertificate.setName(targetCertificate.getName());
        this.updateById(tuCertificate);
        return tuCertificate;
    }

    @Override
    @Transactional
    public void rmByEnrollDetailId(Long enrollDetailId) {
        if (enrollDetailId == null) {
            return;
        }
        QueryWrapper wrapper = new QueryWrapper();
        this.remove((Wrapper)wrapper.lambda().eq(TuCertificate::getEnrollDetailId, (Object)enrollDetailId));
    }

    @Override
    public void rmByEnrollDetailIds(List<Long> enrollDetailIds) {
        if (CollectionUtil.isEmpty(enrollDetailIds)) {
            return;
        }
        for (Long enrollDetailId : enrollDetailIds) {
            this.rmByEnrollDetailId(enrollDetailId);
        }
    }

    @Override
    public List<TuCertificate> listNeedGenCertUnit() {
        return ((TuCertificateMapper)this.baseMapper).listNeedGenCertForUnit(TrainTargetEnum.UNIT.getValue());
    }

    @Override
    public List<TuCertificate> listNeedGenCertForRay() {
        ArrayList trainTargetList = CollUtil.toList((Object[])new Integer[]{TrainTargetEnum.RAY_MANGER.getValue(), TrainTargetEnum.RAY_WORK.getValue()});
        return ((TuCertificateMapper)this.baseMapper).listNeedGenCertForRay(trainTargetList);
    }

    @Override
    public LayuiGridData<TuCertListVo> getList(TuCertificatePageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TuCertListVo> voList = ((TuCertificateMapper)this.baseMapper).getList(param);
        voList.stream().forEach(item -> item.setPdfUrl(this.ossClientBean.getUrl(item.getPdfUrl())));
        return new LayuiGridData((Page)voList, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void updateRedundancyExcludeUintInfo(UpRedundancyInfoParam param) {
        if (param.getUid() == null) {
            throw new ServiceException("uid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getUnitName())) {
            throw new ServiceException("\u8be5\u65b9\u6cd5\u4e0d\u652f\u6301\u5355\u4f4d\u53d8\u66f4");
        }
        if (StringUtils.isEmpty((CharSequence)param.getIdCard()) && StringUtils.isEmpty((CharSequence)param.getSex()) && StringUtils.isEmpty((CharSequence)param.getName())) {
            return;
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.lambda().eq(TuCertificate::getUid, (Object)param.getUid());
        TuCertificate tuCertificate = new TuCertificate();
        tuCertificate.setIdCard(param.getIdCard());
        tuCertificate.setSex(param.getSex());
        tuCertificate.setUname(param.getName());
        this.update(tuCertificate, (Wrapper)wrapper);
        ((TuCertificateMapper)this.baseMapper).cleanTuCertificate(param.getUid());
    }

    @Override
    @Transactional
    public void updateUnitRedundancyInfo(UpRedundancyInfoParam param) {
        if (StringUtils.isEmpty((CharSequence)param.getUnitName())) {
            return;
        }
        if (param.getEnrollDetailId() == null) {
            throw new ServiceException("\u53d8\u66f4\u5355\u4f4d\u65f6\u7f3a\u5c11\u57f9\u8bad\u4fe1\u606fid");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.lambda().eq(TuCertificate::getEnrollDetailId, (Object)param.getEnrollDetailId());
        TuCertificate tuCertificate = new TuCertificate();
        TuEnrollDetail tuEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(param.getEnrollDetailId());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnrollDetail.getTid());
        if (trainingInfo.getIsCurrency() == 1) {
            String trainUnitName = this.trainingCallService.getTrainUnitName(tuEnrollDetail.getHseCid());
            tuCertificate.setTrainingUnitName(trainUnitName);
        }
        tuCertificate.setUnitName(StringUtils.isEmpty((CharSequence)param.getUnitName()) ? null : param.getUnitName());
        this.update(tuCertificate, (Wrapper)wrapper);
        ((TuCertificateMapper)this.baseMapper).cleanTuCertificate(param.getUid());
    }

    @Override
    public List<TuCertificate> getAllSynceException() {
        return ((TuCertificateMapper)this.baseMapper).getAllSyncException();
    }

    @Override
    public void syncSingleInfo(TuCertificate tuCertificate) {
        TuEnrollDetail enrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCertificate.getEnrollDetailId());
        if (!this.tuEnrollDetailService.ifCanSync(enrollDetail)) {
            return;
        }
        TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(enrollDetail.getEnrollId());
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnroll.getTid());
        this.certService.syncCertInfo(tuCertificate, enrollDetail, tuEnroll, (Training)trainingInfo);
    }

    @Override
    public void reSynceAllExceptionInfo() {
        List<TuCertificate> allSyncException = this.getAllSynceException();
        for (TuCertificate tuCertificate : allSyncException) {
            try {
                this.syncSingleInfo(tuCertificate);
            }
            catch (Exception e) {
                this.log.error("Exception\uff1a", (Throwable)e);
            }
        }
    }

    @Override
    public List<TuCertificate> getDeletedDataByDetailId(Long tuEnrollDetailId) {
        return ((TuCertificateMapper)this.baseMapper).getDeletedDataByDetailId(tuEnrollDetailId);
    }

    @Override
    public void setIsValidById(Boolean isValid, List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        ((TuCertificateMapper)this.baseMapper).setIsValidById(isValid, ids);
    }

    @Override
    public TuCertVo getInfoById(Long id) {
        return ((TuCertificateMapper)this.baseMapper).getInfoById(id);
    }

    @Override
    public TuCertificate getByDetailIdAndCertType(Long detailId, String certType) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(TuCertificate::getEnrollDetailId, (Object)detailId)).eq(TuCertificate::getCertType, (Object)certType);
        return (TuCertificate)((TuCertificateMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void cleanCert(Long certId) {
        ((TuCertificateMapper)this.baseMapper).cleanCert(certId);
    }

    @Override
    public List<TuCertificate> getByCertificateNoForCheckResult(String certificateNo) {
        return ((TuCertificateMapper)this.baseMapper).getByCertificateNoForCheckResult(certificateNo);
    }
}

