/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.certificate.impl;

import cn.hutool.core.util.IdcardUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.excel.BaseImportDto;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import cn.smarthse.radiationTraining.modules.training.converter.RaTuCertConverter;
import cn.smarthse.radiationTraining.modules.training.dao.certificate.RaTuCertificateMapper;
import cn.smarthse.radiationTraining.modules.training.dto.ImportRaTuCertDto;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateEditParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.IRaTuCertificateService;
import cn.smarthse.radiationTraining.modules.training.task.cert.offline.CertOfflineService;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RaTuCertificateServiceImpl
extends ServiceImpl<RaTuCertificateMapper, RaTuCertificate>
implements IRaTuCertificateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RaTuCertificateServiceImpl.class);
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;
    @Autowired
    private RaTuCertConverter certConverter;
    @Autowired
    private CertOfflineService certOfflineService;
    @DubboReference
    private IHseCompanyProviderService companyProviderService;
    @DubboReference
    private ISysFileProvideService sysFileProviderService;

    @Override
    public LayuiGridData<RaTuCertificate> getCertList(RaTuCertificateParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RaTuCertificate> voList = ((RaTuCertificateMapper)this.baseMapper).getCertList(param);
        if (!CollectionUtils.isEmpty(voList)) {
            voList.forEach(c -> {
                if (c.getPdfFileId() != null) {
                    c.setPdfUrl(this.sysFileProviderService.getFileUrl(c.getPdfFileId()));
                }
            });
        }
        return new LayuiGridData((Page)voList, (LayuiGridParam)param);
    }

    @Override
    public List<RaTuCertificate> getListByTid(Long tid) {
        return ((RaTuCertificateMapper)this.baseMapper).getListByTid(tid);
    }

    @Override
    public List<Long> listNeedGenCertForOffline() {
        return ((RaTuCertificateMapper)this.baseMapper).listNeedGenCertForOffline();
    }

    @Override
    public void clearCertData(RaTuCertificateParam param) {
        if (param.getTrainingId() == null) {
            return;
        }
        ((RaTuCertificateMapper)this.baseMapper).clearCertData(param.getTrainingId());
    }

    @Override
    public RaTuCertificate getCertDetail(Long id) {
        return (RaTuCertificate)this.getById(id);
    }

    @Override
    @Transactional(readOnly=false)
    public void saveCertDetail(RaTuCertificateEditParam param) {
        CompanyVo companyByCode;
        CompanyVo companyByName;
        RaTuCertificate tuCertificate = new RaTuCertificate();
        if (!StringUtils.isEmpty((CharSequence)param.getIdCard()) && param.getIdCardType().equals(1)) {
            if (!IdcardUtil.isValidCard((String)param.getIdCard())) {
                throw new ServiceException(Integer.valueOf(-1), "\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u6709\u8bef\uff01");
            }
            param.setBirthday((Date)IdcardUtil.getBirthDate((String)param.getIdCard()));
            param.setSex(IdcardUtil.getGenderByIdCard((String)param.getIdCard()) == 1 ? "\u7537" : "\u5973");
        }
        if (this.existCertNo(param.getId(), param.getCertificateNo()).booleanValue()) {
            throw new ServiceException(Integer.valueOf(-1), "\u8be5\u8bc1\u4e66\u7f16\u53f7\u5df2\u5b58\u5728\uff01");
        }
        if (param.getCertType().equals("300002")) {
            companyByName = this.companyProviderService.getRhoCompanyByNameOrCreditCode(param.getUnitName(), Integer.valueOf(1));
            companyByCode = this.companyProviderService.getRhoCompanyByNameOrCreditCode(param.getUnitCreditCode(), Integer.valueOf(2));
        } else {
            companyByName = this.companyProviderService.getHseCompanyByNameOrCreditCode(param.getUnitName(), Integer.valueOf(1));
            companyByCode = this.companyProviderService.getHseCompanyByNameOrCreditCode(param.getUnitCreditCode(), Integer.valueOf(2));
        }
        if (companyByName == null && companyByCode == null) {
            throw new ServiceException(Integer.valueOf(-1), "\u8be5\u5355\u4f4d\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        if (companyByCode != null && StringUtils.isNotEmpty((String)param.getUnitName()) && !param.getUnitName().equals(companyByCode.getName())) {
            throw new ServiceException(Integer.valueOf(-1), "\u8be5\u5355\u4f4d\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\uff01");
        }
        if (companyByName != null && StringUtils.isNotEmpty((String)param.getUnitCreditCode()) && !param.getUnitCreditCode().equals(companyByName.getCreditCode())) {
            throw new ServiceException(Integer.valueOf(-1), "\u8be5\u5355\u4f4d\u4fe1\u7528\u4ee3\u7801\u4e0e\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getCertType()) && !StringUtils.isEmpty((CharSequence)param.getIdCard())) {
            if (param.getCertType().equals("300002")) {
                staffByIdCard = this.getRhoStaffByIdCard(param.getIdCard());
                if (staffByIdCard != null && !staffByIdCard.getName().equals(param.getUname())) {
                    throw new ServiceException(Integer.valueOf(-1), "\u8eab\u4efd\u8bc1\u5bf9\u5e94\u59d3\u540d\u4e0e\u6d59\u91cc\u536b\u4f01\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\uff01");
                }
            } else {
                staffByIdCard = this.getSmarthseStaffByIdCard(param.getIdCard());
                if (staffByIdCard != null && !staffByIdCard.getName().equals(param.getUname())) {
                    throw new ServiceException(Integer.valueOf(-1), "\u8eab\u4efd\u8bc1\u5bf9\u5e94\u59d3\u540d\u4e0e\u653e\u5c04\u536b\u751f\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\uff01");
                }
            }
        }
        BeanUtils.copyProperties((Object)param, (Object)tuCertificate);
        if (companyByName != null && companyByCode != null && companyByName.getId().equals(companyByCode.getId())) {
            tuCertificate.setCid(companyByName.getId());
        }
        tuCertificate.setSyncState(Integer.valueOf(0));
        this.updateById(tuCertificate);
        this.cleanPdf(tuCertificate.getId());
        this.sqlSessionTemplate.flushStatements();
        try {
            this.certOfflineService.genCertFile(tuCertificate.getId());
            log.debug("\u8bc1\u4e66\u6587\u4ef6\u751f\u6210\u6210\u529f\uff0c\u8bc1\u4e66ID: {}", (Object)tuCertificate.getId());
        }
        catch (Exception e) {
            throw new ServiceException(String.format("\u8bc1\u4e66\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bc1\u4e66ID: %s\uff0c%s", tuCertificate.getId(), e.getMessage()));
        }
    }

    @Override
    public List<Long> getListByTidForSyncCert(Long tid) {
        return ((RaTuCertificateMapper)this.baseMapper).getListByTidForSyncCert(tid);
    }

    @Override
    public void delByTid(Long tid) {
        ((RaTuCertificateMapper)this.baseMapper).clearCertData(tid);
    }

    @Override
    public void cleanPdf(Long certId) {
        ((RaTuCertificateMapper)this.baseMapper).cleanPdf(certId);
    }

    public Boolean existCertNoWhileAdd(String certNo) {
        List<RaTuCertificate> list = ((RaTuCertificateMapper)this.baseMapper).getByCertNo(certNo);
        return !list.isEmpty();
    }

    public Boolean existCertNo(Long id, String certNo) {
        List<RaTuCertificate> list = ((RaTuCertificateMapper)this.baseMapper).getByCertNo(certNo);
        if (list.isEmpty()) {
            return false;
        }
        if (list.size() == 1 && list.get(0).getId().equals(id)) {
            return false;
        }
        return true;
    }

    public CStaffBaseInfo getSmarthseStaffByIdCard(String idCard) {
        if (StringUtils.isEmpty((CharSequence)idCard)) {
            return null;
        }
        List<CStaffBaseInfo> staffsByIdCard = ((RaTuCertificateMapper)this.baseMapper).getSmarthseStaffByIdCard(SpringEncryptUtils.encrypt((String)idCard));
        if (staffsByIdCard.isEmpty()) {
            return null;
        }
        CStaffBaseInfo cStaffBaseInfo = staffsByIdCard.get(0);
        if (cStaffBaseInfo != null && StringUtils.isNotEmpty((String)cStaffBaseInfo.getName())) {
            cStaffBaseInfo.setName(SpringEncryptUtils.decrypt((String)cStaffBaseInfo.getName()));
        }
        if (cStaffBaseInfo != null && StringUtils.isNotEmpty((String)cStaffBaseInfo.getIdcard())) {
            cStaffBaseInfo.setIdcard(SpringEncryptUtils.decrypt((String)cStaffBaseInfo.getIdcard()));
        }
        return cStaffBaseInfo;
    }

    public CStaffBaseInfo getRhoStaffByIdCard(String idCard) {
        if (StringUtils.isEmpty((CharSequence)idCard)) {
            return null;
        }
        List<CStaffBaseInfo> staffsByIdCard = ((RaTuCertificateMapper)this.baseMapper).getRhoStaffByIdCard(SpringEncryptUtils.encrypt((String)idCard));
        if (staffsByIdCard.isEmpty()) {
            return null;
        }
        CStaffBaseInfo cStaffBaseInfo = staffsByIdCard.get(0);
        if (cStaffBaseInfo != null && StringUtils.isNotEmpty((String)cStaffBaseInfo.getName())) {
            cStaffBaseInfo.setName(SpringEncryptUtils.decrypt((String)cStaffBaseInfo.getName()));
        }
        if (cStaffBaseInfo != null && StringUtils.isNotEmpty((String)cStaffBaseInfo.getIdcard())) {
            cStaffBaseInfo.setIdcard(SpringEncryptUtils.decrypt((String)cStaffBaseInfo.getIdcard()));
        }
        return cStaffBaseInfo;
    }

    @Override
    @Transactional
    public void importTrainAboutCert(List<ImportRaTuCertDto> list, Long loginUserId) {
        List<BaseImportDto> msgList = this.checkImportTrainAboutCert(list);
        if (!CollectionUtils.isEmpty(msgList)) {
            throw new ServiceException(Integer.valueOf(-1), "\u5bfc\u5165\u5931\u8d25\uff01", msgList);
        }
        List<RaTuCertificate> datas = this.certConverter.dtos2EntityList(list);
        if (!CollectionUtils.isEmpty(datas)) {
            datas.forEach(c -> {
                c.setCreateBy(loginUserId);
                c.setCreateDate(LocalDateTime.now());
            });
        }
        this.saveBatch(datas);
    }

    private List<BaseImportDto> checkImportTrainAboutCert(List<ImportRaTuCertDto> list) {
        ArrayList<BaseImportDto> msgList = new ArrayList<BaseImportDto>();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        Iterator<ImportRaTuCertDto> iterator = list.iterator();
        int rowIndex = 2;
        while (iterator.hasNext()) {
            CompanyVo companyByCode;
            CompanyVo companyByName;
            boolean hasDuplicateCertNo;
            ImportRaTuCertDto next = iterator.next();
            BaseImportDto err = new BaseImportDto();
            ++rowIndex;
            if (StringUtils.isEmpty((CharSequence)next.getUname())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getIdCardTypeStr())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8eab\u4efd\u8bc1\u660e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getIdCard())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isEmpty((CharSequence)next.getIdCardTypeStr()) && next.getIdCardTypeStr().equals("\u8eab\u4efd\u8bc1") && !StringUtils.isEmpty((CharSequence)next.getIdCard())) {
                System.out.println("\u8eab\u4efd\u8bc1\u6821\u9a8c" + next.getIdCard());
                if (!IdcardUtil.isValidCard((String)next.getIdCard())) {
                    err.setHaveError(Boolean.TRUE);
                    err.setErrorReason(err.getErrorReason() + "\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u6709\u8bef\uff01");
                } else {
                    next.setBirthday((Date)IdcardUtil.getBirthDate((String)next.getIdCard()));
                    next.setSex(IdcardUtil.getGenderByIdCard((String)next.getIdCard()) == 1 ? "\u7537" : "\u5973");
                }
            }
            if (!StringUtils.isEmpty((CharSequence)next.getIdCardTypeStr()) && next.getIdCardTypeStr().equals("\u5176\u4ed6") && next.getBirthday() == null) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u51fa\u751f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isEmpty((CharSequence)next.getIdCardTypeStr()) && next.getIdCardTypeStr().equals("\u5176\u4ed6") && StringUtils.isEmpty((CharSequence)next.getSex())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u6027\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getUnitName())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u6240\u5728\u7528\u4eba\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getUnitCreditCode())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u6240\u5728\u7528\u4eba\u5355\u4f4d\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getCertTypeStr())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8bc1\u4e66\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getTrainType())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u57f9\u8bad\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (next.getIssueTime() == null) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8bc1\u4e66\u53d1\u8bc1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (next.getInvalidDate() == null) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8bc1\u4e66\u6709\u6548\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getTrainingResultStr())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u57f9\u8bad\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((CharSequence)next.getTrainingUnitName())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u53d1\u8bc1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!StringUtils.isEmpty((CharSequence)next.getCertType()) && !StringUtils.isEmpty((CharSequence)next.getIdCard())) {
                if (next.getCertType().equals("300002")) {
                    CStaffBaseInfo staffByIdCard = this.getRhoStaffByIdCard(next.getIdCard());
                    if (staffByIdCard != null && !staffByIdCard.getName().equals(next.getUname())) {
                        err.setHaveError(Boolean.TRUE);
                        err.setErrorReason(err.getErrorReason() + "\u8eab\u4efd\u8bc1\u59d3\u540d\u4e0e\u653e\u5c04\u536b\u751f\u5728\u7ebf\u7cfb\u7edf\u4e2d\u7684\u59d3\u540d\u4e0d\u4e00\u81f4\uff01");
                    }
                } else {
                    CStaffBaseInfo staffByIdCard = this.getSmarthseStaffByIdCard(next.getIdCard());
                    if (staffByIdCard != null && !staffByIdCard.getName().equals(next.getUname())) {
                        err.setHaveError(Boolean.TRUE);
                        err.setErrorReason(err.getErrorReason() + "\u8eab\u4efd\u8bc1\u59d3\u540d\u4e0e\u6d59\u91cc\u536b\u4f01\u7cfb\u7edf\u4e2d\u7684\u59d3\u540d\u4e0d\u4e00\u81f4\uff01");
                    }
                }
            }
            if (hasDuplicateCertNo = list.stream().filter(item -> item != next && StringUtils.isNotEmpty((String)item.getCertificateNo())).anyMatch(item -> item.getCertificateNo().equals(next.getCertificateNo()))) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8be5\u8bc1\u4e66\u7f16\u53f7\u5728\u5bfc\u5165\u6570\u636e\u4e2d\u5b58\u5728\u91cd\u590d\uff01");
            }
            if (StringUtils.isNotEmpty((String)next.getCertificateNo()) && this.existCertNoWhileAdd(next.getCertificateNo()).booleanValue()) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8be5\u8bc1\u4e66\u7f16\u53f7\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff01");
            }
            if (next.getCertType().equals("300002")) {
                companyByName = this.companyProviderService.getRhoCompanyByNameOrCreditCode(next.getUnitName(), Integer.valueOf(1));
                companyByCode = this.companyProviderService.getRhoCompanyByNameOrCreditCode(next.getUnitCreditCode(), Integer.valueOf(2));
            } else {
                companyByName = this.companyProviderService.getHseCompanyByNameOrCreditCode(next.getUnitName(), Integer.valueOf(1));
                companyByCode = this.companyProviderService.getHseCompanyByNameOrCreditCode(next.getUnitCreditCode(), Integer.valueOf(2));
            }
            if (companyByName == null && companyByCode == null) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8be5\u5355\u4f4d\u5728\u7cfb\u7edf\u4e2d\u5747\u4e0d\u5b58\u5728\uff01");
            }
            if (companyByCode != null && StringUtils.isNotEmpty((String)next.getUnitName()) && !next.getUnitName().equals(companyByCode.getName())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8be5\u5355\u4f4d\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\uff01");
            }
            if (companyByName != null && StringUtils.isNotEmpty((String)next.getUnitCreditCode()) && !next.getUnitCreditCode().equals(companyByName.getCreditCode())) {
                err.setHaveError(Boolean.TRUE);
                err.setErrorReason(err.getErrorReason() + "\u8be5\u5355\u4f4d\u4fe1\u7528\u4ee3\u7801\u4e0e\u7cfb\u7edf\u4e2d\u4e0d\u4e00\u81f4\uff01");
            }
            if (companyByName != null && companyByCode != null && companyByName.getId().equals(companyByCode.getId())) {
                next.setCid(companyByName.getId());
            }
            err.setRowIndex(Integer.valueOf(rowIndex));
            if (!Boolean.TRUE.equals(err.getHaveError())) continue;
            msgList.add(err);
        }
        return msgList;
    }
}

