/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.training;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingChangeRecord;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.param.training.AssoScoreListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RhoTrainHomeCropParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RhoTrainHomeUserParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TidParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeCetParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeCropParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainHomeUserParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingAddParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingDelParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingEnrollDetailSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingStatusUpdateParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingUpdateParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingWorkTypeService;
import cn.smarthse.radiationTraining.modules.training.vo.training.ApiScoreSearchVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.AssoScoreListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.RhoTrainHomeCropVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.RhoTrainHomeUserVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCetVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCropExportVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeCropVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeUserExportVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainHomeUserVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingHomeListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingHomeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingUnitEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class TrainingProviderServiceImpl
implements ITrainingProviderService {
    private final ITrainingService trainingService;
    private final ITrainingWorkTypeService trainingWorkTypeService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    private final ITrainingCourseProviderService trainingCourseProviderService;

    public LayuiGridData<TrainingListVo> getTrainingList(TrainingSearchParam param) {
        LayuiGridData<TrainingListVo> list = this.trainingService.getTrainingPageList(param);
        list.getData().stream().forEach(train -> {
            if (null != train.getTrainArea()) {
                train.setTrainAreaName(this.areaProviderService.getAreaNameById(train.getTrainArea()));
            }
        });
        return list;
    }

    public TrainingDetailVo getTrainingInfo(TrainingSearchParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"trainingId"});
        return this.trainingService.getTrainingInfo(param);
    }

    public TrainingDetailVo getTrainingInfo(Long tid) {
        if (null == tid) {
            throw new ServiceException("\u57f9\u8badid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.trainingService.getTrainingInfo(tid);
    }

    public List<TrainingWorkTypeVo> getTrainingWorkType() {
        return this.trainingWorkTypeService.getTrainWorkTypeByStatus(-1);
    }

    public List<TrainingWorkTypeVo> getTrainWorkTypeByStatus(Integer status) {
        return this.trainingWorkTypeService.getTrainWorkTypeByStatus(status);
    }

    public LayuiGridData<TrainingUnitEnrollVo> getTrainingUnitEnrollList(TrainingEnrollSearchParam param) {
        return this.trainingService.getTrainingUnitEnrollList(param);
    }

    public LayuiGridData<TrainingPersonEnrollVo> getTrainingPersonEnrollList(TrainingEnrollDetailSearchParam param) {
        return this.trainingService.getTrainingPersonEnrollList(param);
    }

    public Integer updateTrainingDetail(TrainingUpdateParam param) throws IllegalAccessException {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"trainingId"});
        if (param.getIsCurrency() == 1 && !param.getIsSpecifiedUser().booleanValue()) {
            throw new ServiceException("\u5f53\u524d\u8d26\u53f7\u65e0\u6cd5\u8bbe\u7f6e\u57f9\u8bad\u4e3a\u2018\u901a\u7528\u57f9\u8bad\u2019\uff01");
        }
        if (param.getIsCurrency() == 1 && param.getIsSpecifiedUser().booleanValue()) {
            param.getPersonTypeCertificateList().stream().forEach(personType -> personType.setAwardUnit(null));
        }
        if (param.getUserAreaLevel() >= 3 && param.getSendBelong() != null && (param.getSendBelong() != 0 || param.getSendBelong() != 3)) {
            param.setSendBelong(Integer.valueOf(0));
        }
        return this.trainingService.updateTrainingDetail(param);
    }

    public LayuiGridData<TrainingChangeRecord> listTrainChangeRecord(TidParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tid"});
        return this.trainingService.listTrainChangeRecord(param);
    }

    public Integer changeTrainingStatus(TrainingStatusUpdateParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"trainIdList", "status"});
        if (param.getTrainIdList().size() == 0) {
            throw new ServiceException("\u57f9\u8badid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List trainIdList = param.getTrainIdList();
        if (param.getStatus() == 2) {
            trainIdList.stream().forEach(id -> {
                List trainCourseList;
                TrainingDetailVo info = this.getTrainingInfo((Long)id);
                FieldCheckUtils.checkEmptyFields((Object)info, (String[])new String[]{"trainName", "trainArea", "trainType", "signEndTime", "trainStarTime", "trainEndTime", "coverUrl", "isTestOnline", "isCharge", "personCertificateList", "trainIndustryVoList", "isCurrency"});
                if (info.getIsTestOnline() == 1) {
                    FieldCheckUtils.checkEmptyFields((Object)info, (String[])new String[]{"retestLimit", "retestSetting", "testMode", "testPaperUsage", "isFaceRecognition"});
                }
                if ((trainCourseList = this.trainingCourseProviderService.getNewTrainCourseList(new TrainingSearchParam(id))) == null) {
                    throw new ServiceException("\u57f9\u8bad\u8bfe\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Objects.equals(info.getTrainTarget(), TrainTargetEnum.UNIT.getValue())) {
                    if (info.getIsCurrency() == 0) {
                        info.getPersonCertificateList().stream().forEach(person -> FieldCheckUtils.checkEmptyFields((Object)person, (String[])new String[]{"validityDate", "awardUnit", "backgroundId"}));
                    } else {
                        info.getPersonCertificateList().stream().forEach(person -> FieldCheckUtils.checkEmptyFields((Object)person, (String[])new String[]{"validityDate", "backgroundId"}));
                    }
                } else {
                    info.getPersonCertificateList().stream().forEach(person -> FieldCheckUtils.checkEmptyFields((Object)person, (String[])new String[]{"awardUnit"}));
                }
            });
        }
        return this.trainingService.changeTrainingStatus(param);
    }

    public LayuiGridData<TrainingHomeVo> getTrainingHomeList(TrainHomeListParam param) {
        return this.trainingService.getTrainingHomeList(param);
    }

    public LayuiGridData<TrainingHomeListVo> getUntrainedList(TrainHomeListParam param) {
        return this.trainingService.getUntrainedList(param);
    }

    public LayuiGridData<TrainHomeCropVo> getCropTrainList(TrainHomeCropParam param) {
        return this.trainingService.getCropTrainList(param);
    }

    public List<TrainHomeCropExportVo> getCropTrainExportList(TrainHomeCropParam param) {
        return this.trainingService.getCropTrainExportList(param);
    }

    public LayuiGridData<RhoTrainHomeCropVo> getCropTrainListForRho(RhoTrainHomeCropParam param) {
        return this.trainingService.getCropTrainListForRho(param);
    }

    public LayuiGridData<TrainHomeUserVo> getUserTrainList(TrainHomeUserParam param) {
        return this.trainingService.getUserTrainList(param);
    }

    public List<TrainHomeCetVo> getUserCetList(TrainHomeCetParam param) {
        return this.trainingService.getUserCetList(param);
    }

    public List<TrainHomeUserExportVo> getUserTrainCetExportList(TrainHomeUserParam param) {
        return this.trainingService.getUserTrainCetExportList(param);
    }

    public Long addTrainingDetail(TrainingAddParam param) {
        int trainAreaLevel;
        if (param.getTrainArea() != null && (trainAreaLevel = StringUtils.getAreaLevel((Long)param.getTrainArea())) < param.getUserAreaLevel()) {
            throw new ServiceException("\u57f9\u8bad\u533a\u57df\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u8d26\u53f7\u533a\u57df\u8303\u56f4\uff01");
        }
        if (param.getIsCurrency() == 1 && !param.getIsSpecifiedUser().booleanValue()) {
            throw new ServiceException("\u5f53\u524d\u8d26\u53f7\u65e0\u6cd5\u521b\u5efa\u901a\u7528\u57f9\u8bad\uff01");
        }
        if (param.getIsCurrency() == 1 && param.getIsSpecifiedUser().booleanValue()) {
            param.getPersonTypeCertificateList().stream().forEach(personType -> personType.setAwardUnit(null));
        }
        if (param.getUserAreaLevel() >= 3 && param.getSendBelong() != null && (param.getSendBelong() != 0 || param.getSendBelong() != 3)) {
            param.setSendBelong(Integer.valueOf(0));
        }
        return this.trainingService.addTrainingDetail(param);
    }

    public Integer removeBatchTrainingInfo(TrainingDelParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"trainIdList"});
        return this.trainingService.removeBatchTrainingInfo(param);
    }

    public Long cloneTrainByTid(Long tid, Long userId, Boolean isSpecifiedUser, String version) {
        if (tid == null) {
            throw new ServiceException("\u53c2\u6570\u6709\u8bef\uff01\u64cd\u4f5c\u5931\u8d25");
        }
        return this.trainingService.cloneTrainByTid(tid, userId, isSpecifiedUser, version);
    }

    public LayuiGridData<TrainingListVo> getTrainingPageListForApi(TrainingSearchParam param) {
        return this.trainingService.getTrainingPageListForApi(param);
    }

    public TrainingBaseInfoVo getTrainingBaseInfo(TrainingSearchParam param) {
        return this.trainingService.getTrainingBaseInfo(param);
    }

    public Integer updateHseTrainArea() {
        return this.trainingService.updateHseTrainArea();
    }

    public void manuallySyncTrainInfo(Long tid) {
        if (tid == null) {
            return;
        }
        this.trainingService.manuallySyncTrainInfo(tid);
    }

    public LayuiGridData<RhoTrainHomeUserVo> getUserTrainListForRho(RhoTrainHomeUserParam param) {
        return this.trainingService.getUserTrainListForRho(param);
    }

    public LayuiGridData<AssoScoreListVo> listScoreForAssociation(AssoScoreListParam param) {
        return this.trainingService.listScoreForAssociation(param);
    }

    public LayuiGridData<ApiScoreSearchVo> searchScoreByUserForApi(PageParam param) {
        if (!org.springframework.util.StringUtils.hasLength((String)param.getKeyword())) {
            throw new ServiceException("\u8bf7\u8f93\u5165\u59d3\u540d\u6216\u624b\u673a\u53f7\uff01");
        }
        return this.trainingService.searchScoreByUserForApi(param);
    }

    public LayuiGridData<ApiScoreSearchVo> searchScoreByCompanyForApi(PageParam param) {
        if (!org.springframework.util.StringUtils.hasLength((String)param.getKeyword())) {
            throw new ServiceException("\u8bf7\u8f93\u5165\u7528\u4eba\u5355\u4f4d\u540d\u79f0\uff01");
        }
        return this.trainingService.searchScoreByCompanyForApi(param);
    }

    @Generated
    public TrainingProviderServiceImpl(ITrainingService trainingService, ITrainingWorkTypeService trainingWorkTypeService, ITrainingCourseProviderService trainingCourseProviderService) {
        this.trainingService = trainingService;
        this.trainingWorkTypeService = trainingWorkTypeService;
        this.trainingCourseProviderService = trainingCourseProviderService;
    }
}

