/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.training;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.param.training.AddNewTrainCourseGroupParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseGroupVo;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.stereotype.Service;

@Service
@DubboService
public class TrainingCourseProviderServiceImpl
implements ITrainingCourseProviderService {
    private final ITrainingCourseService trainingCourseService;
    private final ITrainingCourseGroupService trainingCourseGroupService;

    public LayuiGridData<TrainingNewCourseGroupVo> getNewTrainCourse(TrainingSearchParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"trainingId"});
        return this.trainingCourseService.getNewTrainCourse(param);
    }

    public List<TrainingNewCourseGroupVo> getNewTrainCourseList(TrainingSearchParam param) {
        return this.trainingCourseService.getNewTrainCourseList(param);
    }

    public void saveOrUpdateNewTrainCourse(AddNewTrainCourseGroupParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tid"});
        this.trainingCourseService.saveOrUpdateNewTrainCourse(param);
    }

    public TrainingCourse getPaperInfoByTid(Long tid) {
        return this.trainingCourseService.getPaperInfoByTid(tid);
    }

    public CourseItemVo getNewCourseInfo(Long courseId) {
        return this.trainingCourseService.getNewCourseInfo(courseId);
    }

    public String delTrainCourseRedis() {
        return this.trainingCourseService.delTrainCourseRedis();
    }

    public String modifyOldTrainCourseGroup() {
        return this.trainingCourseGroupService.modifyOldTrainCourseGroup();
    }

    public TrainingCourse getById(Long trainingCourseId) {
        return this.trainingCourseService.getDetailById(trainingCourseId);
    }

    public List<String> getCourseIdListByTid(Long tid) {
        return this.trainingCourseService.getCourseIdListByTid(tid);
    }

    public List<String> getRiskFactorListByTid(Long tid) {
        return this.trainingCourseService.getRiskFactorListByTid(tid);
    }

    public List<TrainingCourseGroupVo> getTrainingCourseGroupForApi(Long tid) {
        return this.trainingCourseGroupService.getTrainingCourseGroupForApi(tid);
    }

    public List<TrainingCourseVo> getTrainingCourseForApi(Long tid, Long courseGroupId) {
        return this.trainingCourseService.getTrainingCourseForApi(tid, courseGroupId);
    }

    @Generated
    public TrainingCourseProviderServiceImpl(ITrainingCourseService trainingCourseService, ITrainingCourseGroupService trainingCourseGroupService) {
        this.trainingCourseService = trainingCourseService;
        this.trainingCourseGroupService = trainingCourseGroupService;
    }
}

