/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.training;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.dto.ImportRaTuCertDto;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.training.RaTraining;
import cn.smarthse.radiationTraining.modules.training.param.course.SyncRaCertParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateEditParam;
import cn.smarthse.radiationTraining.modules.training.param.training.RaTuCertificateParam;
import cn.smarthse.radiationTraining.modules.training.provider.training.IRaTrainingProviderService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.IRaTuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.IRaTrainingService;
import cn.smarthse.radiationTraining.modules.training.task.cert.offline.CertOfflineService;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class RaTrainingProviderServiceImpl
implements IRaTrainingProviderService {
    private final IRaTrainingService raTrainingService;
    private final IRaTuCertificateService raTuCertificateService;
    private final CertOfflineService certOfflineService;
    @DubboReference
    private ISysAreaProvider areaProvider;

    public LayuiGridData<RaTraining> getTrainingList(RaTuCertificateParam param) {
        return this.raTrainingService.getList(param);
    }

    public LayuiGridData<RaTuCertificate> getCertList(RaTuCertificateParam param) {
        return this.raTuCertificateService.getCertList(param);
    }

    public RaTraining addRaTraining(RaTraining training) {
        return this.raTrainingService.addRaTraining(training);
    }

    public void submit(RaTuCertificateParam param) {
        this.raTrainingService.submit(param);
    }

    public void clearCertData(RaTuCertificateParam param) {
        this.raTuCertificateService.clearCertData(param);
    }

    public void importTrainAboutCert(List<ImportRaTuCertDto> list, Long loginUserId) {
        this.raTuCertificateService.importTrainAboutCert(list, loginUserId);
    }

    public RaTuCertificate getCertDetail(Long id) {
        return this.raTuCertificateService.getCertDetail(id);
    }

    public void saveCertDetail(RaTuCertificateEditParam param) {
        this.raTuCertificateService.saveCertDetail(param);
    }

    public void delTraining(Long id) {
        this.raTrainingService.delTraining(id);
    }

    public RaTraining getTrainingById(Long id) {
        RaTraining raTraining = (RaTraining)this.raTrainingService.getById(id);
        String fullAreaName = this.areaProvider.getAreaAddress(raTraining.getAreaId(), "");
        raTraining.setFullAddress(fullAreaName.concat(raTraining.getAddressDetail()));
        return raTraining;
    }

    public void syncCertData(SyncRaCertParam param) {
        if (param.getTid() == null) {
            throw new ServiceException("\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.certOfflineService.syncCertFileBytTid(param.getTid());
    }

    @Generated
    public RaTrainingProviderServiceImpl(IRaTrainingService raTrainingService, IRaTuCertificateService raTuCertificateService, CertOfflineService certOfflineService) {
        this.raTrainingService = raTrainingService;
        this.raTuCertificateService = raTuCertificateService;
        this.certOfflineService = certOfflineService;
    }
}

