/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.toT;

import cn.smarthse.modules.health.supervise.entity.trainPlan.PerTrainingInfoModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.SyncCertInfoModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainAttendModel;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainPlanUpdateModel;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.training.dto.TrainingContext;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.HSECompanyTrainStatusVo;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrainingSynService<SynE> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrainingSynService.class);
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;

    public void synTrainingBaseInfo(TrainingContext trainingContext) {
        if (trainingContext.getTraining() == null) {
            log.warn("\u540c\u6b65\u57f9\u8bad\u6570\u636e\uff0c\u6570\u636e\u4e3a\u7a7a\uff01");
            return;
        }
    }

    public String syncComapnyTrainStatus(List<HSECompanyTrainStatusVo> voList) {
        List<TrainPlanUpdateModel> trainPlanUpdateModels = this.toggleSyncTrainPlan(voList);
        return this.syncTrainInfoService.batchUpdateTrainPlan(trainPlanUpdateModels);
    }

    public String syncTrainAttendAndCertInfo(TrainingContext trainingContext, byte optType) {
        if (trainingContext == null) {
            log.warn("\u540c\u6b65\u7528\u6237\u57f9\u8bad\u7ed3\u679c\u6570\u636e\uff0c\u6570\u636e\u4e3a\u7a7a\uff01");
            return "\u540c\u6b65\u7528\u6237\u57f9\u8bad\u7ed3\u679c\u6570\u636e\uff0c\u6570\u636e\u4e3a\u7a7a\uff01";
        }
        TrainAttendModel trainAttendModel = this.toggleSyncTrainAttendAndCertInfo(trainingContext, optType);
        log.info("\u540c\u6b65\u7528\u6237\u8bc1\u4e66\u4fe1\u606ftu_certificate.id\uff1a{}, optType\uff1a{}, trainAttendModel\uff1a{}", new Object[]{trainingContext.getTuCertId(), optType, trainAttendModel});
        String s1 = this.syncTrainInfoService.addOrUpdateTrainAttendAndCertInfo(trainAttendModel);
        log.info("\u540c\u6b65\u7528\u6237\u8bc1\u4e66\u4fe1\u606ftu_certificate.id\uff1a{} msg:{}", (Object)trainingContext.getTuCertId(), (Object)s1);
        return s1;
    }

    public String perTrainingInfoDeleteAndRecovery(PerTrainingInfoModel model) {
        return this.syncTrainInfoService.perTrainingInfoDeleteAndRecovery(model);
    }

    public String addTrainInfoByCid(Long cid, Long trainId, Byte opStatus, Integer enrollSource) {
        if (cid == null || trainId == null) {
            log.warn("\u540c\u6b65\u5355\u4f4d\u62a5\u540d\u7684\u57f9\u8bad\u4fe1\u606f\uff0c\u6570\u636e\u4e3a\u7a7a\uff01");
            return "\u540c\u6b65\u5355\u4f4d\u62a5\u540d\u7684\u57f9\u8bad\u4fe1\u606f\uff0c\u6570\u636e\u4e3a\u7a7a\uff01";
        }
        int trainingSource = 3;
        int otherSource = 4;
        return this.syncTrainInfoService.addTrainInfoByCid(cid, trainId, opStatus, Byte.valueOf((byte)(enrollSource == null || enrollSource != 4 ? trainingSource : otherSource)));
    }

    public String syncObtainedCertificateNum(Long trainId, Integer num) {
        if (trainId == null || num == null) {
            log.warn("\u540c\u6b65\u7684\u5df2\u5168\u90e8\u53d6\u8bc1\u4f01\u4e1a\u6570\u76f8\u5173\u6570\u636e\u4e3a\u7a7a\uff01");
            return "\u540c\u6b65\u7684\u5df2\u5168\u90e8\u53d6\u8bc1\u4f01\u4e1a\u6570\u76f8\u5173\u6570\u636e\u4e3a\u7a7a\uff01";
        }
        String res = this.syncTrainInfoService.getCompanyTrainNumber(trainId, num);
        if (!StringUtils.isEmpty((CharSequence)res)) {
            log.warn(res);
        }
        return res;
    }

    private SyncCertInfoModel toggleSyncCertInfoModel(TrainingContext trainingContext) {
        SyncCertInfoModel synData = new SyncCertInfoModel();
        TuCertificate cert = trainingContext.getTuCertificate();
        synData.setTrainId(trainingContext.getTrainingId());
        synData.setStaffName(cert.getUname());
        synData.setIdCard(cert.getIdCard());
        synData.setCid(trainingContext.getTokenLong());
        synData.setCertType(TrainingPersonTypeEnum.getTcode((String)cert.getCertType()));
        synData.setCertNo(cert.getCertificateNo());
        synData.setCertCreateDate(cert.getIssueTime());
        synData.setValidityDate(cert.getInvalidDate());
        synData.setRepeatData(cert.getReviewDate());
        synData.setFileId(cert.getPdfUrl());
        synData.setTrainUserId(cert.getUid());
        return synData;
    }

    private TrainAttendModel toggleSyncTrainAttendAndCertInfo(TrainingContext trainingContext, byte optype) {
        TuCertificate cert = trainingContext.getTuCertificate();
        TuEnrollDetail tuEnrollDetail = trainingContext.getTuEnrollDetail();
        TrainAttendModel trainAttendModel = new TrainAttendModel();
        if (optype == 1) {
            Training training = trainingContext.getTraining();
            trainAttendModel.setOnlineTrainId(training.getId());
            trainAttendModel.setCid(trainingContext.getTokenLong());
            trainAttendModel.setIdCard(trainingContext.getTuEnrollDetail().getIdCard());
            trainAttendModel.setStaffName(trainingContext.getTuCertificate().getUname());
            trainAttendModel.setOperationType(Byte.valueOf(optype));
            trainAttendModel.setTrainUserId(trainingContext.getTuEnrollDetail().getUid());
            trainAttendModel.setNewCid(trainingContext.getTokenLong());
            trainAttendModel.setCertType(TrainingPersonTypeEnum.getTcode((String)cert.getCertType()));
            trainAttendModel.setCertNo(cert.getCertificateNo());
            trainAttendModel.setCertCreateDate(cert.getIssueTime());
            trainAttendModel.setValidityDate(cert.getInvalidDate());
            trainAttendModel.setRepeatData(cert.getInvalidDate());
            trainAttendModel.setValidityDate(cert.getInvalidDate());
            trainAttendModel.setFileId(cert.getPdfUrl());
            trainAttendModel.setMobile(tuEnrollDetail.getPhone());
            int trainingSource = 3;
            int otherSource = 4;
            trainAttendModel.setEnrollSource(Byte.valueOf((byte)(tuEnrollDetail.getEnrollSource() == null || tuEnrollDetail.getEnrollSource() != 4 ? trainingSource : otherSource)));
        } else {
            Training training = trainingContext.getTraining();
            trainAttendModel.setOnlineTrainId(training.getId());
            trainAttendModel.setCid(Long.valueOf(trainingContext.getOldToken()));
            trainAttendModel.setNewCid(trainingContext.getTokenLong());
            trainAttendModel.setOperationType(Byte.valueOf(optype));
            trainAttendModel.setTrainUserId(trainingContext.getTuEnrollDetail().getUid());
            trainAttendModel.setIdCard(trainingContext.getTuEnrollDetail().getIdCard());
            trainAttendModel.setStaffName(trainingContext.getTuCertificate().getUname());
        }
        return trainAttendModel;
    }

    private List<TrainPlanUpdateModel> toggleSyncTrainPlan(List<HSECompanyTrainStatusVo> voList) {
        ArrayList<TrainPlanUpdateModel> modelList = new ArrayList<TrainPlanUpdateModel>();
        for (HSECompanyTrainStatusVo vo : voList) {
            TrainPlanUpdateModel model = new TrainPlanUpdateModel();
            model.setCid(vo.getHseCompanyToken());
            model.setReportId(vo.getTid());
            model.setKeyPersonStatus(vo.getStatus1());
            model.setManagePersonStatus(vo.getStatus2());
            modelList.add(model);
        }
        return modelList;
    }

    @Generated
    public TrainingSynService() {
    }
}

