/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.course;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.provider.order.ISysOrderProviderService;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.param.course.TuCoursePageParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.RestoreStuRecordParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.UpdateDurationParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ITuCourseProviderService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseExamCountVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.TuCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class TuCourseProviderServiceImpl
implements ITuCourseProviderService {
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ICourseRedisService courseRedisService;
    @Autowired
    private ITrainingService trainingService;
    @DubboReference
    private ISysOrderProviderService sysOrderService;

    public TuCourse getById(Long tuCourseId) {
        return (TuCourse)this.tuCourseService.getById(tuCourseId);
    }

    public TuCourse getTuCourseInfoById(Long tuCourseId) {
        return this.tuCourseService.getRecordById(tuCourseId);
    }

    public TuCourse updateExamResult(Long tuCourseId, Integer resultValue, int passTimes, int score, Integer trainMode) {
        return this.tuCourseService.updateExamResult(tuCourseId, resultValue, passTimes, score, trainMode);
    }

    public void updateCentralizedExamResult(Long tuEnrollDetailId, Integer resultValue) {
        this.tuEnrollDetailService.updateCentralizedExamResult(tuEnrollDetailId, resultValue);
    }

    public TuCourse updateStuDuration(UpdateDurationParam param) {
        this.tuCourseService.updateStuDuration(param);
        return null;
    }

    public LayuiGridData<TuCourseVo> getTuCourseExamPageList(TuCoursePageParam pageParam) {
        return this.tuCourseService.getTuCourseExamPageList(pageParam);
    }

    public TuCourseExamCountVo getTuCourseExamCount(Long loginUserId, Long tid) {
        return this.tuCourseService.getTuCourseExamCount(loginUserId, tid);
    }

    public List<CourseGroupCatalogueVo> getCourseCataLogueForMajor(Long tid, Long enrollDetailId, Integer stuStatus, Long loginUserId) {
        return this.tuCourseService.getCourseCataLogueMajor(tid, enrollDetailId, stuStatus);
    }

    public List<CourseItemCatalogueVo> getCourseCataLogueForPrecise(Long enrollDetailId, Integer stuStatus) {
        return this.tuCourseService.getCourseCataLogueForPrecise(enrollDetailId, stuStatus);
    }

    public List<CourseItemCatalogueVo> getCourseCataLogueForOrg(Long tid, Long enrollDetailId, Integer stuStatus) {
        return this.tuCourseService.getCourseCataLogueForOrg(tid, enrollDetailId, stuStatus);
    }

    public void restoreSingleness(RestoreStuRecordParam param) {
        this.tuCourseService.restoreSingleness(param);
    }

    public void restoreAll(RestoreStuRecordParam param) {
        this.tuCourseService.restoreAll(param);
    }

    public List<CourseItemCatalogueVo> getFlunkedCourse(Long tid, Long detailId) {
        return this.tuCourseService.getFlunkedCourse(tid, detailId);
    }

    public void cleanStuiedRecord() {
        this.courseRedisService.cleanStuiedRecord();
    }

    public void syncEnrollInfo(Long id) {
        this.tuEnrollSyncTest(id);
    }

    public List<TuCourse> getTuCourseList(Long tid, Long uid) {
        return this.tuCourseService.getTuCourseList(tid, uid);
    }

    public List<String> getCourseIdListByTAU(Long tid, Long uid) {
        return this.tuCourseService.getCourseIdListByTAU(tid, uid);
    }

    public List<String> getRiskFactorListByTAU(Long tid, Long uid) {
        return this.tuCourseService.getRiskFactorListByTAU(tid, uid);
    }

    public void updateRedundency(Long tid, Long courseItemId) {
        this.tuCourseService.updateRedundency(tid, courseItemId);
    }

    public void checkOwner(Long enrollDetailId, Long tuCourseId, Long uid) {
        TrainingDetailVo trainingInfo;
        if (uid == null) {
            throw new ServiceException("\u7f3a\u5c11\u8d26\u53f7\u4fe1\u606f\uff0c\u65e0\u6cd5\u6821\u9a8c");
        }
        if (enrollDetailId != null) {
            TuEnrollDetail detail = (TuEnrollDetail)this.tuEnrollDetailService.getById(enrollDetailId);
            if (detail == null) {
                throw new ServiceException("\u62a5\u540d\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            if (detail.getUid() == null || !detail.getUid().equals(uid)) {
                throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u4ed6\u4eba\u5b66\u4e60\u4fe1\u606f");
            }
            if (detail != null && (trainingInfo = this.trainingService.getTrainingInfo(detail.getTid())) == null) {
                throw new ServiceException("\u57f9\u8bad\u4e0d\u5b58\u5728");
            }
        }
        if (tuCourseId != null) {
            TuCourse tuCourse = (TuCourse)this.tuCourseService.getById(tuCourseId);
            if (tuCourse == null) {
                throw new ServiceException("\u5b66\u4e60\u8bb0\u5f55\u4e0d\u5b58\u5728");
            }
            if (tuCourse.getUserId() == null || !tuCourse.getUserId().equals(uid)) {
                throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6\u4ed6\u4eba\u5b66\u4e60\u4fe1\u606f");
            }
        }
        TuEnrollDetail orderDetail = null;
        if (tuCourseId != null) {
            TuCourse course = (TuCourse)this.tuCourseService.getById(tuCourseId);
            orderDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(course.getEnrollDetailId());
        }
        if (orderDetail == null && enrollDetailId != null) {
            orderDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(enrollDetailId);
        }
        if (orderDetail != null && (trainingInfo = this.trainingService.getTrainingInfo(orderDetail.getTid())).getIsCharge() == 1 && !this.sysOrderService.checkPayedByBusinessId(orderDetail.getId())) {
            throw new ServiceException("\u57f9\u8bad\u672a\u4ed8\u6b3e");
        }
    }

    private void tuEnrollSyncTest(Long id) {
        TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(id);
    }

    @Generated
    public TuCourseProviderServiceImpl() {
    }
}

