/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.certificate;

import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.training.converter.TuCertConverter;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.RaTuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.param.TuCertificatePageParam;
import cn.smarthse.radiationTraining.modules.training.param.UpdateCertificateParam;
import cn.smarthse.radiationTraining.modules.training.param.training.MyCertificateParam;
import cn.smarthse.radiationTraining.modules.training.provider.certificate.ITuCertificateProviderService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.IRaTuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.task.CertService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.CertTrainVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.MyCertificateVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertListVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertQrVo;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertVo;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

@DubboService
public class TuCertificateProviderServiceImpl
implements ITuCertificateProviderService {
    private final ITuCertificateService certificateService;
    private final IRaTuCertificateService raTuCertificateService;
    private final CertService certService;
    private final TuCertConverter tuCertConverter;
    private final OssClientBean ossClientBean;

    public LayuiGridData<MyCertificateVo> getMyCertificateList(MyCertificateParam param) {
        return this.certificateService.getMyCertificateList(param);
    }

    public CertTrainVo getMyCertificateListCount(MyCertificateParam param) {
        return this.certificateService.getMyCertificateListCount(param);
    }

    public LayuiGridData<CertTrainVo> getHasCetTrainList(MyCertificateParam param) {
        return this.certificateService.getHasCetTrainList(param);
    }

    public List<MyCertificateVo> getTrainCetList(MyCertificateParam param) {
        return this.certificateService.getTrainCetList(param);
    }

    public void addCertificate(Long enrollDetailId) {
        if (this.certificateService.hasBaseCertificate(enrollDetailId).booleanValue()) {
            return;
        }
        this.certificateService.addCertificate(enrollDetailId);
    }

    public List<MyCertificateVo> getMyCertificateList(Long enrollDetailId) {
        List<MyCertificateVo> list = this.certificateService.getMyCertificateList(enrollDetailId);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        for (MyCertificateVo vo : list) {
            vo.setPdfUrl(this.ossClientBean.getUrl(vo.getPdfUrl()));
        }
        return list;
    }

    public TuCertVo getMyCertificateDetailById(Long id, Long uid) {
        TuCertVo tuCertVo = this.certificateService.getInfoById(id);
        if (tuCertVo == null) {
            return null;
        }
        if (!tuCertVo.getUid().equals(uid)) {
            return null;
        }
        tuCertVo.setPdfUrl(this.ossClientBean.getUrl(tuCertVo.getPdfUrl()));
        return tuCertVo;
    }

    public void saveCertificateFile(Long enrollDetailId, String pdfUrl, String imgUrl) {
        this.certificateService.saveCertificateFile(enrollDetailId, pdfUrl, imgUrl);
    }

    public TuCertificate upDateCertificateFile(UpdateCertificateParam updateCertificateVo) {
        return this.certificateService.upDateCertificateFile(updateCertificateVo);
    }

    public TuCertVo genCertFile(Long id) {
        return this.certService.genCert(id);
    }

    public void genCertFile() {
        this.certService.genCertFile();
    }

    public void SendCertificate(Long id) {
        this.certService.sendCertificate(id);
    }

    public TuCertQrVo getTuCertQrVo(Long certId) {
        TuCertQrVo result = this.tuCertConverter.tuCert2TuCertQrVo((TuCertificate)this.certificateService.getById(certId));
        if (result == null) {
            result = this.tuCertConverter.raCert2TuCertQrVo((RaTuCertificate)this.raTuCertificateService.getById(certId));
        }
        if (result != null) {
            result.setPdfUrl(this.ossClientBean.getUrl(result.getPdfUrl()));
        }
        return result;
    }

    public LayuiGridData<TuCertListVo> getList(TuCertificatePageParam param) {
        if (param.getCid() == null) {
            throw new ServiceException("\u53c2\u6570\u5f02\u5e38\uff01");
        }
        return this.certificateService.getList(param);
    }

    public void reSynceAllExceptionInfo() {
        this.certificateService.reSynceAllExceptionInfo();
    }

    public void syncSingleInfo(Long certId) {
        TuCertificate byId = (TuCertificate)this.certificateService.getById(certId);
        this.certificateService.syncSingleInfo(byId);
    }

    public void cleanCert(Long certId) {
        this.certificateService.cleanCert(certId);
    }

    @Generated
    public TuCertificateProviderServiceImpl(ITuCertificateService certificateService, IRaTuCertificateService raTuCertificateService, CertService certService, TuCertConverter tuCertConverter, OssClientBean ossClientBean) {
        this.certificateService = certificateService;
        this.raTuCertificateService = raTuCertificateService;
        this.certService = certService;
        this.tuCertConverter = tuCertConverter;
        this.ossClientBean = ossClientBean;
    }
}

