/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.converter;

import cn.smarthse.radiationTraining.modules.training.converter.TrainingCourseConverter;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainCourseUpdateParam;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingNewCourseVo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class TrainingCourseConverterImpl
implements TrainingCourseConverter {
    @Override
    public TrainingCourse updateParamToTrainingCourse(TrainCourseUpdateParam updateParam) {
        if (updateParam == null) {
            return null;
        }
        TrainingCourse trainingCourse = new TrainingCourse();
        trainingCourse.setTid(updateParam.getTrainingId());
        trainingCourse.setTrainCourseGroupId(updateParam.getTrainCourseGroupId());
        trainingCourse.setCourseId(updateParam.getCourseId());
        trainingCourse.setIsTest(updateParam.getIsTest());
        trainingCourse.setIsPass(updateParam.getIsPass());
        return trainingCourse;
    }

    @Override
    public List<TrainingCourse> newCourseVoListToEntityList(List<TrainingNewCourseVo> vo) {
        if (vo == null) {
            return null;
        }
        ArrayList<TrainingCourse> list = new ArrayList<TrainingCourse>(vo.size());
        for (TrainingNewCourseVo trainingNewCourseVo : vo) {
            list.add(this.trainingNewCourseVoToTrainingCourse(trainingNewCourseVo));
        }
        return list;
    }

    @Override
    public Set<TrainingCourse> addNewParamToEntity(Set<TrainingNewCourseVo> param) {
        if (param == null) {
            return null;
        }
        LinkedHashSet<TrainingCourse> set = new LinkedHashSet<TrainingCourse>(Math.max((int)((float)param.size() / 0.75f) + 1, 16));
        for (TrainingNewCourseVo trainingNewCourseVo : param) {
            set.add(this.trainingNewCourseVoToTrainingCourse(trainingNewCourseVo));
        }
        return set;
    }

    protected TrainingCourse trainingNewCourseVoToTrainingCourse(TrainingNewCourseVo trainingNewCourseVo) {
        if (trainingNewCourseVo == null) {
            return null;
        }
        TrainingCourse trainingCourse = new TrainingCourse();
        trainingCourse.setId(trainingNewCourseVo.getId());
        trainingCourse.setTid(trainingNewCourseVo.getTid());
        trainingCourse.setTrainCourseGroupId(trainingNewCourseVo.getTrainCourseGroupId());
        trainingCourse.setCourseGroupId(trainingNewCourseVo.getCourseGroupId());
        trainingCourse.setCourseId(trainingNewCourseVo.getCourseId());
        trainingCourse.setCourseIndex(trainingNewCourseVo.getCourseIndex());
        trainingCourse.setClassHour(trainingNewCourseVo.getClassHour());
        trainingCourse.setIsTest(trainingNewCourseVo.getIsTest());
        trainingCourse.setIsPass(trainingNewCourseVo.getIsPass());
        trainingCourse.setCourseDuration(trainingNewCourseVo.getCourseDuration());
        trainingCourse.setTestDuration(trainingNewCourseVo.getTestDuration());
        trainingCourse.setPassingScore(trainingNewCourseVo.getPassingScore());
        trainingCourse.setPaperStructureId(trainingNewCourseVo.getPaperStructureId());
        trainingCourse.setTotalScore(trainingNewCourseVo.getTotalScore());
        trainingCourse.setCourseName(trainingNewCourseVo.getCourseName());
        trainingCourse.setCourseType(trainingNewCourseVo.getCourseType());
        trainingCourse.setLecturer(trainingNewCourseVo.getLecturer());
        trainingCourse.setDescription(trainingNewCourseVo.getDescription());
        trainingCourse.setCoverId(trainingNewCourseVo.getCoverId());
        trainingCourse.setCoverUrl(trainingNewCourseVo.getCoverUrl());
        trainingCourse.setVideoDurationSec(trainingNewCourseVo.getVideoDurationSec());
        trainingCourse.setVideoUrl(trainingNewCourseVo.getVideoUrl());
        trainingCourse.setVideoId(trainingNewCourseVo.getVideoId());
        trainingCourse.setIndustry(trainingNewCourseVo.getIndustry());
        trainingCourse.setRiskFactor(trainingNewCourseVo.getRiskFactor());
        trainingCourse.setPersonTypeCode(trainingNewCourseVo.getPersonTypeCode());
        trainingCourse.setMajorStudyStatus(trainingNewCourseVo.getMajorStudyStatus());
        trainingCourse.setManagerStudyStatus(trainingNewCourseVo.getManagerStudyStatus());
        trainingCourse.setDeletable(trainingNewCourseVo.getDeletable());
        return trainingCourse;
    }
}

