/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.service.impl;

import cn.smarthse.radiationTraining.modules.wqxx.converter.SUserExamConverter;
import cn.smarthse.radiationTraining.modules.wqxx.converter.SUserExamQuestionConverter;
import cn.smarthse.radiationTraining.modules.wqxx.dao.SUserExamQuestionMapper;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserExam;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserExamQuestion;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserExamVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.question.SQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.answerExercise.AnswerQuestionParam;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserExamQuestionService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SUserExamQuestionServiceImpl
extends ServiceImpl<SUserExamQuestionMapper, SUserExamQuestion>
implements ISUserExamQuestionService {
    @Autowired(required=false)
    private SUserExamQuestionConverter userExamQuestionConverter;
    @Autowired(required=false)
    private SUserExamConverter userExamConverter;

    @Override
    public List<SUserQuestionVo> listQuestionByUserExamId(Long userExamId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SUserExamQuestion::getUserExamId, (Object)userExamId);
        List userExamQuestionList = this.list((Wrapper)wrapper);
        List rst = this.userExamQuestionConverter.entityList2VoList(userExamQuestionList);
        return rst;
    }

    @Override
    public List<SUserQuestionVo> genUserQuestion(SUserExamVo userExamVo, List<SQuestionVo> questionVoList) {
        List userExamQuestionList = this.userExamQuestionConverter.questionVoList2entityList(questionVoList);
        for (SUserExamQuestion userExamQuestion : userExamQuestionList) {
            userExamQuestion.setId(null);
            userExamQuestion.setUserExamId(userExamVo.getId());
            userExamQuestion.setUserId(userExamVo.getUserId());
            userExamQuestion.setScore(Integer.valueOf(0));
        }
        this.saveBatch(userExamQuestionList);
        return this.userExamQuestionConverter.entityList2VoList(userExamQuestionList);
    }

    @Override
    public List<SUserExamQuestion> submitUserQuestion(SUserExam userExam, List<AnswerQuestionParam> answerList) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SUserExamQuestion::getUserExamId, (Object)userExam.getId());
        List userQuestionList = this.list((Wrapper)wrapper);
        for (AnswerQuestionParam answerParam : answerList) {
            SUserExamQuestion userQuestion = (SUserExamQuestion)userQuestionList.stream().filter(v -> v.getId().equals(answerParam.getId())).collect(Collectors.toList()).get(0);
            if (userQuestion.getUserAnswer() != null && !userQuestion.getUserAnswer().equals("") || answerParam.getUserAnswer() == null || answerParam.getUserAnswer().equals("")) continue;
            userQuestion.setUserAnswer(answerParam.getUserAnswer());
            String rightAnswer = userQuestion.getAnswer();
            String userAnswer = answerParam.getUserAnswer();
            if (userQuestion.getType() == 1 || userQuestion.getType() == 2) {
                rightAnswer = Stream.of(userQuestion.getAnswer().replaceAll("[^(A-Za-z)]", "").split("")).sorted(Comparator.comparingInt(o -> Character.toLowerCase(o.charAt(0)))).collect(Collectors.joining()).toUpperCase();
                userAnswer = Stream.of(userQuestion.getUserAnswer().replaceAll("[^(A-Za-z)]", "").split("")).sorted(Comparator.comparingInt(o -> Character.toLowerCase(o.charAt(0)))).collect(Collectors.joining()).toUpperCase();
            }
            if (rightAnswer.equals(userAnswer)) {
                userQuestion.setResult(Boolean.valueOf(true));
                userQuestion.setScore(Integer.valueOf(1));
                continue;
            }
            userQuestion.setResult(Boolean.valueOf(false));
            userQuestion.setScore(Integer.valueOf(0));
        }
        this.updateBatchById(userQuestionList);
        return userQuestionList;
    }

    @Override
    public void genUserQuestionForTask(List<SUserExam> userExamList, List<SQuestionVo> questionVoList) {
        List userExamQuestionList = this.userExamQuestionConverter.questionVoList2entityList(questionVoList);
        for (SUserExam userExam : userExamList) {
            for (SUserExamQuestion userExamQuestion : userExamQuestionList) {
                userExamQuestion.setId(Long.valueOf(IdWorker.getId((Object)userExamQuestion)));
                userExamQuestion.setUserExamId(userExam.getId());
                userExamQuestion.setUserId(userExam.getUserId());
                userExamQuestion.setResult(Boolean.valueOf(false));
                userExamQuestion.setScore(Integer.valueOf(0));
            }
            this.saveBatch(userExamQuestionList);
        }
    }
}

