/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.question.enums.QuestionTypeEnum;
import cn.smarthse.radiationTraining.modules.wqxx.converter.SQuestionConverter;
import cn.smarthse.radiationTraining.modules.wqxx.dao.SQuestionMapper;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SQuestion;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.question.SQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.ImportSQuestionData;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionEditParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionListAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISQuestionService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class SQuestionServiceImpl
extends ServiceImpl<SQuestionMapper, SQuestion>
implements ISQuestionService {
    @Autowired(required=false)
    private SQuestionConverter converter;

    @Override
    @Transactional
    public void addForAdmin(SQuestionEditParam param) {
        SQuestion question = this.converter.editParam2Entity(param);
        question.setCreateBy(param.getLoginUserId());
        question.setUpdateBy(param.getLoginUserId());
        this.save(question);
    }

    @Override
    @Transactional
    public void editForAdmin(SQuestionEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SQuestion question = this.converter.editParam2Entity(param);
        question.setUpdateBy(param.getLoginUserId());
        this.updateById(question);
    }

    @Override
    @Transactional
    public void delBatchForAdmin(SQuestionBatchAdminParam param) {
        if (CollectionUtil.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UpdateWrapper wrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.lambda().set(SQuestion::getUpdateBy, (Object)param.getLoginUserId())).in(SQuestion::getId, (Collection)param.getIdList());
        this.update((Wrapper)wrapper);
        this.removeByIds(param.getIdList());
    }

    @Override
    @Transactional
    public void upOrDownBatchForAdmin(SQuestionBatchAdminParam param) {
        if (CollectionUtil.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getOptType() == null || param.getOptType() != 0 && param.getOptType() != 2) {
            throw new ServiceException("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        Integer state = param.getOptType() == 0 ? 0 : 2;
        UpdateWrapper wrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.lambda().set(SQuestion::getUpdateBy, (Object)param.getLoginUserId())).set(SQuestion::getState, (Object)state)).in(SQuestion::getId, (Collection)param.getIdList());
        this.update((Wrapper)wrapper);
    }

    @Override
    public LayuiGridData<SQuestionVo> listForAdmin(SQuestionListAdminParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SQuestionMapper)this.baseMapper).listForAdmin(param), (LayuiGridParam)param);
    }

    @Override
    public SQuestionVo getDetailForAdmin(Long id) {
        return ((SQuestionMapper)this.baseMapper).getDetailForAdmin(id);
    }

    @Override
    public List<SQuestionVo> randomAcquisitionForAdmin() {
        return ((SQuestionMapper)this.baseMapper).randomAcquisitionForAdmin();
    }

    @Override
    @Transactional
    public List<String> importQuestion(List<ImportSQuestionData> list) {
        List<SQuestion> entityList = this.converter.importDataList2EntityList(list);
        List<String> errList = this.checkImportData(entityList = this.dealImportData(entityList));
        if (!CollectionUtils.isEmpty(errList)) {
            throw new ServiceException(Integer.valueOf(-1), "\u5bfc\u5165\u5931\u8d25\uff01", errList);
        }
        this.saveBatch(entityList);
        return null;
    }

    private List<SQuestion> dealImportData(List<SQuestion> questions) {
        for (SQuestion question : questions) {
            String answer;
            if (question.getType().equals(QuestionTypeEnum.SINGLE_CHOICE.getValue())) {
                answer = StringUtils.getLetter((String)question.getAnswer());
                question.setAnswer(answer);
            }
            if (question.getType().equals(QuestionTypeEnum.MULTIPLE_CHOICE.getValue())) {
                answer = StringUtils.getLetter((String)question.getAnswer());
                answer = StringUtils.join(Arrays.asList(answer.split("")), (String)",");
                question.setAnswer(answer);
            }
            if (!question.getType().equals(QuestionTypeEnum.JUDGE.getValue())) continue;
            question.setOptionA("\u6b63\u786e");
            question.setOptionB("\u9519\u8bef");
        }
        return questions;
    }

    private List<String> checkImportData(List<SQuestion> dataList) {
        ArrayList<String> msgList = new ArrayList<String>();
        for (int i = 0; i < dataList.size(); ++i) {
            SQuestion question = dataList.get(i);
            if (question.getType().equals(QuestionTypeEnum.SINGLE_CHOICE.getValue())) {
                msgList.addAll(this.checkSingleImportData(question, i));
                continue;
            }
            if (question.getType().equals(QuestionTypeEnum.MULTIPLE_CHOICE.getValue())) {
                msgList.addAll(this.checkMultipleImportData(question, i));
                continue;
            }
            if (question.getType().equals(QuestionTypeEnum.COMPLETION.getValue())) {
                msgList.addAll(this.checkCompletionImportData(question, i));
                continue;
            }
            if (!question.getType().equals(QuestionTypeEnum.JUDGE.getValue())) continue;
            msgList.addAll(this.checkJudgeImportData(question, i));
        }
        return msgList;
    }

    private List<String> checkCommonImportData(SQuestion question, Integer rowIndex) {
        ArrayList<String> msgList = new ArrayList<String>();
        if (StrUtil.isEmpty((CharSequence)question.getStem())) {
            msgList.add(String.format("\u7b2c%s\u884c \u9898\u5e72 \u4e3a\u7a7a\uff01", rowIndex));
        }
        if (StrUtil.isEmpty((CharSequence)question.getAnswer())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848 \u4e3a\u7a7a\uff01", rowIndex));
        }
        if (StrUtil.isEmpty((CharSequence)question.getAnalysis())) {
            msgList.add(String.format("\u7b2c%s\u884c \u89e3\u6790 \u4e3a\u7a7a\uff01", rowIndex));
        }
        return msgList;
    }

    private List<String> checkSingleImportData(SQuestion question, Integer rowIndex) {
        List<String> msgList = this.checkCommonImportData(question, rowIndex);
        if (StrUtil.isEmpty((CharSequence)question.getAnswer())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848 \u4e3a\u7a7a\uff01", rowIndex));
        } else if (question.getAnswer().length() > 1) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u4e0e\u9898\u578b\u4e0d\u7b26\u7b54\u6848\u4e0e\u9898\u578b\u4e0d\u7b26\uff01", rowIndex));
        } else if (question.getAnswer().equals("A") && StrUtil.isEmpty((CharSequence)question.getOptionA())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879A \u4e3a\u7a7a\uff01", rowIndex));
        } else if (question.getAnswer().equals("B") && StrUtil.isEmpty((CharSequence)question.getOptionB())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879B \u4e3a\u7a7a\uff01", rowIndex));
        } else if (question.getAnswer().equals("C") && StrUtil.isEmpty((CharSequence)question.getOptionC())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879C \u4e3a\u7a7a\uff01", rowIndex));
        } else if (question.getAnswer().equals("D") && StrUtil.isEmpty((CharSequence)question.getOptionD())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879D \u4e3a\u7a7a\uff01", rowIndex));
        } else if (question.getAnswer().equals("E") && StrUtil.isEmpty((CharSequence)question.getOptionE())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879E \u4e3a\u7a7a\uff01", rowIndex));
        } else if (question.getAnswer().equals("F") && StrUtil.isEmpty((CharSequence)question.getOptionF())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879F \u4e3a\u7a7a\uff01", rowIndex));
        } else if (question.getAnswer().equals("G") && StrUtil.isEmpty((CharSequence)question.getOptionG())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879G \u4e3a\u7a7a\uff01", rowIndex));
        }
        return msgList;
    }

    private List<String> checkMultipleImportData(SQuestion question, Integer rowIndex) {
        List<String> msgList = this.checkCommonImportData(question, rowIndex);
        if (StrUtil.isEmpty((CharSequence)question.getAnswer())) {
            msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848 \u4e3a\u7a7a\uff01", rowIndex));
        } else {
            if (question.getAnswer().contains("A") && StrUtil.isEmpty((CharSequence)question.getOptionA())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879A \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (question.getAnswer().contains("B") && StrUtil.isEmpty((CharSequence)question.getOptionB())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879B \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (question.getAnswer().contains("C") && StrUtil.isEmpty((CharSequence)question.getOptionC())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879C \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (question.getAnswer().contains("D") && StrUtil.isEmpty((CharSequence)question.getOptionD())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879D \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (question.getAnswer().contains("E") && StrUtil.isEmpty((CharSequence)question.getOptionE())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879E \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (question.getAnswer().contains("F") && StrUtil.isEmpty((CharSequence)question.getOptionF())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879F \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (question.getAnswer().contains("G") && StrUtil.isEmpty((CharSequence)question.getOptionG())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879G \u4e3a\u7a7a\uff01", rowIndex));
            }
        }
        return msgList;
    }

    private List<String> checkCompletionImportData(SQuestion question, Integer rowIndex) {
        List<String> msgList = this.checkCommonImportData(question, rowIndex);
        return msgList;
    }

    private List<String> checkJudgeImportData(SQuestion question, Integer rowIndex) {
        List<String> msgList = this.checkCommonImportData(question, rowIndex);
        return msgList;
    }
}

