/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.wqxx.converter.SExamConverter;
import cn.smarthse.radiationTraining.modules.wqxx.dao.SExamMapper;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SExam;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SExamQuestion;
import cn.smarthse.radiationTraining.modules.wqxx.enums.ExamTypeEnum;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.exam.ExamVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.question.SQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.SExam.SExamBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SExam.SExamEditAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SExam.SExamListAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISExamQuestionService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISExamService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISQuestionService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SExamServiceImpl
extends ServiceImpl<SExamMapper, SExam>
implements ISExamService {
    @Autowired
    private ISExamQuestionService sExamQuestionService;
    @Autowired
    private ISQuestionService sQuestionService;
    @Autowired(required=false)
    private SExamConverter converter;

    @Override
    @Transactional
    public void addForAdmin(SExamEditAdminParam param) {
        SExam sExam = this.converter.editParam2Entity(param);
        sExam.setReleaseDate(new Date());
        sExam.setReleaser(param.getLoginUsername());
        sExam.setReleaseBy(param.getLoginUserId());
        sExam.setCreateBy(param.getLoginUserId());
        sExam.setUpdateBy(param.getLoginUserId());
        sExam.setYear(null);
        sExam.setWeek(null);
        this.save(sExam);
        if (sExam.getId() == null) {
            throw new ServiceException("\u672a\u77e5\u5f02\u5e38");
        }
        if (!CollectionUtil.isEmpty((Collection)param.getQuestionIdList())) {
            ArrayList<SExamQuestion> subList = new ArrayList<SExamQuestion>();
            for (int i = 0; i < param.getQuestionIdList().size(); ++i) {
                Long qid = (Long)param.getQuestionIdList().get(i);
                SExamQuestion subEntity = new SExamQuestion();
                subEntity.setExamId(sExam.getId());
                subEntity.setQuestionId(qid);
                subEntity.setSort(Integer.valueOf(i));
                subEntity.setCreateBy(param.getLoginUserId());
                subEntity.setUpdateBy(param.getLoginUserId());
                subList.add(subEntity);
            }
            this.sExamQuestionService.saveBatch(subList);
        }
    }

    @Override
    @Transactional
    public void randomGeneration() {
        Date current = new Date();
        int year = DateUtil.year((Date)current);
        int week = DateUtil.weekOfYear((Date)current);
        String beginOfCurrentWork = DateUtil.beginOfWeek((Date)current).toString("yyyyMMdd");
        String endOfCurrentWork = DateUtil.endOfWeek((Date)current).toString("yyyyMMdd");
        List<SExam> sExamDBList = this.getByYearAndWeek(year, week);
        if (!CollectionUtil.isEmpty(sExamDBList)) {
            throw new ServiceException("\u672c\u5468\u7b54\u9898\u5df2\u7ecf\u751f\u6210\u65e0\u9700\u518d\u6b21\u751f\u6210");
        }
        SExam sExam = new SExam();
        sExam.setName(beginOfCurrentWork + "-" + endOfCurrentWork);
        sExam.setType(Integer.valueOf(ExamTypeEnum.WEEKLY_EXAM.getValue()));
        sExam.setStatus(Integer.valueOf(1));
        sExam.setYear(Integer.valueOf(year));
        sExam.setWeek(Integer.valueOf(week));
        sExam.setReleaseDate(current);
        sExam.setReleaser("\u7cfb\u7edf\u81ea\u52a8\u751f\u6210");
        this.save(sExam);
        List<SQuestionVo> sQuestionVoList = this.sQuestionService.randomAcquisitionForAdmin();
        if (sQuestionVoList.size() < 5) {
            throw new ServiceException("\u9898\u5e93\u6570\u91cf\u4e0d\u591f");
        }
        ArrayList<SExamQuestion> subList = new ArrayList<SExamQuestion>();
        for (int i = 0; i < sQuestionVoList.size(); ++i) {
            Long qid = sQuestionVoList.get(i).getId();
            SExamQuestion subEntity = new SExamQuestion();
            subEntity.setExamId(sExam.getId());
            subEntity.setQuestionId(qid);
            subEntity.setSort(Integer.valueOf(i));
            subList.add(subEntity);
        }
        this.sExamQuestionService.saveBatch(subList);
    }

    @Override
    @Transactional
    public void editForAdmin(SExamEditAdminParam param) {
        if (param.getId() == null) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SExam db = (SExam)this.getById(param.getId());
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        SExam sExam = this.converter.editParam2Entity(param);
        sExam.setYear(null);
        sExam.setWeek(null);
        sExam.setUpdateBy(param.getLoginUserId());
        this.updateById(sExam);
        if (sExam.getId() == null) {
            throw new ServiceException("\u672a\u77e5\u5f02\u5e38");
        }
        if (!CollectionUtil.isEmpty((Collection)param.getQuestionIdList())) {
            this.sExamQuestionService.delByExamId(param.getId());
            ArrayList<SExamQuestion> subList = new ArrayList<SExamQuestion>();
            for (int i = 0; i < param.getQuestionIdList().size(); ++i) {
                Long qid = (Long)param.getQuestionIdList().get(i);
                SExamQuestion subEntity = new SExamQuestion();
                subEntity.setExamId(sExam.getId());
                subEntity.setQuestionId(qid);
                subEntity.setSort(Integer.valueOf(i));
                subEntity.setCreateBy(param.getLoginUserId());
                subEntity.setUpdateBy(param.getLoginUserId());
                subList.add(subEntity);
            }
            this.sExamQuestionService.saveBatch(subList);
        }
    }

    @Override
    public LayuiGridData<ExamVo> listForAdmin(SExamListAdminParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((SExamMapper)this.baseMapper).listForAdmin(param), (LayuiGridParam)param);
    }

    @Override
    public ExamVo getDetailForAdmin(Long id) {
        ExamVo vo = ((SExamMapper)this.baseMapper).getDetailForAdmin(id);
        List<SQuestionVo> sQuestionVoList = this.sExamQuestionService.getByExamId(id);
        vo.setSQuestionVoList(sQuestionVoList);
        return vo;
    }

    @Override
    @Transactional
    public void delBatchForAdmin(SExamBatchAdminParam param) {
        if (CollectionUtil.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.sExamQuestionService.delByExamIds(param.getIdList());
        UpdateWrapper wrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.lambda().set(SExam::getUpdateBy, (Object)param.getLoginUserId())).in(SExam::getId, (Collection)param.getIdList());
        this.update((Wrapper)wrapper);
        this.removeByIds(param.getIdList());
    }

    @Override
    @Transactional
    public void upOrDownBatchForAdmin(SExamBatchAdminParam param) {
        if (CollectionUtil.isEmpty((Collection)param.getIdList())) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getOptType() == null || param.getOptType() != 1 && param.getOptType() != 2) {
            throw new ServiceException("\u64cd\u4f5c\u7c7b\u578b\u9519\u8bef");
        }
        Integer state = param.getOptType() == 1 ? 1 : 2;
        UpdateWrapper wrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.lambda().set(SExam::getUpdateBy, (Object)param.getLoginUserId())).set(SExam::getStatus, (Object)state)).in(SExam::getId, (Collection)param.getIdList());
        this.update((Wrapper)wrapper);
    }

    @Override
    public List<SExam> getByYearAndWeek(int year, int week) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(SExam::getYear, (Object)year)).eq(SExam::getWeek, (Object)week);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public SExam getWeeklyExamByYearAndWeek(int year, int week) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(SExam::getYear, (Object)year)).eq(SExam::getWeek, (Object)week)).orderByDesc(SExam::getCreateDate)).last("limit 1");
        return (SExam)this.getOne((Wrapper)wrapper);
    }
}

