/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.wqxx.provider.answerExercise;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.question.enums.QuestionTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.wqxx.converter.SUserExamConverter;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SExam;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserExam;
import cn.smarthse.radiationTraining.modules.wqxx.entity.SUserExamQuestion;
import cn.smarthse.radiationTraining.modules.wqxx.enums.UserExamStateEnum;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserExamQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserExamVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.question.SQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.answerExercise.ObtainExamQuestionParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.answerExercise.SubmitAnswerQuestionParam;
import cn.smarthse.radiationTraining.modules.wqxx.provider.answerExercise.IAnswerExerciseProviderService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISExamQuestionService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISExamService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserExamQuestionService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserExamService;
import cn.smarthse.radiationTraining.modules.wqxx.service.ISUserIntegralLogService;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class IAnswerExerciseProviderServiceImpl
implements IAnswerExerciseProviderService {
    @Autowired
    private ISUserExamService userExamService;
    @Autowired
    private ISUserExamQuestionService userExamQuestionService;
    @Autowired
    private ISExamService examService;
    @Autowired
    private ISExamQuestionService examQuestionService;
    @Autowired(required=false)
    private SUserExamConverter userExamConverter;
    @Autowired
    private ISUserIntegralLogService userIntegralLogService;
    @Autowired
    private IUserProviderService userProviderService;

    public LayuiGridData<SUserExamVo> listWeekExam(ObtainExamQuestionParam param) {
        return this.userExamService.listWeekExam(param);
    }

    public SUserExamQuestionVo obtainWeekQuestions(ObtainExamQuestionParam param) {
        SUserExamVo userExamVo = this.userExamService.searchWeekUserExam(param);
        SUserExamQuestionVo rst = new SUserExamQuestionVo(userExamVo);
        if (userExamVo.getIsNewCreate().booleanValue()) {
            List<SUserQuestionVo> userQuestionVoList = this.userExamQuestionService.genUserQuestion(userExamVo, this.examQuestionService.getByExamId(param.getExamId()));
            for (SUserQuestionVo question : userQuestionVoList) {
                if (question.getType() == QuestionTypeEnum.COMPLETION.getValue()) continue;
                question.setAnswer(null);
                question.setAnalysis(null);
            }
            rst.setUserQuestionVoList(userQuestionVoList);
        } else {
            List<SUserQuestionVo> userQuestionVoList = this.userExamQuestionService.listQuestionByUserExamId(userExamVo.getId());
            if (userExamVo.getStatus().intValue() == UserExamStateEnum.INCOMPLETE.getValue()) {
                for (SUserQuestionVo question : userQuestionVoList) {
                    if (question.getType() == QuestionTypeEnum.COMPLETION.getValue()) continue;
                    question.setAnswer(null);
                    question.setAnalysis(null);
                }
            }
            rst.setUserQuestionVoList(userQuestionVoList);
        }
        return rst;
    }

    public SUserExamVo submitWeekQuestions(SubmitAnswerQuestionParam param) {
        SUserExam userExam = (SUserExam)this.userExamService.getById(param.getUserExamId());
        if (userExam.getStatus().intValue() == UserExamStateEnum.DONE.getValue()) {
            return this.userExamConverter.entity2Vo(userExam);
        }
        List<SUserExamQuestion> userQuestionList = this.userExamQuestionService.submitUserQuestion(userExam, param.getAnswerQuestionParamList());
        int rightNum = 0;
        int incorrectNum = 0;
        int score = 0;
        boolean hasDone = true;
        for (SUserExamQuestion userQuestion : userQuestionList) {
            if (userQuestion.getUserAnswer() == null || userQuestion.getUserAnswer().equals("")) {
                hasDone = false;
            }
            if (userQuestion.getResult().booleanValue()) {
                ++rightNum;
                ++score;
                continue;
            }
            ++incorrectNum;
        }
        userExam.setStatus(Integer.valueOf(hasDone ? UserExamStateEnum.DONE.getValue() : UserExamStateEnum.INCOMPLETE.getValue()));
        userExam.setTotalScore(Integer.valueOf(score));
        userExam.setRightNum(Integer.valueOf(rightNum));
        userExam.setIncorrectNum(Integer.valueOf(incorrectNum));
        this.userExamService.updateById(userExam);
        boolean hasGetScore = this.userExamService.judgeScoreStatusByExamType(userExam);
        if (!hasGetScore && userExam.getStatus().intValue() == UserExamStateEnum.DONE.getValue()) {
            Integer integer = this.userIntegralLogService.addIntegralByExam(userExam, param);
            userExam.setTotalScore(integer);
            userExam.setScoreStatus(Integer.valueOf(2));
            this.userExamService.updateById(userExam);
        }
        SUserExamVo rst = this.userExamConverter.entity2Vo(userExam);
        return rst;
    }

    public LayuiGridData<SUserExamVo> listSpecialExam(ObtainExamQuestionParam param) {
        return this.userExamService.listSpecialExam(param);
    }

    public SUserExamQuestionVo obtainSpecialQuestions(ObtainExamQuestionParam param) {
        SUserExamVo userExamVo = this.userExamService.searchSpecialUserExam(param);
        SUserExamQuestionVo rst = new SUserExamQuestionVo(userExamVo);
        if (userExamVo.getIsNewCreate().booleanValue()) {
            List<SUserQuestionVo> userQuestionVoList = this.userExamQuestionService.genUserQuestion(userExamVo, this.examQuestionService.getByExamId(param.getExamId()));
            for (SUserQuestionVo question : userQuestionVoList) {
                if (question.getType() == QuestionTypeEnum.COMPLETION.getValue()) continue;
                question.setAnswer(null);
                question.setAnalysis(null);
            }
            rst.setUserQuestionVoList(userQuestionVoList);
        } else {
            List<SUserQuestionVo> userQuestionVoList = this.userExamQuestionService.listQuestionByUserExamId(userExamVo.getId());
            if (userExamVo.getStatus().intValue() == UserExamStateEnum.INCOMPLETE.getValue()) {
                for (SUserQuestionVo question : userQuestionVoList) {
                    if (question.getType() == QuestionTypeEnum.COMPLETION.getValue()) continue;
                    question.setAnswer(null);
                    question.setAnalysis(null);
                }
            }
            rst.setUserQuestionVoList(userQuestionVoList);
        }
        return rst;
    }

    public SUserExamVo submitSpecialQuestions(SubmitAnswerQuestionParam param) {
        SUserExam userExam = (SUserExam)this.userExamService.getById(param.getUserExamId());
        if (userExam.getStatus().intValue() == UserExamStateEnum.DONE.getValue()) {
            return this.userExamConverter.entity2Vo(userExam);
        }
        List<SUserExamQuestion> userQuestionList = this.userExamQuestionService.submitUserQuestion(userExam, param.getAnswerQuestionParamList());
        int rightNum = 0;
        int incorrectNum = 0;
        int score = 0;
        boolean hasDone = true;
        for (SUserExamQuestion userQuestion : userQuestionList) {
            if (userQuestion.getUserAnswer() == null) {
                hasDone = false;
            }
            if (userQuestion.getResult().booleanValue()) {
                ++rightNum;
                score += userQuestion.getScore().intValue();
                continue;
            }
            ++incorrectNum;
        }
        userExam.setStatus(Integer.valueOf(hasDone ? 2 : 1));
        userExam.setTotalScore(Integer.valueOf(score));
        userExam.setRightNum(Integer.valueOf(rightNum));
        userExam.setIncorrectNum(Integer.valueOf(incorrectNum));
        this.userExamService.updateById(userExam);
        boolean hasGetScore = this.userExamService.judgeScoreStatusByExamType(userExam);
        if (!hasGetScore && userExam.getStatus().intValue() == UserExamStateEnum.DONE.getValue()) {
            Integer integer = this.userIntegralLogService.addIntegralByExam(userExam, param);
            userExam.setScoreStatus(Integer.valueOf(2));
            userExam.setTotalScore(integer);
            this.userExamService.updateById(userExam);
        }
        SUserExamVo rst = this.userExamConverter.entity2Vo(userExam);
        return rst;
    }

    public SUserExamQuestionVo obtainChallengeQuestions(ObtainExamQuestionParam param) {
        SUserExamVo userExamVo = this.userExamService.genUserExam(param);
        List<Long> gennedQuestionIdList = this.userExamQuestionService.listQuestionByUserExamId(param.getUserExamId()).stream().map(SUserQuestionVo::getQuestionId).collect(Collectors.toList());
        List<SQuestionVo> questionForChallenge = this.examQuestionService.getQuestionForChallenge(gennedQuestionIdList);
        List<SUserQuestionVo> userQuestionList = this.userExamQuestionService.genUserQuestion(userExamVo, questionForChallenge);
        SUserExamQuestionVo rst = new SUserExamQuestionVo();
        rst.setUserExamVo(userExamVo);
        rst.setUserQuestionVoList(userQuestionList);
        return rst;
    }

    public SUserExamVo submitChallengeQuestions(SubmitAnswerQuestionParam param) {
        SUserExam userExam = (SUserExam)this.userExamService.getById(param.getUserExamId());
        List<SUserExamQuestion> userQuestionList = this.userExamQuestionService.submitUserQuestion(userExam, param.getAnswerQuestionParamList());
        int rightNum = 0;
        int incorrectNum = 0;
        int score = 0;
        for (SUserExamQuestion userQuestion : userQuestionList) {
            if (userQuestion.getUserAnswer() == null || userQuestion.getUserAnswer().equals("") || !userQuestion.getResult().booleanValue()) break;
            if (userQuestion.getResult().booleanValue()) {
                ++rightNum;
                score += userQuestion.getScore().intValue();
                continue;
            }
            ++incorrectNum;
        }
        userExam.setStatus(Integer.valueOf(UserExamStateEnum.DONE.getValue()));
        userExam.setTotalScore(Integer.valueOf(score));
        userExam.setRightNum(Integer.valueOf(rightNum));
        userExam.setIncorrectNum(Integer.valueOf(incorrectNum));
        this.userExamService.updateById(userExam);
        boolean hasGetScore = this.userExamService.judgeScoreStatusByExamType(userExam);
        if (!hasGetScore && userExam.getTotalScore() > 0) {
            Integer integer = this.userIntegralLogService.addIntegralByExam(userExam, param);
            userExam.setScoreStatus(Integer.valueOf(2));
            userExam.setTotalScore(integer);
            this.userExamService.updateById(userExam);
        } else {
            userExam.setTotalScore(Integer.valueOf(0));
        }
        SUserExamVo rst = this.userExamConverter.entity2Vo(userExam);
        rst.setHasPeaked(Boolean.valueOf(this.userExamService.judgeScoreStatusByExamType(userExam)));
        return rst;
    }

    @Transactional
    public void handleUnexaminedPaper(String param) {
        Long examId;
        if (param != null && !param.equals("")) {
            examId = Long.parseLong(param);
        } else {
            SExam exam = this.examService.getWeeklyExamByYearAndWeek(DateUtil.year((Date)new Date()), DateUtil.weekOfYear((Date)new Date()) - 1);
            examId = exam.getId();
        }
        List allUserIdList = this.userProviderService.listAllWxUserId();
        allUserIdList.removeAll(this.userExamService.listUserIdByWeeklyExamIdAndStatus(examId, UserExamStateEnum.DONE.getValue()));
        allUserIdList.removeAll(this.handleTestingExamAndScore(examId));
        this.handleUnTestExamAndScore(examId, allUserIdList);
    }

    private List<Long> handleTestingExamAndScore(Long examId) {
        List<SUserExam> userExamList = this.userExamService.handleTestingUserExam(examId);
        userExamList.stream().forEach(userExam -> {
            int rightNum = 0;
            int incorrectNum = 0;
            int score = 0;
            List<SUserQuestionVo> userQuestionList = this.userExamQuestionService.listQuestionByUserExamId(userExam.getId());
            for (SUserQuestionVo userQuestion : userQuestionList) {
                if (userQuestion.getResult().booleanValue()) {
                    ++rightNum;
                    ++score;
                    continue;
                }
                ++incorrectNum;
            }
            userExam.setStatus(Integer.valueOf(UserExamStateEnum.DONE.getValue()));
            userExam.setDoneType(Integer.valueOf(1));
            userExam.setTotalScore(Integer.valueOf(score));
            userExam.setRightNum(Integer.valueOf(rightNum));
            userExam.setIncorrectNum(Integer.valueOf(incorrectNum));
            SysUser sysUser = this.userProviderService.selectUserById(userExam.getUserId());
            SubmitAnswerQuestionParam param = new SubmitAnswerQuestionParam(userExam.getCid(), sysUser.getName(), sysUser.getUsername(), sysUser.getPhone());
            param.setOptDate((Date)DateUtil.yesterday());
            this.userIntegralLogService.addIntegralByExam((SUserExam)userExam, param);
            userExam.setScoreStatus(Integer.valueOf(score == 0 ? 1 : 2));
            this.userExamService.updateById(userExam);
        });
        return userExamList.stream().map(SUserExam::getUserId).distinct().collect(Collectors.toList());
    }

    public void handleUnTestExamAndScore(Long examId, List<Long> userIdList) {
        List<SUserExam> userExamList = this.userExamService.genUserExamForTask(examId, userIdList);
        this.userExamQuestionService.genUserQuestionForTask(userExamList, this.examQuestionService.getByExamId(examId));
    }
}

