/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.task;

import cn.smarthse.radiationTraining.modules.sys.dto.sys.MsgDto;
import cn.smarthse.radiationTraining.modules.sys.enums.sys.MsgTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.service.sys.IMsgService;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainTestMsgVo;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"xxljob.switch"}, havingValue="on")
public class TrainingMsgTask {
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuCourseService tuCourseService;
    @DubboReference
    private IMsgService msgService;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @CacheEvict(cacheNames={"TRAINING:WORKTYPE:SEARCH", "TRAINING:INFO", "TRAINING:WORKTYPE:VOLIST", "TRAINING:COURSE:NUM", "TRAINING:COURSE_HOUR:NUM"}, allEntries=true)
    @XxlJob(value="TrainingMsgTask-UnstudiedCourseMsgToUser")
    public void UnstudiedCourseMsgToUser() {
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u6d88\u606f\u63a8\u9001-\u57f9\u8bad\u65f6\u95f4\u4e0d\u8db33\u5929");
        List<Training> trainList = this.trainingService.listWillOverTrain(3);
        trainList.stream().forEach(item -> {
            List<Long> userIdList = this.tuCourseService.listUnstudiedUserByTid(item.getId());
            MsgDto msgDto = new MsgDto();
            msgDto.setMsgType(MsgTypeEnum.training_remind.getValue());
            msgDto.setContent(String.format(MsgTypeEnum.training_remind.getContent(), item.getTrainName()));
            msgDto.setUrl(MsgTypeEnum.training_remind.getUrl());
            for (Long userId : userIdList) {
                msgDto.setUserId(userId);
                this.msgService.pushMsg(msgDto);
            }
        });
    }

    @XxlJob(value="TrainingMsgTask-UntestedCourseMsgToUser")
    public void UntestedCourseMsgToUser() {
        this.logger.debug("\u5b9a\u65f6\u4efb\u52a1-\u6d88\u606f\u63a8\u9001-\u8003\u8bd5\u65f6\u95f4\u4e0d\u8db33\u5929");
        List<TrainTestMsgVo> trainTestMsgVos = this.trainingService.listWillOverTest(3);
        trainTestMsgVos.stream().forEach(item -> {
            MsgDto msgDto = new MsgDto();
            msgDto.setMsgType(MsgTypeEnum.training_test_remind.getValue());
            msgDto.setContent(String.format(MsgTypeEnum.training_test_remind.getContent(), item.getTrainName()));
            msgDto.setUrl(MsgTypeEnum.training_test_remind.getUrl());
            msgDto.setUserId(item.getUserId());
            this.msgService.pushMsg(msgDto);
        });
    }

    @Generated
    public TrainingMsgTask() {
    }
}

