/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.task;

import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainAttendModel;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IEmailProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingCallService;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingSynService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuSpecialCertificateNoService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingPersonCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.task.CertRayService;
import cn.smarthse.radiationTraining.modules.training.task.CertUnitService;
import cn.smarthse.radiationTraining.modules.training.vo.certificate.TuCertVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class CertService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertService.class);
    @Autowired
    private CertUnitService certUnitService;
    @Autowired
    private CertRayService certRayService;
    @Autowired
    private ThreadPoolTaskExecutor executor;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private SysProperties sysProperties;
    @Autowired
    private ITuCertificateService certificateService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITuSpecialCertificateNoService tuSpecialCertificateNoService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITrainingPersonCertificateService trainingPersonCertificateService;
    @Autowired
    private TrainingSynService<TrainAttendModel> trainingSynService;
    @Autowired
    private TrainingCallService trainingCallService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private IEmailProviderService emailProviderService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    RedisLockRegistry lockRegistry;

    public void genCertFile() {
        this.certUnitService.genCertFile();
    }

    public TuCertVo genCert(Long id) {
        Object tuCert = (TuCertificate)this.certificateService.getById(id);
        if (tuCert == null) {
            return null;
        }
        TuEnrollDetail detail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuCert.getEnrollDetailId());
        if (detail == null) {
            return null;
        }
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(detail.getTid());
        if (trainingInfo == null) {
            return null;
        }
        log.info("\u8bc1\u4e66\u751f\u6210-\u5f00\u59cb\uff1aid\uff1a{}", (Object)id);
        tuCert = TrainTargetEnum.isHseTraining((Integer)trainingInfo.getTrainTarget()) != false ? this.certUnitService.genCert((TuCertificate)tuCert) : (TrainTargetEnum.isRhoTraining((Integer)trainingInfo.getTrainTarget()) != false ? this.certRayService.genCert((TuCertificate)tuCert) : null);
        if (tuCert == null) {
            return null;
        }
        TuCertVo tuCertVo = new TuCertVo();
        tuCertVo.setId(tuCert.getId());
        tuCertVo.setUnitName(tuCert.getUnitName());
        tuCertVo.setTrainType(tuCert.getTrainType());
        tuCertVo.setPdfUrl(this.ossClientBean.getUrl(tuCert.getPdfUrl()));
        tuCertVo.setIssueTime(tuCert.getIssueTime());
        tuCertVo.setUid(tuCert.getUid());
        log.info("\u8bc1\u4e66\u751f\u6210-\u7ed3\u675f\uff1aid\uff1a{}", (Object)id);
        return tuCertVo;
    }

    public void sendCertificate(Long id) {
        TuCertificate tuCert = (TuCertificate)this.certificateService.getById(id);
        UserVo userVo = this.userProviderService.getUserVo(tuCert.getUid());
        if (StringUtils.checkEmail((String)userVo.getEmail())) {
            String html = "<html><body><p>\u60a8\u7684\u57f9\u8bad\u201c" + tuCert.getTrainingName() + "\u201d\u7684\u8bc1\u4e66\u5df2\u751f\u6210\uff0c\u70b9\u51fb\u4e0b\u8f7d</p><p>\uff1e\uff1e\uff1e: <a target=\"_blank\" href='" + this.sysProperties.getCertQrUrl() + id + "'>\u8bc1\u4e66" + tuCert.getCertificateNo() + ".pdf</a></p></body></html>";
            this.emailProviderService.sendHtmlEmail(userVo.getEmail(), html);
        }
    }

    public void syncCertInfo(TuCertificate record, TuEnrollDetail tuEnrollDetail, TuEnroll tuEnroll, Training training) {
        if (record == null) {
            return;
        }
        if (TrainTargetEnum.isHseTraining((Integer)training.getTrainTarget()).booleanValue()) {
            this.certUnitService.syncCertInfo(record, tuEnrollDetail, tuEnroll, training);
        } else if (TrainTargetEnum.isRhoTraining((Integer)training.getTrainTarget()).booleanValue()) {
            this.certRayService.syncCertInfo(record, tuEnrollDetail, tuEnroll, training);
        }
    }

    @Generated
    public CertService() {
    }
}

