/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysParamProviderService;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingWorkTypeMapper;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingWorkType;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainWorkTypeParam;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingWorkTypeService;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrainingWorkTypeServiceImpl
extends ServiceImpl<TrainingWorkTypeMapper, TrainingWorkType>
implements ITrainingWorkTypeService {
    @DubboReference
    private ISysParamProviderService sysParamProviderService;

    @Override
    @Cacheable(cacheNames={"TRAINING:WORKTYPE:VOLIST"}, key="#tid", unless="#result == null ")
    public List<TrainingWorkTypeVo> getTrainingWorkType(Long tid) {
        return ((TrainingWorkTypeMapper)this.baseMapper).getTrainingWorkType(tid);
    }

    @Override
    @Cacheable(cacheNames={"TRAINING:WORKTYPE:SEARCH"}, key="#status")
    public List<TrainingWorkTypeVo> getTrainWorkTypeByStatus(Integer status) {
        return ((TrainingWorkTypeMapper)this.baseMapper).getTrainWorkTypeByStatus(status);
    }

    @Override
    public List<TrainingWorkTypeVo> getTrainingWorkTypeForCorp(Long cid) {
        return ((TrainingWorkTypeMapper)this.baseMapper).getTrainingWorkTypeForCorp(cid);
    }

    @Override
    public List<TrainingWorkTypeVo> getTrainingWorkTypeForUser(Long uid) {
        return ((TrainingWorkTypeMapper)this.baseMapper).getTrainingWorkTypeForUser(uid);
    }

    @Override
    @Transactional
    public Integer addTrainingWorkType(TrainWorkTypeParam param) {
        this.addTrainingWorkType(param.getTrainId(), param.getWorkTypeCodeList());
        return 1;
    }

    @Override
    @CacheEvict(cacheNames={"TRAINING:WORKTYPE:SEARCH"}, allEntries=true)
    public Integer addTrainingWorkType(Long trainId, List<String> workTypeCodeList) {
        if (null == workTypeCodeList || workTypeCodeList.isEmpty()) {
            return null;
        }
        ((TrainingWorkTypeMapper)this.baseMapper).delete((Wrapper)new QueryWrapper().eq((Object)"tid", (Object)trainId));
        workTypeCodeList.stream().forEach(item -> {
            TrainingWorkType trainingWorkType = new TrainingWorkType();
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add((String)item);
            trainingWorkType.setTid(trainId);
            trainingWorkType.setWorkTypeCode(item);
            if (((TrainingWorkTypeMapper)this.baseMapper).getTrainWorkType(trainId, (String)item).booleanValue()) {
                ((TrainingWorkTypeMapper)this.baseMapper).updateTrainWorkType(trainId, (String)item);
            } else {
                ((TrainingWorkTypeMapper)this.baseMapper).insert(trainingWorkType);
            }
        });
        return null;
    }

    public void addTrainWorkTypeWithNoDel(Long trainId, List<String> workTypeCodeList) {
        if (null == workTypeCodeList || workTypeCodeList.isEmpty()) {
            return;
        }
        workTypeCodeList.stream().forEach(item -> {
            TrainingWorkType trainingWorkType = new TrainingWorkType();
            trainingWorkType.setTid(trainId);
            trainingWorkType.setWorkTypeCode(item);
            ((TrainingWorkTypeMapper)this.baseMapper).insert(trainingWorkType);
        });
    }

    @Override
    @Transactional
    public Integer removeTrainingWorkType(TrainWorkTypeParam param) {
        this.removeTrainingWorkType(param.getTrainId(), param.getWorkTypeCodeList());
        return 1;
    }

    @Override
    @CacheEvict(cacheNames={"TRAINING:WORKTYPE:VOLIST"}, key="#trainId")
    public Integer removeTrainingWorkType(Long trainId, List<String> workTypeCodeList) {
        if (null == workTypeCodeList || workTypeCodeList.isEmpty()) {
            return -1;
        }
        workTypeCodeList.stream().forEach(item -> {
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)wrapper.eq((Object)"tid", (Object)trainId)).eq((Object)"work_type_code", item);
            ((TrainingWorkTypeMapper)this.baseMapper).delete((Wrapper)wrapper);
        });
        return 1;
    }

    @Override
    @CacheEvict(cacheNames={"TRAINING:WORKTYPE:SEARCH"}, allEntries=true)
    public Integer removeTrainWorkTypeByTid(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tid", (Object)tid);
        return ((TrainingWorkTypeMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    @CacheEvict(cacheNames={"TRAINING:WORKTYPE:SEARCH"}, allEntries=true)
    public Integer modifyTrainingWorkType(Long trainId, List<String> workTypeCodeList) {
        List<TrainingWorkTypeVo> trainWorkTypeList = this.getTrainingWorkType(trainId);
        List curGroup = trainWorkTypeList.stream().map(TrainingWorkTypeVo::getWorkTypeCode).collect(Collectors.toList());
        List<String> addGroup = workTypeCodeList.stream().filter(v -> !curGroup.contains(v)).collect(Collectors.toList());
        List<String> delGroup = curGroup.stream().filter(v -> !workTypeCodeList.contains(v)).collect(Collectors.toList());
        this.removeTrainingWorkType(trainId, delGroup);
        this.addTrainWorkTypeWithNoDel(trainId, addGroup);
        return 1;
    }
}

