/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.training.converter.TrainingListVoConverter;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingMapper;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingPersonTypeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.UserMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingPersonCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingServiceForUser;
import cn.smarthse.radiationTraining.modules.training.vo.training.ExamAlertInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingExamCountVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserTrainStatusNumVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxCompanyListVo;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class TrainingServiceImplForUser
extends ServiceImpl<TrainingMapper, Training>
implements ITrainingServiceForUser {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired(required=false)
    private TrainingListVoConverter trainListVoConverter;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITrainingPersonCertificateService personCertificateService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private OssClientBean ossClientBean;

    @Override
    public TrainingBaseInfoVo getMyTrainingBaseInfoForWx(Long tid, Long uid, Long enrollDetailId) {
        TrainingBaseInfoVo wxBaseInfoVo = ((TrainingMapper)this.baseMapper).selectTrainBaseInfoForWx(enrollDetailId);
        if (null == wxBaseInfoVo) {
            wxBaseInfoVo = new TrainingBaseInfoVo();
        }
        String newUrl = this.ossClientBean.getUrl(wxBaseInfoVo.getCoverUrl());
        ArrayList personTypeNameList = new ArrayList();
        List<String> personTypeCodeList = Arrays.asList(wxBaseInfoVo.getPersonTypeCode().split(","));
        personTypeCodeList.stream().forEach(code -> personTypeNameList.add(TrainingPersonTypeEnum.getNameByValue((String)code)));
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tid);
        this.trainListVoConverter.baseToWxBase(trainingInfo, wxBaseInfoVo);
        wxBaseInfoVo.setCoverUrl(newUrl);
        wxBaseInfoVo.setPersonTypeNameList(personTypeNameList.stream().collect(Collectors.joining("\uff0c")));
        if (wxBaseInfoVo.getTestMode() != null && wxBaseInfoVo.getTestMode() == 0) {
            wxBaseInfoVo.setIsIncludeFlunked(this.tuCourseService.ifIncludeFlunked(enrollDetailId, tid));
        }
        if (wxBaseInfoVo.getTestStatus() != null && wxBaseInfoVo.getTestStatus() != 2 && wxBaseInfoVo.getRetestLimit() != null && wxBaseInfoVo.getRetestLimit() == 0) {
            wxBaseInfoVo.setIsIncludeFlunked(Boolean.valueOf(true));
        }
        return wxBaseInfoVo;
    }

    @Override
    public Boolean isCouldEnroll(TrainingSearchParam param) {
        Integer trainNum = ((TrainingMapper)this.baseMapper).isCouldEnroll(param);
        if (trainNum == null) {
            return false;
        }
        if (trainNum >= 1) {
            return true;
        }
        return false;
    }

    @Override
    public LayuiGridData<TrainingListVo> getCouldEnrollList(TrainingSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingListVo> trainingList = ((TrainingMapper)this.baseMapper).listCouldEnrollTrain(param);
        trainingList.stream().forEach(train -> {
            TrainingDetailVo info = this.trainingService.getTrainingInfo(train.getId());
            train.setPersonTypeNameList(info.getPersonTypeNameList());
            train.setCourseNum(info.getCourseNum());
            train.setTrainIndustryNameList(info.getTrainIndustryNameList());
            train.setCoverUrl(this.ossClientBean.getUrl(train.getCoverUrl()));
        });
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    public TrainingListVo getCouldEnrollInfo(TrainingSearchParam param) {
        TrainingListVo rst = ((TrainingMapper)this.baseMapper).getCouldEnrollInfo(param);
        TrainingDetailVo info = this.trainingService.getTrainingInfo(param.getTrainingId());
        rst.setPersonTypeNameList(info.getPersonTypeNameList());
        rst.setCourseNum(info.getCourseNum());
        rst.setTrainIndustryNameList(info.getTrainIndustryNameList());
        rst.setCoverUrl(this.ossClientBean.getUrl(rst.getCoverUrl()));
        return rst;
    }

    @Override
    public LayuiGridData<WxCompanyListVo> searchCompanyListForRho(TrainingSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<Object> list = new ArrayList();
        list = !StringUtils.hasLength((String)param.getKeyword()) ? ((TrainingMapper)this.baseMapper).searchAssociatedCompanyListForRho(param) : ((TrainingMapper)this.baseMapper).searchCompanyListForRho(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public CompanySuperviseModel getCompanyByIdForRho(Long cid) {
        return ((TrainingMapper)this.baseMapper).getCompanyByIdForRho(cid);
    }

    @Override
    public LayuiGridData<TrainingListVo> getTrainingPageListForUser(TrainingSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingListVo> trainingList = ((TrainingMapper)this.baseMapper).listTrainIsEnrollForUser(param);
        trainingList.stream().forEach(item -> {
            TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(item.getId());
            this.trainListVoConverter.trainDetailToListVo(trainingInfo, item);
        });
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    public UserMyTrainListVo getTrainingBaseInfoForUser(Long tid, Long uid) {
        UserMyTrainListVo rst = ((TrainingMapper)this.baseMapper).selectTrainBaseInfoForUser(tid, uid);
        if (null == rst) {
            rst = new UserMyTrainListVo();
        }
        TrainingDetailVo trainInfo = this.trainingService.getTrainingInfo(tid);
        this.trainListVoConverter.baseToUserBase(trainInfo, rst);
        return rst;
    }

    @Override
    public List<UserTrainStatusNumVo> getTrainingStatusNumListForUser(Long uid) {
        List<UserTrainStatusNumVo> list = ((TrainingMapper)this.baseMapper).listTrainStatusNumForUser(uid);
        IntSummaryStatistics sum = list.stream().collect(Collectors.summarizingInt(UserTrainStatusNumVo::getNum));
        list.add(new UserTrainStatusNumVo(Integer.valueOf(-1), sum.getSum()));
        return list;
    }

    @Override
    public LayuiGridData<UserMyTrainListVo> getMyTrainPageListForUser(UserMyTrainSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<UserMyTrainListVo> trainingList = ((TrainingMapper)this.baseMapper).listMyTrainPageForUser(param);
        for (UserMyTrainListVo train : trainingList) {
            train.setCoverUrl(this.ossClientBean.getUrl(train.getCoverUrl()));
            if (train.getTrainStatus().intValue() == TrainingStatusEnum.GET_CERTIFICATE.getValue().intValue()) {
                train.setCertInvalidDate(((TrainingMapper)this.baseMapper).getCertInvalidDate(train.getEnrollDetailId()));
            }
            train.setPersonTypeNameList(this.personCertificateService.getPersonTypeName(train.getTid()));
            train.setIsIncludeFlunked(Boolean.valueOf(false));
            if (train.getIsTestOnline() == 0) continue;
            if (train.getTestMode() == 0) {
                train.setIsIncludeFlunked(this.tuCourseService.ifIncludeFlunked(train.getEnrollDetailId(), train.getTid()));
            } else if (train.getTestStatus() != null && train.getTestStatus() != 2 && train.getRetestLimit() != null && train.getRetestLimit() == 0) {
                train.setIsIncludeFlunked(Boolean.valueOf(true));
            }
            if (train.getPassClassHour() != null) continue;
            train.setPassClassHour(train.getClassHourTotal());
        }
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    public UserMyTrainListVo getMyTrainingBaseInfoForUser(Long tid, Long uid, Long enrollDetailId) {
        UserMyTrainListVo rst = ((TrainingMapper)this.baseMapper).selectMyTrainBaseInfoForUser(enrollDetailId);
        if (null == rst) {
            rst = new UserMyTrainListVo();
            rst.setCourseNum(Integer.valueOf(0));
        }
        Integer courseNum = rst.getCourseNum();
        TrainingDetailVo trainInfo = this.trainingService.getTrainingInfo(tid);
        this.trainListVoConverter.baseToUserBase(trainInfo, rst);
        rst.setCourseNum(courseNum);
        if (null != rst.getPdfUrl()) {
            ArrayList newUrlList = new ArrayList();
            List<String> pdfUrlList = Arrays.asList(rst.getPdfUrl().split(","));
            pdfUrlList.stream().forEach(url -> newUrlList.add(this.ossClientBean.getUrl(url)));
            rst.setPdfUrl(newUrlList.stream().collect(Collectors.joining(",")));
        }
        return rst;
    }

    @Override
    @Transactional
    public void delTrainingForUser(Long tid, Long uid) {
        ((TrainingMapper)this.baseMapper).delTrainingForUser(tid, uid);
    }

    @Override
    public LayuiGridData<UserMyTrainListVo> getMyTrainingExamPageList(UserMyTrainSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<UserMyTrainListVo> trainingList = ((TrainingMapper)this.baseMapper).getMyTrainingExamList(param);
        for (UserMyTrainListVo train : trainingList) {
            TrainingDetailVo info = this.trainingService.getTrainingInfo(train.getTid());
            train.setCoverUrl(this.ossClientBean.getUrl(train.getCoverUrl()));
            train.setTrainWorkTypeNameList(info.getTrainWorkTypeNameList());
            if (train.getTrainStatus().intValue() == TrainingStatusEnum.GET_CERTIFICATE.getValue().intValue()) {
                train.setCertInvalidDate(((TrainingMapper)this.baseMapper).getCertInvalidDate(train.getEnrollDetailId()));
            }
            train.setIsIncludeFlunked(Boolean.valueOf(false));
            if (train.getIsTestOnline() == 0) continue;
            if (train.getTestMode() == 0) {
                train.setIsIncludeFlunked(this.tuCourseService.ifIncludeFlunked(train.getEnrollDetailId(), train.getTid()));
                continue;
            }
            if (train.getTestStatus() == null || train.getTestStatus() == 2 || train.getRetestLimit() == null || train.getRetestLimit() != 0) continue;
            train.setIsIncludeFlunked(Boolean.valueOf(true));
        }
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    public TrainingExamCountVo getTrainingExamCount(Long loginUserId) {
        UserMyTrainSearchParam param = new UserMyTrainSearchParam();
        param.setUid(loginUserId);
        param.setLimit(Integer.MAX_VALUE);
        List<UserMyTrainListVo> trainingList = ((TrainingMapper)this.baseMapper).getMyTrainingExamList(param);
        TrainingExamCountVo trainingExamCountVo = new TrainingExamCountVo();
        if (!CollectionUtils.isEmpty(trainingList)) {
            Integer totalNum = trainingList.size();
            Integer trainingNum = (int)trainingList.stream().filter(t -> t.getTrainStatus().intValue() == TrainingStatusEnum.IN_TRAINING.getValue().intValue()).count();
            Integer certifiedNum = (int)trainingList.stream().filter(t -> t.getTrainStatus().intValue() == TrainingStatusEnum.GET_CERTIFICATE.getValue().intValue()).count();
            Integer endNum = (int)trainingList.stream().filter(t -> t.getTrainStatus().intValue() == TrainingStatusEnum.TRAINING_COMPLETED.getValue().intValue()).count();
            trainingExamCountVo.setTotalNum(totalNum).setTrainingNum(trainingNum).setCertifiedNum(certifiedNum).setEndNum(endNum);
        }
        return trainingExamCountVo;
    }

    @Override
    public ExamAlertInfoVo getExamAlertInfo(Long tuCourseId) {
        Integer trainMode = this.tuCourseService.getTrainModeByTuCourseId(tuCourseId);
        if (trainMode == null || trainMode.equals(TrainingModeEnum.MARJOR.getValue())) {
            return ((TrainingMapper)this.baseMapper).getExamAlertInfo(tuCourseId);
        }
        return ((TrainingMapper)this.baseMapper).getExamAlertInfoForPrecise(tuCourseId);
    }
}

