/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingMapper;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.param.training.CorpMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.CropTrainingListParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingServiceForCorp;
import cn.smarthse.radiationTraining.modules.training.vo.training.CorpMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CropTrainStatusNumVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CropTrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrainingServiceImplForCorp
extends ServiceImpl<TrainingMapper, Training>
implements ITrainingServiceForCorp {
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuEnrollService enrollService;
    @Autowired
    private OssClientBean ossClientBean;

    @Override
    public LayuiGridData<TrainingListVo> getTrainingPageListForCorp(TrainingSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<TrainingListVo> trainingList = ((TrainingMapper)this.baseMapper).listTrainingPageForCorp(param);
        if (trainingList != null) {
            trainingList.stream().forEach(train -> {
                TrainingDetailVo info = this.trainingService.getTrainingInfo(train.getId());
                train.setPersonTypeNameList(info.getPersonTypeNameList());
                train.setCourseNum(info.getCourseNum());
                train.setCoverUrl(this.ossClientBean.getUrl(train.getCoverUrl()));
            });
        }
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    public List<CropTrainStatusNumVo> getTrainingStatusNumListForCrop(Long cid, Integer trainTargetType) {
        List<CropTrainStatusNumVo> list = ((TrainingMapper)this.baseMapper).listTrainStatusNumForCrop(cid, trainTargetType);
        IntSummaryStatistics sum = list.stream().collect(Collectors.summarizingInt(CropTrainStatusNumVo::getNum));
        list.add(new CropTrainStatusNumVo(Integer.valueOf(-1), sum.getSum()));
        return list;
    }

    @Override
    public TrainingBaseInfoVo getTrainingBaseInfoForCorp(TrainingSearchParam param) {
        TrainingBaseInfoVo rst = ((TrainingMapper)this.baseMapper).selectTrainBaseInfoForCorp(param);
        if (rst == null) {
            throw new ServiceException("\u8be5\u57f9\u8bad\u901a\u77e5\u5df2\u88ab\u7ba1\u7406\u5458\u5220\u9664\uff01");
        }
        TrainingDetailVo info = this.trainingService.getTrainingInfo(param.getTrainingId());
        rst.setCourseNum(info.getCourseNum());
        rst.setWorkType(info.getTrainWorkTypeNameList());
        rst.setPersonTypeNameList(info.getPersonTypeNameList());
        rst.setTrainIndustryNameList(info.getTrainIndustryNameList());
        rst.setCoverUrl(this.ossClientBean.getUrl(rst.getCoverUrl()));
        if (info.getTrainMode() == TrainingModeEnum.PRECISE.getValue() && rst.getTargetClassHour() == null) {
            List personCertificateList = info.getPersonCertificateList();
            double targetClassHour = 0.0;
            for (TrainingPersonCertificate trainCertificate : personCertificateList) {
                targetClassHour += trainCertificate.getTargetClassHour().doubleValue();
            }
            rst.setTargetClassHour(Double.valueOf(targetClassHour));
        }
        return rst;
    }

    @Override
    public LayuiGridData<CorpMyTrainListVo> getMyTrainPageListForCorp(CorpMyTrainSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CorpMyTrainListVo> trainingList = ((TrainingMapper)this.baseMapper).listMyTrainPageForCorp(param);
        trainingList.stream().forEach(train -> train.setCoverUrl(this.ossClientBean.getUrl(train.getCoverUrl())));
        return new LayuiGridData((Page)trainingList, (LayuiGridParam)param);
    }

    @Override
    public CorpMyTrainListVo getMyTrainBaseInfoForCorp(Long tid) {
        CorpMyTrainSearchParam param = new CorpMyTrainSearchParam();
        param.setTid(tid);
        param.setCid(Long.valueOf(1L));
        List<CorpMyTrainListVo> trainingList = ((TrainingMapper)this.baseMapper).listMyTrainPageForCorp(param);
        if (trainingList.isEmpty()) {
            return null;
        }
        CorpMyTrainListVo rst = trainingList.get(0);
        rst.setCourseNum(((TrainingMapper)this.baseMapper).sumCourseNumByTrainId(tid));
        return rst;
    }

    @Override
    public List<CropTrainingListVo> getCropTrain(CropTrainingListParam param) {
        List<CropTrainingListVo> rst = ((TrainingMapper)this.baseMapper).getCropTrain(param);
        rst.stream().forEach(item -> {
            TrainingDetailVo info = this.trainingService.getTrainingInfo(item.getTid());
            item.setPersonTypeNames(info.getPersonTypeNameList());
        });
        return rst;
    }
}

