/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.training.converter.TrainPersonCertificateConverter;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingPersonCertificateMapper;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingPersonCertificate;
import cn.smarthse.radiationTraining.modules.training.param.training.PersonTypeCertificateAddParam;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingPersonCertificateService;
import cn.smarthse.radiationTraining.modules.training.vo.course.ClassHourstatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrainingPersonCertificateServiceImpl
extends ServiceImpl<TrainingPersonCertificateMapper, TrainingPersonCertificate>
implements ITrainingPersonCertificateService {
    @Autowired(required=false)
    private TrainPersonCertificateConverter trainPersonConverter;
    @Autowired
    private OssClientBean ossClientBean;

    @Override
    public List<TrainingPersonCertificate> getPersonCertificateListByTid(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tid", (Object)tid);
        List rst = this.list((Wrapper)wrapper);
        if (null != rst) {
            rst.stream().forEach(item -> item.setElectronicSeal(this.ossClientBean.getUrl(item.getElectronicSeal())));
        }
        return rst;
    }

    @Override
    public String getPersonTypeName(Long tid) {
        List<TrainingPersonCertificate> list = this.getPersonCertificateListByTid(tid);
        return list.stream().map(TrainingPersonCertificate::getPersonTypeName).collect(Collectors.joining(","));
    }

    @Override
    public void addTrainPersonCertificate(Long tid, List<PersonTypeCertificateAddParam> paramList) {
        paramList.stream().forEach(item -> {
            TrainingPersonCertificate entity = this.trainPersonConverter.addParamToEntity(item);
            entity.setId(null);
            entity.setTid(tid);
            this.save(entity);
        });
    }

    @Override
    public void updatePersonCertificate(Long tid, List<PersonTypeCertificateAddParam> paramList) {
        this.delPersonCertificate(tid);
        this.addTrainPersonCertificate(tid, paramList);
    }

    @Override
    public void delPersonCertificate(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tid", (Object)tid);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void clonePersonCertificate(Long oldTid, Long newTid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tid", (Object)oldTid);
        List personCertificateList = this.list((Wrapper)wrapper);
        personCertificateList.stream().forEach(personCertificate -> {
            personCertificate.setId(null);
            personCertificate.setTid(newTid);
            personCertificate.setValidityDate(Integer.valueOf(1));
            personCertificate.setCreateTime(new Date());
            personCertificate.setUpdateTime(null);
        });
        this.saveBatch(personCertificateList);
    }

    @Override
    public TrainingPersonCertificate getPersonCertificate(Long tid, String personType) {
        if (StringUtils.isEmpty((CharSequence)personType)) {
            return null;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TrainingPersonCertificate::getTid, (Object)tid)).eq(TrainingPersonCertificate::getPersonType, (Object)personType)).last("limit 1");
        return (TrainingPersonCertificate)this.getOne((Wrapper)wrapper);
    }

    @Override
    public List<ClassHourstatisticsVo> getMaxClassPreciseHourVoV3_2_2_1() {
        return ((TrainingPersonCertificateMapper)this.baseMapper).getMaxClassPreciseHourVoV3_2_2_1();
    }

    @Override
    public ClassHourstatisticsVo getMaxClassHourVoV1() {
        return ((TrainingPersonCertificateMapper)this.baseMapper).getMaxClassHourVoV1();
    }
}

