/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.training.impl;

import cn.smarthse.radiationTraining.modules.training.converter.TrainIndustryConverter;
import cn.smarthse.radiationTraining.modules.training.dao.training.TrainingIndustryMapper;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingIndustry;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainIndustryAddParam;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingIndustryService;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingIndustryVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrainingIndustryServiceImpl
extends ServiceImpl<TrainingIndustryMapper, TrainingIndustry>
implements ITrainingIndustryService {
    @Autowired(required=false)
    private TrainIndustryConverter trainIndustryConverter;

    @Override
    public List<TrainingIndustry> getTrainIndustryListByTid(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tid", (Object)tid);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<TrainingIndustryVo> getTrainIndustryVoList(Long tid) {
        return this.trainIndustryConverter.entityToVo(this.getTrainIndustryListByTid(tid));
    }

    @Override
    public String getTrainIndustryName(Long tid) {
        List<TrainingIndustry> list = this.getTrainIndustryListByTid(tid);
        return list.stream().map(TrainingIndustry::getIndustryCodeName).collect(Collectors.joining(","));
    }

    @Override
    public void addTrainIndustry(Long tid, List<TrainIndustryAddParam> paramList) {
        paramList.stream().forEach(item -> {
            TrainingIndustry entity = this.trainIndustryConverter.addParamToEntity(item);
            entity.setId(null);
            entity.setTid(tid);
            this.save(entity);
        });
    }

    @Override
    public void updateTrainIndustry(Long tid, List<TrainIndustryAddParam> paramList) {
        this.delTrainIndustry(tid);
        this.addTrainIndustry(tid, paramList);
    }

    @Override
    public void delTrainIndustry(Long tid) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tid", (Object)tid);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public void cloneTrainIndustry(Long oldTid, Long newTid) {
        List<TrainingIndustry> trainIndustryList = this.getTrainIndustryListByTid(oldTid);
        trainIndustryList.stream().forEach(trainIndustry -> {
            trainIndustry.setId(null);
            trainIndustry.setTid(newTid);
            trainIndustry.setCreateTime(new Date());
            trainIndustry.setUpdateTime(null);
        });
        this.saveBatch(trainIndustryList);
    }
}

