/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.redis.impl;

import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import com.alibaba.fastjson.JSON;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrainingRedisServiceImpl
implements ITrainingRedisService {
    @Autowired(required=false)
    private RedisUtil redisUtil;
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private ITrainingCourseService trainingCourseService;

    @Override
    public List<CourseGroupCatalogueVo> getBaseCourseCataLogue(Long tid) {
        List courseGroupCatalogueVos = null;
        String hashCache = (String)this.redisUtil.getHashCache((Object)RedisKey.getCatalogue(null), (Object)RedisKey.getCatalogue((Long)tid));
        courseGroupCatalogueVos = hashCache == null ? this.addOrUpBaseCataLogueHashCache(tid) : JSON.parseArray((String)hashCache, CourseGroupCatalogueVo.class);
        return courseGroupCatalogueVos;
    }

    @Override
    public void rmBaseCourseCataLogue(Long tid) {
        this.redisUtil.delHashCache((Object)RedisKey.getCatalogue(null), (Object)RedisKey.getCatalogue((Long)tid));
    }

    @Override
    public List<CourseGroupCatalogueVo> addOrUpBaseCataLogueHashCache(Long tid) {
        List<CourseGroupCatalogueVo> baseInfoList = this.trainingCourseService.getBaseCourseCataLogueFromDB(tid);
        this.addOrUpBaseCataLogueHashCache(baseInfoList, tid);
        return baseInfoList;
    }

    @Override
    public void addOrUpBaseCataLogueHashCache(List<CourseGroupCatalogueVo> list, Long tid) {
        this.redisUtil.addHashCache((Object)RedisKey.getCatalogue(null), (Object)RedisKey.getCatalogue((Long)tid), (Object)JSON.toJSONString(list));
    }

    @Override
    public TrainingCourse getTrainingCourse(Long traningCourseId) {
        String hashCache = (String)this.redisUtil.getHashCache((Object)RedisKey.getTrainCourse(null), (Object)RedisKey.getTrainCourse((Long)traningCourseId));
        if (hashCache == null) {
            TrainingCourse trainingCourse = (TrainingCourse)this.trainingCourseService.getById(traningCourseId);
            this.addOrUpTrainCourseHashCache(trainingCourse);
            return trainingCourse;
        }
        return (TrainingCourse)JSON.parseObject((String)hashCache, TrainingCourse.class);
    }

    @Override
    public void addOrUpTrainCourseHashCache(TrainingCourse trainingCourse) {
        this.redisUtil.addHashCache((Object)RedisKey.getTrainCourse(null), (Object)RedisKey.getTrainCourse((Long)trainingCourse.getId()), (Object)JSON.toJSONString((Object)trainingCourse));
    }

    @Override
    public void delTrainCourseHashCache(Long trainCourseId) {
        this.redisUtil.delHashCache((Object)RedisKey.getTrainCourse(null), (Object)RedisKey.getTrainCourse((Long)trainCourseId));
    }

    @Override
    public void delTrainingById(Long tid) {
        this.redisUtil.delete("TRAINING:INFO::" + tid);
    }

    @Override
    public void delTrainCourseAndCatalogue() {
        this.redisUtil.delete(RedisKey.getCatalogue(null));
        this.redisUtil.delete(RedisKey.getTrainCourse(null));
    }
}

