/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.redis.impl;

import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import com.alibaba.fastjson.JSON;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class CourseRedisServiceImpl
implements ICourseRedisService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CourseRedisServiceImpl.class);
    @Autowired(required=false)
    private RedisUtil redisUtil;
    @Autowired
    private ThreadPoolTaskExecutor executor;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ICourseItemService courseItemService;

    @Override
    public Long getTuCourseId(Long detailId, Long courseItemId) {
        String hashCache = (String)this.redisUtil.getHashCache((Object)RedisKey.getTuCourseId(null, null), (Object)RedisKey.getTuCourseId((Long)detailId, (Long)courseItemId));
        if (hashCache == null) {
            TuCourse tuCourse = this.tuCourseService.getByDetailIdAndCourseItemId(detailId, courseItemId);
            if (tuCourse == null) {
                return null;
            }
            this.addOrUpTuCourse(tuCourse);
            this.addOrUpTuCourseId(tuCourse);
            return tuCourse.getId();
        }
        return Long.parseLong(hashCache);
    }

    @Override
    public void addOrUpTuCourseId(TuCourse tuCourse) {
        this.redisUtil.addHashCache((Object)RedisKey.getTuCourseId(null, null), (Object)RedisKey.getTuCourseId((Long)tuCourse.getEnrollDetailId(), (Long)tuCourse.getCourseItemId()), (Object)String.valueOf(tuCourse.getId()));
    }

    @Override
    public void rmTuCourseId(Long detailId, Long courseItemId) {
        this.redisUtil.delHashCache((Object)RedisKey.getTuCourseId(null, null), (Object)RedisKey.getTuCourseId((Long)detailId, (Long)courseItemId));
    }

    @Override
    public TuCourse getTuCourse(Long tuCoruseId) {
        String hashCache = (String)this.redisUtil.getHashCache((Object)RedisKey.getTuCourse(null), (Object)RedisKey.getTuCourse((Long)tuCoruseId));
        if (hashCache == null) {
            TuCourse tuCourseDB = (TuCourse)this.tuCourseService.getById(tuCoruseId);
            this.addOrUpTuCourse(tuCourseDB);
            return tuCourseDB;
        }
        return (TuCourse)JSON.parseObject((String)hashCache, TuCourse.class);
    }

    @Override
    public void rmTuCourse(Long tuCoruseId) {
        this.redisUtil.delHashCache((Object)RedisKey.getTuCourse(null), (Object)RedisKey.getTuCourse((Long)tuCoruseId));
    }

    @Override
    public void addOrUpTuCourse(TuCourse tuCourse) {
        this.redisUtil.addHashCache((Object)RedisKey.getTuCourse(null), (Object)RedisKey.getTuCourse((Long)tuCourse.getId()), (Object)JSON.toJSONString((Object)tuCourse));
        this.redisUtil.addHashCache((Object)RedisKey.getTuCourseId(null, null), (Object)RedisKey.getTuCourseId((Long)tuCourse.getEnrollDetailId(), (Long)tuCourse.getCourseItemId()), (Object)String.valueOf(tuCourse.getId()));
    }

    @Override
    public void rmTuCourse(TuCourse tuCourse) {
        this.redisUtil.delHashCache((Object)RedisKey.getTuCourse(null), (Object)RedisKey.getTuCourse((Long)tuCourse.getId()));
        this.redisUtil.delHashCache((Object)RedisKey.getTuCourseId(null, null), (Object)RedisKey.getTuCourseId((Long)tuCourse.getEnrollDetailId(), (Long)tuCourse.getCourseItemId()));
    }

    @Override
    public void cleanStuiedRecord() {
        this.redisUtil.delete(RedisKey.getTuCourse(null));
    }

    @Override
    public CourseItemVo getCourseItemVo(Long courseItemId) {
        String itemCache = (String)this.redisUtil.getHashCache((Object)RedisKey.getCourseItemVo(null), (Object)RedisKey.getCourseItemVo((Long)courseItemId));
        if (itemCache == null) {
            CourseItemVo courseItemVo = this.courseItemService.getCourseItemByIdFromDB(courseItemId);
            if (courseItemVo == null) {
                return null;
            }
            this.addOrUpCourseItemVo(courseItemVo);
            return courseItemVo;
        }
        return (CourseItemVo)JSON.parseObject((String)itemCache, CourseItemVo.class);
    }

    @Override
    public void addOrUpCourseItemVo(CourseItemVo courseItemVo) {
        this.redisUtil.addHashCache((Object)RedisKey.getCourseItemVo(null), (Object)RedisKey.getCourseItemVo((Long)courseItemVo.getId()), (Object)JSON.toJSONString((Object)courseItemVo));
    }

    @Override
    public void rmCourseItemVo(CourseItemVo courseItemVo) {
        this.redisUtil.delHashCache((Object)RedisKey.getCourseItemVo(null), (Object)RedisKey.getCourseItemVo((Long)courseItemVo.getId()));
    }

    @Override
    public void rmCourseItemVo(Long courseItemId) {
        this.redisUtil.delHashCache((Object)RedisKey.getCourseItemVo(null), (Object)RedisKey.getCourseItemVo((Long)courseItemId));
    }
}

