/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.enroll.impl;

import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperQuestProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.enums.CropEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.PersnoalEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.CropSelectTraninglParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonalEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.SpecialCertificateNoEditParam;
import cn.smarthse.radiationTraining.modules.training.service.course.ILearningOrgService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ICropEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuSpecialCertificateNoService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserOrgEnrollServiceV3_2_2_1;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import java.util.Date;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class UserOrgEnrollServiceImplV3_2_2_1
implements IUserOrgEnrollServiceV3_2_2_1 {
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ILearningOrgService learningOrgService;
    @Autowired
    private ITuSpecialCertificateNoService specialCertificateNoService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ICropEnrollService cropEnrollService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private ITuPaperQuestProviderService tuPaperQuestProviderService;
    @DubboReference
    private ISysCompanyStaffProviderService sysCompanyStaffProviderService;

    @Override
    @Transactional
    public void personalSignUpForOrgByIndividual(PersonalEnrollParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"name", "companyName", "cid", "personTypeCode", "trainMode", "trainingId", "userId", "name"});
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(param.getTrainingId());
        PersonalUserVo personalUserInfo = this.userProviderService.getPersonalUserInfo(param.getLoginUserId());
        TuEnroll tuEnroll = this.tuEnrollService.getByHseCidAndTid(param.getCid(), param.getTrainingId());
        if (tuEnroll == null || tuEnroll.getTrainStatus().equals(TrainingStatusEnum.RETURNED.getValue())) {
            CropSelectTraninglParam cropEnrollParam = new CropSelectTraninglParam();
            cropEnrollParam.setTid(param.getTrainingId());
            cropEnrollParam.setCid(param.getCid());
            cropEnrollParam.setSource(CropEnrollSourceEnum.PERSONAL.getValue());
            tuEnroll = this.cropEnrollService.enroll(cropEnrollParam);
        }
        TuEnrollDetail originTuEnrollDetail = this.tuEnrollDetailService.getByUidAndEnrollId(param.getLoginUserId(), tuEnroll.getId());
        this.ifCanEnrollForOrgByIndividual(trainingInfo, personalUserInfo, tuEnroll, originTuEnrollDetail, param);
        TuEnrollDetail enrollDetail = new TuEnrollDetail().setUid(param.getLoginUserId()).setIdCard(param.getIdcard()).setTid(param.getTrainingId()).setHseCid(param.getCid()).setUname(param.getName()).setEnrollTime(new Date()).setEnrollSource(PersnoalEnrollSourceEnum.PERSONAL.getValue()).setTrainStatus(this.analyseTrainStateAfterEnroll(trainingInfo)).setEmail(param.getEmail()).setIdCard(param.getIdcard()).setPhone(param.getPhone()).setTrainMode(TrainingModeEnum.ORG.getValue()).setEnrollId(tuEnroll.getId()).setCname(param.getCompanyName()).setPersonTypeCode(param.getPersonTypeCode()).setCreditCode(param.getCreditCode());
        if (originTuEnrollDetail != null) {
            enrollDetail.setId(originTuEnrollDetail.getId());
        }
        this.tuEnrollDetailService.saveOrUpdate(enrollDetail);
        for (SpecialCertificateNoEditParam p : param.getSpecialCertificateNoList()) {
            p.setDetailId(enrollDetail.getId());
        }
        this.specialCertificateNoService.addInfo(param.getSpecialCertificateNoList(), param.getLoginUserId());
        this.tuCourseService.initInfoForOrg(enrollDetail, (Training)trainingInfo, param);
        this.sysCompanyStaffProviderService.save(enrollDetail.getHseCid(), enrollDetail.getUid(), param.getLoginUserId());
    }

    private void ifCanEnrollForOrgByIndividual(TrainingDetailVo training, PersonalUserVo personalUserInfo, TuEnroll tuEnroll, TuEnrollDetail tuEnrollDetail, PersonalEnrollParam param) {
        if (training == null || personalUserInfo == null) {
            throw new ServiceException("\u6570\u636e\u7f3a\u5931");
        }
        if (tuEnrollDetail != null && TrainingStatusEnum.getEnrolledStatus().contains(tuEnrollDetail.getTrainStatus())) {
            throw new ServiceException("\u60a8\u4e0d\u80fd\u91cd\u590d\u62a5\u540d\uff0c\u5982\u7b2c\u4e00\u6b21\u62a5\u540d\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5220\u9664\u540e\u518d\u91cd\u65b0\u62a5\u540d\uff01");
        }
        if (training == null) {
            throw new ServiceException("\u57f9\u8bad\u4e0d\u5b58\u5728\uff01");
        }
        if (training.getStatus() != 2) {
            throw new ServiceException("\u57f9\u8bad\u672a\u4e0a\u67b6\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
        }
        if (training.getTrainEndTime().getTime() < new Date().getTime()) {
            throw new ServiceException("\u57f9\u8bad\u65f6\u95f4\u5df2\u8fc7\uff0c\u65e0\u6cd5\u53c2\u52a0\u57f9\u8bad\uff01");
        }
        if (!StringUtils.isEmpty((CharSequence)param.getIdcard())) {
            if (StringUtils.isEmpty((CharSequence)personalUserInfo.getIdcard())) {
                throw new ServiceException("\u62b1\u6b49\uff0c\u60a8\u6240\u63d0\u4f9b\u7684\u8eab\u4efd\u8bc1\u4e0e\u60a8\u7684\u8d26\u53f7\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
            }
            if (!param.getIdcard().equals(personalUserInfo.getIdcard())) {
                throw new ServiceException("\u62b1\u6b49\uff0c\u60a8\u6240\u63d0\u4f9b\u7684\u8eab\u4efd\u8bc1\u4e0e\u60a8\u7684\u8d26\u53f7\u8eab\u4efd\u8bc1\u4fe1\u606f\u4e0d\u7b26\uff0c\u65e0\u6cd5\u62a5\u540d\uff01");
            }
        }
    }

    public Integer analyseTrainStateAfterEnroll(TrainingDetailVo training) {
        long trainStartTime;
        long currTime = new Date().getTime();
        if (currTime < (trainStartTime = training.getTrainStarTime().getTime())) {
            return TrainingStatusEnum.TO_BE_TRAINED.getValue();
        }
        return TrainingStatusEnum.IN_TRAINING.getValue();
    }
}

