/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.enroll.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdUtil;
import cn.smarthse.modules.health.supervise.entity.trainPlan.SyncTrainInfoModel;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.training.dto.TrainingImportDataDto;
import cn.smarthse.radiationTraining.modules.training.entity.certificate.TuCertificate;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.Training;
import cn.smarthse.radiationTraining.modules.training.enums.CropEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.PersnoalEnrollSourceEnum;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.provider.toT.TrainingCallService;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ICropEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITrainingExcelService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TrainingExcelServiceImpl
implements ITrainingExcelService {
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ICropEnrollService cropEnrollService;
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuCertificateService tuCertificateService;
    @Autowired
    TrainingCallService trainingCallService;
    @DubboReference
    private IHseCompanyProviderService hseCompanyProviderService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;

    @Override
    @Transactional
    public void importUserData(List<TrainingImportDataDto> paramList, UserEditParam optParam) {
        this.checkAndFillUserData(paramList);
        this.saveUserData(paramList, optParam);
    }

    public void checkAndFillUserData(List<TrainingImportDataDto> paramList) {
        StringBuilder sb = new StringBuilder("\u9519\u8bef\u63d0\u793a:");
        for (int i = 0; i < paramList.size(); ++i) {
            TrainingImportDataDto dto = paramList.get(i);
            if (dto.getUserName() == null || dto.getUserName().equals("")) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u5458\u5de5\u59d3\u540d\u4e3a\u7a7a\uff01\n");
            }
            if (dto.getIdCard() != null && !dto.getIdCard().equals("")) continue;
            sb.append("\u7b2c").append(i).append("\u884c").append("\u5458\u5de5\u8eab\u4efd\u8bc1\u4e3a\u7a7a\uff01\n");
        }
        if (!sb.toString().equals("\u9519\u8bef\u63d0\u793a:")) {
            throw new ServiceException(sb.toString());
        }
    }

    @Transactional
    public void saveUserData(List<TrainingImportDataDto> paramList, UserEditParam optParam) {
        ArrayList<RegisterUserParam> saveList = new ArrayList<RegisterUserParam>();
        Map<String, TrainingImportDataDto> map = paramList.stream().collect(Collectors.toMap(TrainingImportDataDto::getIdCard, t -> t, (key1, key2) -> key1));
        ArrayList<TrainingImportDataDto> collect = new ArrayList<TrainingImportDataDto>(map.values());
        for (int i = 0; i < collect.size(); ++i) {
            TrainingImportDataDto dto = (TrainingImportDataDto)collect.get(i);
            RegisterUserParam param = new RegisterUserParam();
            param.setUsername(dto.getIdCard());
            param.setName(dto.getUserName());
            saveList.add(param);
        }
        this.userProviderService.createUserForImport(saveList);
    }

    @Override
    @Transactional
    public void importTrainingData(List<TrainingImportDataDto> paramList, UserEditParam optParam) {
        this.checkAndFillTrainingData(paramList);
        this.saveTrainingData(paramList, optParam);
    }

    public void checkAndFillTrainingData(List<TrainingImportDataDto> paramList) {
        StringBuilder sb = new StringBuilder("\u9519\u8bef\u63d0\u793a:");
        for (int i = 0; i < paramList.size(); ++i) {
            TrainingImportDataDto trainDto = paramList.get(i);
            if (trainDto.getImportedTid() == null || trainDto.getImportedTid().equals("")) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u57f9\u8badid\u4e3a\u7a7a\uff01\n");
            }
            if (trainDto.getTrainingName() == null || trainDto.getTrainingName().equals("")) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u57f9\u8bad\u540d\u79f0\u4e3a\u7a7a\uff01\n");
            }
            if (trainDto.getTrainArea() != null) continue;
            sb.append("\u7b2c").append(i).append("\u884c").append("\u57f9\u8bad\u533a\u57df\u4e3a\u7a7a\uff01\n");
        }
        if (!sb.toString().equals("\u9519\u8bef\u63d0\u793a:")) {
            throw new ServiceException(sb.toString());
        }
    }

    @Transactional
    public void saveTrainingData(List<TrainingImportDataDto> paramList, UserEditParam optParam) {
        ArrayList<Training> saveList = new ArrayList<Training>();
        long batchId = IdUtil.getSnowflake().nextId();
        Map<String, TrainingImportDataDto> map = paramList.stream().collect(Collectors.toMap(TrainingImportDataDto::getImportedTid, t -> t, (key1, key2) -> key1));
        ArrayList<String> importedTidList = new ArrayList<String>(map.keySet());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(Training::getImportedId, importedTidList)).select(new SFunction[]{Training::getImportedId});
        List existList = this.trainingService.list((Wrapper)queryWrapper);
        existList.forEach(existTrain -> map.remove(existTrain.getImportedId()));
        ArrayList<TrainingImportDataDto> collect = new ArrayList<TrainingImportDataDto>(map.values());
        for (int i = 0; i < collect.size(); ++i) {
            TrainingImportDataDto importDataDto = (TrainingImportDataDto)collect.get(i);
            Training training = new Training();
            training.setImportedBatchCode(String.valueOf(batchId));
            training.setImportedId(importDataDto.getImportedTid());
            training.setTrainName(importDataDto.getTrainingName());
            training.setTrainArea(importDataDto.getTrainArea());
            training.setTrainStarTime(importDataDto.getTrainStarTime());
            training.setTrainEndTime(importDataDto.getTrainEndTime());
            training.setStatus(Byte.valueOf((byte)0));
            training.setCreateBy(optParam.getLoginUserId());
            training.setCreateName(optParam.getLoginName());
            training.setCouldModifyArea(Long.valueOf(330000000000L));
            saveList.add(training);
        }
        this.trainingService.saveBatch(saveList);
        for (Training train : saveList) {
            SyncTrainInfoModel syncTrainInfoModel = new SyncTrainInfoModel();
            syncTrainInfoModel.setTrainId(train.getId());
            syncTrainInfoModel.setTrainName(train.getTrainName());
            syncTrainInfoModel.setTrainTimeBegin(train.getTrainStarTime());
            syncTrainInfoModel.setTrainTimeEnd(train.getTrainEndTime());
            syncTrainInfoModel.setTrainType(train.getTrainType());
            syncTrainInfoModel.setAreaId(train.getTrainArea());
            syncTrainInfoModel.setOperater(optParam.getLoginUsername());
            syncTrainInfoModel.setCompanyName(optParam.getLoginName());
            syncTrainInfoModel.setIsValid(Boolean.valueOf(true));
            syncTrainInfoModel.setCreateBy(optParam.getLoginUserId());
            syncTrainInfoModel.setChangeType(Byte.valueOf((byte)3));
            syncTrainInfoModel.setChangeReason("\u5bfc\u5165\u57f9\u8bad");
            this.syncTrainInfoService.addOrUpdateTrainInfo(syncTrainInfoModel);
        }
    }

    @Override
    @Transactional
    public void importEnrollData(List<TrainingImportDataDto> paramList, UserEditParam userEditParam) {
        this.checkAndFillTuEnrollData(paramList);
        List<TuEnroll> tuEnrollList = this.saveEnrollData(paramList, userEditParam);
        if (CollectionUtil.isEmpty(tuEnrollList)) {
            return;
        }
        List tuEnrollIdList = tuEnrollList.stream().map(TuEnroll::getId).collect(Collectors.toList());
        List syncData = this.tuEnrollService.listByIds(tuEnrollIdList);
        if (CollectionUtil.isEmpty((Collection)syncData)) {
            return;
        }
        for (TuEnroll tuEnroll : syncData) {
            this.cropEnrollService.syncCropEnrollInfo(tuEnroll);
        }
    }

    @Transactional
    public List<TuEnroll> saveEnrollData(List<TrainingImportDataDto> paramList, UserEditParam optParam) {
        ArrayList<TuEnroll> tuEnrollList = new ArrayList<TuEnroll>();
        for (TrainingImportDataDto param : paramList) {
            Long tid = param.getTid();
            String importedTid = param.getImportedTid();
            String importedBatchCode = param.getImportedBatchCode();
            Long cid = param.getCid();
            String unitName = param.getUnitName();
            String trainingName = param.getTrainingName();
            TuEnroll tuEnroll = this.tuEnrollService.getByHseCidAndTid(cid, tid);
            if (tuEnroll != null && !TrainingStatusEnum.RETURNED.getValue().equals(tuEnroll.getTrainStatus())) continue;
            TuEnroll tmp = new TuEnroll();
            tmp.setId(tuEnroll == null ? null : tuEnroll.getId());
            tmp.setTid(tid);
            tmp.setImportedId(importedTid);
            tmp.setImportedBatchCode(importedBatchCode);
            tmp.setHseCid(cid);
            tmp.setTrainStatus(CropEnrollSourceEnum.IMPORT.getValue());
            tmp.setCompanyName(unitName);
            tmp.setTrainStatus(TrainingStatusEnum.TRAINING_COMPLETED.getValue());
            tmp.setSource(CropEnrollSourceEnum.IMPORT.getValue());
            tmp.setSyncState(Integer.valueOf(0));
            tmp.setCreateBy(optParam.getLoginUserId());
            tmp.setUpdateBy(optParam.getLoginUserId());
            tuEnrollList.add(tmp);
        }
        if (!CollectionUtil.isEmpty(tuEnrollList)) {
            List result = tuEnrollList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TuEnroll>(Comparator.comparing(v -> String.valueOf(v.getHseCid()) + v.getTid()))), ArrayList::new));
            this.tuEnrollService.saveOrUpdateBatch(result);
            return result;
        }
        return null;
    }

    public void checkAndFillTuEnrollData(List<TrainingImportDataDto> paramList) {
        StringBuilder sb = new StringBuilder("\u9519\u8bef\u63d0\u793a:");
        for (int i = 0; i < paramList.size(); ++i) {
            Training training;
            TrainingImportDataDto param = paramList.get(i);
            String importedTid = param.getImportedTid();
            String importedBatchCode = param.getImportedBatchCode();
            Long cid = param.getCid();
            String unitName = param.getUnitName();
            String trainingName = param.getTrainingName();
            if (StringUtils.isEmpty((CharSequence)importedBatchCode)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u6279\u6b21\u7f16\u53f7\u672a\u751f\u6210\u3002").append("\n");
            }
            if (importedTid == null || cid == null || StringUtils.isEmpty((CharSequence)unitName) || StringUtils.isEmpty((CharSequence)trainingName)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u5b58\u5728\u672a\u586b\u6570\u636e\u3002").append("\n");
            }
            if ((training = this.trainingService.getByImportedId(param.getImportedTid())) == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u7cfb\u7edf\u57f9\u8bad\u8fd8\u672a\u751f\u6210\u57f9\u8bad\u300a").append(trainingName).append("\u300b\u3002").append("\n");
            } else {
                param.setTid(training.getId());
            }
            HseCompanyVo hseCompanyVo = this.hseCompanyProviderService.getInfoById(cid);
            if (hseCompanyVo == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u516c\u53f8(").append(unitName).append(")\u4e0d\u5b58\u5728\u3002").append("\n");
                continue;
            }
            if (unitName.equals(hseCompanyVo.getName())) continue;
            sb.append("\u7b2c").append(i).append("\u884c").append("\u516c\u53f8(").append(unitName).append(")\u5176\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e2d\u516c\u53f8\u540d\u79f0\u4e0d\u4e00\u6837\u3002").append("\n");
        }
        if (!sb.toString().equals("\u9519\u8bef\u63d0\u793a:")) {
            throw new ServiceException(sb.toString());
        }
    }

    @Override
    @Transactional
    public void importTuEnrollDetailData(List<TrainingImportDataDto> paramList, UserEditParam userEditParam) {
        this.checkAndFillTuEnrollDetailData(paramList);
        this.saveTuEnrollDetailData(paramList, userEditParam);
    }

    @Transactional
    public void saveTuEnrollDetailData(List<TrainingImportDataDto> paramList, UserEditParam optParam) {
        Map<String, List<TrainingImportDataDto>> paramGroup = paramList.stream().collect(Collectors.groupingBy(v -> "" + v.getTuEnrollId() + v.getUid()));
        ArrayList detailList = new ArrayList();
        paramGroup.forEach((k, vList) -> {
            if (vList.size() >= 3 || vList.size() == 0) {
                throw new ServiceException("\u62a5\u540d\u6570\u91cf\u6709\u8bef");
            }
            TrainingImportDataDto param = (TrainingImportDataDto)vList.get(0);
            Long tid = param.getTid();
            Long uid = param.getUid();
            Long tuEnrollId = param.getTuEnrollId();
            String importedTid = param.getImportedTid();
            String importedBatchCode = param.getImportedBatchCode();
            Long cid = param.getCid();
            String idCard = param.getIdCard();
            String userName = param.getUserName();
            String unitName = param.getUnitName();
            String trainingName = param.getTrainingName();
            Training trainingInfo = (Training)this.trainingService.getById(tid);
            TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(tuEnrollId);
            HseCompanyVo hseCompanyVo = this.hseCompanyProviderService.getInfoById(cid);
            TuEnrollDetail tuEnrollDetailDB = this.tuEnrollDetailService.getByUidAndEnrollId(uid, tuEnrollId);
            if (tuEnrollDetailDB == null || TrainingStatusEnum.RETURNED.getValue().equals(tuEnrollDetailDB.getTrainStatus())) {
                TuEnrollDetail detail = new TuEnrollDetail();
                detail.setId(tuEnrollDetailDB == null ? null : tuEnrollDetailDB.getId());
                detail.setHseCid(cid);
                detail.setTid(tid);
                detail.setEnrollId(tuEnrollId);
                detail.setUid(uid);
                detail.setUname(userName);
                detail.setIdCard(idCard);
                detail.setEnrollSource(PersnoalEnrollSourceEnum.IMPORT.getValue());
                detail.setStudiedProgress(Integer.valueOf(1));
                detail.setStudyProgressTotal(Integer.valueOf(1));
                detail.setTestedProgress(Integer.valueOf(1));
                detail.setTestProgressTotal(Integer.valueOf(1));
                detail.setTestStatus(Integer.valueOf(2));
                detail.setTrainStatus(TrainingStatusEnum.GET_CERTIFICATE.getValue());
                detail.setStudiedClassHour(Double.valueOf(1.0));
                detail.setPassClassHour(Double.valueOf(1.0));
                detail.setClassHourTotal(Double.valueOf(1.0));
                detail.setCreditCode(hseCompanyVo.getCreditCode());
                detail.setCname(hseCompanyVo.getName());
                detail.setSynState(Integer.valueOf(0));
                detail.setCreateBy(optParam.getLoginUserId());
                detail.setUpdateBy(optParam.getLoginUserId());
                detail.setImportedId(importedTid);
                detail.setImportedBatchCode(importedBatchCode);
                String personType = vList.stream().map(v -> {
                    if ("12".equals(v.getCertType())) {
                        return "200001";
                    }
                    if ("13".equals(v.getCertType())) {
                        return "200002";
                    }
                    throw new ServiceException("\u8bc1\u4e66\u7c7b\u578b\u9519\u8bef");
                }).collect(Collectors.joining(","));
                detail.setPersonTypeCode(personType);
                detailList.add(detail);
            }
        });
        this.tuEnrollDetailService.saveOrUpdateBatch(detailList);
    }

    public void checkAndFillTuEnrollDetailData(List<TrainingImportDataDto> paramList) {
        StringBuilder sb = new StringBuilder("\u9519\u8bef\u63d0\u793a:");
        for (int i = 0; i < paramList.size(); ++i) {
            TrainingImportDataDto param = paramList.get(i);
            String importedTid = param.getImportedTid();
            String importedBatchCode = param.getImportedBatchCode();
            Long cid = param.getCid();
            String certType = param.getCertType();
            String idCard = param.getIdCard();
            String userName = param.getUserName();
            String unitName = param.getUnitName();
            String trainingName = param.getTrainingName();
            if (StringUtils.isEmpty((CharSequence)importedBatchCode)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u6279\u6b21\u7f16\u53f7\u672a\u751f\u6210\u3002").append("\n");
            }
            if (importedTid == null || cid == null || StringUtils.isEmpty((CharSequence)unitName) || StringUtils.isEmpty((CharSequence)trainingName) || StringUtils.isEmpty((CharSequence)idCard)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u5b58\u5728\u672a\u586b\u6570\u636e\u3002").append("\n");
            }
            if (StringUtils.isEmpty((CharSequence)certType)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u4eba\u5458\u7c7b\u578b\u672a\u586b\u5199\u3002").append("\n");
            } else if (!certType.equals("12") && !certType.equals("13")) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u4eba\u5458\u7c7b\u578b\u4e0d\u6b63\u786e\u3002").append("\n");
            }
            SysUser sysUser = this.userProviderService.getOneByIdCard(idCard);
            if (sysUser == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u7cfb\u7edf\u4e0d\u5b58\u5728\u7528\u6237(").append(userName).append(")\u3002").append("\n");
            } else {
                param.setUid(sysUser.getId());
            }
            Training training = this.trainingService.getByImportedId(param.getImportedTid());
            if (training == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u7cfb\u7edf\u57f9\u8bad\u8fd8\u672a\u751f\u6210\u57f9\u8bad\u300a").append(trainingName).append("\u300b\u3002").append("\n");
                continue;
            }
            param.setTid(training.getId());
            HseCompanyVo hseCompanyVo = this.hseCompanyProviderService.getInfoById(cid);
            if (hseCompanyVo == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u516c\u53f8(").append(unitName).append(")\u4e0d\u5b58\u5728\u3002").append("\n");
            }
            if (!unitName.equals(hseCompanyVo.getName())) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u516c\u53f8(").append(unitName).append(")\u5176\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e2d\u516c\u53f8\u540d\u79f0\u4e0d\u4e00\u6837\u3002").append("\n");
            }
            if (training == null || hseCompanyVo == null) continue;
            TuEnroll tuEnroll = this.tuEnrollService.getByHseCidAndTid(cid, training.getId());
            if (tuEnroll == null || TrainingStatusEnum.RETURNED.getValue().equals(tuEnroll.getTrainStatus())) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u4e0d\u5b58\u5728\u5355\u4f4d(").append(userName).append(")\u7684\u62a5\u540d\u6570\u636e\u3002").append("\n");
                continue;
            }
            param.setTuEnrollId(tuEnroll.getId());
        }
        if (!sb.toString().equals("\u9519\u8bef\u63d0\u793a:")) {
            throw new ServiceException(sb.toString());
        }
    }

    @Override
    @Transactional
    public void importTuCertificateData(List<TrainingImportDataDto> paramList, UserEditParam userEditParam) {
        this.checkAndFillTuCertificate(paramList);
        List<TuCertificate> tuCertificates = this.saveTuCertificateData(paramList, userEditParam);
        List certIdList = tuCertificates.stream().map(TuCertificate::getId).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(certIdList)) {
            return;
        }
        List syncData = this.tuCertificateService.listByIds(certIdList);
        if (CollectionUtil.isEmpty((Collection)syncData)) {
            return;
        }
        for (TuCertificate tuCertificate : syncData) {
            this.tuCertificateService.syncSingleInfo(tuCertificate);
        }
    }

    @Transactional
    public List<TuCertificate> saveTuCertificateData(List<TrainingImportDataDto> paramList, UserEditParam userEditParam) {
        ArrayList<TuCertificate> list = new ArrayList<TuCertificate>();
        for (int i = 0; i < paramList.size(); ++i) {
            TrainingImportDataDto param = paramList.get(i);
            String importedTid = param.getImportedTid();
            String importedBatchCode = param.getImportedBatchCode();
            Long cid = param.getCid();
            String certType = param.getCertType();
            String certTypePerson = "12".equals(certType) ? "200001" : ("13".equals(certType) ? "200002" : null);
            String certNo = param.getCertNo();
            String idCard = param.getIdCard();
            Date issueTime = param.getIssueTime();
            Date invalidDate = param.getInvalidDate();
            Date trainStarTime = param.getTrainStarTime();
            Date trainEndTime = param.getTrainEndTime();
            String userName = param.getUserName();
            String unitName = param.getUnitName();
            String trainingName = param.getTrainingName();
            TuCertificate tuCertificateDB = this.tuCertificateService.getByDetailIdAndCertType(param.getTuEnrollDetailId(), certTypePerson);
            if (tuCertificateDB != null) continue;
            Training training = (Training)this.trainingService.getById(param.getTid());
            TuCertificate tmp = new TuCertificate();
            tmp.setUid(param.getUid());
            tmp.setEnrollDetailId(param.getTuEnrollDetailId());
            tmp.setName(trainingName);
            tmp.setUname(userName);
            tmp.setIdCard(idCard);
            tmp.setAreaId(null);
            tmp.setYear(Integer.valueOf(DateUtil.year((Date)issueTime)));
            tmp.setCertType(certTypePerson);
            tmp.setCertificateNo(param.getCertNo());
            tmp.setQualificationCertNo(null);
            tmp.setTrainingName(trainingName);
            tmp.setTrainingUnitName(null);
            tmp.setUname(param.getUnitName());
            tmp.setTrainType(training.getTrainType());
            tmp.setTrainStarDate(trainStarTime);
            tmp.setTrainEndDate(trainEndTime);
            tmp.setIssueTime(issueTime);
            tmp.setInvalidDate(invalidDate);
            tmp.setSyncState(Integer.valueOf(0));
            tmp.setCreateBy(userEditParam.getLoginUserId());
            tmp.setUpdateBy(userEditParam.getLoginUserId());
            tmp.setTid(param.getTid());
            tmp.setImportedId(param.getImportedTid());
            tmp.setImportedBatchCode(param.getImportedBatchCode());
            tmp.setEnrollSource(PersnoalEnrollSourceEnum.IMPORT.getValue());
            list.add(tmp);
        }
        this.tuCertificateService.saveBatch(list);
        return list;
    }

    public void checkAndFillTuCertificate(List<TrainingImportDataDto> paramList) {
        StringBuilder sb = new StringBuilder("\u9519\u8bef\u63d0\u793a:");
        for (int i = 0; i < paramList.size(); ++i) {
            TrainingImportDataDto param = paramList.get(i);
            String importedTid = param.getImportedTid();
            String importedBatchCode = param.getImportedBatchCode();
            Long cid = param.getCid();
            String certType = param.getCertType();
            String certNo = param.getCertNo();
            String idCard = param.getIdCard();
            Date issueTime = param.getIssueTime();
            Date invalidDate = param.getInvalidDate();
            String userName = param.getUserName();
            String unitName = param.getUnitName();
            String trainingName = param.getTrainingName();
            if (StringUtils.isEmpty((CharSequence)importedBatchCode)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u6279\u6b21\u7f16\u53f7\u672a\u751f\u6210\u3002").append("\n");
            }
            if (importedTid == null || cid == null || StringUtils.isEmpty((CharSequence)unitName) || StringUtils.isEmpty((CharSequence)trainingName) || StringUtils.isEmpty((CharSequence)certNo) || issueTime == null || invalidDate == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u5b58\u5728\u672a\u586b\u6570\u636e\u3002").append("\n");
            }
            if (StringUtils.isEmpty((CharSequence)idCard)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u672a\u586b\u8eab\u4efd\u8bc1\u3002").append("\n");
            }
            if (StringUtils.isEmpty((CharSequence)certType)) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u4eba\u5458\u7c7b\u578b\u672a\u6765\u586b\u5199\u3002").append("\n");
            } else if (!certType.equals("12") && !certType.equals("13")) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u4eba\u5458\u7c7b\u578b\u4e0d\u6b63\u786e\u3002").append("\n");
            }
            SysUser sysUser = this.userProviderService.getOneByIdCard(idCard);
            if (sysUser == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u7cfb\u7edf\u4e0d\u5b58\u5728\u7528\u6237(").append(userName).append(")\u3002").append("\n");
            } else {
                param.setUid(sysUser.getId());
            }
            Training training = this.trainingService.getByImportedId(param.getImportedTid());
            if (training == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u7cfb\u7edf\u57f9\u8bad\u8fd8\u672a\u751f\u6210\u57f9\u8bad\u300a").append(trainingName).append("\u300b\u3002").append("\n");
                continue;
            }
            param.setTid(training.getId());
            HseCompanyVo hseCompanyVo = this.hseCompanyProviderService.getInfoById(cid);
            if (hseCompanyVo == null) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u516c\u53f8(").append(unitName).append(")\u4e0d\u5b58\u5728\u3002").append("\n");
            }
            if (!unitName.equals(hseCompanyVo.getName())) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u516c\u53f8(").append(unitName).append(")\u5176\u540d\u79f0\u4e0e\u7cfb\u7edf\u4e2d\u516c\u53f8\u540d\u79f0\u4e0d\u4e00\u6837\u3002").append("\n");
            }
            TuEnroll tuEnroll = null;
            if (training != null && hseCompanyVo != null) {
                tuEnroll = this.tuEnrollService.getByHseCidAndTid(cid, training.getId());
                if (tuEnroll == null) {
                    sb.append("\u7b2c").append(i).append("\u884c").append("\u4e0d\u5b58\u5728\u5355\u4f4d(").append(userName).append("(\u7684\u62a5\u540d\u6570\u636e\u3002").append("\n");
                } else {
                    param.setTuEnrollId(tuEnroll.getId());
                }
            }
            if (tuEnroll == null || sysUser == null) continue;
            TuEnrollDetail tuEnrollDetailDB = this.tuEnrollDetailService.getByUidAndEnrollId(sysUser.getId(), tuEnroll.getId());
            if (tuEnrollDetailDB == null || TrainingStatusEnum.RETURNED.getValue().equals(tuEnrollDetailDB.getTrainStatus())) {
                sb.append("\u7b2c").append(i).append("\u884c").append("\u62a5\u540d\u4e0d\u5b58\u5728\u5355\u4f4d\u3002").append("\n");
                continue;
            }
            param.setTuEnrollDetailId(tuEnrollDetailDB.getId());
        }
        if (!sb.toString().equals("\u9519\u8bef\u63d0\u793a:")) {
            throw new ServiceException(sb.toString());
        }
    }
}

