/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.enroll.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISuperviseTrainPlanService;
import cn.smarthse.radiationTraining.core.framework.utils.AccountUtil;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperProviderService;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnroll;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingStatusEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToRemoveStaffParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToRmCropEnrollParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToSendBackCropParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.AdminToSendBackParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainEnrollDetailOptBatchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainEnrollOptBatchParam;
import cn.smarthse.radiationTraining.modules.training.service.certificate.ITuCertificateService;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IAdminEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ICropEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.IUserEnrollService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.vo.enroll.EnrollOptVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdminEnrollServiceImpl
implements IAdminEnrollService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminEnrollServiceImpl.class);
    @Autowired
    private ITuEnrollDetailService tuEnrollDetailService;
    @Autowired
    private ITuCourseService tuCourseService;
    @Autowired
    private ITrainingService trainingService;
    @Autowired
    private ITuCertificateService tuCertificateService;
    @Autowired
    private ITuEnrollService tuEnrollService;
    @Autowired
    private ICropEnrollService cropEnrollService;
    @Autowired
    private IUserEnrollService userEnrollService;
    @Autowired
    private ITrainingRedisService trainingRedisService;
    @DubboReference(registry={"public_nacos"})
    private ISuperviseTrainPlanService superviseTrainPlanService;
    @DubboReference
    private ITuPaperProviderService tuPaperProviderService;

    @Override
    @Transactional
    public void adminToSendBack(AdminToSendBackParam param) {
        Long enrollDetailId = param.getEnrollDetailId();
        TuEnrollDetail tuEnrollDetailDB = (TuEnrollDetail)this.tuEnrollDetailService.getById(enrollDetailId);
        EnrollOptVo cropSignUpVo = this.ifCanSendBackEnrollDetail(tuEnrollDetailDB, param);
        if (cropSignUpVo != null && cropSignUpVo.getCode() == 0) {
            throw new ServiceException(cropSignUpVo.getMsg());
        }
        tuEnrollDetailDB.setTrainStatus(TrainingStatusEnum.RETURNED.getValue());
        tuEnrollDetailDB.setUpdateTime(new Date());
        tuEnrollDetailDB.setUpdateBy(param.getLoginUserId());
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
    }

    @Transactional
    public List<EnrollOptVo> adminToSendBackBatch(List<AdminToSendBackParam> paramList) {
        List idList = paramList.stream().map(v -> v.getEnrollDetailId()).collect(Collectors.toList());
        List tuEnrollDetailList = this.tuEnrollDetailService.listByIds(idList);
        ArrayList<EnrollOptVo> errorList = new ArrayList<EnrollOptVo>();
        ArrayList<TuEnrollDetail> candSendBackList = new ArrayList<TuEnrollDetail>();
        for (TuEnrollDetail detail : tuEnrollDetailList) {
            EnrollOptVo cropSignUpVo = this.ifCanSendBackEnrollDetail(detail, paramList.get(0));
            if (cropSignUpVo != null && cropSignUpVo.getCode() == 0) {
                errorList.add(cropSignUpVo);
                continue;
            }
            candSendBackList.add(detail);
        }
        if (candSendBackList.size() > 0) {
            for (TuEnrollDetail detail : candSendBackList) {
                detail.setTrainStatus(TrainingStatusEnum.RETURNED.getValue());
                detail.setUpdateTime(new Date());
                detail.setUpdateBy(paramList.get(0).getLoginUserId());
                this.tuEnrollDetailService.updateById(detail);
            }
        }
        return errorList;
    }

    public EnrollOptVo ifCanSendBackEnroll(AdminToSendBackCropParam param, TuEnroll tuEnroll, List<TuEnrollDetail> tuEnrollDetailList) {
        if (tuEnroll == null || tuEnroll.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue()) {
            return null;
        }
        if (AccountUtil.isSpecifiedUserName((String)param.getOptName())) {
            return null;
        }
        for (TuEnrollDetail detail : tuEnrollDetailList) {
            double studyProgressTotal;
            double studiedProgress;
            if (detail.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue() || !((studiedProgress = (double)detail.getStudiedProgress().intValue()) / (studyProgressTotal = (double)detail.getStudyProgressTotal().intValue()) >= 0.5)) continue;
            return new EnrollOptVo(Integer.valueOf(0), null, null, null, "\u5b66\u4e60\u8fdb\u5ea6\u5df2\u7ecf\u8fbe\u523050%,\u65e0\u6cd5\u9000\u56de", null);
        }
        return null;
    }

    @Override
    @Transactional
    public void adminToSendBackCrop(AdminToSendBackCropParam param) {
        Long enrollId = param.getEnrollId();
        TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(enrollId);
        if (tuEnroll == null || tuEnroll.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue()) {
            return;
        }
        List<TuEnrollDetail> tuEnrollDetailList = this.tuEnrollDetailService.getByEnrollId(tuEnroll.getId());
        EnrollOptVo enrollOptVo = this.ifCanSendBackEnroll(param, tuEnroll, tuEnrollDetailList);
        if (enrollOptVo != null && enrollOptVo.getCode() == 0) {
            throw new ServiceException(enrollOptVo.getMsg());
        }
        for (TuEnrollDetail detail : tuEnrollDetailList) {
            detail.setTrainStatus(TrainingStatusEnum.RETURNED.getValue());
            detail.setUpdateBy(param.getLoginUserId());
        }
        this.tuEnrollDetailService.updateBatchById(tuEnrollDetailList);
        tuEnroll.setTrainStatus(TrainingStatusEnum.RETURNED.getValue());
        tuEnroll.setUpdateTime(new Date());
        tuEnroll.setUpdateBy(param.getLoginUserId());
        tuEnroll.setSynDes("\u975e\u804c\u4e1a\u5065\u5eb7\u63d0\u793a\uff1a\u57f9\u8bad\u5df2\u7ecf\u9000\u56de\uff0c\u9700\u8981\u540c\u6b65\u9000\u56de\u72b6\u6001");
        tuEnroll.setSyncState(Integer.valueOf(0));
        tuEnroll.setUpdateBy(param.getLoginUserId());
        this.tuEnrollService.updateById(tuEnroll);
        this.cropEnrollService.syncCropEnrollInfo(tuEnroll);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnroll.getTid());
        try {
            this.superviseTrainPlanService.sendOnlineTrainBackMessage(Long.valueOf(param.getAdminToken()), Long.valueOf(tuEnroll.getHseCid()), trainingInfo.getId(), trainingInfo.getTrainName(), "training/detail/" + trainingInfo.getId());
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public List<EnrollOptVo> adminToSendBackCropBatch(List<AdminToSendBackCropParam> paramList) {
        ArrayList<EnrollOptVo> errInfoList = new ArrayList<EnrollOptVo>();
        for (AdminToSendBackCropParam param : paramList) {
            Long enrollId = param.getEnrollId();
            TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(enrollId);
            if (tuEnroll == null || tuEnroll.getTrainStatus() == TrainingStatusEnum.RETURNED.getValue()) continue;
            List<TuEnrollDetail> tuEnrollDetailList = this.tuEnrollDetailService.getByEnrollId(tuEnroll.getId());
            EnrollOptVo enrollOptVo = this.ifCanSendBackEnroll(param, tuEnroll, tuEnrollDetailList);
            if (enrollOptVo != null && enrollOptVo.getCode() == 0) {
                errInfoList.add(enrollOptVo);
                continue;
            }
            for (TuEnrollDetail detail : tuEnrollDetailList) {
                detail.setTrainStatus(TrainingStatusEnum.RETURNED.getValue());
                detail.setUpdateBy(param.getLoginUserId());
            }
            this.tuEnrollDetailService.updateBatchById(tuEnrollDetailList);
            tuEnroll.setTrainStatus(TrainingStatusEnum.RETURNED.getValue());
            tuEnroll.setUpdateTime(new Date());
            tuEnroll.setUpdateBy(param.getLoginUserId());
            tuEnroll.setSynDes("\u975e\u804c\u4e1a\u5065\u5eb7\u63d0\u793a\uff1a\u57f9\u8bad\u5df2\u7ecf\u9000\u56de\uff0c\u9700\u8981\u540c\u6b65\u9000\u56de\u72b6\u6001");
            tuEnroll.setSyncState(Integer.valueOf(0));
            tuEnroll.setUpdateBy(param.getLoginUserId());
            this.tuEnrollService.updateById(tuEnroll);
            this.cropEnrollService.syncCropEnrollInfo(tuEnroll);
            TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnroll.getTid());
            try {
                this.superviseTrainPlanService.sendOnlineTrainBackMessage(Long.valueOf(param.getAdminToken()), Long.valueOf(tuEnroll.getHseCid()), trainingInfo.getId(), trainingInfo.getTrainName(), "training/detail/" + trainingInfo.getId());
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        }
        return errInfoList;
    }

    @Override
    @Transactional
    public void adminToDeletePersonalEnrollDetail(AdminToRemoveStaffParam param) {
        if (!AccountUtil.isSpecifiedUserName((String)param.getOptName())) {
            throw new ServiceException("\u60a8\u6ca1\u6709\u5220\u9664\u4e2a\u4eba\u62a5\u540d\u7684\u6743\u9650");
        }
        Long enrollDetailId = param.getEnrollDetailId();
        TuEnrollDetail tuEnrollDetailDB = (TuEnrollDetail)this.tuEnrollDetailService.getById(enrollDetailId);
        if (tuEnrollDetailDB == null) {
            return;
        }
        this.tuCourseService.deleteByEnrollDetailId(enrollDetailId);
        this.tuCertificateService.rmByEnrollDetailId(enrollDetailId);
        tuEnrollDetailDB.setUpdateBy(param.getLoginUserId());
        tuEnrollDetailDB.setUpdateName(param.getLoginUsername());
        this.tuEnrollDetailService.updateById(tuEnrollDetailDB);
        this.tuEnrollDetailService.removeById(enrollDetailId);
        this.tuPaperProviderService.delTuPaperAndQuestion(enrollDetailId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuEnrollDetailDB.getTid());
        this.tuEnrollDetailService.perTrainingInfoDeleteAndRecovery(tuEnrollDetailDB, trainingInfo, param.getToken());
        this.trainingRedisService.delTrainingById(tuEnrollDetailDB.getTid());
    }

    @Override
    @Transactional
    public List<EnrollOptVo> adminToDeletePersonalEnrollDetailBatch(List<AdminToRemoveStaffParam> paramList) {
        AdminToRemoveStaffParam param = paramList.get(0);
        if (!AccountUtil.isSpecifiedUserName((String)param.getOptName())) {
            throw new ServiceException("\u60a8\u6ca1\u6709\u5220\u9664\u4e2a\u4eba\u62a5\u540d\u7684\u6743\u9650");
        }
        List idList = paramList.stream().map(v -> v.getEnrollDetailId()).collect(Collectors.toList());
        List detailList = this.tuEnrollDetailService.listByIds(idList);
        ArrayList<Long> canRemoveList = new ArrayList<Long>();
        ArrayList<TuEnrollDetail> canRemoveInfoList = new ArrayList<TuEnrollDetail>();
        ArrayList<EnrollOptVo> errInfoList = new ArrayList<EnrollOptVo>();
        for (TuEnrollDetail detail : detailList) {
            if (detail.getTrainStatus() != TrainingStatusEnum.RETURNED.getValue()) {
                errInfoList.add(new EnrollOptVo(Integer.valueOf(0), detail.getEmail(), detail.getUname(), detail.getIdCard(), "\u7528\u6237\u672a\u9000\u56de\u65e0\u6cd5\u5220\u9664", null));
                continue;
            }
            canRemoveList.add(detail.getId());
            canRemoveInfoList.add(detail);
        }
        if (canRemoveList.size() > 0) {
            for (TuEnrollDetail detail : canRemoveInfoList) {
                detail.setUpdateBy(param.getLoginUserId());
                detail.setUpdateName(param.getOptName());
                this.tuEnrollDetailService.updateById(detail);
            }
            this.tuCourseService.deleteByEnrollDetailIds(canRemoveList);
            this.tuCertificateService.rmByEnrollDetailIds(canRemoveList);
            this.tuEnrollDetailService.removeByIds(canRemoveList);
            this.tuPaperProviderService.delTuPaperAndQuestionBatch(canRemoveList);
            TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(((TuEnrollDetail)canRemoveInfoList.get(0)).getTid());
            for (TuEnrollDetail detail : canRemoveInfoList) {
                this.tuEnrollDetailService.perTrainingInfoDeleteAndRecovery(detail, trainingInfo, param.getToken());
            }
            this.trainingRedisService.delTrainingById(((TuEnrollDetail)detailList.get(0)).getTid());
        }
        return errInfoList;
    }

    @Override
    @Transactional
    public List<EnrollOptVo> adminToDeleteEnrollBatch(List<AdminToRmCropEnrollParam> paramList) {
        if (CollectionUtil.isEmpty(paramList)) {
            return null;
        }
        AdminToRmCropEnrollParam param = paramList.get(0);
        if (!AccountUtil.isSpecifiedUserName((String)param.getOptName())) {
            return Collections.singletonList(new EnrollOptVo(Integer.valueOf(0), "\u60a8\u6ca1\u6709\u5220\u9664\u5355\u4f4d\u62a5\u540d\u7684\u6743\u9650"));
        }
        List idList = paramList.stream().map(v -> v.getEnrollId()).collect(Collectors.toList());
        List tuEnrollList = this.tuEnrollService.listByIds(idList);
        ArrayList<EnrollOptVo> errInfoList = new ArrayList<EnrollOptVo>();
        for (TuEnroll tuEnroll : tuEnrollList) {
            EnrollOptVo enrollOptVo = this.adminToDeleteEnroll(tuEnroll, paramList.get(0).getLoginUserId(), paramList.get(0).getOptName());
            if (enrollOptVo == null || enrollOptVo.getCode() != 0) continue;
            errInfoList.add(enrollOptVo);
        }
        return errInfoList;
    }

    @Transactional
    public EnrollOptVo adminToDeleteEnroll(TuEnroll tuEnroll, Long opt, String optName) {
        if (tuEnroll != null && tuEnroll.getTrainStatus() != TrainingStatusEnum.RETURNED.getValue()) {
            return new EnrollOptVo(Integer.valueOf(0), "\u5355\u4f4d\u57f9\u8bad\u8fd8\u672a\u9000\u56de,\u65e0\u6cd5\u5220\u9664");
        }
        this.userEnrollService.rmByEnrollId(tuEnroll.getId(), opt, optName);
        return null;
    }

    @Override
    @Transactional
    public void adminToDeleteEnroll(AdminToRmCropEnrollParam param) {
        Long enrolllId = param.getEnrollId();
        TuEnroll tuEnroll = (TuEnroll)this.tuEnrollService.getById(enrolllId);
        if (!AccountUtil.isSpecifiedUserName((String)param.getOptName())) {
            throw new ServiceException("\u60a8\u6ca1\u6709\u5220\u9664\u5355\u4f4d\u62a5\u540d\u7684\u6743\u9650");
        }
        EnrollOptVo enrollOptVo = this.adminToDeleteEnroll(tuEnroll, param.getLoginUserId(), param.getOptName());
        if (enrollOptVo != null && enrollOptVo.getCode() == 0) {
            throw new ServiceException(enrollOptVo.getMsg());
        }
    }

    @Override
    @Transactional
    public List<EnrollOptVo> enrollDetailOptBath(List<TrainEnrollDetailOptBatchParam> paramList) {
        if (CollectionUtil.isEmpty(paramList)) {
            return null;
        }
        Map<Byte, List<TrainEnrollDetailOptBatchParam>> batchGroup = paramList.stream().collect(Collectors.groupingBy(v -> v.getType()));
        ArrayList<EnrollOptVo> errorListInfo = new ArrayList<EnrollOptVo>();
        batchGroup.forEach((k, optList) -> {
            if (k == 0) {
                ArrayList<AdminToSendBackParam> sendBackParamList = new ArrayList<AdminToSendBackParam>();
                for (TrainEnrollDetailOptBatchParam opt : optList) {
                    sendBackParamList.add(new AdminToSendBackParam().setEnrollDetailId(opt.getEnrollDetailId()).setOptUserType(opt.getOptUserType()).setOperationRole(opt.getOperationRole()).setOptName(opt.getOptName()));
                }
                errorListInfo.addAll(this.adminToSendBackBatch(sendBackParamList));
            } else if (k == 1) {
                List<AdminToRemoveStaffParam> removeStaffParamList = paramList.stream().map(v -> {
                    AdminToRemoveStaffParam adminToRemoveStaffParam = new AdminToRemoveStaffParam().setEnrollDetailId(v.getEnrollDetailId()).setOptUserType(v.getOptUserType()).setOperationRole(v.getOperationRole()).setOptName(v.getOptName()).setToken(v.getToken());
                    adminToRemoveStaffParam.setLoginUserId(v.getLoginUserId());
                    return adminToRemoveStaffParam;
                }).collect(Collectors.toList());
                errorListInfo.addAll(this.adminToDeletePersonalEnrollDetailBatch(removeStaffParamList));
            } else if (k == 2) {
                // empty if block
            }
        });
        return errorListInfo;
    }

    @Override
    @Transactional
    public List<EnrollOptVo> enrollOptBath(List<TrainEnrollOptBatchParam> paramList) {
        if (CollectionUtil.isEmpty(paramList)) {
            return null;
        }
        ArrayList<EnrollOptVo> errorInfoList = new ArrayList<EnrollOptVo>();
        Map<Byte, List<TrainEnrollOptBatchParam>> batchGroup = paramList.stream().collect(Collectors.groupingBy(v -> v.getType()));
        batchGroup.forEach((k, optList) -> {
            if (k == 0) {
                List<AdminToSendBackCropParam> sendBackCropParamList = paramList.stream().map(v -> new AdminToSendBackCropParam().setAdminToken(v.getAdminToken()).setOperationRole(v.getOperationRole()).setOptName(v.getOptName()).setOptUserType(v.getOptUserType()).setEnrollId(v.getEnrolllId())).collect(Collectors.toList());
                List<EnrollOptVo> enrollOptVoList = this.adminToSendBackCropBatch(sendBackCropParamList);
                errorInfoList.addAll(enrollOptVoList);
            } else if (k == 1) {
                List<AdminToRmCropEnrollParam> adminToRmCropEnrollParamList = paramList.stream().map(v -> {
                    AdminToRmCropEnrollParam param = new AdminToRmCropEnrollParam().setEnrollId(v.getEnrolllId()).setAdminToken(v.getAdminToken()).setOperationRole(v.getOperationRole()).setOptName(v.getOptName()).setOptUserType(v.getOptUserType());
                    param.setLoginUserId(v.getLoginUserId());
                    return param;
                }).collect(Collectors.toList());
                List<EnrollOptVo> enrollOptVoList = this.adminToDeleteEnrollBatch(adminToRmCropEnrollParamList);
                errorInfoList.addAll(enrollOptVoList);
            } else if (k == 2) {
                // empty if block
            }
        });
        return errorInfoList;
    }

    private EnrollOptVo ifCanSendBackEnrollDetail(TuEnrollDetail tuEnrollDetail, AdminToSendBackParam param) {
        double studyProgressTotal;
        if (AccountUtil.isSpecifiedUserName((String)param.getOptName())) {
            return null;
        }
        double studiedProgress = tuEnrollDetail.getStudiedProgress().intValue();
        if (studiedProgress / (studyProgressTotal = (double)tuEnrollDetail.getStudyProgressTotal().intValue()) >= 0.5) {
            return new EnrollOptVo(Integer.valueOf(0), tuEnrollDetail.getEmail(), tuEnrollDetail.getUname(), tuEnrollDetail.getIdCard(), "\u5b66\u4e60\u8fdb\u5ea6\u5df2\u7ecf\u8fbe\u523050%,\u65e0\u6cd5\u9000\u56de", null);
        }
        return null;
    }

    private EnrollOptVo ifCanRmForAdmin(TuEnrollDetail tuEnrollDetail) {
        Integer studiedProgress = tuEnrollDetail.getStudiedProgress();
        if (studiedProgress > 0) {
            return new EnrollOptVo(Integer.valueOf(0), tuEnrollDetail.getEmail(), tuEnrollDetail.getUname(), tuEnrollDetail.getIdCard(), "\u5df2\u7ecf\u5f00\u59cb\u5b66\u4e60,\u65e0\u6cd5\u5220\u9664", null);
        }
        return null;
    }
}

