/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.smarthse.radiationTraining.modules.training.dao.course.CourseItemWorkTypeMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemWorkType;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemWorkTypeService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CourseItemWorkTypeServiceImpl
extends ServiceImpl<CourseItemWorkTypeMapper, CourseItemWorkType>
implements ICourseItemWorkTypeService {
    @Resource
    private CourseItemWorkTypeMapper courseItemWorkTypeMapper;

    @Override
    public List<String> getCodesByCourseItemId(Long courseItemId) {
        List<CourseItemWorkType> courseItemByCourseItemId = this.getCourseItemByCourseItemId(courseItemId);
        if (courseItemByCourseItemId == null) {
            return null;
        }
        return courseItemByCourseItemId.stream().map(v -> v.getWorkTypeCode()).collect(Collectors.toList());
    }

    @Override
    public List<CourseItemWorkType> getCourseItemByCourseItemId(Long courseItemId) {
        QueryWrapper courseItemWorkTypeQueryWrapper = new QueryWrapper();
        courseItemWorkTypeQueryWrapper.eq((Object)"course_item_id", (Object)courseItemId);
        return this.courseItemWorkTypeMapper.selectList((Wrapper)courseItemWorkTypeQueryWrapper);
    }

    @Override
    public Integer deleteByCourseItemId(Long courseItemId) {
        QueryWrapper courseItemWorkTypeQueryWrapper = new QueryWrapper();
        courseItemWorkTypeQueryWrapper.eq((Object)"course_item_id", (Object)courseItemId);
        return this.courseItemWorkTypeMapper.delete((Wrapper)courseItemWorkTypeQueryWrapper);
    }

    @Override
    public void updateIsValidByCourseItemId(Long courseItemId, Integer isValid) {
        this.courseItemWorkTypeMapper.updateIsValidByCourseItemId(courseItemId, isValid);
    }

    @Override
    public CourseItemWorkType getByGroupIdAndWorkTypeCodeInIsValidEq0Or1(Long courseItemId, String workTypeCode) {
        return this.courseItemWorkTypeMapper.getByGroupIdAndWorkTypeCodeInIsValidEq0Or1(courseItemId, workTypeCode);
    }

    @Override
    public void updateIsValidByItemIdAndWorkTypeCode(Long courseItemId, String workTypeCode, int isValid) {
        this.courseItemWorkTypeMapper.updateIsValidByItemIdAndWorkTypeCode(courseItemId, workTypeCode, isValid);
    }

    @Override
    public void removeByItemIdAndWorkTypeCode(Long courseItemId, String workTypeCode) {
        QueryWrapper courseItemWorkTypeQueryWrapper = new QueryWrapper();
        ((QueryWrapper)courseItemWorkTypeQueryWrapper.eq((Object)"work_type_code", (Object)workTypeCode)).eq((Object)"course_item_id", (Object)courseItemId);
        this.courseItemWorkTypeMapper.delete((Wrapper)courseItemWorkTypeQueryWrapper);
    }

    @Override
    public List<CourseItemWorkType> getByCourseItemId(Long itemId) {
        QueryWrapper workTypeQueryWrapper = new QueryWrapper();
        workTypeQueryWrapper.eq((Object)"course_item_id", (Object)itemId);
        return ((CourseItemWorkTypeMapper)this.baseMapper).selectList((Wrapper)workTypeQueryWrapper);
    }

    @Override
    public Set<CourseWorkTypeVo> getWorkTypeSet() {
        return ((CourseItemWorkTypeMapper)this.baseMapper).getWorkTypeSet();
    }

    @Override
    public List<CourseWorkTypeVo> getWorkTypeByGroupId(Long courseGroupId) {
        return ((CourseItemWorkTypeMapper)this.baseMapper).getWorkTypeByGroupId(courseGroupId);
    }

    @Override
    public boolean exist(String code, Long courseItemId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(CourseItemWorkType::getCourseItemId, (Object)courseItemId)).eq(CourseItemWorkType::getWorkTypeCode, (Object)code);
        return ((CourseItemWorkTypeMapper)this.baseMapper).selectOne((Wrapper)wrapper) != null;
    }
}

