/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.smarthse.radiationTraining.modules.training.dao.course.CourseItemIndustryMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemIndustryService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class CourseItemIndustryServiceImpl
extends ServiceImpl<CourseItemIndustryMapper, CourseItemIndustry>
implements ICourseItemIndustryService {
    @Override
    public List<CourseItemIndustry> getByGroupId(Long groupId) {
        return ((CourseItemIndustryMapper)this.baseMapper).getByGroupId(groupId);
    }

    @Override
    public boolean exist(String code, Long courseItemId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(CourseItemIndustry::getCourseItemId, (Object)courseItemId)).eq(CourseItemIndustry::getCode, (Object)code);
        return ((CourseItemIndustryMapper)this.baseMapper).selectOne((Wrapper)wrapper) != null;
    }

    @Override
    public List<CourseItemIndustry> getByCourseItemId(Long courseItemId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(CourseItemIndustry::getCourseItemId, (Object)courseItemId);
        return ((CourseItemIndustryMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void removeByCourseItemId(Long courseItemId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(CourseItemIndustry::getCourseItemId, (Object)courseItemId);
        ((CourseItemIndustryMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public List<CourseItemIndustry> getByCourseItemIdList(List<Long> courseItemIdList) {
        if (CollectionUtils.isEmpty(courseItemIdList)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(CourseItemIndustry::getCourseItemId, courseItemIdList);
        return ((CourseItemIndustryMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }
}

