/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.course.impl;

import cn.smarthse.radiationTraining.modules.training.dao.course.CourseGroupItemMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseGroupItem;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupItemService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseWorkTypeVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CourseGroupItemServiceImpl
extends ServiceImpl<CourseGroupItemMapper, CourseGroupItem>
implements ICourseGroupItemService {
    @Resource
    private CourseGroupItemMapper courseGroupItemMapper;

    @Override
    public CourseGroupItem getLast(Long courseGroupId) {
        return this.courseGroupItemMapper.getLast(courseGroupId);
    }

    @Override
    @Transactional
    public boolean deleteByCourseItemId(Long courseItemId) {
        QueryWrapper courseGroupItemQueryWrapper = new QueryWrapper();
        courseGroupItemQueryWrapper.eq((Object)"course_item_id", (Object)courseItemId);
        this.courseGroupItemMapper.delete((Wrapper)courseGroupItemQueryWrapper);
        return true;
    }

    @Override
    public List<Long> getCourseGroupIdsByCourseItemId(Long courseItemId) {
        return this.courseGroupItemMapper.getCourseGroupIdsByCourseItemId(courseItemId);
    }

    @Override
    @Transactional
    public void updateIsValidByCourseItemId(Long courseItemId, Integer isValid) {
        this.courseGroupItemMapper.updateIsValidByCourseItemId(courseItemId, isValid);
    }

    @Override
    @Transactional
    public void updateSequence(Long courseGroupId, Long courseItemId, Long pageSequence) {
        this.courseGroupItemMapper.updateSequence(courseGroupId, courseItemId, pageSequence);
    }

    @Override
    public List<CourseGroupItem> getByGroupId(Long groupId) {
        return this.courseGroupItemMapper.getByGroupId(groupId);
    }

    @Override
    @Transactional
    public void deleteByCourseGroupId(Long groupId) {
        QueryWrapper courseGroupItemQueryWrapper = new QueryWrapper();
        courseGroupItemQueryWrapper.eq((Object)"course_group_id", (Object)groupId);
        this.courseGroupItemMapper.delete((Wrapper)courseGroupItemQueryWrapper);
    }

    @Override
    public CourseGroupItem getByGroupIdAndItemIdInIsValidEq0Or1(Long courseGroupId, Long courseItemId) {
        return this.courseGroupItemMapper.getByGroupIdAndItemIdInIsValidEq0Or1(courseGroupId, courseItemId);
    }

    @Override
    @Transactional
    public void updateIsValidByGroupIdAndItemId(Long courseGroupId, Long courseItemId, int isValid) {
        this.courseGroupItemMapper.updateIsValidByGroupIdAndItemId(courseGroupId, courseItemId, isValid);
    }

    @Override
    @Transactional
    public void removeByGroupoIdAndItemId(Long courseGroupId, Long courseItemId) {
        QueryWrapper courseGroupItemQueryWrapper = new QueryWrapper();
        ((QueryWrapper)courseGroupItemQueryWrapper.eq((Object)"course_group_id", (Object)courseGroupId)).eq((Object)"course_item_id", (Object)courseItemId);
        this.courseGroupItemMapper.delete((Wrapper)courseGroupItemQueryWrapper);
    }

    @Override
    public List<CourseWorkTypeVo> getWorkTypeByCourseItemId(String id) {
        return ((CourseGroupItemMapper)this.baseMapper).getWorkTypeByCourseItemId(id);
    }

    @Override
    public List<CourseGroupItem> getByCourseItemId(Long itemId) {
        QueryWrapper courseGroupItemQueryWrapper = new QueryWrapper();
        courseGroupItemQueryWrapper.eq((Object)"course_item_id", (Object)itemId);
        return ((CourseGroupItemMapper)this.baseMapper).selectList((Wrapper)courseGroupItemQueryWrapper);
    }

    @Override
    public boolean exist(Long gourpId, Long courseItemId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(CourseGroupItem::getCourseGroupId, (Object)gourpId)).eq(CourseGroupItem::getCourseItemId, (Object)courseItemId);
        return ((CourseGroupItemMapper)this.baseMapper).selectOne((Wrapper)wrapper) != null;
    }
}

