/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.service.aspect;

import cn.smarthse.radiationTraining.core.framework.annotation.AtomEnrollLimit;
import cn.smarthse.radiationTraining.modules.training.service.redis.IEnrollLockRedisService;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=-1)
public class EnrollLimitAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnrollLimitAspect.class);
    @Autowired
    private IEnrollLockRedisService enrollLockRedisService;

    @Pointcut(value="@annotation( cn.smarthse.radiationTraining.core.framework.annotation.AtomEnrollLimit)")
    public void logPoinCut() {
    }

    @Around(value="logPoinCut()")
    public Object limit(ProceedingJoinPoint proceedingJoinPoint) {
        Long targetId;
        MethodSignature signature = (MethodSignature)proceedingJoinPoint.getSignature();
        Method method = signature.getMethod();
        AtomEnrollLimit annotation = method.getAnnotation(AtomEnrollLimit.class);
        int optType = annotation.optType();
        String tidEl = annotation.tid();
        String targetIdEl = annotation.targetId();
        Long tid = Long.valueOf(this.parseExpression(tidEl, method, proceedingJoinPoint.getArgs()));
        if (!this.enrollLockRedisService.ifCanEnrollOpt(tid, targetId = Long.valueOf(this.parseExpression(targetIdEl, method, proceedingJoinPoint.getArgs())))) {
            throw new ServiceException(Integer.valueOf(1), "\u62b1\u6b49\uff0c\u5f53\u524d\u62a5\u540d\u6570\u636e\u6b63\u5728\u81ea\u52a8\u6821\u9a8c\u4e2d\uff0c\u6821\u9a8c\u65f6\u95f4\u8f83\u4e45\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff0c\u6821\u9a8c\u5b8c\u6210\u540e\u53ef\u67e5\u770b");
        }
        if (optType == 1) {
            this.enrollLockRedisService.start(tid, targetId);
            try {
                Object result;
                Object object = result = proceedingJoinPoint.proceed();
                return object;
            }
            catch (ServiceException se) {
                throw se;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable throwable) {
                log.error("Exception\uff1a", throwable);
                throwable.printStackTrace();
                throw new ServiceException("\u62a5\u540d\u9650\u5236\u51fa\u73b0\u672a\u77e5\u9519\u8bef");
            }
            finally {
                this.enrollLockRedisService.puase(tid, targetId);
            }
        }
        try {
            Object result = proceedingJoinPoint.proceed();
            return result;
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable throwable) {
            log.error("Exception\uff1a", throwable);
            throw new ServiceException("\u62a5\u540d\u9650\u5236\u51fa\u73b0\u672a\u77e5\u9519\u8bef");
        }
    }

    private static Map<String, Object> getFieldsName(ProceedingJoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        DefaultParameterNameDiscoverer pnd = new DefaultParameterNameDiscoverer();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String[] parameterNames = pnd.getParameterNames(method);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(32);
        for (int i = 0; i < parameterNames.length; ++i) {
            paramMap.put(parameterNames[i], args[i]);
        }
        return paramMap;
    }

    private String parseExpression(String expressionString, Method method, Object[] args) {
        LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
        String[] paramNameArr = discoverer.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < paramNameArr.length; ++i) {
            context.setVariable(paramNameArr[i], args[i]);
        }
        String result = (String)parser.parseExpression(expressionString).getValue((EvaluationContext)context, String.class);
        return result;
    }
}

