/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.training;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.framework.enums.SystemDeploymentSourceEnum;
import cn.smarthse.common.util.passwordLog.StringUtils;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseModel;
import cn.smarthse.modules.datacentre.model.supervise.CompanySuperviseSearchModel;
import cn.smarthse.modules.datacentre.provider.ICompanyProvideBySuperviseService;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.ResponseData;
import cn.smarthse.radiationTraining.modules.sys.dto.AreaDto;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IAreaProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.training.converter.CourseItemConverter;
import cn.smarthse.radiationTraining.modules.training.entity.course.TuCourse;
import cn.smarthse.radiationTraining.modules.training.entity.enroll.TuEnrollDetail;
import cn.smarthse.radiationTraining.modules.training.entity.training.TrainingCourse;
import cn.smarthse.radiationTraining.modules.training.enums.TrainingModeEnum;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.enroll.PersonEnrollSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.TrainingSearchParam;
import cn.smarthse.radiationTraining.modules.training.param.training.UserMyTrainSearchParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseItemManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderServiceForUser;
import cn.smarthse.radiationTraining.modules.training.service.course.ITuCourseService;
import cn.smarthse.radiationTraining.modules.training.service.enroll.ITuEnrollDetailService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ITrainingRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingServiceForUser;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingWorkTypeService;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseGroupCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.CourseItemCatalogueVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.ExamAlertInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.SysUserTrainInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainEnrollCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingBaseInfoVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingCourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingExamCountVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingPersonEnrollVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingWorkTypeVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.TraningProgressVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainCourseVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserMyTrainListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.UserTrainStatusNumVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxCompanyListVo;
import cn.smarthse.radiationTraining.modules.training.vo.training.WxTrainCourseGroupVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;

@DubboService
public class TrainingProviderServiceImplForUser
implements ITrainingProviderServiceForUser {
    private final ITrainingServiceForUser trainingServiceForUser;
    private final ITuEnrollDetailService tuEnrollDetailService;
    private final ITrainingCourseService trainingCourseService;
    private final ITrainingService trainingService;
    private final ICourseItemManagerProviderService courseItemProviderService;
    private final ITrainingCourseGroupService trainingCourseGroupService;
    private final ITrainingWorkTypeService trainingWorkTypeService;
    private final CourseItemConverter courseItemConverter;
    private final ITuCourseService tuCourseService;
    private final OssClientBean ossClientBean;
    private final ITrainingRedisService trainingRedisService;
    @DubboReference
    private ISysCompanyStaffProviderService sysCompanyStaffProviderService;
    @DubboReference
    private IUserProviderService userProviderService;
    @DubboReference
    private IAreaProviderService areaProviderService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ICompanyProvideBySuperviseService companyProvideBySuperviseService;

    public TrainingBaseInfoVo getMyTrainingBaseInfoForWx(Long tid, Long uid, Long enrollDetailId) {
        if (null == tid) {
            throw new ServiceException("tid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.trainingServiceForUser.getMyTrainingBaseInfoForWx(tid, uid, enrollDetailId);
    }

    public TrainingBaseInfoVo getEnrollNeededInfo(Long tid) {
        TrainingBaseInfoVo rst = new TrainingBaseInfoVo();
        TrainingDetailVo info = this.trainingService.getTrainingInfo(tid);
        rst.setTrainMode(info.getTrainMode());
        rst.setPersonCertificateList(info.getPersonCertificateList());
        rst.setTrainName(info.getTrainName());
        rst.setSignStarTime(info.getSignStarTime());
        rst.setSignEndTime(info.getTrainEndTime());
        rst.setTargetClassHour(info.getTargetClassHour());
        rst.setGeneralClassHour(info.getGeneralClassHour());
        rst.setVersion(info.getVersion());
        return rst;
    }

    public LayuiGridData<WxCompanyListVo> searchCompanyList(Long userId, String companyName, Integer pageNum, Integer pageSize) {
        CompanySuperviseSearchModel param = new CompanySuperviseSearchModel();
        param.setSystemDeploymentSource(SystemDeploymentSourceEnum.ONLINE_TRAINING.getCode());
        param.setName(companyName);
        PageInfo jqGridData = new PageInfo();
        if (StrUtil.isNotBlank((CharSequence)companyName)) {
            jqGridData = this.companyProvideBySuperviseService.getAllOptionalEnterprisesBySystemDeploymentSourceEnum(param, pageNum.intValue(), pageSize.intValue(), Boolean.valueOf(false));
        } else {
            List companyStaffList = this.sysCompanyStaffProviderService.getByUidForSelfEnroll(userId, null);
            if (CollUtil.isNotEmpty((Collection)companyStaffList)) {
                ArrayList<CompanySuperviseModel> addList = new ArrayList<CompanySuperviseModel>(companyStaffList.size());
                for (CompanyListVo companyStaffVo : companyStaffList) {
                    CompanySuperviseModel companyBindingVo = new CompanySuperviseModel();
                    companyBindingVo.setCid(companyStaffVo.getId());
                    companyBindingVo.setName(companyStaffVo.getName());
                    companyBindingVo.setAreaId(companyStaffVo.getAreaId());
                    companyBindingVo.setBelongType(companyStaffVo.getBelongType());
                    addList.add(companyBindingVo);
                }
                jqGridData.setList(addList);
                jqGridData.setTotal((long)addList.size());
            }
        }
        if (CollUtil.isEmpty((Collection)jqGridData.getList())) {
            return new LayuiGridData();
        }
        ArrayList<WxCompanyListVo> rstList = new ArrayList<WxCompanyListVo>(jqGridData.getList().size());
        for (CompanySuperviseModel vo : jqGridData.getList()) {
            rstList.add(new WxCompanyListVo(vo.getCid(), vo.getName(), vo.getAreaId(), vo.getBelongType()));
        }
        return new LayuiGridData(rstList, pageNum, pageSize, Integer.valueOf((int)jqGridData.getTotal()), null);
    }

    public LayuiGridData<WxCompanyListVo> searchCompanyListForRho(Long userId, String companyName, Integer pageNum, Integer pageSize) {
        TrainingSearchParam param = new TrainingSearchParam();
        param.setUid(userId);
        param.setKeyword(companyName);
        param.setLimit(pageSize.intValue());
        param.setPage(pageNum.intValue());
        return this.trainingServiceForUser.searchCompanyListForRho(param);
    }

    public Boolean isCouldEnroll(TrainingSearchParam param) {
        CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(param.getCid());
        CompanySuperviseModel companySuperviseModel = companyInfo = companyInfo == null ? this.trainingServiceForUser.getCompanyByIdForRho(param.getCid()) : companyInfo;
        if (companyInfo == null) {
            throw new ServiceException("\u533b\u9662\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        param.setAreaId(companyInfo.getAreaDetailId());
        param.setBelongType(companyInfo.getBelongType());
        AreaDto areaInfo = this.areaProviderService.getAreaById(param.getAreaId());
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(areaInfo.getProvinceId());
        list.add(areaInfo.getCityId());
        list.add(areaInfo.getAreaId());
        list.add(areaInfo.getStreetId());
        param.setAreaIdList(list);
        return this.trainingServiceForUser.isCouldEnroll(param);
    }

    public LayuiGridData<TrainingListVo> getCouldEnrollList(TrainingSearchParam param) {
        CompanySuperviseModel companyInfo = this.companyProvideBySuperviseService.getCompanyInfoById(param.getCid());
        CompanySuperviseModel companySuperviseModel = companyInfo = companyInfo == null ? this.trainingServiceForUser.getCompanyByIdForRho(param.getCid()) : companyInfo;
        if (companyInfo == null) {
            throw new ServiceException("\u533b\u9662\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        param.setAreaId(companyInfo.getAreaDetailId());
        param.setBelongType(companyInfo.getBelongType());
        AreaDto areaInfo = this.areaProviderService.getAreaById(param.getAreaId());
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(areaInfo.getProvinceId());
        list.add(areaInfo.getCityId());
        list.add(areaInfo.getAreaId());
        list.add(areaInfo.getStreetId());
        param.setAreaIdList(list);
        return this.trainingServiceForUser.getCouldEnrollList(param);
    }

    public TrainingListVo getCouldEnrollInfo(TrainingSearchParam param) {
        if (param.getTrainingId() == null) {
            throw new ServiceException("\u57f9\u8badid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.trainingServiceForUser.getCouldEnrollInfo(param);
    }

    public List<WxTrainCourseGroupVo> getTrainCourseListForWx(Long tid) {
        return this.trainingCourseService.getTrainCourseListForWx(tid);
    }

    public List<UserTrainStatusNumVo> getTrainingStatusNumListForUser(Long uid) {
        return this.trainingServiceForUser.getTrainingStatusNumListForUser(uid);
    }

    public LayuiGridData<TrainingListVo> getTrainingPageListForUser(TrainingSearchParam param) {
        return this.trainingServiceForUser.getTrainingPageListForUser(param);
    }

    public UserMyTrainListVo getTrainingBaseInfoForUser(Long tid, Long uid) {
        return this.trainingServiceForUser.getTrainingBaseInfoForUser(tid, uid);
    }

    public List<TrainingCourseGroupVo> getTrainingCourseGroup(Long tid, Long uid) {
        if (null == tid) {
            throw new ServiceException("tid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.trainingCourseGroupService.getTrainingCourseGroupForUser(tid, uid);
    }

    public List<UserMyTrainCourseVo> getTrainingCourse(Long tid, Long uid, Long courseGroupId) {
        if (null == tid || null == courseGroupId) {
            throw new ServiceException("tid\u4e0ecourseGroupId\u4e3a\u5fc5\u586b\u9879");
        }
        return this.trainingCourseService.getTrainingCourse(tid, uid, courseGroupId);
    }

    public SysUserTrainInfoVo getMyTrainingBaseInfoForUser(Long tid, Long uid, Long enrollDetailId) {
        UserMyTrainListVo trainBaseInfo = this.trainingServiceForUser.getMyTrainingBaseInfoForUser(tid, uid, enrollDetailId);
        SysUserTrainInfoVo rst = new SysUserTrainInfoVo();
        if (trainBaseInfo == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)trainBaseInfo, (Object)rst);
        UserVo userVo = this.userProviderService.getUserVo(uid);
        rst.setUserName(userVo.getName());
        return rst;
    }

    public LayuiGridData<UserMyTrainListVo> getMyTrainPageListForUser(UserMyTrainSearchParam param) {
        return this.trainingServiceForUser.getMyTrainPageListForUser(param);
    }

    public List<TrainingCourseGroupVo> getMyTrainingCourseGroup(Long tid, Long uid) {
        if (null == tid) {
            throw new ServiceException("tid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.trainingCourseGroupService.getMyTrainingCourseGroupForUser(tid, uid);
    }

    public List<UserMyTrainCourseVo> getMyTrainingCourse(Long tid, Long uid, Long courseGroupId) {
        if (null == tid || null == courseGroupId) {
            throw new ServiceException("tid\u4e0ecourseGroupId\u4e3a\u5fc5\u586b\u9879");
        }
        return this.trainingCourseService.getMyTrainingCourse(tid, uid, courseGroupId);
    }

    public void delTrainingForUser(Long tid, Long uid) {
        if (null == tid) {
            throw new ServiceException("tid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.trainingServiceForUser.delTrainingForUser(tid, uid);
    }

    public List<TrainingWorkTypeVo> getTrainingWorkType(Long uid) {
        return this.trainingWorkTypeService.getTrainingWorkTypeForUser(uid);
    }

    public List<CourseItemCatalogueVo> getCourseCataSubLogue(Long GroupId, Long loginUserId) {
        return this.trainingCourseService.getCourseCataSubLogue(GroupId, loginUserId);
    }

    public LayuiGridData<UserMyTrainListVo> getMyTrainingExamPageList(UserMyTrainSearchParam param) {
        return this.trainingServiceForUser.getMyTrainingExamPageList(param);
    }

    public UserMyTrainListVo getTrainingBaseInfo(Long id) {
        return this.tuEnrollDetailService.getTrainingBaseInfo(id);
    }

    public ResponseData<TrainingCourseItemVo> getCourseItemDetailForMajor(Long traningCourseId, Long tuCoruseId) {
        TrainingCourse trainingCourse = this.trainingCourseService.getDetailById(traningCourseId);
        if (trainingCourse == null) {
            throw new ServiceException("\u57f9\u8bad\u8bfe\u7a0b\u4e0d\u5b58\u5728");
        }
        TrainingCourseItemVo trainingCourseItemVo = new TrainingCourseItemVo();
        TuCourse tuCourse = this.tuCourseService.getRecordById(tuCoruseId);
        trainingCourseItemVo.setTrainingGroupId(trainingCourse.getTrainCourseGroupId());
        trainingCourseItemVo.setIsPass(trainingCourse.getIsPass().byteValue());
        trainingCourseItemVo.setIsTest(trainingCourse.getIsTest().byteValue());
        trainingCourseItemVo.setVideoId(trainingCourse.getVideoId());
        trainingCourseItemVo.setVideoUrl(this.ossClientBean.getUrl(trainingCourse.getVideoUrl()));
        trainingCourseItemVo.setCoverId(trainingCourse.getCoverId());
        trainingCourseItemVo.setCoverUrl(this.ossClientBean.getUrl(trainingCourse.getCoverUrl()));
        trainingCourseItemVo.setLecturer(trainingCourse.getLecturer());
        trainingCourseItemVo.setName(trainingCourse.getCourseName());
        trainingCourseItemVo.setDescription(trainingCourse.getDescription());
        trainingCourseItemVo.setExamStatus(tuCourse.getIsPassed());
        trainingCourseItemVo.setStuStatus(tuCourse.getStatus());
        trainingCourseItemVo.setRetestLimit(tuCourse.getRetestLimit());
        trainingCourseItemVo.setScore(tuCourse.getScore());
        trainingCourseItemVo.setStuDurationSec(tuCourse.getStuDurationSec());
        trainingCourseItemVo.setVideoDurationSec(tuCourse.getVideoDurationSec());
        return ResponseData.success((Object)trainingCourseItemVo);
    }

    public ResponseData<TrainingCourseItemVo> getCourseItemDetailForPrecise(Long tuCoruseId) {
        TuCourse tuCourse = this.tuCourseService.getRecordById(tuCoruseId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuCourse.getTid());
        CourseItemVo courseItemVo = this.courseItemProviderService.getCourseItemById(tuCourse.getCourseItemId());
        TrainingCourseItemVo trainingCourseItemVo = this.courseItemConverter.vo2TrainingCourItem(courseItemVo);
        trainingCourseItemVo.setIsPass((byte)tuCourse.getIsPassed().intValue());
        trainingCourseItemVo.setIsTest(trainingInfo.getIsTestOnline() == 1 && trainingInfo.getTestMode() == 0 ? (byte)1 : 0);
        trainingCourseItemVo.setExamStatus(tuCourse.getIsPassed());
        trainingCourseItemVo.setStuStatus(tuCourse.getStatus());
        trainingCourseItemVo.setScore(tuCourse.getScore());
        trainingCourseItemVo.setRetestLimit(tuCourse.getRetestLimit());
        if (!StringUtils.isEmpty((String)tuCourse.getVideoUrl())) {
            trainingCourseItemVo.setVideoUrl(tuCourse.getVideoUrl());
        }
        if (!StringUtils.isEmpty((String)tuCourse.getCoverUrl())) {
            trainingCourseItemVo.setCoverUrl(tuCourse.getCoverUrl());
        }
        trainingCourseItemVo.setStuDurationSec(tuCourse.getStuDurationSec());
        trainingCourseItemVo.setVideoDurationSec(tuCourse.getVideoDurationSec());
        return ResponseData.success((Object)trainingCourseItemVo);
    }

    public TraningProgressVo getTraningProgress(Long tuEnrollDetailId) {
        TuEnrollDetail tuEnrollDetail = (TuEnrollDetail)this.tuEnrollDetailService.getById(tuEnrollDetailId);
        return new TraningProgressVo().setTrainStatusCode(tuEnrollDetail.getTrainStatus()).setLearnedCourseNum(tuEnrollDetail.getStudiedProgress()).setTotalCourseNum(tuEnrollDetail.getStudyProgressTotal()).setClassHourTotal(tuEnrollDetail.getClassHourTotal()).setStudiedClassHour(tuEnrollDetail.getStudiedClassHour()).setPassClassHour(tuEnrollDetail.getPassClassHour());
    }

    public TrainingExamCountVo getTrainingExamCount(Long loginUserId) {
        return this.trainingServiceForUser.getTrainingExamCount(loginUserId);
    }

    public LayuiGridData<TrainingPersonEnrollVo> listPersnoEnroll(PersonEnrollSearchParam param) {
        return this.tuEnrollDetailService.listPersnoEnroll(param);
    }

    public LayuiGridData<TrainEnrollCourseVo> listPersnoEnrollCourse(PersonEnrollCourseParam param) {
        return this.tuEnrollDetailService.listPersnoEnrollCourse(param);
    }

    public ExamAlertInfoVo getExamAlertInfo(Long tuCourseId) {
        return this.trainingServiceForUser.getExamAlertInfo(tuCourseId);
    }

    public List<CourseGroupCatalogueVo> getBaseCourseCataLogue(Long tid) {
        return this.trainingRedisService.getBaseCourseCataLogue(tid);
    }

    public ResponseData<TrainingCourseItemVo> getCourseItem(Long tuCoruseId) {
        TuCourse tuCourse = this.tuCourseService.getRecordById(tuCoruseId);
        TrainingDetailVo trainingInfo = this.trainingService.getTrainingInfo(tuCourse.getTid());
        Integer trainMode = trainingInfo.getTrainMode();
        if (TrainingModeEnum.MARJOR.getValue().equals(trainMode) || TrainingModeEnum.ORG.getValue().equals(trainMode)) {
            return this.getCourseItemDetailForMajor(tuCourse.getTrainingCourseId(), tuCoruseId);
        }
        if (TrainingModeEnum.PRECISE.getValue().equals(trainMode)) {
            return this.getCourseItemDetailForPrecise(tuCoruseId);
        }
        throw new ServiceException("\u57f9\u8bad\u7c7b\u578b\u9519\u8bef");
    }

    @Generated
    public TrainingProviderServiceImplForUser(ITrainingServiceForUser trainingServiceForUser, ITuEnrollDetailService tuEnrollDetailService, ITrainingCourseService trainingCourseService, ITrainingService trainingService, ICourseItemManagerProviderService courseItemProviderService, ITrainingCourseGroupService trainingCourseGroupService, ITrainingWorkTypeService trainingWorkTypeService, CourseItemConverter courseItemConverter, ITuCourseService tuCourseService, OssClientBean ossClientBean, ITrainingRedisService trainingRedisService) {
        this.trainingServiceForUser = trainingServiceForUser;
        this.tuEnrollDetailService = tuEnrollDetailService;
        this.trainingCourseService = trainingCourseService;
        this.trainingService = trainingService;
        this.courseItemProviderService = courseItemProviderService;
        this.trainingCourseGroupService = trainingCourseGroupService;
        this.trainingWorkTypeService = trainingWorkTypeService;
        this.courseItemConverter = courseItemConverter;
        this.tuCourseService = tuCourseService;
        this.ossClientBean = ossClientBean;
        this.trainingRedisService = trainingRedisService;
    }
}

