/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.toT;

import cn.smarthse.modules.health.supervise.model.onlineTrain.IssuedModel;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.training.enums.TrainTargetEnum;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TrainingCallService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrainingCallService.class);
    @DubboReference
    private IUserCropProviderService userCropProviderService;
    @DubboReference
    ICompanyProvider rayCompanyProvider;
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;

    public Map<Long, IssuedModel> getTrainUnitNames(List<Long> cidList) {
        Map issuedModelMap = this.syncTrainInfoService.issuedBy(cidList);
        return issuedModelMap == null ? null : issuedModelMap;
    }

    public IssuedModel getSingleTrainUnitNameModel(Long cid) {
        ArrayList<Long> cidList = new ArrayList<Long>();
        cidList.add(cid);
        Map issuedModelMap = null;
        try {
            issuedModelMap = this.syncTrainInfoService.issuedBy(cidList);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            throw new ServiceException("\u8fdc\u7a0b\u83b7\u53d6\u53d1\u8bc1\u5355\u4f4d\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
        return issuedModelMap == null ? null : (IssuedModel)issuedModelMap.get(cid);
    }

    public Map<String, Object> getSingleTrainUnitNameModel2(Long cid) {
        Map map = null;
        try {
            map = this.syncTrainInfoService.issuedBy(cid);
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
            throw new ServiceException("\u8fdc\u7a0b\u83b7\u53d6\u53d1\u8bc1\u5355\u4f4d\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5");
        }
        return map == null ? null : map;
    }

    public Map<String, Object> getSuperviseUnit(Long cid, Integer trainTarget) {
        Map issueMap = null;
        if (TrainTargetEnum.isHseTraining((Integer)trainTarget).booleanValue()) {
            issueMap = this.getSingleTrainUnitNameModel2(cid);
        }
        if (TrainTargetEnum.isRhoTraining((Integer)trainTarget).booleanValue()) {
            issueMap = this.rayCompanyProvider.getSuperviseUnit(cid);
        }
        if (issueMap == null || !issueMap.containsKey("id") || !issueMap.containsKey("name")) {
            throw new ServiceException("\u76d1\u7763\u5355\u4f4d/\u53d1\u8bc1\u5355\u4f4d\u6570\u636e\u4e0d\u5b8c\u6574");
        }
        return issueMap;
    }

    public String getTrainUnitName(Long hseCid) {
        IssuedModel issuedModel = this.getSingleTrainUnitNameModel(hseCid);
        return issuedModel == null ? null : issuedModel.getIssueUnit();
    }

    @Generated
    public TrainingCallService() {
    }
}

