/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.training.provider.course;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysParamProviderService;
import cn.smarthse.radiationTraining.modules.training.converter.CourseGroupConverter;
import cn.smarthse.radiationTraining.modules.training.converter.CourseItemConverter;
import cn.smarthse.radiationTraining.modules.training.dao.course.CourseManagerMapper;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseGroup;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItem;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemIndustry;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemPersonType;
import cn.smarthse.radiationTraining.modules.training.entity.course.CourseItemRadiation;
import cn.smarthse.radiationTraining.modules.training.enums.InudstryAllCodeTypeEnum;
import cn.smarthse.radiationTraining.modules.training.param.CheckEditPermissionParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupAddParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupChangeStatusParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupEditParam;
import cn.smarthse.radiationTraining.modules.training.param.course.CourseGroupSingleOptParam;
import cn.smarthse.radiationTraining.modules.training.param.course.DefaultCourseParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupAddItemsParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupDeleteItemParam;
import cn.smarthse.radiationTraining.modules.training.param.course.GroupPageParam;
import cn.smarthse.radiationTraining.modules.training.provider.course.ICourseGroupManagerProviderService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupItemService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseGroupService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemIndustryService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemPersonTypeService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemRaditaionService;
import cn.smarthse.radiationTraining.modules.training.service.course.ICourseItemService;
import cn.smarthse.radiationTraining.modules.training.service.redis.ICourseRedisService;
import cn.smarthse.radiationTraining.modules.training.service.training.ITrainingCourseGroupService;
import cn.smarthse.radiationTraining.modules.training.utils.IndustryTypeUtils;
import cn.smarthse.radiationTraining.modules.training.utils.PersonTypeUtils;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupBatchOptVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseGroupVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.CourseItemVo;
import cn.smarthse.radiationTraining.modules.training.vo.course.GroupWarningVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class CourseGroupManagerProviderServiceImpl
implements ICourseGroupManagerProviderService {
    @Autowired
    private ICourseGroupService courseGroupService;
    @Autowired
    private ICourseItemService courseItemService;
    @Autowired
    private ICourseRedisService courseRedisService;
    @Autowired
    private ICourseGroupItemService courseGroupItemService;
    @Autowired
    private ICourseItemRaditaionService courseItemRaditaionService;
    @Autowired
    private ICourseItemIndustryService courseItemIndustryService;
    @Autowired
    private ICourseItemPersonTypeService courseItemPersonTypeService;
    @DubboReference
    private ISysParamProviderService sysParamProviderService;
    @DubboReference
    private ISysFileProvideService sysFileProvideService;
    @Autowired
    private CourseManagerMapper courseManagerMapper;
    @Autowired
    private CourseGroupConverter courseGroupConverter;
    @Autowired
    private CourseItemConverter courseItemConverter;
    @Autowired
    private ITrainingCourseGroupService trainingCourseGroupService;

    public void pptt() {
        this.courseGroupService.list();
    }

    public LayuiGridData<CourseGroupVo> searchGroupsByKeyword(GroupPageParam param) {
        List industryCodeList = param.getIndustryCodeList();
        boolean containMedicalIndustry = IndustryTypeUtils.containMedicalIndustry((List)industryCodeList);
        boolean containNonMedicalIndustry = IndustryTypeUtils.containNonMedicalIndustry((List)industryCodeList);
        boolean containAllMedicalIndustry = CollUtil.contains((Collection)industryCodeList, (Object)InudstryAllCodeTypeEnum.ALL_MEDICAL.getValue());
        boolean containAllNonMedicalIndustry = CollUtil.contains((Collection)industryCodeList, (Object)InudstryAllCodeTypeEnum.ALL_NON_MEDICAL.getValue());
        param.setContainMedicalIndustry(Boolean.valueOf(containMedicalIndustry));
        param.setContainNonMedicalIndustry(Boolean.valueOf(containNonMedicalIndustry));
        param.setContainAllMedicalIndustry(Boolean.valueOf(containAllMedicalIndustry));
        param.setContainAllNonMedicalIndustry(Boolean.valueOf(containAllNonMedicalIndustry));
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CourseGroupVo> vos = this.courseGroupService.searchByKeyword(param);
        for (CourseGroupVo vo : vos) {
            Long courseGroupId = vo.getId();
            List<CourseItemVo> courseItemVoByGroupId = this.courseItemService.getCourseItemVoByGroupId(vo.getId(), 1);
            List<CourseItemPersonType> personTypeList = this.courseItemPersonTypeService.getByGroupId(courseGroupId);
            List<CourseItemRadiation> radiationList = this.courseItemRaditaionService.getByGroupId(courseGroupId);
            List<CourseItemIndustry> industryList = this.courseItemIndustryService.getByGroupId(courseGroupId);
            vo.setPersonTypeList(personTypeList);
            vo.setRadiationList(radiationList);
            vo.setCourseItemIndustryList(industryList);
            if (param.getIfIncludeCourse() != 1) continue;
            ArrayList<CourseItemVo> itemVoList = new ArrayList<CourseItemVo>();
            List idList = courseItemVoByGroupId.stream().map(v -> v.getId()).collect(Collectors.toList());
            for (Long id : idList) {
                CourseItemVo courseItemVo = this.courseItemService.getCourseItemById(id);
                itemVoList.add(courseItemVo);
            }
            vo.setCourseItemVoList(itemVoList);
        }
        return new LayuiGridData((Page)vos, (LayuiGridParam)param);
    }

    public List<CourseGroupVo> getIdsAndNamesByKeyword(String keyword) {
        return this.courseGroupService.getIdsAndNamesByKeyword(keyword);
    }

    public CourseGroupVo getGroupDetailById(Long id) {
        if (id == null) {
            return null;
        }
        CourseGroup courseGroup = (CourseGroup)this.courseGroupService.getById(id);
        if (courseGroup == null) {
            return null;
        }
        List<CourseItem> items = this.courseItemService.getCourseItemByGroupId(id);
        if (items == null || items.size() == 0) {
            return this.courseGroupConverter.courseGroup2Vo(courseGroup);
        }
        CourseGroupVo courseGroupVo = this.courseGroupConverter.courseGroup2Vo(courseGroup);
        List itemVos = this.courseItemConverter.courseItemList2VoList(items);
        for (CourseItemVo itemVo : itemVos) {
            List<String> personType = this.courseItemService.getPersonType(itemVo.getId());
            boolean b = PersonTypeUtils.checkTTTypeAndPT((String)courseGroup.getTrainingTargetType(), personType);
            if (b) continue;
            GroupWarningVo warningVo = new GroupWarningVo();
            warningVo.setGroupId(courseGroup.getId());
            warningVo.setGroupName(courseGroup.getName());
            warningVo.setCourseId(itemVo.getId());
            warningVo.setCourseName(itemVo.getName());
            warningVo.setMsg("\u8bfe\u7a0b\u7ec4\u9002\u7528\u4eba\u5458\u7c7b\u578b\u4e0e\u8bfe\u7a0b\u4eba\u5458\u7c7b\u578b\u4e0d\u5339\u914d\u3002");
            itemVo.setWarningVo(warningVo);
        }
        courseGroupVo.setCourseItemVoList(itemVos);
        return courseGroupVo;
    }

    public boolean addGroup(CourseGroupAddParam param) {
        if (param.getName() == null) {
            throw new ServiceException("\u8bfe\u7a0b\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CourseGroup courseGroup = new CourseGroup().setName(param.getName()).setEditor(param.getLoginUserId()).setType(param.getType()).setCreateBy(param.getLoginUserId()).setUpdateBy(param.getLoginUserId()).setStatus(Integer.valueOf(2)).setIsValid(Integer.valueOf(1));
        boolean result = this.courseGroupService.save(courseGroup);
        return result;
    }

    public void addCourseItem(GroupAddItemsParam param) {
        this.courseGroupService.addCourseItem(param);
    }

    public void editGroup(CourseGroupEditParam param) {
        this.courseGroupService.editGroup(param);
    }

    public boolean editGroupStatus(CourseGroupChangeStatusParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"id", "status"});
        Long id = param.getId();
        Integer status = param.getStatus();
        CourseGroup dbCourseGroup = (CourseGroup)this.courseGroupService.getById(id);
        if (dbCourseGroup.getCourseNumber() == 0L) {
            status = 0;
        }
        this.courseGroupService.changeStatusById(id, (long)status);
        return true;
    }

    @Transactional
    public boolean delete(Long id) {
        return this.courseGroupService.deleteOne(id);
    }

    public CourseGroupVo previewByGroupId(Long id) {
        if (id == null) {
            return null;
        }
        CourseGroup courseGroup = (CourseGroup)this.courseGroupService.getById(id);
        if (courseGroup == null) {
            return null;
        }
        List<CourseItemVo> itemVos = this.courseItemService.getCourseItemVoByGroupId(id);
        if (itemVos == null || itemVos.size() == 0) {
            return this.courseGroupConverter.courseGroup2Vo(courseGroup);
        }
        CourseGroupVo courseGroupVo = this.courseGroupConverter.courseGroup2Vo(courseGroup);
        courseGroupVo.setCourseItemVoList(itemVos);
        return courseGroupVo;
    }

    public List<CourseGroupVo> previewByItemId(Long id) {
        List<Long> groupIdList = this.courseGroupItemService.getCourseGroupIdsByCourseItemId(id);
        ArrayList<CourseGroupVo> courseGroupVoList = new ArrayList<CourseGroupVo>();
        for (Long groupId : groupIdList) {
            CourseGroupVo courseGroupVo = this.previewByGroupId(groupId);
            courseGroupVoList.add(courseGroupVo);
        }
        return courseGroupVoList;
    }

    public List<CourseGroupBatchOptVo> batchOpt(List<CourseGroupSingleOptParam> paramList) {
        return this.courseGroupService.batchOpt(paramList);
    }

    public void deleteCoruseItem(GroupDeleteItemParam param) {
        this.courseGroupItemService.removeByGroupoIdAndItemId(param.getGroupId(), param.getItemId());
        this.courseGroupService.updateVideoNumberByCourseGroupId(param.getGroupId());
        this.courseRedisService.rmCourseItemVo(param.getItemId());
    }

    public void deleteCoruseItemBatch(List<GroupDeleteItemParam> paramList) {
        if (paramList.size() > 0) {
            for (GroupDeleteItemParam param : paramList) {
                this.courseRedisService.rmCourseItemVo(param.getItemId());
                this.courseGroupItemService.removeByGroupoIdAndItemId(param.getGroupId(), param.getItemId());
            }
            this.courseGroupService.updateVideoNumberByCourseGroupId(paramList.get(0).getGroupId());
        }
    }

    public void checkEditPermission(CheckEditPermissionParam param) {
        this.courseGroupService.checkEditPermission(param);
    }

    public void checkEditPermission(Long uid, String uname, Integer userFrom, Integer userOptRole, List<Long> groupIdList) {
        this.courseGroupService.checkEditPermission(uid, uname, userFrom, userOptRole, groupIdList);
    }

    public List<CourseGroupVo> getDefaultCourse(DefaultCourseParam param) {
        List<CourseGroupVo> voList = this.courseGroupService.getDefaultCourse(param);
        for (CourseGroupVo vo : voList) {
            ArrayList<CourseItemVo> itemVoList = new ArrayList<CourseItemVo>();
            Long courseGroupId = vo.getId();
            List<CourseItemVo> courseItemVoByGroupId = this.courseItemService.getCourseItemVoByGroupId(vo.getId(), 1);
            List<CourseItemPersonType> personTypeList = this.courseItemPersonTypeService.getByGroupId(courseGroupId);
            List<CourseItemRadiation> radiationList = this.courseItemRaditaionService.getByGroupId(courseGroupId);
            List<CourseItemIndustry> industryList = this.courseItemIndustryService.getByGroupId(courseGroupId);
            vo.setPersonTypeList(personTypeList);
            vo.setRadiationList(radiationList);
            vo.setCourseItemIndustryList(industryList);
            List idList = courseItemVoByGroupId.stream().map(v -> v.getId()).collect(Collectors.toList());
            for (Long id : idList) {
                CourseItemVo courseItemVo = this.courseItemService.getCourseItemById(id);
                itemVoList.add(courseItemVo);
            }
            vo.setCourseItemVoList(itemVoList);
        }
        return voList;
    }

    @Generated
    public CourseGroupManagerProviderServiceImpl() {
    }
}

